; BPP.COM - Enables/Disables the parallel port bidirectional mode on IBM PS/1 2011/2121 computers.

	CPU		286

	LF		EQU	10
	CR		EQU	13

;--------------------------------------------------------------------
; Skips the immediately following 2 byte instruction by using it
; as an immediate value to a dummy instruction.
; Destroys the contents of %1.
;
; SKIP2B
;	Parameters:
;		%1:		Any 16 bit general purpose register or F for flags.
;	Returns:
;		Nothing
;	Corrupts registers:
;		%1
;--------------------------------------------------------------------
%macro SKIP2B 1
	%ifidni		%1, f
		db	03Dh					; Opcode byte for CMP AX, <immed>
		;db	0A9h					; Alt. version TEST AX, <immed>
	%elifidni	%1, ax
		db	0B8h					; Opcode byte for MOV AX, <immed>
	%elifidni	%1, cx
		db	0B9h					; Opcode byte for MOV CX, <immed>
	%elifidni	%1, dx
		db	0BAh					; Opcode byte for MOV DX, <immed>
	%elifidni	%1, bx
		db	0BBh					; Opcode byte for MOV BX, <immed>
	%elifidni	%1, sp
		db	0BCh					; Opcode byte for MOV SP, <immed>
	%elifidni	%1, bp
		db	0BDh					; Opcode byte for MOV BP, <immed>
	%elifidni	%1, si
		db	0BEh					; Opcode byte for MOV SI, <immed>
	%elifidni	%1, di
		db	0BFh					; Opcode byte for MOV DI, <immed>
	%else
		%error "Invalid parameter passed to SKIP2B"
	%endif
%endmacro


	ORG		100h

	mov		dx, s$Description
	call	PrintStringInDSDX
	push	sp
	pop		bp
	mov		dx, s$Needs286CPU
	cmp		bp, sp
	jne		SHORT Needs286OrHigher
	mov		di, 81h
	mov		dx, s$ParameterError
	xor		ch, ch
	mov		cl, [di-1]
	jcxz	NoParameterFound
	mov		al, 20h
	repe	scasb
	jne		SHORT ParameterFound
Needs286OrHigher:
NoParameterFound:
InvalidParameter:
	jmp		PrintStringInDSDX
ParameterFound:
	mov		bl, 80h
	or		al, [di-1]
	cmp		al, 'e'
	jne		SHORT NotEnable
	mov		bl, ch
	SKIP2B	dx
NotEnable:
	cmp		al, 'd'
	jne		SHORT InvalidParameter
	mov		al, 10h
	mov		di, CMOSData
	mov		dx, 71h
	mov		si, di
.NextByte:
	cli
	out		70h, al
	jmp		SHORT $+2
	inc		ax
	insb
	sti
	cmp		al, 32h
	jb		SHORT .NextByte

	dec		di
	mov		bh, 7Fh
	and		bh, [di]
	or		bh, bl
	cmp		bh, [di]
	je		SHORT NoChange
	mov		BYTE [s$Already], '$'

	mov		[di], bh
	mov		ax, 0FFFFh
	mov		bp, 1021h
	push	dx

ChecksumNextByte:
	mov		bh, [si]
	call	UpdateCRC
	inc		si
	cmp		si, di
	jbe		SHORT ChecksumNextByte
;	call	AugmentCRC
	xchg	ah, al
	mov		[si], ax

	dec		si
	mov		al, 31h
	pop		dx
WriteNextCMOSByte:
	cli
	out		70h, al
	jmp		SHORT $+2
	inc		ax
	outsb
	sti
	cmp		al, 34h
	jb		SHORT WriteNextCMOSByte

	mov		dx, s$BiDirMode
	call	PrintBiDirModeEnabledOrDisabled
	mov		dx, s$AskForReboot
	call	PrintStringInDSDX
	mov		ah, 1
	int		21h
	or		al, 20h
	mov		dx, s$CRLF
	cmp		al, 'y'
	jne		SHORT PrintStringInDSDX
	pop		ds
	mov		WORD [472h], 1234h
	jmp		0FFFFh:0

	s$Enabled			db	"enabled!",CR,LF,"$"
	s$Disabled			db	"disabled!"
	s$CRLF				db	CR,LF,"$"

NoChange:
	mov		dx, s$BiDirModeAlready
PrintBiDirModeEnabledOrDisabled:
	call	PrintStringInDSDX
	mov		dx, s$Enabled
	test	bl, bl
	jz		SHORT PrintStringInDSDX
%if (s$Enabled-$$) & 0FF00h = (s$Disabled-$$) & 0FF00h
	mov		dl, (s$Disabled-$$) & 0FFh
%else
	mov		dx, s$Disabled
%endif
PrintStringInDSDX:
	mov		ah, 9
	int		21h
	ret

; CRC-CCITT - 16-bit 8088/8086 assembly implementation based on C code at http://srecord.sourceforge.net/crc16-ccitt.html
%if 0	; "Good" CRC
;--------------------------------------------------------------------
;	UpdateCRC
;
;	Parameters:		AX:		CRC (or 0FFFFh if first run)
;					BH:		Data byte in need of checksumming
;					BP:		Polynomial (1021h)
;
;	Returns:		AX:		Updated CRC
;
;	Corrupts:		DX
;--------------------------------------------------------------------
UpdateCRC:
	%rep	8
	cwd
	rol		bh, 1
	rcl		ax, 1
	and		dx, bp
	xor		ax, dx
	%endrep
	ret

;--------------------------------------------------------------------
;	AugmentCRC
;
;	Parameters:		AX:		CRC
;					BP:		Polynomial (1021h)
;
;	Returns:		AX:		Augmented CRC
;
;	Corrupts:		DX
;--------------------------------------------------------------------
AugmentCRC:
	%rep	16
	cwd
	shl		ax, 1
	and		dx, bp
	xor		ax, dx
	%endrep
	ret

%else	; "Bad" CRC
;--------------------------------------------------------------------
;	UpdateCRC
;
;	Parameters:		AX:		CRC (or 0FFFFh if first run)
;					BH:		Data byte in need of checksumming
;					BP:		Polynomial (1021h)
;
;	Returns:		AX:		Updated CRC
;
;	Corrupts:		DX
;--------------------------------------------------------------------
UpdateCRC:
	%rep	8
	xor		ah, bh
	cwd
	xor		ah, bh
	and		dx, bp
	shl		ax, 1
	xor		ax, dx
	rol		bh, 1
	%endrep
	ret

%endif ; 0

	s$BiDirMode:
	s$BiDirModeAlready	db	LF
						db	"Bidirectional mode "
	s$Already			db	"already $"

	s$AskForReboot		db	LF
						db	"Reboot computer? $"

CMOSData:

	s$Description		db	LF
						db	"BPP.COM - Bidirectional Parallel Port",CR,LF
						db	"by Krister Nordvall (krille_n_@hotmail.com)",CR,LF
						db	LF
						db	"Enables/Disables parallel port bidirectional",CR,LF
						db	"mode on IBM PS/1 2011/2121 computers.",CR,LF,"$"

	s$Needs286CPU		db	LF
						db	"This program needs a 286+ CPU!",CR,LF,"$"

	s$ParameterError	db	LF
						db	"Invalid parameter or no parameter provided!",CR,LF
						db	LF
						db	"Valid parameters are:",CR,LF
						db	LF
						db	"E or e - Enables bidirectional mode",CR,LF
						db	"D or d - Disables bidirecional mode",CR,LF,"$"
