//*********************************************************
//*
//* rodsapp.c: performs all initialization for first instance
//*		   of application.
//*
//*********************************************************

#define	NOCOMM
#define	_WINDOWS

#include	<windows.h>
#include <stdlib.h>
#include "rodsapp.h"

BOOL InitApplication(HANDLE hInstance)
{
	/* local variables */
	static char		szClassName[]= "RODSAPP";
	WNDCLASS			wc;

	/* fill in the WNDCLASS structure */
	wc.style=			0;
	wc.lpfnWndProc=	MainWndProc;
	wc.cbClsExtra=		0;
	wc.cbWndExtra=		0;
	wc.hInstance=		hInstance;
	wc.hIcon=			LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor=			LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground=	COLOR_WINDOW+1;
	wc.lpszMenuName=	MAKEINTRESOURCE(IDM_RODMENU);
	wc.lpszClassName=	szClassName;

	/* register the window class */
	if(!RegisterClass(&wc))
		return(FALSE);

} /* InitApplication */

//**************************************************************************>

BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
	/* local variables */
	static char	szClassName[]= "RODSAPP";
	HWND	hWnd;

	/* create the application main window */
	hWnd= CreateWindow(szClassName,
								"DLL Demo",
								WS_OVERLAPPEDWINDOW,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								NULL,
								NULL,
								hInstance,
								NULL);

	/* draw and show window */
	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return(TRUE);

} /* InitInstance */

