#define LEN 256

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "myopt.h"
#define TRUE 1
#define FALSE 0

#define MAX_NUMBER  255

struct _apitype {
    char chName[34];
    int  cb;
    long offset;
} apilist[MAX_NUMBER];



FILE *fp_src, *fp_dst, *fp_err, *fp_dat;
int api_num = 0;
char chFirstBuf[53];
int token_length = 0;

char *get_token( char *pch)
{
    char *pch2;

    while (*pch)
        {
        if (isalnum(*pch))
            {
            if (strchr( chFirstBuf, *pch))
                {
                pch2 = pch;
                while(isalnum(*pch2)) pch2++;
                token_length = (int)(pch2 - pch);
                return(pch);
                }
            do
                {
                pch++;
                } while(isalnum(*pch));
            }
        while (*pch && !isalnum(*pch))
            {
            pch++;
            } 
        }
    return(NULL);
}

#if 1
void print_dat()
{
    int ii;
    int err;
    char chInBuf[256];

    for (ii = 0; ii < api_num; ii++)
        {
        fprintf( fp_dst, "Api Name %s %x\n", apilist[ii].chName,
            apilist[ii].offset);
        err = fseek( fp_dat, apilist[ii].offset, SEEK_SET);
        if (err != 0)
            fprintf( fp_dst, "Fseek Failed\n");
        else
            {
            while (fgets( chInBuf, 256, fp_dat))
                {
                if (chInBuf[0] == '@')
                    {
                    break;
                    }
                else
                    fputs( chInBuf, fp_dst);
                }

            }
        
        }
    fprintf( fp_dst, "First Letters: (%s)\n", chFirstBuf);
}

#endif

found( int ii)
{
    char chInBuf[256];

    fseek( fp_dat, apilist[ii].offset, SEEK_SET);
    while (fgets( chInBuf, 256, fp_dat))
        {
        if (chInBuf[0] == '@')
            {
            return(0);
            }
        else
            {
            fputs( "\\\\MS_HINT ", fp_dst);
            fputs( chInBuf, fp_dst);
            }
        }

}

init_dat()
{
    char chInBuf[256];
    char *pch;
    
    chFirstBuf[0] = '\0';

    while (fgets( chInBuf, 256, fp_dat))
        {
        if (chInBuf[0] == '@')
            {
            if (chInBuf[1] == '\n')
                return(0);

            pch = strchr( chInBuf + 1, '\n');
            if (pch == NULL)
                {
                printf( "Error in datafile %d\n", api_num);
                exit(0);
                }

            *pch = '\0';
            strcpy( apilist[api_num].chName, chInBuf + 1);
            apilist[api_num].cb = strlen( apilist[api_num].chName);
            apilist[api_num].offset = ftell(fp_dat);

            if ( (strchr(chFirstBuf, chInBuf[1])) == NULL)
                {
                chInBuf[2] = '\0';
                strcat(chFirstBuf, chInBuf + 1);
                }

            api_num++;
            }
        }
}


char *FindApi( char *pch)
{
    int ii;

    for (ii = 1; ii < api_num; ii++)
        if ( token_length == apilist[ii].cb &&
                *pch == apilist[ii].chName[0] &&
                (strncmp( pch, apilist[ii].chName, apilist[ii].cb) == 0))
            {
            found(ii);
            return( pch + apilist[ii].cb);
            }

    return( pch + 1);
}
void useage()
{
    printf( "Useage: annotate [-d || -f data_file] file_name [ file_result ] \n");
    printf( "        -d -- dump data file. \n");
    printf( "        -f -- specify alternate data file. \n");
}
main( argc, argv)
	int argc;
	char *argv[];
    {
    int ii;
    char src[30];
    char dst[30];
    char buffer[256];
    char *ptr;
    int  bDump = FALSE;
    char chDataFile[34] = "os2win32.dat";
    char *pchDataFile = chDataFile;

    src[0] = 0x00;
    dst[0] = 0x00;

    while (ii = my_getopt(argc, argv, "df:"))
        {
        switch (ii)
            {
            case ((int) 'd'):
                bDump = TRUE;
                break;
            case ((int) 'f'):
                if (p_optstr != NULL)
                    pchDataFile = p_optstr;
                break;
            case -1:
                if (src[0] == 0x00)
                    {
                    strcpy(src, p_optstr);
                    break;
                    }
                if (dst[0] == 0x00)
                    {
                    strcpy(dst, p_optstr);
                    break;
                    }

                // FALL THRU

            default:
                useage();
                return(0);
            }
        }
    
    if (src[0] == 0x00 && bDump == FALSE)
        {
        useage();
        return(0);
        }

    fp_src = stdin;
	fp_dst = stdout;
	fp_err = stderr;

    fp_dat = fopen( pchDataFile, "rt");    
    if (fp_dat == NULL)
        {
        printf( "Failed to open DataFile %s\n", pchDataFile);
        return(0);
        }

    if (bDump)
        {
        init_dat();
        print_dat();

        fclose(fp_dat);
        return(0);
        }

    if (dst[0] == 0x00)
        {
        strcpy( dst, src);
        
        if ((ptr = strchr( dst, '.')))
            {
            *ptr = '\0';
            }
        strcat( dst, ".win");   
        }

    printf( "src: (%s) dst (%s)\n", src, dst);

    fp_src = freopen( src, "rt", stdin);
	fp_dst = freopen( dst, "w", stdout);

    init_dat();

    while (fgets( buffer, 256, fp_src))
        {
        fputs( buffer, fp_dst);
        ptr = buffer;
        while (ptr = get_token( ptr))
            {
            ptr = FindApi(ptr);
            }
        }
    fclose(fp_dat);
    fclose(fp_src);
    fclose(fp_dst);
    }

