
    typedef unsigned char UCHAR;

/*  Data structure for linked list of images in PM file.
    ==================================================== */

    typedef struct _fileimages {
        struct _fileimages *pfiNext; /* Next element in linked list.       */
        USHORT usImageNum;           /* Image number from start of list.   */
        USHORT usType;               /* Type of image header: BFT_*        */
        ULONG offHeader;             /* Offset in file for the header.     */
        SHORT DIBWidth;              /*              Stuff for ico header. */
        SHORT DIBHeight;             /*              Stuff for ico header. */
        SHORT DIBColors;             /*              Stuff for ico header. */
        SHORT DIBxhotspot;           /*              Stuff for ico header. */
        SHORT DIByhotspot;           /*              Stuff for ico header. */
        LONG  DIBSize;               /*              Stuff for ico header. */
        LONG  DIBOffset;             /*              Stuff for ico header. */
    } FILEIMAGES;

/*  Windows output file structures.
    =============================== */

    typedef struct {
        SHORT reserved;                /* Must be 0.                       */
        SHORT resType;                 /* 1-icon, 2-cursor.                */
        SHORT resCount;                /* Number of resources in file.     */
    } WINICONHEADER;

    typedef struct {
        UCHAR width;                   /* Width of this image.             */
        UCHAR height;                  /* Height of this image.            */
        UCHAR clrcount;                /* Number of colors in the image.   */
        UCHAR reserved;                /* 0.                               */
        SHORT xHotSpot;                /* For cursor, icon = 0.            */
        SHORT yHotSpot;                /* For cursor, icon = 0.            */
        LONG  DIBsize;                 /* Size of the image.               */
        LONG  DIBoffset;               /* Offset in file of the image.     */
    } WINICONARRAY;

    typedef struct {
        ULONG cbSize;                  /* Size of this structure (0x28).   */
        ULONG ulWidth;                 /* Width of bitmap.                 */
        ULONG ulHeight;                /* Height of bmp (x2 for ico/cur).  */
        USHORT cPlanes;                /* Number of planes.                */
        USHORT cBitCount;              /* Bits per pixel.                  */
        ULONG ulMisc[6];               /* Random stuff (set to 0L).        */
    } WINBITMAPINFOHEADER;

    typedef struct {
        USHORT usType;                 /* Type of file (must be 'BM').     */
        ULONG  ulSize;                 /* Size of file.                    */
        USHORT reserved1;              /* Reserved, must be set to 0.      */
        USHORT reserved2;              /* Reserved, must be set to 0.      */
        ULONG  ulOffBits;              /* Offset of bmp bits (after RGB).  */
    } WINBITMAPFILEHEADER;

    typedef struct {
        UCHAR blue;                    /* Blue value.                      */
        UCHAR green;                   /* Green value.                     */
        UCHAR red;                     /* Red value.                       */
        UCHAR reserved;                /* 0.                               */
    } RGB4;



/*  Function declarations.
    ====================== */

    int     main                   (int argc, char **argv);
    SHORT   ParseArgs              (int argc, char **argv);
    void    Usage                  (void);
    SHORT   ScanImages             (void);
    SHORT   ProcessImage           (FILEIMAGES *pfi);
    SHORT   ProcessArrayBmp        (FILEIMAGES *pfi);
    SHORT   ProcessArrayIco        (FILEIMAGES *pfi);
    SHORT   ProcessNormalBmp       (FILEIMAGES *pfi);
    SHORT   ProcessNormalIco       (FILEIMAGES *pfi);
    SHORT   ProcessNormalIcoMono   (FILEIMAGES *pfi);
    SHORT   WriteHeaderInfo        (void);
    SHORT   CopyBytes              (LONG count);
    void    ConvertXorSchemes      (SHORT width, SHORT height, SHORT cBitCount, UCHAR *pAnd, UCHAR *pXor, UCHAR *pClr);
