/*------------------------------
   HEAD.C -- Displays File Head
  ------------------------------*/

#define INCL_WIN
#define INCL_GPI
#include <os2win.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
//CHNG4
//#include "easyfont.h"
#include "head.h"

#define LCID_FIXEDFONT   1L
#define LCID_BOLDFONT    2L

//CHNG1 Msgs are now UINT's
DWORD EXPENTRY ClientWndProc (HWND, UINT, DWORD, DWORD) ;
DWORD EXPENTRY AboutDlgProc  (HWND, UINT, DWORD, DWORD) ;
DWORD EXPENTRY OpenDlgProc   (HWND, UINT, DWORD, DWORD) ;
SHORT            ParseFileName (CHAR *, CHAR *) ;

CHAR szClientClass [] = "Head" ;
CHAR szFileName [80] ;
int  hab ;

int main (int argc, char *argv[])
     {
     static ULONG flFrameFlags = HP_FCF_TITLEBAR      | HP_FCF_SYSMENU  |
                                 HP_FCF_SIZEBORDER    | HP_FCF_MINMAX   |
                                 MS_W32_NOTIMP(FCF_SHELLPOSITION) | MS_W32_NOTIMP(FCF_TASKLIST) |
                                 HP_FCF_MENU ;
     int          hmq ;
     HWND         hwndFrame, hwndClient ;
     QMSG         qmsg ;

               // Check for filename parameter and copy to szFileName

     if (argc > 1)
          ParseFileName (szFileName, argv [1]) ;

               // Continue normally
     
     hab = NULL ;
     hmq = NULL ;

     HP_RegisterClass(( szClientClass),( ClientWndProc),( HP_CS_SIZEREDRAW),( 0)) ;

     hwndFrame = HP_CreateStdWindow (HWND_DESKTOP, HP_WS_VISIBLE,
                                     &flFrameFlags, szClientClass, NULL,
                                     0L, NULL, ID_RESOURCE, &hwndClient) ;

     //CHNG2a
     ShowWindow(hwndFrame, nCmdShow);
     UpdateWindow(hwndFrame);

     if (hwndFrame != NULL)
          {
          HP_SendMessage (hwndFrame, WM_SETICON,
                      HP_winQuerySysPointer (HWND_DESKTOP, SPTR_APPICON, FALSE),
                      NULL) ;

          while (GetMessage(( &qmsg), ( NULL), ( 0), ( 0)))
              {
               //CHNG2b
               TranslateMessage( &qmsg);
               DispatchMessage(( &qmsg)) ;
              }

          //CHNG2d
          //DestroyWindow (hwndFrame) ;
          }
      ;
      ;
     return 0 ;
     }

//CHNG1 Msgs are now UINT's
DWORD EXPENTRY ClientWndProc (HWND hwnd, UINT msg, DWORD mp1, DWORD mp2)
     {
     static CHAR  szErrorMsg [] = "File not found or could not be opened" ;
     static SHORT cxClient, cyClient, cxChar, cyChar, cyDesc ;
     CHAR         *pcReadBuffer ;
     FILE         *fileInput ;
     TEXTMETRIC  fm ;
     HDC          hps ;
     POINT       ptl ;
     SHORT        sLength ;
     //CHNG4
     HFONT        hFontReg, hFontPrev, hFontBld;
     //CHNG5
     PAINTSTRUCT  ps;

     switch (msg)
          {
          //CHNG2c
          case WM_DESTROY:
               PostQuitMessage(0);
               break;

          case WM_CREATE:
               hps = GetDC (hwnd) ;
               //CHNG4
               //EzfQueryFonts (hps) ;

               hFontReg = HP_SimpleFont( "Courier", 0, 0, 0);
               if (hFontReg == NULL)
                    {
                    ReleaseDC(hwnd,(hps)) ;

                    MessageBox((HWND_DESKTOP),(
                         "Cannot find a fixed-pitch font.  Load the Courier "
                         "fonts from the Control Panel and try again."),(
                         szClientClass),( MB_OK | MB_ICONEXCLAMATION)) ;

                    return 1 ;
                    }
               GetTextMetrics((hps),( &fm)) ;
               cxChar = (SHORT) fm.tmAveCharWidth ;
               cyChar = (SHORT) fm.tmHeight ;
               cyDesc = (SHORT) fm.tmDescent ;

               SelectObject((hps),hFontPrev) ;
               DeleteObject(hFontReg) ;
               ReleaseDC(hwnd,(hps)) ;
               return 0 ;
          
          case WM_SIZE:
               cxClient = LOWORD (mp2) ;
               cyClient = HIWORD (mp2) ;
               return 0 ;

          case WM_COMMAND:
               switch (COMMANDMSG(&msg)->cmd)
                    {
                    case IDM_OPEN:
                         if (DialogBoxParam(hinst,MAKEINTRESOURCE(( IDD_OPEN)),(HWND_DESKTOP),( OpenDlgProc),( NULL)))
                              InvalidateRect((hwnd),( NULL),TRUE) ;
                         return 0 ;

                    case IDM_ABOUT:
                         DialogBoxParam(hinst,MAKEINTRESOURCE(( IDD_ABOUT)),(HWND_DESKTOP),( AboutDlgProc),( NULL)) ;
                         return 0 ;
                    }
               break ;

          case WM_PAINT:
               //CHNG5
               hps = BeginPaint( hwnd, &ps);
               //GpiErase (hps) ;

               if (szFileName [0] != '\0')
                    {
                    hFontReg  = HP_SimpleFont("Courier", 0,0,0);
                    hFontBld  = HP_SimpleFont("Courier", 0,0,FATTR_SEL_BOLD);

                    hFontPrev = SelectObject((hps),hFontBld) ;
                    ptl.x = cxChar ;
                    ptl.y = cyClient - cyChar + cyDesc ;
                    HP_gpiCharStringAt (hps, &ptl, (LONG) strlen (szFileName),
                                                szFileName) ;
                    ptl.y -= cyChar ;
                                
                    if ((fileInput = fopen (szFileName, "r")) != NULL)
                         {
                         SelectObject((hps),hFontReg) ;
                         pcReadBuffer = malloc (cxClient / cxChar) ;

                         while ((ptl.y -= cyChar) > 0 &&
                                fgets (pcReadBuffer, cxClient / cxChar - 2,
                                       fileInput) != NULL)
                              {
                              sLength = strlen (pcReadBuffer) ;

                              if (pcReadBuffer [sLength - 1] == '\n')
                                   sLength-- ;

                              if (sLength > 0)
                                   HP_gpiCharStringAt (hps, &ptl, (LONG) sLength,
                                                         pcReadBuffer) ;
                              }
                         free (pcReadBuffer) ;
                         fclose (fileInput) ;
                         }
                    else           // file cannot be opened
                         {
                         ptl.y -= cyChar ;
                         HP_gpiCharStringAt (hps, &ptl,
                                          (LONG) strlen (szErrorMsg),
                                          szErrorMsg) ;
                         }
                    SelectObject((hps),hFontPrev) ;
                    DeleteObject(hFontReg) ;
                    DeleteObject(hFontBld) ;
                    }
               //CHNG5
               EndPaint (hps, &ps) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, msg, mp1, mp2) ;
     }

//CHNG1 Msgs are now UINT's
DWORD EXPENTRY AboutDlgProc (HWND hwnd, UINT msg, DWORD mp1, DWORD mp2)
     {
     switch (msg)
          {
          case WM_COMMAND:
               switch (COMMANDMSG(&msg)->cmd)
                    {
                    case IDOK:
                    case IDCANCEL:
                         EndDialog (hwnd, TRUE) ;
                         //CHNG3
                         break;
                    //CHNG3
                    default:
                        return(FALSE);
                    }
               break ;
          //CHNG3
          default:
            return(FALSE);
          }
     //CHNG3
     return TRUE;
     }

//CHNG7
VOID FillDirListBox (HWND hwnd, CHAR *pcCurrentPath)
     {
     static CHAR szDrive [] = "  :" ;
     WIN32_FIND_DATA findbuf ;
     HANDLE        hDir = 1 ;
     SHORT       sDrive ;
     USHORT      usDriveNum, usCurPathLen, usSearchCount = 1 ;
     ULONG       ulDriveMap ;
     UINT        uRet;

     HP_dosQCurDisk (&usDriveNum, &ulDriveMap) ;
     pcCurrentPath [0] = (CHAR) usDriveNum + '@' ;
     pcCurrentPath [1] = ':' ;
     pcCurrentPath [2] = '\\' ;
     usCurPathLen = 64 ;
     HP_dosQCurDir (0, pcCurrentPath + 3, &usCurPathLen) ;

     SetDlgItemText (hwnd, IDD_PATH, pcCurrentPath) ;
     HP_DlgItemMessage (hwnd, IDD_DIRLIST, LB_RESETCONTENT, NULL, NULL) ;

     for (sDrive = 0 ; sDrive < 26 ; sDrive++)
          if (ulDriveMap & 1L << sDrive)
               {
               szDrive [1] = (CHAR) sDrive + 'A' ;

               HP_DlgItemMessage (hwnd, IDD_DIRLIST, LB_INSERTSTRING,
                                  MAKELONG (LIT_END, 0),
                                  MPFROMP (szDrive)) ;
               }

     hDir = FindFirstFile ("*.*", &findbuf);
     if (hDir == INVALID_HANDLE_VALUE)
        return;
     do
          {
          if (findbuf.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY &&
                    (findbuf.cFileName [0] != '.' || findbuf.cFileName [1]))
               
               SendDlgItemMessage (hwnd, IDD_DIRLIST, LB_INSERTSTRING,
                                  MAKELONG (MS_W32_NOTIMP(LIT_SORTASCENDING), 0),
                                  MPFROMP (findbuf.cFileName)) ;

          uRet = FindNextFile (hDir, &findbuf) ;
          } while (uRet);
     FindClose(hDir);
     }

//CHNG7
VOID FillFileListBox (HWND hwnd)
     {
     WIN32_FIND_DATA findbuf ;
     HANDLE        hDir = 1 ;
     USHORT      usSearchCount = 1 ;
     UINT        uRet;

     HP_DlgItemMessage (hwnd, IDD_FILELIST, LB_RESETCONTENT, NULL, NULL) ;

     hDir = FindFirstFile ("*.*", &findbuf);
     if (hDir == INVALID_HANDLE_VALUE)
        return;

     do 
          {
          if ( ! (findbuf.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
              SendDlgItemMessage (hwnd, IDD_FILELIST, LB_INSERTSTRING,
                             MAKELONG (MS_W32_NOTIMP(LIT_SORTASCENDING), 0),
                             MPFROMP (findbuf.cFileName)) ;

          uRet = FindNextFile (hDir, &findbuf) ;
          } while (uRet);
     FindClose(hDir);
     }

//CHNG1 Msgs are now UINT's
DWORD EXPENTRY OpenDlgProc (HWND hwnd, UINT msg, DWORD mp1, DWORD mp2)
     {
     static CHAR szCurrentPath [80], szBuffer [80] ;
     SHORT       sSelect ;

     switch (msg)
          {
          case WM_INITDIALOG:
               FillDirListBox (hwnd, szCurrentPath) ;
               FillFileListBox (hwnd) ;

               HP_DlgItemMessage (hwnd, IDD_FILEEDIT, EM_LIMITTEXT,
                                        MAKELONG (80, 0), NULL) ;
               //CHNG3
               return FALSE ;

          case WM_COMMAND:
               if (LOWORD (mp1) == IDD_DIRLIST ||
                   LOWORD (mp1) == IDD_FILELIST)
                    {
                    sSelect = (USHORT) HP_DlgItemMessage (hwnd,
                                                  LOWORD (mp1),
                                                  LB_GETCURSEL, 0L, 0L) ;

                    //CHNG8
                    if (sSelect != LB_ERR)
                    HP_DlgItemMessage (hwnd, LOWORD (mp1),
                                       HP_LB_GETTEXT,
                                       MAKELONG (sSelect, sizeof szBuffer),
                                       MPFROMP (szBuffer)) ;
                    }

               switch (LOWORD (mp1))             // Control ID
                    {
                    case IDD_DIRLIST:
                         switch (HIWORD (mp1))   // notification code
                              {
                              case LBN_DBLCLK:
                                   //CHNG8
                                   if (szBuffer [1] == ':')
                                        HP_dosSelectDisk (szBuffer [0] - '@') ;
                                   else
					HP_SetCurrentDirectory((szBuffer)) ;

                                   FillDirListBox (hwnd, szCurrentPath) ;
                                   FillFileListBox (hwnd) ;

                                   SetDlgItemText (hwnd, IDD_FILEEDIT, "") ;
                                   //CHNG3
                                   //return 0 ;
                                   break;
                              }
                         break ;

                    case IDD_FILELIST:
                         switch (HIWORD (mp1))   // notification code
                              {
                              case LBN_SELCHANGE:
                                   SetDlgItemText (hwnd, IDD_FILEEDIT,
                                                      szBuffer) ;
                                   //CHNG3
                                   //return 0 ;
                                   break;

                              case LBN_DBLCLK:
                                   ParseFileName (szFileName, szBuffer) ;
                                   EndDialog (hwnd, TRUE) ;
                                   //CHNG3
                                   //return 0 ;
                                   break;
                              }
                         break ;
                    //CHNG6
                    case IDOK:
                         GetDlgItemText((hwnd),( IDD_FILEEDIT),( szBuffer),(
                                              sizeof szBuffer)) ;

                         switch (ParseFileName (szCurrentPath, szBuffer))
                              {
                              case 0:
                                   MessageBeep(( MB_ICONHAND)) ;
                                   FillDirListBox (hwnd, szCurrentPath) ;
                                   FillFileListBox (hwnd) ;
                                   //CHNG3
                                   break;

                              case 1:
                                   FillDirListBox (hwnd, szCurrentPath) ;
                                   FillFileListBox (hwnd) ;
                                   SetDlgItemText (hwnd, IDD_FILEEDIT, "") ;
                                   //CHNG3
                                   break;

                              case 2:
                                   strcpy (szFileName, szCurrentPath) ;
                                   EndDialog (hwnd, TRUE) ;
                                   //CHNG3
                                   break;
                              }
                         break ;

                    case IDCANCEL:
                         EndDialog (hwnd, FALSE) ;
                         //CHNG3
                         break;
                    default:
                        return(FALSE);
                    }
               break ;
          //CHNG3
          default:
              return(FALSE);
          }
     //CHNG3
     return TRUE;
     }

SHORT ParseFileName (CHAR *pcOut, CHAR *pcIn)
     {
          /*----------------------------------------------------------------
             Input:    pcOut -- Pointer to parsed file specification.
                       pcIn  -- Pointer to raw file specification.
                       
             Returns:  0 -- pcIn had invalid drive or directory.
                       1 -- pcIn was empty or had no filename.
                       2 -- pcOut points to drive, full dir, and file name.

             Changes current drive and directory per pcIn string.
            ----------------------------------------------------------------*/

     CHAR   *pcLastSlash, *pcFileOnly ;
     ULONG  ulDriveMap ;
     USHORT usDriveNum, usDirLen = 64 ;

     strupr (pcIn) ;

               // If input string is empty, return 1

     if (pcIn [0] == '\0')
          return 1 ;

               // Get drive from input string or current drive

     if (pcIn [1] == ':')
          {
          if (HP_dosSelectDisk (pcIn [0] - '@'))
               return 0 ;

          pcIn += 2 ;
          }
     HP_dosQCurDisk (&usDriveNum, &ulDriveMap) ;

     *pcOut++ = (CHAR) usDriveNum + '@' ;
     *pcOut++ = ':' ;
     *pcOut++ = '\\' ;

               // If rest of string is empty, return 1

     if (pcIn [0] == '\0')
          return 1 ;

               // Search for last backslash.  If none, could be directory.

     if (NULL == (pcLastSlash = strrchr (pcIn, '\\')))
          {
	  if (!HP_SetCurrentDirectory((pcIn)))
               return 1 ;

                    // Otherwise, get current dir & attach input filename

          HP_dosQCurDir (0, pcOut, &usDirLen) ;

          if (strlen (pcIn) > 12)
               return 0 ;

          if (*(pcOut + strlen (pcOut) - 1) != '\\')
               strcat (pcOut++, "\\") ;

          strcat (pcOut, pcIn) ;
          return 2 ;
          }
               // If the only backslash is at beginning, change to root

     if (pcIn == pcLastSlash)
          {
	  HP_SetCurrentDirectory(("\\")) ;

          if (pcIn [1] == '\0')
               return 1 ;

          strcpy (pcOut, pcIn + 1) ;
          return 2 ;
          }
               // Attempt to change directory -- Get current dir if OK

     *pcLastSlash = '\0' ;

     if (HP_SetCurrentDirectory((pcIn)))
          return 0 ;

     HP_dosQCurDir (0, pcOut, &usDirLen) ;

               // Append input filename, if any

     pcFileOnly = pcLastSlash + 1 ;

     if (*pcFileOnly == '\0')
          return 1 ;

     if (strlen (pcFileOnly) > 12)
          return 0 ;

     if (*(pcOut + strlen (pcOut) - 1) != '\\')
          strcat (pcOut++, "\\") ;

     strcat (pcOut, pcFileOnly) ;
     return 2 ;
     }
