/*------------------------------
   HEAD.C -- Displays File Head
  ------------------------------*/

#define INCL_WIN
#define INCL_GPI
#include <os2win.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include "easyfont.h"
#include "head.h"

#define LCID_FIXEDFONT   1L
#define LCID_BOLDFONT    2L

DWORD EXPENTRY ClientWndProc (HWND, USHORT, DWORD, DWORD) ;
DWORD EXPENTRY AboutDlgProc  (HWND, USHORT, DWORD, DWORD) ;
DWORD EXPENTRY OpenDlgProc   (HWND, USHORT, DWORD, DWORD) ;
SHORT            ParseFileName (CHAR *, CHAR *) ;

CHAR szClientClass [] = "Head" ;
CHAR szFileName [80] ;
int  hab ;

int main (int argc, char *argv[])
     {
     static ULONG flFrameFlags = HP_FCF_TITLEBAR      | HP_FCF_SYSMENU  |
                                 HP_FCF_SIZEBORDER    | HP_FCF_MINMAX   |
                                 MS_W32_NOTIMP(FCF_SHELLPOSITION) | MS_W32_NOTIMP(FCF_TASKLIST) |
                                 HP_FCF_MENU ;
     int          hmq ;
     HWND         hwndFrame, hwndClient ;
     QMSG         qmsg ;

               // Check for filename parameter and copy to szFileName

     if (argc > 1)
          ParseFileName (szFileName, argv [1]) ;

               // Continue normally
     
     hab = WinInitialize (0) ;
     hmq = WinCreateMsgQueue (hab, 0) ;

     WinRegisterClass (hab, szClientClass, ClientWndProc, HP_CS_SIZEREDRAW, 0) ;

     hwndFrame = HP_CreateStdWindow (HWND_DESKTOP, HP_WS_VISIBLE,
                                     &flFrameFlags, szClientClass, NULL,
                                     0L, NULL, ID_RESOURCE, &hwndClient) ;

     if (hwndFrame != NULL)
          {
          HP_SendMessage (hwndFrame, WM_SETICON,
                      HP_winQuerySysPointer (HWND_DESKTOP, SPTR_APPICON, FALSE),
                      NULL) ;

          while (WinGetMsg (hab, &qmsg, NULL, 0, 0))
               WinDispatchMsg (hab, &qmsg) ;

          DestroyWindow (hwndFrame) ;
          }
     WinDestroyMsgQueue (hmq) ;
     WinTerminate (hab) ;
     return 0 ;
     }

DWORD EXPENTRY ClientWndProc (HWND hwnd, USHORT msg, DWORD mp1, DWORD mp2)
     {
     static CHAR  szErrorMsg [] = "File not found or could not be opened" ;
     static SHORT cxClient, cyClient, cxChar, cyChar, cyDesc ;
     CHAR         *pcReadBuffer ;
     FILE         *fileInput ;
     TEXTMETRIC  fm ;
     HDC          hps ;
     POINT       ptl ;
     SHORT        sLength ;

     switch (msg)
          {
          case WM_CREATE:
               hps = GetDC (hwnd) ;
               EzfQueryFonts (hps) ;

               if (!EzfCreateLogFont (hps, LCID_FIXEDFONT, FONTFACE_COUR,
                                                           FONTSIZE_10, 0))
                    {
                    WinReleasePS (hps) ;

                    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
                         "Cannot find a fixed-pitch font.  Load the Courier "
                         "fonts from the Control Panel and try again.",
                         szClientClass, 0, MB_OK | MB_ICONEXCLAMATION) ;

                    return 1 ;
                    }
               GpiQueryFontMetrics (hps, (LONG) sizeof fm, &fm) ;
               cxChar = (SHORT) fm.tmAveCharWidth ;
               cyChar = (SHORT) fm.tmHeight ;
               cyDesc = (SHORT) fm.tmDescent ;

               GpiSetCharSet (hps, LCID_DEFAULT) ;
               GpiDeleteSetId (hps, LCID_FIXEDFONT) ;
               WinReleasePS (hps) ;
               return 0 ;
          
          case WM_SIZE:
               cxClient = LOWORD (mp2) ;
               cyClient = HIWORD (mp2) ;
               return 0 ;

          case WM_COMMAND:
               switch (COMMANDMSG(&msg)->cmd)
                    {
                    case IDM_OPEN:
                         if (WinDlgBox (HWND_DESKTOP, hwnd, OpenDlgProc,
                                        NULL, IDD_OPEN, NULL))
                              WinInvalidateRect (hwnd, NULL, FALSE) ;
                         return 0 ;

                    case IDM_ABOUT:
                         WinDlgBox (HWND_DESKTOP, hwnd, AboutDlgProc,
                                    NULL, IDD_ABOUT, NULL) ;
                         return 0 ;
                    }
               break ;

          case WM_PAINT:
               hps = WinBeginPaint (hwnd, NULL, NULL) ;
               GpiErase (hps) ;

               if (szFileName [0] != '\0')
                    {
                    EzfCreateLogFont (hps, LCID_FIXEDFONT, FONTFACE_COUR,
                                           FONTSIZE_10,    0) ;
                    EzfCreateLogFont (hps, LCID_BOLDFONT,  FONTFACE_COUR,
                                           FONTSIZE_10,    FATTR_SEL_BOLD) ;

                    GpiSetCharSet (hps, LCID_BOLDFONT) ;
                    ptl.x = cxChar ;
                    ptl.y = cyClient - cyChar + cyDesc ;
                    HP_gpiCharStringAt (hps, &ptl, (LONG) strlen (szFileName),
                                                szFileName) ;
                    ptl.y -= cyChar ;
                                
                    if ((fileInput = fopen (szFileName, "r")) != NULL)
                         {
                         GpiSetCharSet (hps, LCID_FIXEDFONT) ;
                         pcReadBuffer = malloc (cxClient / cxChar) ;

                         while ((ptl.y -= cyChar) > 0 &&
                                fgets (pcReadBuffer, cxClient / cxChar - 2,
                                       fileInput) != NULL)
                              {
                              sLength = strlen (pcReadBuffer) ;

                              if (pcReadBuffer [sLength - 1] == '\n')
                                   sLength-- ;

                              if (sLength > 0)
                                   HP_gpiCharStringAt (hps, &ptl, (LONG) sLength,
                                                         pcReadBuffer) ;
                              }
                         free (pcReadBuffer) ;
                         fclose (fileInput) ;
                         }
                    else           // file cannot be opened
                         {
                         ptl.y -= cyChar ;
                         HP_gpiCharStringAt (hps, &ptl,
                                          (LONG) strlen (szErrorMsg),
                                          szErrorMsg) ;
                         }
                    GpiSetCharSet (hps, LCID_DEFAULT) ;
                    GpiDeleteSetId (hps, LCID_FIXEDFONT) ;
                    GpiDeleteSetId (hps, LCID_BOLDFONT) ;
                    }
               WinEndPaint (hps) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, msg, mp1, mp2) ;
     }

DWORD EXPENTRY AboutDlgProc (HWND hwnd, USHORT msg, DWORD mp1, DWORD mp2)
     {
     switch (msg)
          {
          case WM_COMMAND:
               switch (COMMANDMSG(&msg)->cmd)
                    {
                    case IDOK:
                    case IDCANCEL:
                         EndDialog (hwnd, TRUE) ;
                         return 0 ;
                    }
               break ;
          }
     return TRUE /* MS_WARNING! DLG BOXE RTNS must be changed */ (hwnd, msg, mp1, mp2) ;
     }

VOID FillDirListBox (HWND hwnd, CHAR *pcCurrentPath)
     {
     static CHAR szDrive [] = "  :" ;
     WIN32_FIND_DATA findbuf ;
     HANDLE        hDir = 1 ;
     SHORT       sDrive ;
     USHORT      usDriveNum, usCurPathLen, usSearchCount = 1 ;
     ULONG       ulDriveMap ;

     HP_dosQCurDisk (&usDriveNum, &ulDriveMap) ;
     pcCurrentPath [0] = (CHAR) usDriveNum + '@' ;
     pcCurrentPath [1] = ':' ;
     pcCurrentPath [2] = '\\' ;
     usCurPathLen = 64 ;
     HP_dosQCurDir (0, pcCurrentPath + 3, &usCurPathLen) ;

     SetDlgItemText (hwnd, IDD_PATH, pcCurrentPath) ;
     HP_DlgItemMessage (hwnd, IDD_DIRLIST, LB_RESETCONTENT, NULL, NULL) ;

     for (sDrive = 0 ; sDrive < 26 ; sDrive++)
          if (ulDriveMap & 1L << sDrive)
               {
               szDrive [1] = (CHAR) sDrive + 'A' ;

               HP_DlgItemMessage (hwnd, IDD_DIRLIST, LB_INSERTSTRING,
                                  MAKELONG (LIT_END, 0),
                                  MPFROMP (szDrive)) ;
               }

     DosFindFirst ("*.*", &hDir, 0x0017, &findbuf, sizeof findbuf,
                              &usSearchCount, 0L) ;
     while (usSearchCount)
          {
          if (findbuf.dwFileAttributes & 0x0010 &&
                    (findbuf.cFileName [0] != '.' || findbuf.cFileName [1]))
               
               HP_DlgItemMessage (hwnd, IDD_DIRLIST, LB_INSERTSTRING,
                                  MAKELONG (MS_W32_NOTIMP(LIT_SORTASCENDING), 0),
                                  MPFROMP (findbuf.cFileName)) ;

          DosFindNext (hDir, &findbuf, sizeof findbuf, &usSearchCount) ;
          }
     }

VOID FillFileListBox (HWND hwnd)
     {
     WIN32_FIND_DATA findbuf ;
     HANDLE        hDir = 1 ;
     USHORT      usSearchCount = 1 ;

     HP_DlgItemMessage (hwnd, IDD_FILELIST, LB_RESETCONTENT, NULL, NULL) ;

     DosFindFirst ("*.*", &hDir, 0x0007, &findbuf, sizeof findbuf,
                              &usSearchCount, 0L) ;
     while (usSearchCount)
          {
          HP_DlgItemMessage (hwnd, IDD_FILELIST, LB_INSERTSTRING,
                             MAKELONG (MS_W32_NOTIMP(LIT_SORTASCENDING), 0),
                             MPFROMP (findbuf.cFileName)) ;

          DosFindNext (hDir, &findbuf, sizeof findbuf, &usSearchCount) ;
          }
     }

DWORD EXPENTRY OpenDlgProc (HWND hwnd, USHORT msg, DWORD mp1, DWORD mp2)
     {
     static CHAR szCurrentPath [80], szBuffer [80] ;
     SHORT       sSelect ;

     switch (msg)
          {
          case WM_INITDIALOG:
               FillDirListBox (hwnd, szCurrentPath) ;
               FillFileListBox (hwnd) ;

               HP_DlgItemMessage (hwnd, IDD_FILEEDIT, EMs_LIMITTEXT,
                                        MAKELONG (80, 0), NULL) ;
               return 0 ;

          case WM_COMMAND:
               if (LOWORD (mp1) == IDD_DIRLIST ||
                   LOWORD (mp1) == IDD_FILELIST)
                    {
                    sSelect = (USHORT) HP_DlgItemMessage (hwnd,
                                                  LOWORD (mp1),
                                                  LB_GETCURSEL, 0L, 0L) ;

                    HP_DlgItemMessage (hwnd, LOWORD (mp1),
                                       HP_LB_GETTEXT,
                                       MAKELONG (sSelect, sizeof szBuffer),
                                       MPFROMP (szBuffer)) ;
                    }

               switch (LOWORD (mp1))             // Control ID
                    {
                    case IDD_DIRLIST:
                         switch (HIWORD (mp1))   // notification code
                              {
                              case LBN_DBLCLK:
                                   if (szBuffer [0] == ' ')
                                        HP_dosSelectDisk (szBuffer [1] - '@') ;
                                   else
					DosChDir (szBuffer, 0L) ;

                                   FillDirListBox (hwnd, szCurrentPath) ;
                                   FillFileListBox (hwnd) ;

                                   SetDlgItemText (hwnd, IDD_FILEEDIT, "") ;
                                   return 0 ;
                              }
                         break ;

                    case IDD_FILELIST:
                         switch (HIWORD (mp1))   // notification code
                              {
                              case LBN_SELCHANGE:
                                   SetDlgItemText (hwnd, IDD_FILEEDIT,
                                                      szBuffer) ;
                                   return 0 ;

                              case LBN_DBLCLK:
                                   ParseFileName (szFileName, szBuffer) ;
                                   EndDialog (hwnd, TRUE) ;
                                   return 0 ;
                              }
                         break ;
                    }
               break ;

          case WM_COMMAND:
               switch (COMMANDMSG(&msg)->cmd)
                    {
                    case IDOK:
                         WinQueryDlgItemText (hwnd, IDD_FILEEDIT,
                                              sizeof szBuffer, szBuffer) ;

                         switch (ParseFileName (szCurrentPath, szBuffer))
                              {
                              case 0:
                                   WinAlarm (HWND_DESKTOP, MB_ICONHAND) ;
                                   FillDirListBox (hwnd, szCurrentPath) ;
                                   FillFileListBox (hwnd) ;
                                   return 0 ;

                              case 1:
                                   FillDirListBox (hwnd, szCurrentPath) ;
                                   FillFileListBox (hwnd) ;
                                   SetDlgItemText (hwnd, IDD_FILEEDIT, "") ;
                                   return 0 ;

                              case 2:
                                   strcpy (szFileName, szCurrentPath) ;
                                   EndDialog (hwnd, TRUE) ;
                                   return 0 ;
                              }
                         break ;

                    case IDCANCEL:
                         EndDialog (hwnd, FALSE) ;
                         return 0 ;
                    }
               break ;
          }
     return TRUE /* MS_WARNING! DLG BOXE RTNS must be changed */ (hwnd, msg, mp1, mp2) ;
     }

SHORT ParseFileName (CHAR *pcOut, CHAR *pcIn)
     {
          /*----------------------------------------------------------------
             Input:    pcOut -- Pointer to parsed file specification.
                       pcIn  -- Pointer to raw file specification.
                       
             Returns:  0 -- pcIn had invalid drive or directory.
                       1 -- pcIn was empty or had no filename.
                       2 -- pcOut points to drive, full dir, and file name.

             Changes current drive and directory per pcIn string.
            ----------------------------------------------------------------*/

     CHAR   *pcLastSlash, *pcFileOnly ;
     ULONG  ulDriveMap ;
     USHORT usDriveNum, usDirLen = 64 ;

     strupr (pcIn) ;

               // If input string is empty, return 1

     if (pcIn [0] == '\0')
          return 1 ;

               // Get drive from input string or current drive

     if (pcIn [1] == ':')
          {
          if (HP_dosSelectDisk (pcIn [0] - '@'))
               return 0 ;

          pcIn += 2 ;
          }
     HP_dosQCurDisk (&usDriveNum, &ulDriveMap) ;

     *pcOut++ = (CHAR) usDriveNum + '@' ;
     *pcOut++ = ':' ;
     *pcOut++ = '\\' ;

               // If rest of string is empty, return 1

     if (pcIn [0] == '\0')
          return 1 ;

               // Search for last backslash.  If none, could be directory.

     if (NULL == (pcLastSlash = strrchr (pcIn, '\\')))
          {
	  if (!DosChDir (pcIn, 0L))
               return 1 ;

                    // Otherwise, get current dir & attach input filename

          HP_dosQCurDir (0, pcOut, &usDirLen) ;

          if (strlen (pcIn) > 12)
               return 0 ;

          if (*(pcOut + strlen (pcOut) - 1) != '\\')
               strcat (pcOut++, "\\") ;

          strcat (pcOut, pcIn) ;
          return 2 ;
          }
               // If the only backslash is at beginning, change to root

     if (pcIn == pcLastSlash)
          {
	  DosChDir ("\\", 0L) ;

          if (pcIn [1] == '\0')
               return 1 ;

          strcpy (pcOut, pcIn + 1) ;
          return 2 ;
          }
               // Attempt to change directory -- Get current dir if OK

     *pcLastSlash = '\0' ;

     if (DosChDir (pcIn, 0L))
          return 0 ;

     HP_dosQCurDir (0, pcOut, &usDirLen) ;

               // Append input filename, if any

     pcFileOnly = pcLastSlash + 1 ;

     if (*pcFileOnly == '\0')
          return 1 ;

     if (strlen (pcFileOnly) > 12)
          return 0 ;

     if (*(pcOut + strlen (pcOut) - 1) != '\\')
          strcat (pcOut++, "\\") ;

     strcat (pcOut, pcFileOnly) ;
     return 2 ;
     }
