#
# Hacked up Nmake makefile for GNU Sed.
#
# TimF, ArdenW	17-Apr-92
#


# You must have a couple of environment variables set:
#
# 	CPU must be set to one of "MIPS" or "i386",
#		Build for mips assumes r4000.
#
#	INCLUDE must ne set the full path to your NT .h files.
#
#	LIB must be set to the full path to your NT .lib files.
#		(coffbase.txt must be at $(LIB)\..\coffbase.txt
#
#


!IF "$(CPU)" == "MIPS"
# Set up the compiler flags for building on mips

# I wonder how many of the flags aren't required for anything but building a
# kernel...

CFLAGS = -std -Wb,-dwalign -G 0 -std -checkstack 4096 -excpt -g0 -O -EL	\
	-c -Wab,MIPS2 -Wab,-diag -DMIPS=1 -DNO_EXT_KEYS -DMIPSEL 	\
	-DDEVL=1 -DCONDITION_HANDLING=1 -DNT_INST=0 -DNT_UP=1 -DJAZZ	\
	-DR4000	-DDBG=1

!ELSE
!IF "$(CPU)" == "i386"
# Set up the compiler flags for building on x86

CFLAGS = -nologo -Di386=1 -DCONDITION_HANDLING=1 -DNT_UP=1 -DNT_INST=0	\
	-DDBG=1 -DDEVL=1 /c /Zel -W2 -H63 /AS /G3d /Ox /Zd

!ELSE
!ERROR You must specify CPU as either i386 or MIPS.
!ENDIF
!ENDIF


!IFNDEF INCLUDE
!ERROR You need to set INCLUDE to the NT .h files directory.
!ELSE
INCLUDEP = -I. -I$(INCLUDE) -I$(INCLUDE)\crt
!ENDIF


!IFNDEF LIB
!ERROR You need to set LIB to the NT .lib files directory.
!ENDIF


GENERICFLAGS = -DWINDOWSNT=1 -DSTDC_HEADERS=1


NAME =	sed

TARGET= $(BLD)\$(NAME).exe
TLIB =	$(BLD)\$(NAME).lib
TOBJ =	$(BLD)\sed.obj

BLD =	obj


OBJ =	$(BLD)\alloca.obj	\
	$(BLD)\getopt.obj	\
	$(BLD)\getopt1.obj	\
	$(BLD)\regex.obj	\
	$(BLD)\utils.obj


LIBS =	$(TLIB)			\
	$(LIB)\setargv.obj	\
	$(LIB)\kernel32.lib	\
	$(LIB)\libc.lib		\
	$(LIB)\ntdll.lib

!IF "$(CPU)" == "MIPS"
$(TARGET): $(LIBS) $(TOBJ)
	@- coff -LINK -out:$(TARGET) -debug:PARTIAL -machine:mips -base:@$(LIB)\..\coffbase.txt,usermode -subsystem:console -entry:mainCRTStartup $(TOBJ) $(LIBS)

$(TLIB): $(OBJ)
	@- coff -lib -out:$(TLIB) $**

.c{$(BLD)}.obj:
	@- if not exist $(BLD) md $(BLD) >nul 2>&1
	@- chmode -r $@ >nul 2>&1
	@- del $@ >nul 2>&1
	@- echo cc $<
	@- cc $(CFLAGS) $(GENERICFLAGS) $(INCLUDEP) -Olimit 1250 -o $@ $<
	@- mip2coff $@
!ELSE
$(TARGET): $(LIBS) $(TOBJ)
	link -out:$(TARGET) -debug:PARTIAL -machine:i386 -base:@$(LIB)\..\coffbase.txt,usermode -align:0x1000 -subsystem:console -entry:mainCRTStartup $(TOBJ) $(LIBS)

$(TLIB): $(OBJ)
	lib -out:$(TLIB) $**

.c{$(BLD)}.obj:
	@- if not exist $(BLD) md $(BLD) >nul 2>&1
	@- chmode -r $@ >nul 2>&1
	@- del $@ >nul 2>&1
	@- cl386 $(CFLAGS) $(GENERICFLAGS) $(INCLUDEP) -Fo$@ $<
	@- cvtomf $@
!ENDIF
