/*
 * chemtab - a periodic table data base (C) 1989 Jim King (pulsar@lsrhs)
 *
 * cleanup.c	Cleanup (exit) routine
 */

#include <curses.h>
#include <stdio.h>
#include "win.h"
#include "variable.h"
#include <process.h>

/*
 * cleanup() - no input
 *
 * purpose:  Handle any quit or ^C signal nicely.
 */

cleanup()
{
	char	c, unm[80];			/* input */
	if (trans) {				/* transcript flag */
		mvwaddstr(btm, 0, 0, "Would you like your transcript printed out? ");
		wrefresh(btm);
		noecho();
		crmode();
		c = getchar();
		if (c == 'n') {
			wclear(btm);
			wrefresh(btm);
		} else {			/* else print it out */
			wprintw(btm, "yes");
			wrefresh(btm);
			fclose(fp);
#ifdef WIN32
                        mvwaddstr(btm, 2, 0, "The Windows NT version does not currently support printing.");
                        wrefresh(btm);
                        getchar();
#else
			sprintf(str, "/usr/local/bin/letter -h %d.chemtab", getpid());
			system(str);
#endif
			wclear(btm);
			wrefresh(btm);
		}
	}
	fclose(fp);				/* close things up */
	clear(); refresh();
	echo();
	nocrmode();
	endwin();				/* turn off curses */
	if (trans) {
		printf("A copy of your transcript can be found in the file %s.chemtab\n", lnm);
		printf("\nYou can pick up your printout at the printer to the left of\n");
		printf("The White-Board, labelled Happy.  Look for your last name in >><<'s on\n");
		printf("the top line of each printout.  Good luck with Chemistry.\n");
	}
	fflush(stdout);				/* just make sure.. */
	exit(1);				/* quit nicely */
}
