/*
 * chemtab - a periodic table data base (C) 1989 by Jim King (pulsar@lsrhs)
 *
 * element.c	Reads in the file from the #define PERTABLE (which is the
 *		data file) and sorts into the structure l1 (e).
 */

#include "variable.h"
#include "element.h"
#include "tune.h"
#include <stdio.h>

/*
 * readelem() - no input
 *
 * purpose:	Take a line from PERTABLE (tune.h) and put it in structure
 *		e[] which is defined as the element table used throughout
 *		the program.  This was designed so the operator could easily
 *		change an element or add one without changing anything but
 *		tune.h
 */
readelem()
{
	char	foo[160];			/* input line */
	int	i;				/* for loop int */
	FILE	*fp;				/* File pointer for PERTABLE */

	if ((fp = fopen(PERTABLE, "r")) == NULL) { /* Open it please */
		bot("Cannot open element data file");
		sleep(3);
		cleanup();
	}

	fgets(foo, 160, fp);			/* Read in comment line */
	fgets(foo, 160, fp);			/* Eat the spacer */

	for (i = 1; i < MAXLM+1; i++) {		/* Munch that damn line!! */
		if (fscanf(fp, "%s%s%d%d%d%d%d%d%d%d%d%f%f%f%f\n",
		       e[i].name, e[i].sym, &e[i].anum, &e[i].amass, &e[i].fam,
		       &e[i].row, &e[i].val, &e[i].melt, &e[i].boil,
		       &e[i].fio, &e[i].year, &e[i].eneg, &e[i].spht,
		       &e[i].dens, &e[i].arad) == EOF)
		       	break;
	}
	fclose(fp);				/* Be nice and neat */
}
