/*
 * chemtab - a periodic table data base (C) 1989 by Jim King (pulsar@lsrhs)
 *
 * element.h	Contains the structure for all the elements, e[].
 */

#include "tune.h"

struct elem {
	char	name[15],		/* Atomic Name */
		sym[4];			/* Atomic Symbol */
	float	eneg,			/* Electronegativity */
		spht,			/* Specific Heat */
		arad,			/* Atomic Radius */
		dens;			/* Density of the Solid */
	int	anum,			/* Atomic Number */
		amass,			/* Atomic Mass */
		melt,			/* Melting point, deg C */
		boil,			/* Boiling point, deg C */
		fio,			/* First Ionization Energy, cal */
		year,			/* Year Discovered */
		val,			/* Valence Electrons */
		fam,			/* Family (1-18, new system) */
		row;			/* Horizontal rows */
} e[MAXLM];
