/*
 * chemtab - a periodic table data base (C) 1989 Jim King pulsar@lsrhs
 *
 * looke.c - look for an element, then print known stats
 */

#include <curses.h>
#include <stdio.h>
#include "element.h"
#include "variable.h"
#include "tune.h"
#include "win.h"
#include "undefs.h"

/*
 * disp(l)
 *	input:	l - int - referring to atomic number of elem. to display
 *	output: curses only
 *
 * purpose:	separate the displaying from the rest of the subroutine
 */
disp(l)
int	l;
{
	wclear(graph);
	wmove(graph, 0, 0); wprintw(graph, "Atomic Name: %s", e[l].name);
	wmove(graph, 1, 0); wprintw(graph, "Atomic Symbol: %s", e[l].sym);
	wmove(graph, 2, 0); wprintw(graph, "Atomic Number: %d", e[l].anum);
	wmove(graph, 3, 0); wprintw(graph, "Atomic Mass: %d", e[l].amass);

	if (e[l].melt == MEL)
		mvwaddstr(graph, 5, 0, "Melting Temp: NOT AVAILABLE");
	else {
		wmove(graph, 5, 0); wprintw(graph, "Melting Temp: %d Celcius", e[l].melt);
	}
	if (e[l].boil == BOI)
		mvwaddstr(graph, 5, 40, "Boiling Temp: NOT AVAILABLE");
	else {
		wmove(graph, 5, 40); wprintw(graph, "Boiling Temp: %d Celcius", e[l].boil);
	}
	if (e[l].spht == SPHT)
		mvwaddstr(graph, 7, 0, "Specific Heat: NOT AVAILABLE");
	else {
		wmove(graph, 7, 0); wprintw(graph, "Specific Heat: %1.2f", e[l].spht);
	}
	if (e[l].dens == DENS)
		mvwaddstr(graph, 8, 0, "Density: NOT AVAILABLE");
	else {
		wmove(graph, 8, 0); wprintw(graph, "Density: %2.2f", e[l].dens);
	}
	if (e[l].arad == ARD)
		mvwaddstr(graph, 9, 0, "Atomic Radius: NOT AVAILABLE");
	else {
		wmove(graph, 9, 0); wprintw(graph, "Atomic Radius: %1.2f Angstroms", e[l].arad);
	}
	if (e[l].eneg == ENG)
		mvwaddstr(graph, 11, 0, "Electronegativity: NOT AVAILABLE");
	else {
		wmove(graph, 11, 0); wprintw(graph, "Electronegativity: %1.1f", e[l].eneg);
	}
	if (e[l].year == YEA)
		mvwaddstr(graph, 12, 0, "Discovery Year: ANCIENT, B.C.");
	else {
		wmove(graph, 12, 0); wprintw(graph, "Discovery Year: %d A.D.", e[l].year);
	}
	wrefresh(graph);
	capture(graph, 0, 0);
	spc();	/* space to continue? */
}
	
looke()
{
	char	*str,				/* Random input string */
		srch[80],			/* String comparison */
		c = '5';			/* choice input */
	noecho(); crmode();
	wclear(mn); wrefresh(mn);
	wclear(srt); wrefresh(srt);
	clear(); refresh();

	mvwaddstr(mn, 0, 0, "Look for element by:");
	mvwaddstr(mn, 2, 0, "1] Atomic Name");
	mvwaddstr(mn, 3, 0, "2] Atomic Number");
	mvwaddstr(mn, 4, 0, "3] Atomic Symbol");
	mvwaddstr(mn, 5, 0, "4] Return to Main Menu");
	if (hlp)
		mvwaddstr(mn, 7, 16, "(type in number of choice, do not hit return)");
	mvwaddstr(mn, 7, 0, "Your Choice? ");
	wrefresh(mn);
	noecho();
	crmode();
	while (c < '1' || c > '4')
#ifdef WIN32
                c = wgetch(mn);
#else
		c = wgetch();
#endif

	if (c == '4') {
		wprintw(mn, "Return to Main Menu.");
		wrefresh(mn);
		sleep(1);
		return(0);
	}
	
	if (c == '1') {		/* look by name */
		wprintw(mn, "Look by Name (all lowercase please)");
		if (hlp)
			mvwaddstr(mn, 9, 33, "(type in name of element, then hit return)");
		mvwaddstr(mn, 9, 0, "Name of Element: ");
		wrefresh(mn);
		echo();
		nocrmode();
		gets(srch);
	}

	if (c == '2') {		/* look by number */
		wprintw(mn, "Look by Number (1 - %d please)", MAXLM-1);
		if (hlp)
			mvwaddstr(mn, 9, 21, "(type in atomic number, then hit return)");
		mvwaddstr(mn, 9, 0, "Atomic Number: ");
		wrefresh(mn);
		echo();
		nocrmode();
		gets(srch);
	}

	if (c == '3') {		/* look by symbol */
		wprintw(mn, "Look by Symbol");
		if (hlp)
			mvwaddstr(mn, 9, 20, "(type in atomic symbol, then hit return)");
		mvwaddstr(mn, 9, 0, "Atomic Symbol: ");
		wrefresh(mn);
		echo();
		nocrmode();
		gets(srch);
	}
	
	wclear(mn); wrefresh(mn);
	for (i = 1; i < MAXLM; i++) {	/* Look for appropriate element */
		switch(c) {		/* then display it */
			case '1': str = e[i].name;
				if (strncmp(srch, str, sizeof(srch)) == 0) {
					disp(e[i].anum); goto nd;
				} else
					break;
			case '2':
				if (atoi(srch) == e[i].anum) {
					disp(e[i].anum); goto nd;
				} else
					break;
			case '3': str = e[i].sym;
				if (strncmp(srch, str, sizeof(srch)) == 0) {
					disp(e[i].anum); goto nd;
				} else
					break;
		}
	}
	mvwaddstr(mn, 11, 0, "No such element!");
	wrefresh(mn);
	sleep(2);
nd:	wclear(graph); wrefresh(graph);
	wclear(mn); wrefresh(mn);
	return(0);
}

		
