
/*
 * chemtab - a periodic table data base (C) 1989 Jim King (pulsar@lsrhs)
 *
 * main.c	Main program structure and branch
 *
 * 6/18/92 - Ported to Windows NT by David Feinleib
 */

#include <stdio.h>
#include <curses.h>
#include <time.h>
#include <signal.h>
#ifdef WIN32
#  include <process.h>
#endif

#include "variable.h"
#include "win.h"

extern int	cleanup();

/*
 * main() - no input
 *
 * purpose:	Main program branch & menu & inits
 */
main()
{
#ifdef TRANSCRIPT
	long	secs;		/* For logfile */
#endif TRANSCRIPT
	char	c;		/* input choice */
	initscr();		/* start curses */

	btm = newwin(1, 79, 23, 0);	/* Bottom line window */
	srt = newwin(5, 79, 0, 0);	/* Top sort window */
	graph = newwin(23, 79, 0, 0);	/* Whole screen overwrite */
	mn = newwin(17, 79, 5, 0);	/* Middle (main) window */

#ifdef	TRANSCRIPT			/* Log time and user in file */
	time(&secs);
	bot("Logging you in..");
	fp = fopen(TRANSCRIPT, "a+");
	fprintf(fp, "%s logged in at %s", getenv("USER"), ctime(&secs));
	fclose(fp);
#endif	TRANSCRIPT

	clear();
	mvaddstr(5, 37, "ChemTab");
	mvaddstr(9, 8, "\033#6Periodic Table Data Base");
	mvaddstr(20, 21, "Version 3.2b, December 1, 1989 by Jim King");
	mvaddstr(21, 4, "Windows NT port Jun 15 1992 by David Feinleib and the NT marching band");
	refresh();				/* Title page */
	spc();
frs:	mvwaddstr(btm, 0, 0, "Would you like extra explanations? ");
	wrefresh(btm);	/* .. help flag (hlp) */
	noecho();
	crmode();
	c = getchar();
	if (c == 'y') {
		wprintw(btm, "yes"); wrefresh(btm);
		hlp++;
	} else if (c != 'n') {
		mvwaddstr(btm, 0, 38, "(y or n)");
		goto frs;
	}
	wprintw(btm, "no"); wrefresh(btm);
	wclear(btm);
	wrefresh(btm);
nxt:	mvwaddstr(btm, 0, 0, "Would you like a transcript of graphs and information? ");
	wrefresh(btm);	/* transcript flag (trans) */
	c = getchar();
	if (c == 'y') {
		trans++;
		wclear(btm);
		mvwaddstr(btm, 0, 0, "Please enter your last name for the transcript: ");
		wrefresh(btm);
		echo(); nocrmode();
		gets(lnm);
#ifdef WIN32
                sprintf(str, "%d.ctb", getpid());
#else
		sprintf(str, "%d.chemtab", getpid());
#endif
		fp = fopen(str, "w");
		fprintf(fp, "*** ChemTab - Periodic Table Database - Transcript for >> %s <<", lnm);
		/* \n will be added later! */
	}
	else if (c != 'n') {
		mvwaddstr(btm, 0, 58, "(y or n) ");
		goto nxt;
	}
	wprintw(btm, "no"); wrefresh(btm);
	wclear(btm);
	wrefresh(btm);
	clear();
	refresh();

	bot("Reading in elements...");

	readelem();				/* Sort PERTABLE -> e[] */

	bot(" ");

	signal(SIGINT, cleanup);
#ifndef WIN32
	signal(SIGTSTP, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
#endif
	for (i = 0; i < 3; i++)			/* initialize sort choices */
		dosort[i].wch = 0;

	for (;;) {				/* main loop */
		wclear(mn);
		wrefresh(srt);
		upsort();			/* Update the sort window */
		for (i = 1; i < 7; i++) {
			wmove(mn, i+1, 0);
			wprintw(mn, "%d] %s", i, mopts[i]);
		}	/* give me choices and help, then branch off */
		if (hlp) {
			mvwaddstr(mn, 12, 16, "If you do not know what to do, consult your ChemTab handbook");
			mvwaddstr(mn, 9, 16, "(type in number of choice, do not hit return)");
		}
		wmove(mn, 9, 0); wrefresh(mn);
		wrefresh(mn);		
		wstandout(mn);
		mvwaddstr(mn, 0, 36, "MAIN MENU");
		wstandend(mn);
		mvwaddstr(mn, 9, 0, "Your choice? ");
		wclrtoeol(mn);
		wrefresh(mn);
		echo();
		crmode();
loop:		switch(wgetch(mn)) {
			case '2': schar(); esort(); break; /* Select Characteristics */
			case '3': vdata(); break; /* View Selected Elements */
			case '4': ptabl(); break; /* Print periodic table.. */
			case '5': dogph(); break; /* Do a graph for us..... */
			case '1': looke(); break; /* View specific Element. */
			case '6': cleanup(); break; /* Exit */
			default: goto loop;
		}
	}
}
