/*
 * chemtab - a periodic table data base (C) 1989 Jim King (pulsar@lsrhs)
 *
 * scrmisc.c	Collection of curses screen misc stuff
 */

#include <curses.h>
#include "variable.h"
#include "win.h"

#ifdef WIN32
#  define getchar() NTGetChar()
#endif

/*
 * bot(str)
 *	input:	str - char - string to print on bottom
 *	output: curses only
 *
 * purpose:	Take ''str'' and put it on ''btm'' (window)
 */
bot(str)
char	*str;
{
	wclear(btm); mvwaddstr(btm, 0, 0, str); wrefresh(btm);
}

/*
 * spc() - no input
 *
 * purpose:	To prompt the user that there is more..
 */
spc()
{
	wclear(btm); mvwaddstr(btm, 0, 0, "<< Press SPACE BAR to continue >>");
	wrefresh(btm);
	noecho(); crmode();
	getchar();
	wclear(btm);
	wrefresh(btm);
}

capture(win, f, z)
WINDOW	*win;
int	f, z;
{
	int	icn;			/* Internal count */
	if (trans) {
		if (!z) {
			for (i = 0; i < 5; i++) {
				fputc('\n', fp);
				icn++;
			}
		} else {
			for (i = 0; i < 3; i++) {
				fputc('\n', fp);
				icn++;
			}
			fprintf(fp, "Your selection characteristics are listed on the next line.\n");
			icn++;
			for (i = 0; i < 3; i++) {
				if (dosort[i].wch != 0) {
					icn++;
					fprintf(fp, "%s ", sopts[dosort[i].wch].chst);
					switch(dosort[i].sgn) {
						case EQUAL: fprintf(fp, "= "); break;
						case GREATER: fprintf(fp, "> "); break;
						default: fprintf(fp, "< ");
					}
					fprintf(fp, "%4.*f  ", sopts[dosort[i].wch].dnum, dosort[i].amt);
				}
			}
		}
		fputc('\n', fp);
		for (i = 0; i < 23; i++) {
			if (!f)
				fprintf(fp, "      ");
			for (j = 0; j < 80; j++) {
				wmove(graph, i, j);
				fputc(winch(graph), fp);
			}
			fputc('\n', fp);
		}
		for (i = 0; i < 4; i++)
			fputc('\n', fp);
	}
	fflush(fp);
	return(1);
}
