
/*
 * chemtab - a periodic table data base (C) 1989 Jim King (pulsar@lsrhs)
 *
 * vdata.c	View current data
 */

#include <stdio.h>
#include <curses.h>
#include "variable.h"
#include "tune.h"
#include "element.h"
#include "win.h"
#include "undefs.h"

/*
 * topline() - no input
 *
 * purpose:	sets up the topline of user info.
 */
topline()
{
	mvwaddstr(graph, 0, 0, "Name");
	mvwaddstr(graph, 0, 13, "Sy");
	mvwaddstr(graph, 0, 18, "Z");
	mvwaddstr(graph, 0, 22, "M");
	mvwaddstr(graph, 0, 26, "FM");
	mvwaddstr(graph, 0, 29, "R");
	mvwaddstr(graph, 0, 31, "V");
	mvwaddstr(graph, 0, 33, "Melt");
	mvwaddstr(graph, 0, 38, "Boil");
	mvwaddstr(graph, 0, 43, "FIO");
	mvwaddstr(graph, 0, 47, "Year");
	mvwaddstr(graph, 0, 52, "ENG");
	mvwaddstr(graph, 0, 56, "SPHT");
	mvwaddstr(graph, 0, 61, "DENS");
	mvwaddstr(graph, 0, 66, "ARAD");
	wrefresh(graph);
}

/*
 * vdata() - no input
 *
 * purpose:	show all information on all selected elements to user
 */
vdata()
{
	int	x = 0, flg = 0, factor = 1, l, m;

	wclear(mn);
	wrefresh(mn);

	clear();
	wclear(graph);
	wrefresh(graph);
	refresh();
	topline();
	if (gtot == 0) {
		mvwaddstr(graph, 5, 0, "No elements met the requirements you set.");
		wrefresh(graph);
		spc();
		clear();
		refresh();
		return(0);
	}
	sprintf(str, "GTOT = %d", gtot);
	bot(str);
	if (gtot > 22)
		factor++;
	if (gtot > 44)
		factor++;
	if (gtot > 66)
		factor++;
	if (gtot > 88)
		factor++;
	for (i = 0; i < factor; i++) {
		for (j = 22*i+1; j < 22*i+23; j++) {
			if (j > gtot)
				break;
			x = sub1[j];
			mvwaddstr(graph, j-22*i, 0, e[x].name);
			wmove(graph, j-22*i, 13); wprintw(graph, "%s", e[x].sym);
			wmove(graph, j-22*i, 18); wprintw(graph, "%-d", e[x].anum);
			wmove(graph, j-22*i, 22); wprintw(graph, "%-d", e[x].amass);
			wmove(graph, j-22*i, 26); wprintw(graph, "%-d", e[x].fam);
			wmove(graph, j-22*i, 29); wprintw(graph, "%-d", e[x].row);
			if (e[x].val == VAL) {
				wstandout(graph);
				mvwaddstr(graph, j-22*1, 31, "X");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 31); wprintw(graph, "%d", e[x].val);
			}
			if (e[x].melt == MEL) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 33, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 33); wprintw(graph, "%-d", e[x].melt);
			}
			if (e[x].boil == BOI) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 38, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 38); wprintw(graph, "%-d", e[x].boil);
			}
			if (e[x].fio == FIO) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 43, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 43); wprintw(graph, "%3d", e[x].fio);
			}
			if (e[x].year == YEA) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 47, "B.C.");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 47); wprintw(graph, "%-d", e[x].year);
			}
			if (e[x].eneg == ENG) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 52, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 52); wprintw(graph, "%1.1f", e[x].eneg);
			}
			if (e[x].spht == SPHT) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 56, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 56); wprintw(graph, "%1.2f", e[x].spht);
			}
			if (e[x].dens == DENS) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 61, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 61);
				if (e[x].dens > 9.99)
					wprintw(graph, "%2.1f", e[x].dens);
				else
					wprintw(graph, "%1.2f", e[x].dens);
			}
			if (e[x].arad == ARD) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 66, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 66); wprintw(graph, "%1.2f", e[x].arad);
			}
			wrefresh(graph);
		}
		spc();
		capture(graph, 0, 1);
		wclear(graph);
		topline();
	}
	clear();
	refresh();
	return(0);
}
