/**************

    Windows NT Curses Functions i/o for Win32 console mode

    Written by David Feinleib and the Windows NT marching band 6/15/92
    For use with PCCurses 1.4

****************/

#include <windows.h>
#include <stdio.h>
#include <io.h> /* eof() */


static int myrow = 1000;
static int mycol = 1000;

extern HANDLE hConIn;
extern HANDLE hConOut;

static int cbreak = 1;

void sleep(int seconds)
{
    Sleep(seconds * 1000);
}

void _cursescattr(char chr, DWORD attr)
{
    CHAR_INFO ciBuffer[1];
    COORD dwSize;
    SMALL_RECT srWindow;
    COORD dwOrigin;
    int i, len;

    dwSize.X = 1;
    dwSize.Y = 1;

    dwOrigin.X = 0;
    dwOrigin.Y = 0;

    srWindow.Left = mycol;
    srWindow.Top = myrow;
    srWindow.Right = mycol + 1;
    srWindow.Bottom = myrow + 1;

    if (chr == ' ' && attr < 10)
	{
	attr = (attr & 0x80);
	}

    ciBuffer[0].Char.AsciiChar = chr;
    ciBuffer[0].Attributes = attr;


    WriteConsoleOutput(hConOut, (PCHAR_INFO) &ciBuffer,
	    dwSize, dwOrigin, &srWindow);

    if (mycol++ >= 80)
	{
	mycol = 0;
	myrow++;
	}
}

void _cursescursor(int row, int column)
{
    COORD dwCursorPosition;

    if (row == myrow && column == mycol)
	return;

    dwCursorPosition.X = column;
    dwCursorPosition.Y = row;

    SetConsoleCursorPosition(hConOut, dwCursorPosition);

    myrow = row;
    mycol = column;
}

int _cursesgcols()
{
    CONSOLE_SCREEN_BUFFER_INFO csInfo;

    GetConsoleScreenBufferInfo(hConOut, &csInfo);
//    return (csInfo.dwSize.X);
    return (80);

}

int _cursesglines()
{
    CONSOLE_SCREEN_BUFFER_INFO csInfo;

    GetConsoleScreenBufferInfo(hConOut, &csInfo);
//    return (csInfo.dwSize.Y);
    return (25);

}

void _cursesputc(char chr, DWORD attr)
{

    CHAR_INFO ciBuffer[1];
    COORD dwSize;
    SMALL_RECT srWindow;
    COORD dwOrigin;
    int i, len;

    dwSize.X = 1;
    dwSize.Y = 1;

    dwOrigin.X = 0;
    dwOrigin.Y = 0;

    srWindow.Left = mycol;
    srWindow.Top = myrow;
    srWindow.Right = mycol + 1;
    srWindow.Bottom = myrow + 1;

    ciBuffer[0].Char.AsciiChar = chr;
    ciBuffer[0].Attributes = attr;

    WriteConsoleOutput(hConOut, (PCHAR_INFO) ciBuffer,
	    dwSize, dwOrigin, &srWindow);

    if (mycol++ >= 80)
	{
	mycol = 0;
	myrow++;
	}

}

void _cursesscroll(int urow, int lcol, int lrow, 
		int rcol, int lines, DWORD attr)
{
    SMALL_RECT srScrollRect;
    SMALL_RECT srClipRect;
    COORD dwDestOrigin;
    CHAR_INFO *ciFill;  
    int len, i;

    if (lines == 0)
	{
	COORD cr;
	DWORD dwWritten;
	CONSOLE_SCREEN_BUFFER_INFO screen_info;
	cr.X = 0;
	cr.Y = 0;
	FillConsoleOutputCharacter(hConOut, ' ', (rcol - lcol + 1) * (lrow - urow),
			cr, &dwWritten);
	return;
	}
    if (lines < 0)
	{       
	dwDestOrigin.Y = urow - 1;      
	}
    if (lines > 0)
	dwDestOrigin.Y = urow + 1;

    dwDestOrigin.X = lcol;

    srScrollRect.Left = lcol;
    srScrollRect.Top = urow;
    srScrollRect.Right = rcol;
    srScrollRect.Bottom = lrow;

    ScrollConsoleScreenBuffer(hConOut, &srScrollRect,
					NULL,
					dwDestOrigin,
					&ciFill);       
    len = (rcol - lcol) * (lrow - urow);

    for (i = 0; i < len; i++)
	{
	ciFill[i].Char.AsciiChar = ' ';
	ciFill[i].Attributes = 0;
	}
}

int _cursesgcmode()
{
    return (0); /* need to convert between con info (%) and bits */
}

/* _cursescmode -- sets cursor size */
void _cursescmode(int startrow, int endrow)
{
}

int _curseskey()
{
    int ch;

    ch = NTGetChar();

//    ch = getchar();

    return (ch);
}

int _curseskeytst()
{
    INPUT_RECORD        inputrec[81];
    DWORD               dwRead;
    int                 i;

    if (PeekConsoleInput(hConIn, (PINPUT_RECORD)inputrec, 80,
			  &dwRead))
	{
	for (i = 0; i < dwRead; i++)
	    {
	    if (inputrec[i].EventType == KEY_EVENT
			    && !inputrec[i].Event.KeyEvent.bKeyDown
			    && (isalnum(inputrec[i].Event.KeyEvent.uChar.AsciiChar) 
			    || ispunct(inputrec[i].Event.KeyEvent.uChar.AsciiChar)
			    || isspace(inputrec[i].Event.KeyEvent.uChar.AsciiChar)))
		return (TRUE);
	    }
	}
    return (FALSE);
}

int NTGetChar()
{
    char szBuf[5];
    DWORD dwRead;
    DWORD dwMode;
    DWORD dwModeSave = 0L;

    if (GetConsoleMode(hConIn, &dwMode))
	{
        dwModeSave = dwMode;
	dwMode &= ~ENABLE_LINE_INPUT;
        dwMode &= ~ENABLE_ECHO_INPUT;
	SetConsoleMode(hConIn, dwMode);
	}
    ReadFile(hConIn, szBuf, 1, &dwRead, NULL);
    if (dwModeSave)
        SetConsoleMode(hConIn, dwModeSave);

    return (szBuf[0]);

}

int _cursesgcb()
{
    return (cbreak); 
}

void _cursesscb(int setting)
{
    cbreak = setting;
}
