#include <windows.h>
#include <windowsx.h>


#define CMDSRC_PUSHBUTTON          1
#define CMDSRC_MENU                2
#define CMDSRC_ACCELERATOR         3
#define CMDSRC_OTHER               0

#define EXLST_EXIT 1
#define NT_PORT

#define MB_QUERY				MB_ICONQUESTION		/*TJR - like it is in os/2 */
#define MB_INFORMATION		MB_ICONASTERISK		/*TJR - like it is in os/2 */
#define MB_ERROR            MB_ICONEXCLAMATION
#define MB_CANCEL           MB_OK
#define MB_WARNING          MB_ICONEXCLAMATION

#define _far
#define far     /* NT -- No more far's          */
#define near    /* NT -- No more near's         */
#define _loadds /* NT -- No more load DS stuff  */

#define huge    /* NT -- No more 'huge' BS      */

#define PMERR_MEMORY_ALLOCATION_ERR ERROR_OUTOFMEMORY;
#define SELECTOROF(a) (a)
#define EXLST_ADD    5
#define EXLST_REMOVE 6
#define CSEM_PUBLIC  TRUE
#define CSEM_PRIVATE FALSE
#define HWND_OBJECT NULL
#define MPFROMLONG(a) a                               
#define LONGFROMMP(a)  a
#define MPFROMSHORT(a) a
#define OFFSETOF(a) a
#define SHORT1FROMMR(a) ((SHORT)(a))
#define PVOIDFROMMR(a) ((LPVOID)(a))
typedef  HCURSOR HPOINTER;

#define DID_OK      1
#define DID_CANCEL  2
#define DID_ERROR  -1
#define MBID_ERROR  0




// ==============================================================
// Globals defined in HolePort.c WinMain for your use.
// ==============================================================
extern HANDLE hinst;  // You must have a global hinst for some
                      // of the translations to work.
extern int nCmdShow;

// ==============================================================
// Type defs needed for Holeport.c or old OS/2 code that
// can translate as is.
// ==============================================================

typedef HWND   *PHWND;
typedef HANDLE *PHANDLE;
typedef HANDLE HPIPE;
typedef HANDLE *PHPIPE;
typedef PROC PFN;
typedef PROC *PPFN;
typedef HANDLE SEL;
typedef HANDLE *PSEL;
typedef char *PSZ;
typedef char *NPSZ;
typedef DWORD *PULONG;
typedef DWORD *PFNWP(HWND, UINT, DWORD, DWORD);


typedef struct _FILELOCK
    {
    DWORD lOffset;
    DWORD lRange;
    } FILELOCK;
typedef FILELOCK *PFILELOCK;


typedef struct {
    HWND hwnd;
    DWORD msg;
    DWORD mp1;
    LONG  mp2;
    DWORD time;
    POINTL ptl;
} QMSG;
typedef QMSG *PQMSG;

typedef struct {
    LONG xLeft;
    LONG yBottom;
    LONG xRight;
    LONG yTop;
} XRECTL;
typedef XRECTL *PXRECTL;
typedef XRECTL *NXPRECTL;

typedef union _packit {
    DWORD dw;
    union {
        SHORT shl;
        SHORT shh;
    };
    union {
        char ch[4];
    };
} PACKED_LONG;

typedef struct _MENUITEM { /* mi */
    SHORT   iPosition;
    USHORT  afStyle;
    USHORT  afAttribute;
    USHORT  id;
    HWND    hwndSubMenu;
    ULONG   hItem;
} MENUITEM;
typedef MENUITEM FAR *PMENUITEM;

typedef struct _COMMANDMSG { /* commandmsg */
    USHORT  cmd;             /* mp1 */
    USHORT  invalid1;          
    USHORT  invalid2;        /* mp2 */
    USHORT  invalid3;
} CMDMSG;


typedef struct _CURSORINFO { /* csri */
    HWND    hwnd;
    LONG   x;
    LONG   y;
    LONG   cx;
    LONG   cy;
    USHORT  fs;
    RECT    rclClip;
} CURSORINFO;
typedef CURSORINFO FAR *PCURSORINFO;


// ==============================================================
// Definitions that are needful
// ==============================================================

#define VOID    void
#define SHANDLE HANDLE
#define LHANDLE HANDLE

#define ERRORID DWORD
#define NEG_ONE  0xFFFFFFFF


#define QW_NEXT         0
#define QW_PREV         1
#define QW_TOP          2
#define QW_BOTTOM       3
#define QW_OWNER        4
#define QW_PARENT       5
#define QW_NEXTTOP      6
#define QW_PREVTOP      7
#define QW_FRAMEOWNER   8

#define SPTR_APPICON               10
#define SPTR_ARROW                 1
#define SPTR_ICONERROR             13
#define SPTR_ICONINFORMATION       11
#define SPTR_ICONQUESTION          12
#define SPTR_ICONWARNING           14
#define SPTR_MOVE                  5
#define SPTR_SIZENESW              7
#define SPTR_SIZENS                9
#define SPTR_SIZENWSE              6
#define SPTR_SIZEWE                8
#define SPTR_TEXT                  2
#define SPTR_WAIT                  3

#define SEG_NONSHARED       0x0000
#define SEG_GIVEABLE        0x0001
#define SEG_GETTABLE        0x0002
#define SEG_DISCARDABLE     0x0004
#define SEG_SIZEABLE        0x0008



#define FILE_CREATE     0x0010
#define FILE_OPEN       0x0001
#define FILE_TRUNCATE   0x0002
#define FILE_NORMAL     0x0000
#define FILE_READONLY   0x0001
#define FILE_HIDDEN     0x0002
#define FILE_SYSTEM     0x0004
#define FILE_ARCHIVED   0x0020

#define OPEN_FLAGS_DASD             0x0000
#define OPEN_ACCESS_READONLY        0x0000  /* ---- ---- ---- -000 */
#define OPEN_ACCESS_WRITEONLY       0x0001  /* ---- ---- ---- -001 */
#define OPEN_ACCESS_READWRITE       0x0002  /* ---- ---- ---- -010 */
#define OPEN_SHARE_DENYREADWRITE    0x0010  /* ---- ---- -001 ---- */
#define OPEN_SHARE_DENYWRITE        0x0020  /* ---- ---- -010 ---- */
#define OPEN_SHARE_DENYREAD         0x0030  /* ---- ---- -011 ---- */
#define OPEN_SHARE_DENYNONE         0x0040  /* ---- ---- -100 ---- */
#define OPEN_FLAGS_NOINHERIT        0x0080  /* ---- ---- 1--- ---- */
#define OPEN_FLAGS_WRITE_THROUGH    0x4000  /* -1-- ---- ---- ---- */
#define OPEN_FLAGS_FAIL_ON_ERROR    0x2000  /* --1- ---- ---- ---- */
#define OPEN_FLAGS_NO_CACHE         0x1000  /* ---1 ---- ---- ---- */
#define OPEN_FLAGS_SEQUENTIAL       0x0100  /* ---- -001 ---- ---- */
#define OPEN_FLAGS_RANDOM           0x0200  /* ---- -010 ---- ---- */
#define EXIT_THREAD         0
#define EXIT_PROCESS        1

#define FATTR_SEL_ITALIC           0x0001
#define FATTR_SEL_UNDERSCORE       0x0002
#define FATTR_SEL_STRIKEOUT        0x0010
#define FATTR_SEL_BOLD             0x0020

#define HARDERROR_ENABLE   0
#define HARDERROR_DISABLE  1

#define MLFQS_MINMAXSEL            0
#define MLFQS_MINSEL               1
#define MLFQS_MAXSEL               2
#define MLFQS_ANCHORSEL            3
#define MLFQS_CURSORSEL            4

#define LIT_END  -1


#define HDIR_SYSTEM                   0x0001
#define HDIR_CREATE                   0xFFFF

#define FID_SYSMENU                0x8002
#define FID_TITLEBAR               0x8003
#define FID_MINMAX                 0x8004
#define FID_MENU                   0x8005
#define FID_VERTSCROLL             0x8006
#define FID_HORZSCROLL             0x8007
#define FID_CLIENT                 0x8008



// ==============================================================
// Definitions that are needful, HP_ prefix
// ==============================================================

#define HP_FILE_NORMAL  0x0000

#define HP_CS_SIZEREDRAW              0x00000004L
#define HP_CS_SAVEBITS                0x04000000L

#define HP_FS_DLGBORDER               0x00000080L
#define HP_FS_BORDER                  0x00000100L
#define HP_FS_SIZEBORDER              0x00000800L
#define HP_FS_STANDARD                0x10000000L
#define HP_FCF_TITLEBAR               0x00000001L
#define HP_FCF_SYSMENU                0x00000002L
#define HP_FCF_MENU                   0x00000004L
#define HP_FCF_SIZEBORDER             0x00000008L
#define HP_FCF_MINBUTTON              0x00000010L
#define HP_FCF_MAXBUTTON              0x00000020L
#define HP_FCF_MINMAX                 0x00000030L 
#define HP_FCF_VERTSCROLL             0x00000040L
#define HP_FCF_HORZSCROLL             0x00000080L
#define HP_FCF_DLGBORDER              0x00000100L
#define HP_FCF_BORDER                 0x00000200L
#define HP_FCF_STANDARD               0x10000000L
#define HP_WS_VISIBLE                 0x80000000L
#define HP_WS_DISABLED                0x40000000L
#define HP_WS_CLIPCHILDREN            0x20000000L
#define HP_WS_CLIPSIBLINGS            0x10000000L
#define HP_WS_MINIMIZED               0x01000000L
#define HP_WS_MAXIMIZED               0x00800000L
#define HP_WS_GROUP                   0x00010000L
#define HP_WS_TABSTOP                 0x00020000L

#define HP_LB_GETTEXT   LB_GETTEXT
#define HP_BM_GETSTATE  BM_GETSTATE
#define HP_EM_GETMODIFY EM_GETMODIFY
#define HP_EM_GETSEL    EM_GETSEL
#define HP_LB_SELITEMRANGE LB_SELITEMRANGE

#define HP_MIA_CHECKED                0x2000
#define HP_MIA_DISABLED               0x4000
#define HP_MIA_HILITED                0x8000

// ==============================================================
// HolePort message values.
// ==============================================================

#define WM_PORT_BOTTOM  0x4A4D4800
#define WM_SETICON                    (WM_PORT_BOTTOM + 0)
#define HP_SBM_SETSCROLLBAR           (WM_PORT_BOTTOM + 1)
#define MM_SETITEMATTR                (WM_PORT_BOTTOM + 2)
#define HP_MLM_QUERYSEL               (WM_PORT_BOTTOM + 3)
#define HP_EM_SETSEL                  (WM_PORT_BOTTOM + 4)
#define HP_LM_SETITEMTEXT             (WM_PORT_BOTTOM + 5)
#define HP_SBM_QUERYPOS               (WM_PORT_BOTTOM + 6)
#define HP_SBM_QUERYRANGE             (WM_PORT_BOTTOM + 7)
#define HP_SBM_SETPOS                 (WM_PORT_BOTTOM + 8)

// ==============================================================
// Macros
// ==============================================================

#define COMMANDMSG(pmsg) \
        ((struct _COMMANDMSG FAR *)((PBYTE)pmsg + sizeof(UINT)))

#define MS_W32_NOTIMP(a) 0
#define MAKEP(a,b) ((LPBYTE)(a) + (b))
#define HP_SendMessage(h,m,w,l) HP_Message((h),(m),(w),(l),TRUE)
#define HP_PostMessage(h,m,w,l) HP_Message((h),(m),(w),(l),FALSE)

#define MPFROMP(a)                 (a)
#define CHAR1FROMMP(mp)            ((UCHAR)(mp))
#define CHAR2FROMMP(mp)            ((UCHAR)((ULONG)mp >> 8))
#define CHAR3FROMMP(mp)            ((UCHAR)((ULONG)mp >> 16))
#define CHAR4FROMMP(mp)            ((UCHAR)((ULONG)mp >> 24))
#define SHORT1FROMMP(mp)           ((USHORT)(ULONG)(mp))
#define SHORT2FROMMP(mp)           ((USHORT)((ULONG)mp >> 16))


#define HP_SetCurrentDirectory(a) (SetCurrentDirectory((a)) ? 0 : -1)

// ==============================================================
// HolePort.c functions
// ==============================================================


LONG HP_gpiCharStringAt(HDC hdc, PPOINTL ppl, int cb, LPCSTR pch);
USHORT HP_dosReallocSeg(USHORT usNew, SEL sel);
USHORT HP_dosFreeSeg( SEL sel);
USHORT HP_dosAllocSeg( USHORT usSize, PSEL psel, USHORT fs);
BOOL HP_winQueryCursorInfo(HWND hd, PCURSORINFO pcsri);
HWND HP_winQueryWindow(HWND hwnd, SHORT cmd, BOOL b);
HANDLE HP_winQuerySysPointer(HWND hd, SHORT s, BOOL b);
USHORT HP_dosChgFilePtr(HANDLE h, LONG l, USHORT M, PULONG pul);
VOID HP_dosExit( USHORT usF, USHORT usC);
USHORT HP_dosQHandType( HANDLE h, PULONG pul, PUSHORT pus);
USHORT HP_dosQFileMode( PSZ psz, PULONG pul, DWORD d);
USHORT HP_dosGetProcAddress( HANDLE h, PSZ psz, PPFN pul);
DWORD  HP_dosMakeNmPipe(PSZ pszName, PHPIPE php, USHORT fsOpenMode,
    USHORT fsPipeMode, USHORT cbOutBuf, USHORT cbInBuf, DWORD ulTimeOut);
DWORD HP_dosOpen(PSZ pszFileName, PHANDLE phf, PUSHORT pusAction,
    ULONG ulFileSize, USHORT usAttribute, USHORT fsOpenFlags, 
    USHORT fsOpenMode, ULONG ul);
USHORT HP_dosQCurDir(USHORT usDriveNum, PSZ pszPath, PUSHORT pcb);
USHORT HP_dosQCurDisk(PUSHORT pusDriveNum, PULONG pul);
USHORT HP_dosSelectDisk(USHORT usDriveNum);
UINT HP_Message(HWND a, UINT b, WPARAM c, LPARAM d, UINT e);
HWND HP_CreateStdWindow(HWND a,DWORD b,LPDWORD c,LPCTSTR d,LPCTSTR e,DWORD f,
		HMODULE g, DWORD h, PHWND i);
void HP_RegisterClass(LPCTSTR a, PFNWP b, DWORD c, int d);
HFONT HP_SimpleFont( LPCTSTR a, LONG b, LONG c, DWORD d);
UINT HP_DlgItemMessage(HWND hwnd, int idDlg, UINT msg, WPARAM mp1, LPARAM mp2);
int HP_IsPtr( LPVOID lpv);
DWORD HP_dosCreateSem(int bExclusive, LPHANDLE lph, LPCTSTR lpch);
DWORD HP_dosOpenSem( LPHANDLE lph, LPCTSTR lpch, DWORD dwAccess);
USHORT HP_dosSemClear(HANDLE lpv);
USHORT HP_dosSemSet(HANDLE lpv);
USHORT HP_dosSemWait(HANDLE lpv, DWORD lTimeOut);
USHORT HP_dosSemRequest(HANDLE lpv, DWORD lTimeOut);
DWORD HP_dosFindFirst(LPTSTR pszSpec, LPDWORD ph, USHORT usAttr,
    LPWIN32_FIND_DATA lpdata, USHORT usBufLen, PUSHORT pusCount);
USHORT HP_dosFindNext(DWORD dw, LPWIN32_FIND_DATA lpdata,
        USHORT usBufLen, PUSHORT pusCount);
USHORT HP_dosFindClose(DWORD dw);
DWORD HP_dosNewSize(HANDLE h, DWORD dwSize);
DWORD HP_dosFileLocks(HANDLE h, PFILELOCK pfUnlock, PFILELOCK pfLock);
HP_dosLoadModule( LPCTSTR lpName, LPHANDLE ph);
VOID HP_SetHinst(HANDLE h);

BOOL WINAPI _CRT_INIT(HINSTANCE, DWORD, LPVOID);
