/************************************************************************\
* The enclosed files, "the software," is provided by 
* Microsoft Corporation "as is" without warranty of any kind. 
* MICROSOFT DISCLAIMS ALL WARRANTIES, EITHER EXPRESS OR IMPLIED, 
* INCLUDING BUT NOT LIMITED TO IMPLIED WARRANTIES OF MERCHANTABILITY 
* AND FITNESS FOR A PARTICULAR PURPOSE.  You assume all risks of 
* using the software.
* 
* The software is Copyright (c) 1992 Microsoft Corporation.
* Original Author: John M. Hall, Microsoft SDE  9/1/92
*
* You are granted the right to freely distribute this software.
* You are granted the right to make changes provided this comment block
* is retained without modification and you acknowledge the changes.
* 
\************************************************************************/
/************************************************************************\
*
*                               SHRMEM.H
*
\************************************************************************/

#ifndef SHRMEM_DLL_H
#define SHRMEM_DLL_H

/************************************************************************\
*                         SYMBOLIC CONSTANTS
\************************************************************************/

#define FREE        0x00
#define EXCLUSIVE   0x01
#define SHARED      0x02
#define HEAD        0xF0

#ifdef SHRMEM_DLL_C
#define ALLFFS      0xFFFFFFFF
#define SZ_MEMORY   (1024 * 1024)
#define SZ_CONTROL  (1024 * 64)
#define NUMBER_ELEM 256
#define MUNGE       37

/************************************************************************\
*                          GLOBAL SHARED VARIABLES
\************************************************************************/

DWORD dwPageSize;
DWORD dwProcesses;
int   iiUnused;
LPVOID lpTryBase;
DWORD dwBase;
DWORD dwLength;

/************************************************************************\
*                          GLOBAL NON-Shared VARIABLES
\************************************************************************/

HANDLE hMod = NULL;
HANDLE hSemaphore = NULL;
HANDLE hMemory = NULL;
LPVOID lpMemBase = NULL;
HANDLE hControl = NULL;
LPVOID lpCtrlBase = NULL;
DWORD  dwProcessID = 0;
FILE *fp_log = NULL;

/************************************************************************\
*                          MACROS
\************************************************************************/
#define MAKE_PTR(a,b)  ((LPVOID)((DWORD)(a) + (b)))
#define MUNGEIT(a) ( ((a)+1)* MUNGE)
#define UNMUNGE(a) ( ((a)/MUNGE)-1)

// turn the wOffset (in pages) into a LPVOID
#define MAKE_LPV(a) ((LPVOID) ((DWORD)lpMemBase + (dwPageSize * (a))))


#ifdef DEBUG
#define AssertBox(a,b) if (!(a)) MyAssertBox((b), #a, __FILE__, __LINE__)
#else
#define AssertBox(a,b)
#endif

/************************************************************************\
*                          STRUCTURES
\************************************************************************/

typedef struct {
    DWORD dwProcessID;
    WORD  wOffset;
    WORD  wLength;
    SHORT sNext;
    SHORT sPrior;
    ATOM  aName;
    UCHAR uchLock;
    UCHAR uchFlags;
} FREE_ELEMENT;
typedef FREE_ELEMENT *FEP;
#endif

/************************************************************************\
*                         FLAGS
\************************************************************************/
#define SHR_MEM_FREE    0x00
#define SHR_MEM_ALLOC   0x01
#define SHR_MEM_INVALID 0x02

/************************************************************************\
*                         FUNCTION PROTOTYPES
\************************************************************************/
VOID    MyAssertBox( const char *, const char *, const char *, int);

DWORD   ShrAlloc(DWORD dwSize, UCHAR uchFlags);
LPVOID  ShrLock( DWORD hShr);
DWORD   ShrUnlock( DWORD hShr);
DWORD   ShrFree( DWORD hShr);
BOOL    DLLEntryPoint (HANDLE hDLL, DWORD dwReason, LPVOID lpReserved);
BOOL    attach_memory(LPTSTR lptstr);
BOOL    ShrName(DWORD hShr, LPCTSTR lpsz);
DWORD   ShrGet(LPCTSTR lpsz);
VOID    ShrDump(void);

#endif // SHRMEM_DLL_H
