/*****************************************************************\


	Library of X window functions which call Windows 32
	equivalent functions.

	Some data structures are maintained by this code,
	simulating the operation of an X server and window manager.

	Aug/Sep-92	xyz	$$1 Created.
        Oct-92  abc $$2 Added color stuff.

\******************************************************************/

#ifndef __XNT
#define __XNT

#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include <string.h>
#include <windows.h>
#include "xnt.h"        /* Includes X.h, Xlib.h, Xutil.h mainly. */


#define printf(x)   /* x */
#define SetSystemPaletteUse(x) /* x */

/* Local Data */

static char *app_name = "Sample";

static XEvent l_event;     /* Local structure filled in by Window function */
static HANDLE hInstance,hPrevInstance;
static Window NT_CWIN=NULL;	/* Handle of the window under the cursor */
static Display *d = NULL;       /* The display structure of this display. */
static Window  PIWindow = NULL;
static int PIWidth,PIHeight;
static unsigned char *smallBitBase;
static HDC hdcPal = INVALID_HANDLE;
static HPALETTE hpalX;
static LOGPALETTE *sysPal;
static int cmapSize;
static int nextFreeColour;
static long windowBg;
static int sysColorNumArray[21] = {COLOR_ACTIVEBORDER,COLOR_ACTIVECAPTION,COLOR_APPWORKSPACE,COLOR_BACKGROUND,
                                   COLOR_BTNFACE,COLOR_BTNSHADOW,COLOR_BTNTEXT,COLOR_CAPTIONTEXT,COLOR_GRAYTEXT,
                                   COLOR_HIGHLIGHT,COLOR_HIGHLIGHTTEXT,COLOR_INACTIVEBORDER,COLOR_INACTIVECAPTION,
                                   COLOR_INACTIVECAPTIONTEXT,COLOR_MENU,COLOR_MENUTEXT,COLOR_SCROLLBAR,COLOR_BTNSHADOW,
                                   COLOR_WINDOW,COLOR_WINDOWFRAME,COLOR_WINDOWTEXT};
static COLORREF sysColorArray[21];

GetSysColors(number,nums,vals)
int number;
int *nums;
COLORREF *vals;
{
  int i;
  for (i=0;i<number;i++)
    vals[i] = GetSysColor(nums[i]);
}
/* Routine declarations */

static struct NT_window      *NT_find_window_from_id();
static int                    NT_delete_window();
static struct NT_window      *NT_new_window();
static struct NT_window      *NT_new_window_pair();
static void                   NT_set_GC_pen();
static void                   NT_set_GC_brush();
static HPEN                   NT_get_GC_pen();
static HBRUSH                 NT_get_GC_brush();
void NT_set_rop();

/*----------------------------------------------------------------*\
| FUNCTIONS TO MAINTAIN AN INTERNAL LIST OF WINDOWS AND THEIR      |
| ATTRIBUTES - AS WOULD BE MAINTAINED IN THE X SERVER.             |
\*----------------------------------------------------------------*/

static struct NT_window *window_list=NULL;

/* Structure to hold pen and brush info in GC ext_data field */

typedef struct NTGC_
{
HPEN	pen;
HBRUSH	brush;
} NTGC;

/* Sizes of window decoration features. */
#define NT_TITLE_BORDER_SIZE 32
#define NT_BORDER_SIZE 8

typedef struct dc_info_
{
  struct dc_info_ *next;
  HWND win_id;
  HDC  dc_id;
  int rop;
} DCInfo;

static DCInfo DCIHead = {NULL,0,0};
static int num_dcs = 0;


del_from_dc_info(window,dc)
HWND window;
HDC dc;
{
  DCInfo *ptr = DCIHead.next;
  DCInfo *prev = &DCIHead;
  while (ptr)
  {
    if (ptr->win_id == window && ptr->dc_id == dc)
    {
      prev->next=ptr->next;
      free(ptr);
      return;
    }
    prev = ptr;
    ptr = ptr->next;
  }
  printf("Could not find HDC %x for window %x\n");
}

int find_in_dc_info(window,dc)
HWND window;
HDC *dc;
{
  DCInfo *ptr = DCIHead.next;
  while (ptr)
  {
    if (ptr->win_id == window && (*dc==0 || *dc==ptr->dc_id))
    {
      *dc = ptr->dc_id;
      return TRUE;
    }
    ptr = ptr->next;
  }
  return FALSE;
}

add_to_dc_info(window,dc)
HWND window;
HDC dc;
{
   DCInfo *newInfo;
   if(!(newInfo = malloc(sizeof(newInfo))))
   {
     printf("Failed to malloc DCInfo struct.\n");
     return;
   }
   newInfo->win_id = window;
   newInfo->dc_id = dc;
   newInfo->next = DCIHead.next;
   DCIHead.next = newInfo;
}

HDC cjh_get_dc(window)
HWND window;
{
  HDC foundDC = 0,newDC;
  if (find_in_dc_info(window,&foundDC))
  {
  /*    printf("****************Window %x already has a DC %x allocated.\n",window,foundDC);*/
      newDC = foundDC;
  }
  else
  {
    newDC = GetDC(window);

    if (newDC!=0)
    {
      add_to_dc_info(window,newDC);
    }
    printf("Got Window %x a dc with value %x                    %d\n",window,newDC,++num_dcs);
  }
  return newDC;
}

HDC cjh_get_dc_ex(window,hrgnClip,flags)
HWND window;
HRGN hrgnClip;
DWORD flags;
{
  HDC foundDC = 0,newDC;
  return cjh_get_dc(window);
  if (find_in_dc_info(window,&foundDC))
  {
      printf("EX**************Window %x already has a DC %x allocated.\n",window,foundDC);
  }

  newDC = GetDC(window); /*Ex(window,hrgnClip,flags);*/
  if (newDC!=0)
  {
    add_to_dc_info(window,newDC);
  }
  printf("Got Window %x an ex dc with value %x                    %d\n",window,newDC,++num_dcs);
  return newDC;
}


int cjh_rel_dc(window,dc)
HWND window;
HDC dc;
{
  HDC foundDC;
/***
 ***  MODIFIED TO RETURN TRUE HERE!!!!!!!!!!
 ***/

  return TRUE;

  foundDC = dc;
  if (!find_in_dc_info(window,&foundDC))
  {
      printf("######################Window %x doesnt have a DC %x\n",window,dc);
      return FALSE;
  }
  printf("Deleteing Window %x the dc with value %x                      %d\n",window,dc,--num_dcs);
  del_from_dc_info(window,dc);
  if(!find_in_dc_info(window,&foundDC))
    ReleaseDC(window,dc);
  else
    printf("Whoops Two Entries for %x and %x - Not releasing DC.\n",window,foundDC);
  return TRUE;
}


/****************************************************************\
 FOCUS PUSHDOWN STACK CODE!
\****************************************************************/

typedef struct _pd_focus {
  Window top;
  struct _pd_focus *next;
 } pdFocus;

static pdFocus focusHead = {NULL,NULL};

addFocusWindow(newWin)
Window newWin;
{
  pdFocus *newFocus;

  if(!(newFocus = malloc(sizeof(pdFocus))))
  {
    printf("Argh, Failed to get memory for focus stack - exiting.\n");
    return;
  }
  newFocus->top = newWin;
  newFocus->next = focusHead.next;
  focusHead.next = newFocus;
}

raiseFocusWindow(toRaise)
Window toRaise;
{
  pdFocus *finder,*follower;
  finder = focusHead.next;
  follower = &focusHead;
  while(finder)
  {
    if(finder->top == toRaise)
      break;
    follower = finder;
    finder = finder->next;
  }

  if (!finder)
  {
    printf("Error - raising unknown window.\n");
    return;
  }
  follower->next = finder->next;
  finder->next = focusHead.next;
  focusHead.next = finder;
}

delFocusWindow(toDel)
Window toDel;
{
  pdFocus *finder,*follower;
  finder = focusHead.next;
  follower = &focusHead;

  while(finder)
  {
    if(finder->top == toDel)
      break;
    follower = finder;
    finder = finder->next;
  }

  if (!finder)
  {
    printf("Error - deleting unknown window.\n");
    return;
  }
  follower->next = finder->next;
  free(finder);
}

activateTopWin()
{
  if(focusHead.next)
  {
    SetActiveWindow(focusHead.next->top->w);
    SetFocus(focusHead.next->top->client->w);
  }
}


HWND getTopWinHandle()
{
  if(focusHead.next)
    return focusHead.next->top->w;
  else
    return 0;
}

/*****************************************************************\

	Function:  NT_OrderFrame

	Comments:  Set the frame to TOPMOST or NOTOPMOST according to
		   the top_flag in the window definition.

\*****************************************************************/

void
NT_OrderFrame(window,raise)
Window window;
int    raise;
{
  if ( raise )
    {
    if ( window->top_flag == TRUE)
      SetWindowPos(window->w, HWND_TOPMOST,
                   0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE );
    else
      SetWindowPos(window->w, HWND_NOTOPMOST,
                   0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE );
    }
  else
    SetWindowPos(window->w, HWND_NOTOPMOST,
                 0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE );
}

void
NT_OrderFocusList(head, raise)
pdFocus *head;
int     raise;
{

  if ( head->next != NULL )
    NT_OrderFocusList(head->next, raise);
  if ( head->top != NULL )
    NT_OrderFrame(head->top, raise);
}

void
NT_OrderAllFrames(raise)
int raise;
{
  if ( focusHead.next != NULL )
    NT_OrderFocusList(focusHead.next, raise);
}

/*****************************************************************\

	Function: NT_move_focus
	Inputs:   message type, window ID

	Comments: Sets the keyboard focus to a window which receives
	          a mouse click.  Not needed by pro/ENGINEER really.

\*****************************************************************/

void
NT_MoveFocus(msg,window)
UINT msg;
Window window;
{
	switch (msg)
	{
		case WM_LBUTTONDOWN:
		case WM_MBUTTONDOWN:
		case WM_RBUTTONDOWN:
		case WM_LBUTTONUP:
		case WM_MBUTTONUP:
		case WM_RBUTTONUP:
		case WM_LBUTTONDBLCLK:
		case WM_MBUTTONDBLCLK:
		case WM_RBUTTONDBLCLK:
		case WM_NCLBUTTONDOWN:
		case WM_NCMBUTTONDOWN:
		case WM_NCRBUTTONDOWN:
		case WM_NCLBUTTONUP:
		case WM_NCMBUTTONUP:
		case WM_NCRBUTTONUP:
			if (window->client!=NULL)  /* Frame window? */
				SetFocus (window->client->w);
			else
				SetFocus (window->w);
		break;

		default:
		break;
	}
}

/*****************************************************************\

	Function: MainWndProc
	Inputs:   Window handle, message, message parameters.

	Comments: This is called when messages are sent to the application
		  but not to the application's message queue.  If an
		  event can be processed, it is done here.  The equivalent
		  XEvent is filled out in l_event, which is picked up
		  in the X event routines.  Some events are not received
		  from Windows, eg Enter/LeaveNotify, so these are made
		  up as required.

	Caution:  The application does not see HWND, but Window.

\*****************************************************************/

LONG APIENTRY MainWndProc(
	HWND hWnd,		  /* window handle		     */
	UINT message,		  /* type of message		     */
	UINT wParam,		  /* additional information	     */
	LONG lParam)		  /* additional information	     */
{
/*    static int      x =34, y = 34;   */

	POINT pt;
	RECT rect;
        PAINTSTRUCT paintStruct;
        WINDOWPOS *posStruct;
	unsigned long int st=0L;
        struct NT_window *window;
        HDC winDC;
	MSG msg;

    window = NT_find_window_from_id(hWnd);
    if (!window)
      return DefWindowProc(hWnd,message,wParam,lParam);

    NT_MoveFocus(message,window);
    switch (message) {
      case WM_ERASEBKGND:
        winDC = cjh_get_dc(hWnd);
        RealizePalette(winDC);
        cjh_rel_dc(winDC);
        l_event.type=-1;
        return (1);
        break;
      case WM_ACTIVATE:
        if(window)
          raiseFocusWindow(window);
        break;
    case WM_ACTIVATEAPP:
/*      if (wParam!=0) /* Deactivate!
      {
        winDC = cjh_get_dc(hWnd);
        SetSystemPaletteUse(winDC,SYSPAL_STATIC);
        SetSysColors(21,sysColorNumArray,sysColorArray);
        cjh_rel_dc(hWnd,winDC);
      }
      else
      {
        winDC = cjh_get_dc(hWnd);
        GetSysColors(21,sysColorNumArray,sysColorArray);
        SetSystemPaletteUse(winDC,SYSPAL_NOSTATIC);
        cjh_rel_dc(hWnd,winDC);
      }                         */
      NT_OrderAllFrames(wParam);
      break;
      case WM_PAINT:
	if (window->client!=NULL)
		window=window->client;
/*	if (window->child!=NULL && window->parent->w!=GetDesktopWindow())
		PostMessage(window->child->w->w,WM_PAINT,wParam,lParam);
	BringWindowToTop(hWnd);  */

	l_event.type=Expose;
        BeginPaint(hWnd,&paintStruct);
	l_event.xexpose.x=paintStruct.rcPaint.left;
	l_event.xexpose.y=paintStruct.rcPaint.top;
	l_event.xexpose.width=paintStruct.rcPaint.right-paintStruct.rcPaint.left;
	l_event.xexpose.height=paintStruct.rcPaint.bottom-paintStruct.rcPaint.top;
        l_event.xexpose.count=0;
        l_event.xexpose.window=window;
        EndPaint(hWnd,&paintStruct);

       /* if(window)
          while(PeekMessage(&msg,window->w,WM_PAINT,WM_PAINT,PM_REMOVE))
          {
            GetMessage(&msg,window->w,WM_PAINT,WM_PAINT);
            BeginPaint(hWnd,&paintStruct);
            printf("Removed  a WM_PAINT\n");
            ValidateRgn(hWnd,NULL);
            EndPaint(hWnd,&paintStruct);
         }*/



        printf("WM_PAINT\n");
        return (DefWindowProc(hWnd, message, wParam, lParam));
        break;

      case WM_LBUTTONDOWN:
      case WM_LBUTTONDBLCLK: /* Double click behaves like two single clicks */
        l_event.type = ButtonPress;
        l_event.xbutton.x = LOWORD (lParam);
        l_event.xbutton.y = HIWORD (lParam);
        if ( wParam & MK_SHIFT )
          l_event.xbutton.button=Button2;
        else
	  l_event.xbutton.button=Button1;
        l_event.xbutton.window = window;
	l_event.xbutton.time=GetTickCount();
	break;

      case WM_LBUTTONUP:
        l_event.type=ButtonRelease;
	l_event.xbutton.x=LOWORD(lParam);
	l_event.xbutton.y=HIWORD (lParam);
	if ( wParam & MK_SHIFT )
          l_event.xbutton.button=Button2;
        else
	  l_event.xbutton.button=Button1;
        l_event.xbutton.window=window;
	l_event.xbutton.time=GetTickCount();
	break;

      case WM_MBUTTONDOWN:
      case WM_MBUTTONDBLCLK:
        l_event.type=ButtonPress;
	l_event.xbutton.x=LOWORD(lParam);
	l_event.xbutton.y=HIWORD (lParam);
	l_event.xbutton.button=Button2;
	l_event.xbutton.window=window;
	l_event.xbutton.time=GetTickCount();
	printf("middle button down\n");
	break;

      case WM_MBUTTONUP:
	l_event.type=ButtonRelease;
	l_event.xbutton.x=LOWORD(lParam);
	l_event.xbutton.y=HIWORD (lParam);
	l_event.xbutton.button=Button2;
	l_event.xbutton.window=window;
	l_event.xbutton.time=GetTickCount();
	printf("middle button up\n");
        break;

      case WM_RBUTTONDOWN:
      case WM_RBUTTONDBLCLK:
	l_event.type=ButtonPress;
	l_event.xbutton.x=LOWORD(lParam);
	l_event.xbutton.y=HIWORD (lParam);
        l_event.xbutton.button=Button3;
        l_event.xbutton.window=window;
	l_event.xbutton.time=GetTickCount();
	break;

      case WM_RBUTTONUP:
	l_event.type=ButtonRelease;
	l_event.xbutton.x=LOWORD(lParam);
	l_event.xbutton.y=HIWORD (lParam);
	l_event.xbutton.button=Button3;
	l_event.xbutton.window=window;
	l_event.xbutton.time=GetTickCount();
	break;

      case WM_MOUSEMOVE:
        if (hWnd!=NT_CWIN)  /* Mouse in different window? */
        {
        	if (NT_CWIN==NULL) /* No previous window */
        	{
			l_event.type = EnterNotify;
			l_event.xcrossing.x = LOWORD(lParam);
			l_event.xcrossing.y = HIWORD(lParam);
			l_event.xcrossing.window = window;
        	}
        	else
        	{
        		l_event.type=LeaveNotify;
			l_event.xcrossing.x=LOWORD(lParam);
			l_event.xcrossing.y=HIWORD(lParam);
			l_event.xcrossing.window = NT_find_window_from_id(NT_CWIN);
                        PostMessage(hWnd,USR_EnterNotify,wParam,lParam);
		}
        }
        else
        {
		l_event.type=MotionNotify;    /* Fill out mouse event */
		l_event.xmotion.window=window;
		l_event.xmotion.x=pt.x=LOWORD(lParam);
		l_event.xmotion.y=pt.y=HIWORD(lParam);
		ClientToScreen(hWnd,&pt);     /* Translate coordinates */
		l_event.xmotion.x_root=pt.x;
		l_event.xmotion.y_root=pt.y;
		if (wParam&MK_CONTROL)
			st|=ControlMask;
		if (wParam&MK_SHIFT)
			st|=ShiftMask;
		if (wParam&MK_LBUTTON)
			st|=Button1Mask;
		if (wParam&MK_MBUTTON)
			st|=Button2Mask;
		if (wParam&MK_RBUTTON)
			st|=Button3Mask;
		l_event.xmotion.state=st;
	}
	NT_CWIN=hWnd;
	break;

      case WM_CHAR:
	l_event.type=KeyPress;
	l_event.xkey.state=0;
/*	if (GetKeyState(VK_SHIFT)&0x8000!=0)   Need this sometime?
		l_event.xkey.state|=ShiftMask;
	if (GetKeyState(VK_CONTROL)&0x8000!=0)
		l_event.xkey.state|=ControlMask;
	if (GetKeyState(VK_LBUTTON)&0x8000!=0)
		l_event.xkey.state|=Button1Mask;
	if (GetKeyState(VK_MBUTTON)&0x8000!=0)
		l_event.xkey.state|=Button2Mask;
	if (GetKeyState(VK_RBUTTON)&0x8000!=0)
		l_event.xkey.state|=Button3Mask;   */
	l_event.xkey.keycode=wParam;
	l_event.xkey.window=window;
	break;

      case WM_QUIT:
/*        winDC = cjh_get_dc(hWnd);
        SetSystemPaletteUse(winDC,SYSPAL_STATIC);
        SetSysColors(21,sysColorNumArray,sysColorArray);
        cjh_rel_dc(hWnd,winDC);   */
        l_event.type = ClientMessage;
        break;
      case WM_CLOSE:
      case WM_DESTROY:		  /* message: window being destroyed */
/*        winDC = cjh_get_dc(hWnd);
        SetSystemPaletteUse(winDC,SYSPAL_STATIC);
        cjh_rel_dc(hWnd,winDC);          */
        l_event.type = ClientMessage;
	break;

      case USR_EnterNotify:
	l_event.type = EnterNotify;
	l_event.xcrossing.x = LOWORD(lParam);
	l_event.xcrossing.y = HIWORD(lParam);
	l_event.xcrossing.window = window;
	break;

      case WM_QUERYNEWPALETTE:
        if (window && window->w != INVALID_HANDLE)
        {
         if((winDC = cjh_get_dc_ex(window->w,NULL,DCX_NORESETATTRS))!=0)
         {
           SetSystemPaletteUse(winDC,SYSPAL_NOSTATIC);
           SelectPalette(winDC,hpalX,FALSE);
           RealizePalette(winDC);
           cjh_rel_dc(window->w,winDC);
         }

         printf("QueryNew *********************Palette window %x\n",window->w);
         if (window->client && window->client->w != INVALID_HANDLE)
         {
           if((winDC = cjh_get_dc_ex(window->client->w,NULL,DCX_NORESETATTRS))!=0)
           {
             dumpSysPal(winDC);
             SetSystemPaletteUse(winDC,SYSPAL_NOSTATIC);
             SelectPalette(winDC,hpalX,FALSE);
             RealizePalette(winDC);
             cjh_printf("After ...\n");
             buildPaletteTable();
             dumpSysPal(winDC);
             cjh_rel_dc(window->client->w,winDC);
           }
         }
        }
        break;
      case WM_PALETTECHANGED:
        /*if (window && window->client)
          if ( window->client->w!= (HWND)wParam && window->client->hDC != -1)*/
          if (window && window->client)
          {
            if(window->client->w != (HWND)wParam)
            {
              printf("WM_PALETTE_CHANGED\n");
              winDC = cjh_get_dc_ex(window->client->w,NULL,DCX_NORESETATTRS);
              SelectPalette(winDC,hpalX,FALSE);
              SetSystemPaletteUse(winDC,SYSPAL_NOSTATIC);
              RealizePalette(winDC);
              buildPaletteTable();
              cjh_rel_dc(window->client->w,winDC);
            }
            /*UpdateColors(cjh_get_dc(window->client->w));*/
          }
        break;


      case WM_WINDOWPOSCHANGED:
        posStruct = (WINDOWPOS *)lParam;
        l_event.type = ConfigureNotify;
        l_event.xconfigure.window = window;
        l_event.xconfigure.x = posStruct->x;
        l_event.xconfigure.y = posStruct->y;
        l_event.xconfigure.width = posStruct->cx;
        l_event.xconfigure.height = posStruct->cy;
        l_event.xconfigure.above = Above;
        return TRUE;
        break;
      case WM_MOVE:
        if(window)
        {
          l_event.type = ConfigureNotify;
          l_event.xconfigure.window = window;
          l_event.xconfigure.x = posStruct->x;
          l_event.xconfigure.y = posStruct->y;
          l_event.xconfigure.width = window->wdth;
          l_event.xconfigure.height = window->hght;
          l_event.xconfigure.above = Above;
        }
        break;



      case USR_StructureNotify:    /* Designed to pass StructureNotifyMask */
        l_event.type=ConfigureNotify;
	break;

      default:			  /* Passes it on if unproccessed    */
	l_event.type = -1;
        return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return 0L;
}


/*****************************************************************\

	Function: WinMain
	Inputs:   instance, previous instance, command line arguments,
		  default start up.

	Comments: Called instead of main() as the execution entry point.

\*****************************************************************/
#define MAX_COMMAND_ARGS 20
int
WinMain(hInst,hPrevInst,lpCmdLine,nCmdShow)
HANDLE hInst;
HANDLE hPrevInst;
LPSTR lpCmdLine;
int nCmdShow;
{
        static char *command_args[MAX_COMMAND_ARGS];
        static int num_command_args;
        static char proEng[] = "proe";
        char *wordPtr,*tempPtr;
        int i,quote;
	hInstance=hInst;
	hPrevInstance=hPrevInst;
        for (i=0;i<MAX_COMMAND_ARGS;i++)
          command_args[i] = NULL;

        wordPtr = lpCmdLine;
        quote = 0;
        num_command_args = 1;
        command_args[0] = proEng;
        while  (*wordPtr && (*wordPtr == ' ' || *wordPtr == '\t'))
           wordPtr++;
        if (*wordPtr == '\"')
        {
          quote = 1;
          wordPtr++;
        }
        if (!*wordPtr)
          main(0,NULL);
        else
        {
          while (*wordPtr && num_command_args < MAX_COMMAND_ARGS)
          {
            tempPtr = wordPtr;
            if (quote)
            {
              while (*tempPtr && *tempPtr != '\"')
                tempPtr++;
              quote = 0;
            }
            else
              while (*tempPtr && *tempPtr != ' ')
                tempPtr++;
            if (*tempPtr)
              *(tempPtr++) = '\0';
            command_args[num_command_args++] = wordPtr;
            wordPtr = tempPtr;
            while (*wordPtr && (*wordPtr == ' ' || *wordPtr == '\t'))
              wordPtr++;
            if (*wordPtr == '\"')
            {
              quote = 1;
              wordPtr++;
            }
          }
          main(num_command_args,command_args);
        }

}

/*****************************************************************\

	Function: XOpenDisplay
	Inputs:   Display name

	Comments: Fills out a Display structure and a Visual and Screen.
		  Hopefully all the X macros should work with this
		  structure.  Note that the default visual is for a
		  True colour screen (24bits).
\*****************************************************************/
Display
*XOpenDisplay (name)
char *name;
{
	static char vstring[]="NT Xlibemu",
	            *vs,*dn;

        Screen *scrd;
        static Depth dlist[1];
        static Visual vlist[1];
        Colormap cmap;
        RECT rect;
        int i;
        HDC rootDC = CreateDC("DISPLAY",NULL,NULL,NULL);
	DWORD pix;

	dlist[0].depth=8;
        dlist[0].nvisuals=1;
        dlist[0].visuals=vlist;
        vlist[0].ext_data=NULL;
        vlist[0].visualid=0;
        vlist[0].class=PseudoColor;
        vlist[0].bits_per_rgb=8;
        vlist[0].map_entries=256;
	vlist[0].red_mask=255;
	vlist[0].green_mask=255<<8;
	vlist[0].blue_mask=255<<16;
	scrd=(Screen *) malloc (sizeof (Screen));
	scrd->display=d;
        scrd->root= NT_new_window();
	scrd->root->w=GetDesktopWindow();
	scrd->root->parent=0;
	scrd->root->frame=NULL;
	GetWindowRect(GetDesktopWindow(),&rect);
        scrd->width=rect.right-rect.left;
        scrd->height=rect.bottom-rect.top;
        scrd->mwidth=260;
        scrd->mheight=190;
        scrd->ndepths=1;
        scrd->depths=dlist;
        scrd->root_depth=8;
        scrd->root_visual=vlist;
        scrd->default_gc=NULL;
        scrd->cmap=cmap;
        scrd->white_pixel=1;
        scrd->black_pixel=0;


	d=(Display *) malloc (sizeof (Display));
	vs=(char *) malloc (sizeof (char)*strlen (vstring));
	dn=(char *) malloc (sizeof (char)*strlen (name));
	strcpy (vs,vstring);
	strcpy (dn,name);
	d->ext_data=NULL;
	d->next=NULL;
	d->fd=0;
	d->lock=0;
	d->proto_major_version=11;
	d->proto_minor_version=4;
	d->vendor=vs;
	d->resource_base=0;
	d->resource_mask=0;
	d->resource_id=0;
	d->resource_shift=0;
	d->resource_alloc=NULL;
	d->byte_order=0;
	d->bitmap_unit=0;
	d->bitmap_pad=0;
	d->bitmap_bit_order=0;
	d->nformats=0;
	d->pixmap_format=NULL;
	d->vnumber=11;
	d->release=4;
	d->head=NULL;
	d->tail=NULL;
	d->qlen=0;
	d->last_request_read=0;
	d->request=0;
	d->last_req=NULL;
	d->buffer=NULL;
	d->bufptr=NULL;
	d->bufmax=NULL;
	d->max_request_size=0;
	d->db=NULL;
	d->synchandler=NULL;
	d->display_name=dn;
	d->default_screen=0;
	d->nscreens=1;
	d->screens=scrd;
	d->motion_buffer=0;
	d->current=0;
	d->min_keycode=0;
	d->max_keycode=255;
	d->keysyms=NULL;
	d->modifiermap=NULL;
	d->keysyms_per_keycode=0;
	d->xdefaults=NULL;
	d->scratch_buffer=NULL;
	d->scratch_length=0;
	d->ext_number=0;
	d->ext_procs=NULL;
/*	d->event_vec[]=;
	d->wire_vec[]=;  */

/*
 * Intern some Atoms in our role as a fake MWM
 */
        XInternAtom(d,_XA_MOTIF_WM_HINTS,FALSE);
        XInternAtom(d,_XA_MWM_HINTS,FALSE);

/*
 * Initialize the colour map.
 */
   GetSysColors(21,sysColorNumArray,sysColorArray);
   SetSystemPaletteUse(rootDC,SYSPAL_NOSTATIC);
   cmapSize = GetDeviceCaps(rootDC,SIZEPALETTE);/* First two entries are black and white. */
   cjh_printf("Number of colors are %d %d\n",cmapSize,GetDeviceCaps(rootDC,NUMCOLORS));
   sysPal = malloc(sizeof(LOGPALETTE) + (cmapSize-1)*sizeof(PALETTEENTRY));
   sysPal->palVersion = 0x300;
   sysPal->palNumEntries = cmapSize;


/* Default colors to a gray scale */
   for(i=0;i<cmapSize;i++)
   {
     sysPal->palPalEntry[i].peRed = i;
     sysPal->palPalEntry[i].peBlue = i;
     sysPal->palPalEntry[i].peGreen = i;
     sysPal->palPalEntry[i].peFlags = PC_NOCOLLAPSE;
   }

   sysPal->palPalEntry[0].peRed = 0;
   sysPal->palPalEntry[0].peBlue = 0;
   sysPal->palPalEntry[0].peGreen = 0;

   sysPal->palPalEntry[1].peRed = 255;
   sysPal->palPalEntry[1].peBlue = 255;
   sysPal->palPalEntry[1].peGreen = 255;
   
   hpalX = CreatePalette(sysPal);
   nextFreeColour = 2;
   SelectPalette(rootDC,hpalX,FALSE);
   SetSystemPaletteUse(rootDC,SYSPAL_NOSTATIC);
   RealizePalette(rootDC);
   hdcPal = rootDC;


	return (d);
}


int
XCloseDisplay(display)
Display *display;
{
  HDC winDC;
  Window wanderer;

  wanderer = window_list;
  while(wanderer)
  {
    DestroyWindow(wanderer->w);
    wanderer = wanderer->next;
  }
/* Do something ? */
/* Must GlobalDelete all atoms/properties leftover */
  SetSystemPaletteUse(hdcPal,SYSPAL_STATIC);
  SetSysColors(21,sysColorNumArray,sysColorArray);

}

char
*XDisplayString(display)
Display *display;
{
	return (display->display_name);
}


void putImagePart2();

static Window cachedImageWindow = NULL;
int
XFlush(display)
Display *display;
{
  putImagePart2();
}


int
XSync(display,discard)
Display *display;
int discard;
{
	/* Do nothing here either */
}

/*****************************************************************\

	Function: XGetVisualInfo
	Inputs:   display, info mask, template, number of matches.
	Returned: List of XVisualInfo structures, one for each matching
		  Visual.

	Comments: Behaves like X routine, but there is only ever one
		  Visual, so the returned list is never longer than one.

\*****************************************************************/
XVisualInfo
*XGetVisualInfo(display,vinm,vint,n)
Display *display;
long vinm;
XVisualInfo *vint;
int *n;
{
	static XVisualInfo xvi;
	int status=1;

	if ((vinm&VisualIDMask|vinm==VisualAllMask)&&
            vint->visualid!=display->screens->root_visual->visualid)
		status=0;
	if ((vinm&VisualScreenMask|vinm==VisualAllMask)&&
	    vint->screen!=0)
		status=0;
	if ((vinm&VisualDepthMask|vinm==VisualAllMask)&&
	    vint->depth!=24)
		status=0;
	if ((vinm&VisualClassMask|vinm==VisualAllMask)&&
	    vint->class!=display->screens->root_visual->class)
		status=0;
	if ((vinm&VisualRedMaskMask|vinm==VisualAllMask)&&
	    vint->red_mask!=display->screens->root_visual->red_mask)
		status=0;
	if ((vinm&VisualGreenMaskMask|vinm==VisualAllMask)&&
	    vint->green_mask!=display->screens->root_visual->green_mask)
		status=0;
	if ((vinm&VisualBlueMaskMask|vinm==VisualAllMask)&&
	    vint->blue_mask!=display->screens->root_visual->blue_mask)
		status=0;
	if ((vinm&VisualColormapSizeMask|vinm==VisualAllMask)&&
	    vint->colormap_size!=display->screens->root_visual->map_entries)
		status=0;
	if ((vinm&VisualBitsPerRGBMask|vinm==VisualAllMask)&&
	    vint->bits_per_rgb!=display->screens->root_visual->bits_per_rgb)
		status=0;
	if (status==1)
	{
		xvi.visualid=display->screens->root_visual->visualid;
		xvi.screen=0;
		xvi.depth=display->screens->root_visual->bits_per_rgb;
		xvi.class=display->screens->root_visual->class;
		xvi.red_mask=display->screens->root_visual->red_mask;
		xvi.green_mask=display->screens->root_visual->green_mask;
		xvi.blue_mask=display->screens->root_visual->blue_mask;
		xvi.colormap_size=display->screens->root_visual->map_entries;
		xvi.bits_per_rgb=display->screens->root_visual->bits_per_rgb;
		xvi.visual=display->screens->root_visual;
		*n=1;
		return (&xvi);
	}
	*n=0;
	return (&xvi);
}


/*****************************************************************\

	Function: XClearWindow
	Inputs:   display, window

	Comments: As mentioned, the Window structure is not the one windows
		  recognises.  The background colour for the window is
		  stored in this structure.

		  The sequence of GetDC, CreateBrush/Pen, SelectObject,
		  <draw stuff>, DeleteObject, ReleaseDC occurs in all the
		  drawing functions.

\*****************************************************************/
int
XClearWindow(display, window)
Display *display;
Window window;
{
	RECT  rRect;
	HBRUSH hbrush;
        HDC hDC;
        HANDLE oldObj;
        int oldROP;

        hDC = cjh_get_dc(window->w);
        oldROP = SetROP2(hDC,R2_COPYPEN);
	hbrush = CreateSolidBrush(PALETTEINDEX(window->bg));
	oldObj = SelectObject(hDC, hbrush);
	GetClientRect(window->w, &rRect);
	FillRect(hDC, &rRect, hbrush);
        SelectObject(hDC, oldObj);
	DeleteObject(hbrush);
        SetROP2(hDC,oldROP);
        cjh_rel_dc(window->w,hDC);
}


/*****************************************************************\

	Function: XCreateSimpleWindow
	Inputs:   display, parent window, geometry, border width,
		  border colour, background colour.
	Returned: Window ID

	Comments: The first time a window is made by the application, it
		  has to be registered.
		  To simulate the action of a window manager, the toplevel
		  client window is reparented and a frame window is created.
		  A StructureNotify event is sent to the new client.
		  Note that child windows are created in the manner of the
		  default X behaviour, ie. each is clipped individually.


        NOTE:     This routine has now changed. As part of our role as
                  Window manager, we now defer creation of the windows until
                  they are mapped. The fact that a window has been created
                  and not mapped is flagged to other routines by setting the
                  w element of the structure to -1.
                  WE STILL CREATE THE Window STRUCTURES.
                  (SEE XMapWindow)

\*****************************************************************/

Window
XCreateSimpleWindow(display, parent,x, y, w, h, brd, brd_col, bg)
Display *display;
Window  parent;
int     x, y, brd;
unsigned int w,h;
long bg, brd_col;
{
	WNDCLASS  wc;
	Window    canvas, outer;
	HANDLE    curInstance = hInstance;
	HBRUSH    hbrush;
	HANDLE    prevInstance = hPrevInstance;
	static int first = 1;
	RECT rect;
        cjh_printf("BACKGROUND color to %d - %x %x %x\n",(int)bg,sysPal->palPalEntry[bg].peRed,
                                                 sysPal->palPalEntry[bg].peGreen,sysPal->palPalEntry[bg].peBlue);
        windowBg = bg;
	if (!prevInstance  && first)
	{
		wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC; /* CS_OWNDC */
		wc.lpfnWndProc = (WNDPROC)MainWndProc;
		wc.cbClsExtra = 0;
		wc.cbWndExtra = 0;
		wc.hInstance = curInstance;
		wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
		wc.hCursor = LoadCursor(NULL, IDC_ARROW);

		wc.hbrBackground = hbrush = CreateSolidBrush (PALETTEINDEX(bg));
		wc.lpszMenuName =  NULL;
		wc.lpszClassName = app_name;
		RegisterClass(&wc);
/*		if (!RegisterClass(&wc))
			return NULL;     */
		first = 0;
	}

        if ( parent->w == GetDesktopWindow() )
          {
          outer = NT_new_window_pair(&canvas);
          outer->client = canvas;
          outer->bg = bg;
          outer->parent = parent;
          outer->frame  = NULL;
          NT_add_child(outer,canvas);
          NT_add_child(parent,outer);
          canvas->frame = outer;
	  outer->x = x;
          outer->y = y;
          outer->wdth = w;
          outer->hght = h;
          canvas->x = -1;
          canvas->y = -1;
          }
        else
          {
	  canvas = NT_new_window();
          outer = parent;
          canvas->frame = NULL;
          canvas->x = x;
          canvas->y = y;
          canvas->wdth = w;
          canvas->hght = h;
          NT_add_child(parent,canvas);
          }
	canvas->bg=bg;
	canvas->parent=outer;
	canvas->client=NULL;
        canvas->title_text = NULL;
        canvas->props = NULL;
	if (outer!=parent)
		outer->client=canvas;

	return (canvas);
}


/*****************************************************************\

	Function: XCreateWindow
	Inputs:   display, parent window, geometry, border width, depth,
		  class, visual, attributes mask, attributes structure
	Returned: Window ID

	Comments: Simply calls XCreateSimpleWindow.  Some of the arguments
		  are ignored :-).

\*****************************************************************/

Window
XCreateWindow(display,parent,x,y,width,height,bw,depth,class,visual,
			valuemask,attr)
Display *display;
Window  parent;
int x,y;
unsigned int width,height,bw;
int depth;
unsigned int class;
Visual *visual;
unsigned long valuemask;
XSetWindowAttributes *attr;
{
	return (XCreateSimpleWindow(display,parent,x,y,width,height,bw,
		attr->border_pixel,attr->background_pixel));
}


/*****************************************************************\

	Function: XDestroyWindow
	Inputs:   Display, window to be destroyed.

	Comments: Removes a window from the server.  Some fiddling is needed
		  to remove frames that we have made as well as client
		  windows.

\*****************************************************************/
int
XDestroyWindow(display,w)
Display *display;
Window w;
{
        if (w->hDC != INVALID_HANDLE)
          cjh_rel_dc(w->w,w->hDC);
	/*DestroyWindow(w->w);*/
        if ( w->frame != NULL )
	  {
          if (w->frame->hDC != INVALID_HANDLE)
            cjh_rel_dc(w->frame->w,w->frame->hDC);
          delFocusWindow(w->frame);
          activateTopWin();
	  /*DestroyWindow(w->frame->w);*/
	  NT_delete_window(w->frame);
	  }
	NT_delete_window(w);   /* Remove window from data structure */
}


/*****************************************************************\

	Function: XGetGeometry
	Inputs:   display, window
	Returned: root window, screen depth, geometry, border width

	Comments: fetches information from the windows kernel and our
		  display structure.

\*****************************************************************/

Status
XGetGeometry(display,w,root,x,y,width,height,bw,depth)
Display *display;
Drawable w;
Window *root;
int *x,*y;
unsigned int *width,*height;
unsigned int *bw,*depth;
{
	RECT r;

	*root=display->screens[0].root;
	*depth=24;

	GetWindowRect(w->w,&r);
	*x=r.left;
	*y=r.top;
	*width=r.right-r.left;
	*height=r.bottom-r.top;
	GetClientRect(w->w,&r);
	*bw=(*width-(r.right-r.left))/2;
}


/*****************************************************************\

	Function: XGetWindowAttributes
	Inputs:   display, window, attributes
	Returned: 1 = ok.

	Comments: Fills out attributes structure.

\*****************************************************************/

Status
XGetWindowAttributes(display,w,wattr)
Display *display;
Window w;
XWindowAttributes *wattr;
{
	XGetGeometry(display,w,&wattr->root,&wattr->x,&wattr->y,&wattr->width,
		&wattr->height,&wattr->border_width,&wattr->depth);
	wattr->class=InputOutput;
	wattr->bit_gravity=StaticGravity;
	wattr->win_gravity=CenterGravity;
	wattr->backing_store=NotUseful;
	wattr->backing_planes=0;
	wattr->backing_pixel=0;
	wattr->save_under=False;
	wattr->colormap=None;
	wattr->map_installed=True;
	wattr->map_state=IsViewable;
/*	wattr->all_event_masks=
	wattr->your_event_mask=
	wattr->do_not_propagate_mask=    */
	wattr->override_redirect=False;
	wattr->screen=display->screens;
	return (1);
}



int
XSelectInput(display, window, mask)
Display *display;
Window  window;
long    mask;
{
/***** Depends on event structure -- not fixed yet *****/
}

DWORD mwmHintsToFrameStyle(hints)
MwmHints *hints;
{
  DWORD frame_style = WS_CLIPCHILDREN;
  if (hints->decorations & MWM_DECOR_BORDER)
  {
    frame_style |=  WS_BORDER;
  }

  if (hints->decorations & MWM_DECOR_RESIZEH)
  {
    frame_style |= WS_THICKFRAME;
  }
  if (hints->decorations & MWM_DECOR_TITLE)
  {
    frame_style |= WS_CAPTION;
  }
  else
  {
    frame_style |= WS_POPUP;
  }
  if (hints->decorations & MWM_DECOR_MENU)
  {
    frame_style |= WS_SYSMENU;
  }
  if (hints->decorations & MWM_DECOR_MINIMIZE)
  {
    frame_style |= WS_MINIMIZEBOX;
  }
  if (hints->decorations & MWM_DECOR_MAXIMIZE)
  {
    frame_style |= WS_MAXIMIZEBOX;
  }

  return frame_style;
}

/*****************************************************************\

	Function: XMapWindow
	Inputs:   display, window to be mapped

	Comments: If the specified window is not already mapped, this
		  routine calls the Windows function which displays it.
		  Again, frames have to be mapped as well as clients.

\*****************************************************************/
int
XMapWindow(display, window)
Display *display;
Window window;
{
  RECT rect;
  HANDLE curInstance = hInstance;
  MwmHints *hints;
  Atom property;
  Atom ret_type;
  int ret_format;
  DWORD frame_style;
  long ret_nitems;
  long ret_after;
  HDC hDC;

        property = XInternAtom(d,_XA_MWM_HINTS,TRUE);

        if ( window->frame != NULL )
        {
          if (XGetWindowProperty(d,window,property,0L,0L,
                                FALSE,property,&ret_type,&ret_format,
                                     &ret_nitems,&ret_after,&hints) == Success)
          {
            frame_style = mwmHintsToFrameStyle(hints);
          }
          else
          {
            frame_style = WS_OVERLAPPEDWINDOW|WS_CLIPCHILDREN;
          }

          if (window->free_flag == NT_NOT_REPROPED)
          {
            printf("Redoing the properties of window %x with HWND %x\n",window,window->frame->w);
            window->frame->free_flag = NT_USED;
            SetWindowLong(window->frame->w,GWL_STYLE,frame_style);

            if((frame_style & WS_OVERLAPPEDWINDOW) == WS_OVERLAPPEDWINDOW)
              window->frame->hght+=NT_TITLE_BORDER_SIZE;
            else if ((frame_style & WS_CAPTION) == WS_CAPTION)
              window->frame->hght+=NT_TITLE_BORDER_SIZE;
            else
              window->frame->hght += NT_BORDER_SIZE;
            window->frame->wdth+=8;

	    if ( window->frame->wdth > 250 )
	      window->frame->top_flag = FALSE;
	    else
	      window->frame->top_flag = TRUE;

            SetWindowPos(window->frame->w,HWND_TOP,window->frame->x,
                         window->frame->y,window->frame->wdth,
                         window->frame->hght,SWP_NOACTIVATE);
            addFocusWindow(window->frame);
          }




	  if ( window->frame->w == INVALID_HANDLE )
            {
              if((frame_style & WS_OVERLAPPEDWINDOW) == WS_OVERLAPPEDWINDOW)
                window->frame->hght+=NT_TITLE_BORDER_SIZE;
              else if ((frame_style & WS_CAPTION) == WS_CAPTION)
                window->frame->hght+=NT_TITLE_BORDER_SIZE;
              else
                window->frame->hght += NT_BORDER_SIZE;

              window->free_flag = NT_USED;
              window->frame->wdth+=8;

	      if ( window->frame->wdth > 250 )
	        window->frame->top_flag = FALSE;
	      else
	        window->frame->top_flag = TRUE;

              window->frame->hDC = INVALID_HANDLE;
              window->frame->w = CreateWindow(app_name,"",frame_style,
			    window->frame->x,window->frame->y,
		            window->frame->wdth,window->frame->hght,
                            NULL,NULL,curInstance,NULL);
              /*window->frame->hDC = cjh_get_dc(window->frame->w);*/
              if (window->title_text != NULL)
                (void) SetWindowText(window->frame->w,window->title_text);
              addFocusWindow(window->frame);
              printf("Created Window Frame %x with handle %x\n",window->frame,window->frame->w);
            }

          if ( IsWindowVisible(window->frame->w)==0)
	  {

	    ShowWindow(window->frame->w, SW_SHOW);
	    UpdateWindow(window->frame->w);
	  }
	NT_OrderFrame(window->frame, TRUE);
        }

        if (window->x == -1 && window->y == -1)
        {
          GetClientRect(window->frame->w,&rect);
          window->x = rect.left;
          window->y = rect.top;
          window->wdth = rect.right-rect.left;
          window->hght = rect.bottom - rect.top;
         }

        if (window->free_flag == NT_NOT_REPROPED)
          {
            window->free_flag = NT_USED;
            SetWindowPos(window->w,HWND_TOP,window->x,
                         window->y,window->wdth,
                         window->hght,SWP_NOACTIVATE);
          }

        if (window->w == INVALID_HANDLE)
        {
          window->hDC = INVALID_HANDLE;
          window->w = CreateWindow(app_name,"",
                       WS_CHILD|WS_CLIPCHILDREN|WS_CLIPSIBLINGS,
                       window->x,window->y,window->wdth,window->hght,
                       window->parent->w,NULL,curInstance,NULL);
           printf("Created Window %x with handle %x\n",window,window->w);
           hDC = cjh_get_dc(window->w);
           SelectPalette(hDC,hpalX,FALSE);
           SetSystemPaletteUse(hDC,SYSPAL_NOSTATIC);
           RealizePalette(hDC);
           cjh_rel_dc(window->w,hDC);
          PostMessage(window->w,USR_StructureNotify,0,0);
        }
	if (IsWindowVisible(window->w)==0)
	{
		ShowWindow(window->w, SW_SHOW);
		UpdateWindow(window->w);
		XClearWindow(display,window);
		PostMessage(window->w,USR_StructureNotify,0,0);
	}
      GetWindowRect(window->w,&rect);
}


/*****************************************************************\

	Function: XCreateGC
	Inputs:   display, window, mask of setup values, setup values.
	Returned: GC pointer.

	Comments: Fills out a GC structure with the X defaults unless
		  the caller specifies otherwise.

\*****************************************************************/

GC
XCreateGC(display, window, mask, gc_values)
Display *display;
Window window;
unsigned long mask;
XGCValues *gc_values;
{
	GC	local_gc;
	int	size;
	char	*ptr;

	size = sizeof(GC);

        ptr = (char *)malloc((size_t)1000);
	local_gc = (GC)ptr;
	local_gc->ext_data = NULL;
	local_gc->gid=(GContext) window;
	local_gc->rects=FALSE;
	local_gc->dashes=FALSE;

	if (mask&GCArcMode)
	local_gc->values.arc_mode=gc_values->arc_mode;
	else
	local_gc->values.arc_mode=ArcPieSlice;
	if (mask&GCBackground)
	local_gc->values.background=gc_values->background;
	else
	local_gc->values.background=display->screens->white_pixel;
	if (mask&GCCapStyle)
	local_gc->values.cap_style=gc_values->cap_style;
	else
	local_gc->values.cap_style=CapButt;
	if (mask&GCClipMask)
	local_gc->values.clip_mask=gc_values->clip_mask;
	else
	local_gc->values.clip_mask=None;
	if (mask&GCClipXOrigin)
	local_gc->values.clip_x_origin=gc_values->clip_x_origin;
	else
	local_gc->values.clip_x_origin=0;
	if (mask&GCClipYOrigin)
	local_gc->values.clip_y_origin=gc_values->clip_y_origin;
	else
	local_gc->values.clip_y_origin=0;
	if (mask&GCDashList)
	local_gc->values.dashes=gc_values->dashes;
	else
	local_gc->values.dashes=4;
	if (mask&GCDashOffset)
	local_gc->values.dash_offset=gc_values->dash_offset;
	else
	local_gc->values.dash_offset=0;
	if (mask&GCFillRule)
	local_gc->values.fill_rule=gc_values->fill_rule;
	else
	local_gc->values.fill_rule=EvenOddRule;
	if (mask&GCFillStyle)
	local_gc->values.fill_style=gc_values->fill_style;
	else
	local_gc->values.fill_style=FillSolid;
	if (mask&GCFont)
	local_gc->values.font=gc_values->font;
	else
	local_gc->values.font= 999;/*"fixed";*/
	if (mask&GCForeground)
	local_gc->values.foreground=gc_values->foreground;
	else
	local_gc->values.foreground=display->screens->black_pixel;
	if (mask&GCFunction)
	local_gc->values.function=gc_values->function;
	else
	local_gc->values.function=GXcopy;
	if (mask&GCGraphicsExposures)
	local_gc->values.graphics_exposures=gc_values->graphics_exposures;
	else
	local_gc->values.graphics_exposures=True;
	if (mask&GCJoinStyle)
	local_gc->values.join_style=gc_values->join_style;
	else
	local_gc->values.join_style=JoinMiter;
	if (mask&GCLineStyle)
	local_gc->values.line_style=gc_values->line_style;
	else
	local_gc->values.line_style=LineSolid;
	if (mask&GCLineWidth)
	local_gc->values.line_width=gc_values->line_width;
	else
	local_gc->values.line_width=0;
	if (mask&GCPlaneMask)
	local_gc->values.plane_mask=gc_values->plane_mask;
	else
	local_gc->values.plane_mask=255;
	if (mask&GCStipple)
	local_gc->values.stipple=gc_values->stipple;
/*	else
	local_gc->values.stipple=XCreatePixmap(display,window,8,8,8);  */
	if (mask&GCSubwindowMode)
	local_gc->values.subwindow_mode=gc_values->subwindow_mode;
	else
	local_gc->values.subwindow_mode=ClipByChildren;
	if (mask&GCTile)
	local_gc->values.tile=gc_values->tile;
/*	else
	local_gc->values.tile=XCreatePixmap(display,window,8,8,8);  */
	if (mask&GCTileStipXOrigin)
	local_gc->values.ts_x_origin=gc_values->ts_x_origin;
	else
	local_gc->values.ts_x_origin=0;
	if (mask&GCTileStipYOrigin)
	local_gc->values.ts_y_origin=gc_values->ts_y_origin;
	else
	local_gc->values.ts_y_origin=0;

	local_gc->dirty = 0xFFFF;

	return (local_gc);
}


/*****************************************************************\

	Function: XSetForeground
	Inputs:   display, gc, colour.

	Comments: Colour is an RGB triple (24bits).
\*****************************************************************/
int
XSetForeground(display, gc, color)
Display *display;
GC gc;
unsigned long    color;
{
        cjh_printf("Setting foreground color to %d - %x %x %x\n",(int)color,sysPal->palPalEntry[color].peRed,sysPal->palPalEntry[color].peGreen,sysPal->palPalEntry[color].peBlue);
	gc->values.foreground=color;
	gc->dirty |= GCForeground;
}


/*****************************************************************\

	Function: XDrawString
	Inputs:   display, window, gc, position, string, length of string.

	Comments: Writes text to the screen in the manner of X windows.
		  Note that the y origin is on the text baseline, ie.
		  the lowest part of a letter o rests on the baseline and
		  descenders fall below it.
		  The text is transparent.

\*****************************************************************/

int
XDrawString(display, window, gc, x, y, str, len)
Window  window;
GC      gc;
int     x,y,len;
char    *str;
{
	HDC          hDC;
	TEXTMETRIC   tmet;

        hDC = cjh_get_dc(window->w);
	SetBkMode(hDC,TRANSPARENT);
	SetTextColor(hDC,PALETTEINDEX(gc->values.foreground));
	GetTextMetrics(hDC,&tmet);
	TextOut(hDC,x,y-tmet.tmAscent,str,len);
        cjh_rel_dc(window->w,hDC);

}



int
XDrawString16(display, window, gc, x, y, str, len)
Window  window;
GC      gc;
int     x,y,len;
XChar2b *str;
{
}


/*****************************************************************\

	Function: XFillRectangle
	Inputs:   display, window, gc, geometry.

	Comments: fills rectangles in uniform colours.  No tiles/Pixmaps
		  are implemented yet.

\*****************************************************************/

int
XFillRectangle (display,window,gc,x,y,w,h)
Display *display;
Window window;
GC gc;
int x,y;
unsigned int w,h;
{
        RECT rct;
	HBRUSH hbrush;
        HDC hDC;
        HANDLE oldObj;
	int ret;

        hDC = cjh_get_dc(window->w);
        NT_set_rop(hDC,gc);
	hbrush = NT_get_GC_brush(hDC,gc);
	oldObj = SelectObject(hDC, hbrush);
        rct.left=(LONG) x;
        rct.right=(LONG) (x+w);
        rct.top=(LONG) y;
        rct.bottom=(LONG) (y+h);
	ret=FillRect(hDC, &rct, hbrush);
        cjh_rel_dc(window->w,hDC);
        SelectObject(hDC, oldObj);
	return (ret);
}


/*****************************************************************\

	Function: XClearArea
	Inputs:   display, geometry, exposure events allowed.

	Comments: Straightforward.

\*****************************************************************/
int
XClearArea(display,w,x,y,width,height,exposures)
Display *display;
Window w;
int x,y;
unsigned int width,height;
Bool exposures;
{
	RECT rct;
	DWORD Color;
	HBRUSH hbrush;
        HDC hDC;
        HANDLE oldObj;
        int oldROP;

        hDC = cjh_get_dc(w->w);
        oldROP = SetROP2(hDC,R2_COPYPEN);
	hbrush=CreateSolidBrush(PALETTEINDEX(w->bg));
	oldObj = SelectObject(hDC,hbrush);
        GetClientRect(w->w,&rct);

	if (width!=0)
	{
		rct.left=(LONG)x;
		rct.right=(LONG)(x+width+1);
	}

        if (height !=0)
        {
		rct.top=(LONG)y;
		rct.bottom=(LONG)(y+height + 1);
        }

	FillRect(hDC,&rct,hbrush);
        SelectObject(hDC, oldObj);
	DeleteObject(hbrush);
        SetROP2(hDC,oldROP);
        cjh_rel_dc(w->w,hDC);
}


Region
XCreateRegion()
{
	HRGN hrgn;

	hrgn=CreateRectRgn(0,0,1,1);
	return (hrgn);
}


/* Untested.  The Region stuff needs thinking about. */

int
XClipBox(hrgn,rect)
Region hrgn;
XRectangle *rect;
{
	RECT rct;

	GetRgnBox(hrgn,&rct);
	rect->x=(short)rct.left;
	rect->y=(short)rct.top;
	rect->width=(unsigned short)rct.right-rct.left;
	rect->height=(unsigned short)rct.bottom-rct.top;
	return TRUE;/*(rect);*/
}


int
XSetRegion(display,gc,hrgn)
Display *display;
GC gc;
Region hrgn;
{
	/* What to do here ? */

}


int
XDestroyRegion(hrgn)
Region hrgn;
{
	DeleteObject(hrgn);
}


int
XUnionRectWithRegion(rect,hrgnsrc,hrgndest)
XRectangle *rect;
Region hrgnsrc,hrgndest;
{
	HRGN temp;

	temp=CreateRectRgn(rect->x,rect->y,rect->x+rect->width,
				rect->y+rect->height);
	CombineRgn(hrgndest,hrgnsrc,temp,RGN_OR);
}


/*****************************************************************\

	Function: XDrawArc
	Inputs:   display, window, gc, bounding box geometry, arc angles.

	Comments: Works fine.

\*****************************************************************/

int
XDrawArc(display,w,gc,x,y,width,height,a1,a2)
Display *display;
Window w;
GC gc;
int x,y;
unsigned int width,height;
int a1,a2;
{
	HDC hDC;
	HPEN hpen;
	int tmp;
	double NT_deg64_to_rad();
        HANDLE oldObj;

	if (a2>=0)
		a2+=a1;
	else
	{
		tmp=a1;
		a1-=a2;
		a2=tmp;
	}

        hDC = cjh_get_dc(w->w);
	hpen = NT_get_GC_pen(hDC,gc);
	oldObj = SelectObject(hDC,hpen);
	Arc(hDC,x,y,x+width-1,y+height-1,
		(int) (x+width/2+width*cos(NT_deg64_to_rad(a1))),
		(int) (y+height/2-height*sin(NT_deg64_to_rad(a1))),
		(int) (x+width/2+width*cos(NT_deg64_to_rad(a2))),
		(int) (y+height/2-height*sin(NT_deg64_to_rad(a2))));
        SelectObject(hDC, oldObj);
        cjh_rel_dc(w->w,hDC);
}


/*****************************************************************\

	Function: XFillArc
	Inputs:   display, window, gc, geometry as above.

	Comments: Not tested at all, but should work.

\*****************************************************************/

int
XFillArc(display,w,gc,x,y,width,height,a1,a2)
Display *display;
Window w;
GC gc;
int x,y;
unsigned int width,height;
int a1,a2;
{
	HDC hDC;
	HBRUSH hbrush;
	int tmp;
        HANDLE oldObj;

	if (a2>=0)
		a2+=a1;
	else
	{
		tmp=a1;
		a1-=a2;
		a2=tmp;
	}
        hDC = cjh_get_dc(w->w);
	hbrush = NT_get_GC_brush(hDC,gc);
	oldObj = SelectObject(hDC,hbrush);
	if (gc->values.arc_mode==ArcChord)
	{
		Chord(hDC,x,y,x+width,y+height,
			(int) (x+width/2+width*cos(NT_deg64_to_rad(a1))),
			(int) (y+height/2+height*sin(NT_deg64_to_rad(a1))),
			(int) (x+width/2+width*cos(NT_deg64_to_rad(a2))),
			(int) (y+height/2+height*sin(NT_deg64_to_rad(a2))));
	}
	else
	{
		Pie(hDC,x,y,x+width,y+height,
			(int) (x+width/2+width*cos(NT_deg64_to_rad(a1))),
			(int) (y+height/2+height*sin(NT_deg64_to_rad(a1))),
			(int) (x+width/2+width*cos(NT_deg64_to_rad(a2))),
			(int) (y+height/2+height*sin(NT_deg64_to_rad(a2))));
	}
        SelectObject(hDC, oldObj);
        cjh_rel_dc(w->w,hDC);
}


/*****************************************************************\

	Function: XFillPolygon
	Inputs:   display, window, gc, points list, number of points,
		  shape hint, relative drawing mode.

	Comments: Works for convex polygons.  Untested on otherwise.
	          Optimisation hints are unused, as is the mode.

\*****************************************************************/

int
XFillPolygon(display,w,gc,points,nps,shape,mode)
Display *display;
Window w;
GC gc;
XPoint *points;
int nps,shape,mode;
{
	HBRUSH hbrush;
	int n;
	POINT ntps[1000];
        HDC hDC;
        HANDLE oldObj;

 	/*ntps=malloc(sizeof(POINT)*nps);*/
        hDC = cjh_get_dc(w->w);
	hbrush = NT_get_GC_brush(hDC,gc);
	oldObj = SelectObject(hDC,hbrush);
	for (n=0;n<nps;++n)
	{
		(ntps+n)->x=(LONG)points->x;
		(ntps+n)->y=(LONG)(points++)->y;
	}
	Polygon(hDC,ntps,nps);
        SelectObject(hDC, oldObj);
        cjh_rel_dc(w->w,hDC);
	/*free(ntps);*/
}


/*****************************************************************\

	Function: XDrawLine
	Inputs:   display, window, geometry.

	Comments: Seems to work ok.

\*****************************************************************/

int
XDrawLine(display,w,gc,x1,y1,x2,y2)
Display *display;
Window w;
GC gc;
int x1,y1,x2,y2;
{
	HDC hDC;
	HPEN hpen;
	RECT da;
        HANDLE oldObj;

        GetClientRect(w->w,&da);

        x1 = ( x1 < 0         )   ? 0          : x1;
        x1 = ( x1 > da.right  )   ? da.right   : x1;
        y1 = ( y1 < 0         )   ? 0          : y1;
        y1 = ( y1 > da.bottom )   ? da.bottom  : y1;
        x2 = ( x2 < 0         )   ? 0          : x2;
        x2 = ( x2 > da.right  )   ? da.right   : x2;
        y2 = ( y2 < 0         )   ? 0          : y2;
        y2 = ( y2 > da.bottom )   ? da.bottom  : y2;

        hDC = cjh_get_dc(w->w);
	hpen = NT_get_GC_pen(hDC,gc);
	oldObj = SelectObject(hDC,hpen);
	MoveToEx(hDC,x1,y1,NULL);
	LineTo(hDC,x2,y2);
        SelectObject(hDC, oldObj);
        cjh_rel_dc(w->w,hDC);
}


/*****************************************************************\

	Function: XDrawLines
	Inputs:   display, window, gc, points list, number of points, mode.

	Comments: Untested.

\*****************************************************************/

int
XDrawLines(display,w,gc,points,nps,mode)
Display *display;
Window w;
GC gc;
XPoint *points;
int nps,mode;
{
	HPEN hpen;
	int n;
	POINT pts[1000];
        HDC hDC;
        HANDLE oldObj;

	/*pts=(POINT *) malloc(sizeof(POINT)*nps);*/
	pts->x=(LONG)points->x;
	pts->y=(LONG)points->y;

	for(n=1;n<nps;++n)
		if (mode==CoordModeOrigin)
		{
			(pts+n)->x=(LONG)(points+n)->x;
			(pts+n)->y=(LONG)(points+n)->y;
		}
		else
		{
			(pts+n)->x=(LONG)(points+n)->x+(pts+n-1)->x;
			(pts+n)->y=(LONG)(points+n)->y+(pts+n-1)->y;
		}

        hDC = cjh_get_dc(w->w);
	hpen = NT_get_GC_pen(hDC,gc);
	oldObj = SelectObject(hDC,hpen);
	Polyline(hDC,pts,nps);
        SelectObject(hDC, oldObj);
        cjh_rel_dc(w->w,hDC);
	/*free(pts);*/
}


/*****************************************************************\

	Function: XDrawPoints
	Inputs:   display, window, gc, points list, number of points, mode.

	Comments: Untested.

\*****************************************************************/

int
XDrawPoints(display,w,gc,points,nps,mode)
Display *display;
Window w;
GC gc;
XPoint *points;
int nps,mode;
{
	HDC hDC;
	int n;

        hDC = cjh_get_dc(w->w);
	SetPixelV(hDC,points->x,points->y,PALETTEINDEX(gc->values.foreground));
	for (n=1;n<nps;++n)
	{
		if (mode==CoordModeOrigin)
			SetPixelV(hDC,(points+n)->x,(points+n)->y,
					PALETTEINDEX(gc->values.foreground));
		else
			SetPixelV(hDC,(points+n-1)->x+(points+n)->x,
				(points+n-1)->y+(points+n)->y,
					PALETTEINDEX(gc->values.foreground));
	}
        cjh_rel_dc(w->w,hDC);
}


/*****************************************************************\

	Function: XDrawRectangle
	Inputs:   display, window, gc, geometry

	Comments: Seems to work.

\*****************************************************************/

int
XDrawRectangle(display,w,gc,x,y,width,height)
Display *display;
Window w;
GC gc;
int x,y;
unsigned int width,height;
{
	HDC hDC;
	RECT rect;
	HBRUSH hbrush;
	HPEN hpen;
        HANDLE oldbrush, oldpen;

        hDC = cjh_get_dc(w->w);
	hbrush = NT_get_GC_brush(hDC,gc);
	rect.left=(LONG)x;
	rect.right=(LONG)(x+width);
	rect.top=(LONG)y;
	rect.bottom=(LONG)(y+height);
	oldbrush = SelectObject(hDC,GetStockObject(NULL_BRUSH));
	hpen = NT_get_GC_pen(hDC,gc);
	oldpen = SelectObject(hDC,hpen);

	Rectangle(hDC,(int)rect.left,(int)rect.top,(int)rect.right,(int)rect.bottom);
/*
	FrameRect(hDC,&rect,hbrush);
*/
        SelectObject(hDC, oldbrush);
        SelectObject(hDC, oldpen);
        cjh_rel_dc(w->w,hDC);

}


/*****************************************************************\

	Function: XDrawSegments
	Inputs: display, window, gc, segment list, number of segments.

	Comments: Untested.

\*****************************************************************/

int
XDrawSegments(display,w,gc,segs,nsegs)
Display *display;
Window w;
GC gc;
XSegment *segs;
int nsegs;
{
	HDC hDC;
	HPEN hpen;
	int n;
        HANDLE oldObj;

        hDC = cjh_get_dc(w->w);
	hpen = NT_get_GC_pen(hDC,gc);
	oldObj = SelectObject(hDC,hpen);
        SetBkMode(hDC,TRANSPARENT);
	for (n=0;n<nsegs;n++)
	{
          MoveToEx(hDC,(segs+n)->x1,(segs+n)->y1,NULL);
          LineTo(hDC,(segs+n)->x2,(segs+n)->y2);
	}
        SelectObject(hDC, oldObj);
        cjh_rel_dc(w->w,hDC);
}


/*	Not needed for TrueColour */

Status
XAllocColor(display,cmap,xc)
Display *display;
Colormap cmap;
XColor *xc;
{
        printf("Calling alloc color %x %x %x.\n",xc->red,xc->green,xc->blue);
	xc->pixel=RGB((BYTE) xc->red,(BYTE) xc->green,(BYTE) xc->blue);
	return (1);
}

int NT_XDestroyImage(ximage)
XImage *ximage;
{
  free(ximage->data);
  free(ximage);
  return 1;
}


XImage
*XGetImage(display,w,x,y,width,height,plm,format)
Display *display;
Window w;
int x,y;
unsigned int width,height;
unsigned long plm;
int format;
{
        XImage *ret_image;
        RECT clientRect;
        HDC  hdcCompatible, hdcWindow;
        unsigned char *bigBitData,*smallBitData,*smallBitBase;
        HBITMAP hbmBitmap;
        BITMAPINFO bmInfo;
        int i;
/*
        hdcWindow = cjh_get_dc(w->w);
        GetClientRect(w->w,&clientRect);


        hdcCompatible = CreateCompatibleDC(hdcWindow);
        hbmBitmap = CreateCompatibleBitmap(hdcWindow,width,height);

/* Get the window's bitmap into our new "Compatible" bitmap
        if (!SelectObject(hdcCompatible,hbmBitmap))
        {
          printf("Could not allocate X image structure.\n");
          return NULL;
        }
        */
        if(!(ret_image = malloc(sizeof(XImage))))
        {
          printf("Could not allocate X image structure.\n");
          return NULL;
        }

        ret_image->width = width;
        ret_image->height = height;
        ret_image->xoffset = 0;
        ret_image->format = ZPixmap;

        if (!(ret_image->data = malloc(width*height*2)))
        {
          printf("Failed to allocate data area for XImage.\n");
          return NULL;
        }
        if (!(smallBitData = smallBitBase = malloc(width*height*3)))
        {
          printf("Failed to allocate data area for 24 Bit image.\n");
          return NULL;
        }


        ret_image->byte_order = LSBFirst;
        ret_image->bitmap_unit = 8;
        ret_image->bitmap_bit_order = MSBFirst;
        ret_image->bitmap_pad = 0;
        ret_image->depth = 8;
        ret_image->bytes_per_line = width;
        ret_image->bits_per_pixel = 8;
        ret_image->f.destroy_image = NT_XDestroyImage;

/* Get the BITMAP info into the Image .
        GetDIBits(hdcCompatible,hbmBitmap,0,height,smallBitData,&bmInfo,DIB_RGB_COLORS);

/* Copy the 24 Bit Pixmap to a 32-Bit one.
        bigBitData = ret_image->data;
        for (i = 0 ; i< width*height;i++)
        {
          *bigBitData++ = *smallBitData++;
          *bigBitData++ = *smallBitData++;
          *bigBitData++ = *smallBitData++;
          *bigBitData++ = 0;
        }


/* Free the Device contexts, and the Bitmap
        free(smallBitBase);
        DeleteDC(hdcCompatible);
        DeleteObject(hbmBitmap);
        cachedImageWindow = w;*/
        return ret_image;
}



XPutImage2(display,w,gc,image,sx,sy,dx,dy,width,height)
Display *display;
Window w;
XImage *image;
GC gc;
int sx,sy,dx,dy;
unsigned int width,height;
{
        RECT clientRect;
        HDC  hdcPICompat, hdcWindow;
        HBITMAP hbmPICompat;
        BITMAPINFO *bmInfo;
        int i;
        unsigned char *smallBitData,*smallBitBase,*bigBitData;
        WORD *indexWords;
        GetClientRect(w->w,&clientRect);
        /*printf("PutImage %d %d - %d %d | %d %d\n",sx,sy,dx,dy,width,height);*/

        PIWindow = w;

        hdcWindow = cjh_get_dc(w->w);
        hdcPICompat = CreateCompatibleDC(hdcWindow);
        SetSystemPaletteUse(hdcWindow,SYSPAL_NOSTATIC);
        RealizePalette(hdcWindow);
        hbmPICompat = CreateCompatibleBitmap(hdcWindow,width,height);
        bmInfo = malloc(sizeof(BITMAPINFO)+(cmapSize-1)*sizeof(WORD)-sizeof(RGBQUAD));

        /*  printf("*Put Bitmap is %x\n",hbmBitmap);*/

/* Get the window's bitmap into our new "Compatible" bitmap */
        if (!SelectObject(hdcPICompat,hbmPICompat))
        {
          printf("Failed to select comp bitmap into comp DC.\n");
          if (hdcPICompat)
            DeleteDC(hdcPICompat);
          if (hbmPICompat)
            DeleteObject(hbmPICompat);
          return;
        }
        SelectPalette(hdcPICompat,hpalX,FALSE);
        SetSystemPaletteUse(hdcPICompat,SYSPAL_NOSTATIC);
        RealizePalette(hdcPICompat);

        /*if (!(smallBitData = smallBitBase = malloc(width*height*2)))
        {
          printf("Failed to allocate data area for 24 Bit image.\n");
          return NULL;
        }
*/

/* Copy the 32 Bit Pixmap to a 24-Bit one.
        bigBitData = image->data;
        for (i = 0 ; i< width*height;i++)
        {
          *smallBitData++ = *bigBitData++;
        }
*/

/* Setup the BITMAPINFOHEADER, for the equivilent of an X-Windows ZPixmap. */
        bmInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
        bmInfo->bmiHeader.biWidth = width;
        bmInfo->bmiHeader.biHeight = height;
        bmInfo->bmiHeader.biPlanes = 1;
        bmInfo->bmiHeader.biBitCount = 8;
        bmInfo->bmiHeader.biCompression = BI_RGB;
        bmInfo->bmiHeader.biSizeImage = width *height; /* Specify a 24 bit bitmap. */
        bmInfo->bmiHeader.biClrImportant = 0; /* All colours important. */
        bmInfo->bmiHeader.biClrUsed = 0;
       indexWords = (WORD *)bmInfo->bmiColors;
       for (i=0;i<cmapSize;i++)
        indexWords[i] = i;

/* Put the XImage data into our compatible Bitmap. */
        SetDIBits(hdcPICompat,hbmPICompat,0,height,image->data/*smallBitBase*/,bmInfo,DIB_PAL_COLORS);

/* Copy into the window. */
        (void)BitBlt(hdcWindow,dx,dy,width,height,hdcPICompat,sx,sy,SRCCOPY);

/* Free the Device contexts, and the Bitmap */

        DeleteDC(hdcPICompat);
        DeleteObject(hbmPICompat);
        cjh_rel_dc(w->w,hdcWindow);
 /*       free(smallBitBase);*/
        free(bmInfo);
        PIWindow = NULL;
        /*for (i=0;i<width;i++)
          printf("%x%x%x ",image->data[3*i],image->data[3*i+1],image->data[3*i+2]);
        printf("\n");*/
}

int
XPutImage(display,w,gc,image,sx,sy,dx,dy,width,height)
Display *display;
Window w;
XImage *image;
GC gc;
int sx,sy,dx,dy;
unsigned int width,height;
{
        RECT clientRect;
        int i,j,toNextLine;
        unsigned char *smallBitData;
        unsigned char *bigBitData;
        printf("XPutImage %d %d -> %d %d by %d and %d into %d %d\n",sx,sy,dx,dy,width,height,PIWidth,PIHeight);
        if (width==height && width==1)
        {
             return;
        }
        if (w != PIWindow)
        {
          putImagePart2();
          PIWindow = w;
          GetClientRect(PIWindow->w,&clientRect);
          PIWidth = clientRect.right - clientRect.left ;
          PIHeight = clientRect.bottom - clientRect.top;
          PIWidth += ((PIWidth%4) == 0)?0:(4-(PIWidth%4));
          if (!(smallBitBase = malloc(PIWidth*PIHeight *2)))
          {
            printf("Failed to allocate data area for Bit image.\n");
            return NULL;
          }
        }


        bigBitData = image->data;
        smallBitData = smallBitBase+(PIWidth*(PIHeight - dy -1) + dx);
        toNextLine = 2*(PIWidth);
        for (i = 0 ; i< height;i++)
        {
          for (j = 0;j<width;j++)
          {
            *smallBitData++ = *(bigBitData++);
          }
          smallBitData-=toNextLine;
        }

}


void putImagePart2()
{
  HDC hdcPIWindow;
  HDC hdcPICompat;
  HWND oldFocusWin;
  HBITMAP hbmPICompat;
  BITMAPINFO *bmInfo;
  BITMAPINFOHEADER bmInfoHdr;
  int i;
  WORD *indexWords;

  if (!smallBitBase)
    return;

  printf("Differences are %d %d\n",PIWindow->wdth-PIWidth,PIWindow->hght-PIHeight);
  bmInfo = malloc(sizeof(BITMAPINFO)+(cmapSize-1)*sizeof(WORD)-sizeof(RGBQUAD));
  hdcPIWindow = cjh_get_dc(PIWindow->w);
  SetSystemPaletteUse(hdcPIWindow,SYSPAL_NOSTATIC);
  RealizePalette(hdcPIWindow);
  hdcPICompat = CreateCompatibleDC(hdcPIWindow);
  SelectPalette(hdcPICompat,hpalX,FALSE);
  SetSystemPaletteUse(hdcPICompat,SYSPAL_NOSTATIC);
  RealizePalette(hdcPICompat);
  hbmPICompat = CreateCompatibleBitmap(hdcPIWindow,PIWidth,PIHeight);

/*  Select the newly created Bitmap into the Compatible DC. */
  if (!SelectObject(hdcPICompat,hbmPICompat))
  {
     printf("Failed to select comp bitmap into comp DC.\n");
     return;
  }



/* Setup the BITMAPINFOHEADER, for the equivilent of an X-Windows ZPixmap. */
/*  GetDIBits(hdcPICompat,hbmPICompat,0,PIHeight,NULL,bmInfo,DIB_PAL_COLORS);
  printf("Dimensions are %x %x instead of %x %x\n",(int)bmInfo->bmiHeader.biWidth,
                                                   (int)bmInfo->bmiHeader.biHeight,
                                                   PIWidth,PIHeight);
  */

  bmInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
  bmInfo->bmiHeader.biWidth = PIWidth;
  bmInfo->bmiHeader.biHeight = PIHeight;
  bmInfo->bmiHeader.biPlanes = 1;
  bmInfo->bmiHeader.biBitCount = 8;
  bmInfo->bmiHeader.biCompression = BI_RGB;
  bmInfo->bmiHeader.biSizeImage = (PIWidth)* (PIHeight);
  bmInfo->bmiHeader.biClrImportant = 0; /* All colours important. */
  bmInfo->bmiHeader.biClrUsed = 0;

  indexWords = (WORD *)bmInfo->bmiColors;
  for (i=0;i<cmapSize;i++)
    indexWords[i] = i;



/* Put the XImage data into our compatible Bitmap. */
  SetSystemPaletteUse(hdcPICompat,SYSPAL_NOSTATIC);
  RealizePalette(hdcPICompat);
  SetDIBits(hdcPICompat,hbmPICompat,0,PIHeight,smallBitBase,bmInfo,DIB_PAL_COLORS);


/* Copy into the window. */
  SetSystemPaletteUse(hdcPIWindow,SYSPAL_NOSTATIC);
  RealizePalette(hdcPIWindow);
    (void)BitBlt(hdcPIWindow,0,0,PIWidth,PIHeight,hdcPICompat,0,0,SRCCOPY);

/* Free the Device contexts, and the Bitmap */
  DeleteDC(hdcPICompat);
  DeleteObject(hbmPICompat);
  cjh_rel_dc(PIWindow->w,hdcPIWindow);
  free(smallBitBase);
  free(bmInfo);
  smallBitBase = NULL;
  PIWindow = NULL;
}


/*****************************************************************\

	Function: XSetFillStyle
	Inputs:   display, gc, fill style.

	Comments: ZZzzz...

\*****************************************************************/

int
XSetFillStyle(display,gc,fs)
Display *display;
GC gc;
int fs;
{
	gc->values.fill_style=fs;
	gc->dirty |= GCFillStyle;
}


int
XSetDashes(display,gc,doff,dlist,n)
Display *display;
GC gc;
int doff;
char *dlist;
int n;
{
}


Pixmap
XCreateBitmapFromData(display,w,data,width,height)
Display *display;
Window w;
char *data;
unsigned int width,height;
{
}


int
XChangeWindowAttributes(display,w,vmask,attr)
Display *display;
Window w;
unsigned long vmask;
XSetWindowAttributes *attr;
{
}


/*****************************************************************\

	Function: XLowerWindow
	Inputs:   display, window to be lowered.

	Comments: Make sure if the window has a frame that that gets lowered
		  too.

\*****************************************************************/

int
XLowerWindow(display,w)
Display *display;
Window w;
{
	SetWindowPos((HWND)w->w,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
	if (w->frame!=NULL)
		SetWindowPos(w->frame->w,HWND_BOTTOM,0,0,0,0,
					SWP_NOMOVE|SWP_NOSIZE);
}


/*****************************************************************\

	Function: XMapRaised
	Inputs:   display, window.

	Comments: Frames get raised first.

\*****************************************************************/

int
XMapRaised(display,w)
Display *display;
Window w;
{
	XMapWindow(display,w);
	if (w->frame!=NULL)
		SetWindowPos(w->frame->w,HWND_TOP,0,0,0,0,
					SWP_NOMOVE|SWP_NOSIZE);
	SetWindowPos(w->w,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
}


/*****************************************************************\

	Function: XMapSubwindows
	Inputs:   display, window.

	Comments: Unfortunately, the optimisations normally made by
		  the X server are not made here.

\*****************************************************************/

int
XMapSubwindows(display,w)
Display *display;
Window w;
{
        struct NT_child *tmp;

	tmp=w->child;
	while (tmp!=NULL)
	{
		XMapWindow(display,tmp->w);
		tmp=tmp->next;
        }
}


/*****************************************************************\

	Function: XQueryTree
	Inputs:   display, window.
	Returned: root window, parent window, list of children, status.

	Comments: Not fully implemented.  The child field is wrong.

\*****************************************************************/

Status
XQueryTree(display,w,root,parent,ch,n)
Display *display;
Window w;
Window *root;
Window *parent;
Window **ch;
unsigned int *n;
{
	Status status=1;

	*parent=w->parent;
	if (*parent==NULL)
		status=0;
	*root=display->screens[0].root;
	*ch=NULL;
	*n=0;
	return (status);
}


/*****************************************************************\

	Function: XRaiseWindow
	Inputs:   display, window.

	Comments: Recursive raising of window and its children.

\*****************************************************************/

int
XRaiseWindow(display,w)
Display *display;
Window w;
{
	struct NT_child *tmp;

	if (w->frame!=NULL)
		BringWindowToTop(w->frame->w);
	BringWindowToTop(w->w);
	tmp=w->child;
	while (tmp!=NULL)
	{
		XRaiseWindow(display,tmp->w);
		tmp=tmp->next;
	}
}


/*****************************************************************\

	Function: XRootWindow
	Inputs:   display, screen number
	Returned: root window ID.

	Comments: Info taken from display structure.

\*****************************************************************/

Window
XRootWindow(display,scr)
Display *display;
int scr;
{
	return(display->screens[0].root);
}


/*****************************************************************\

	Function: XRootWindowOfScreen
	Inputs:   screen pointer
	Returned: root window ID.

	Comments: ZZzzz...

\*****************************************************************/

Window
XRootWindowOfScreen(scr)
Screen *scr;
{
	return(scr->root);
}


/*****************************************************************\

	Function: NT_get_children
	Inputs:   Window
	Returned: number of windows, window list.

	Comments: In preference to the windows Enum procedures, we examine
		  our own data structure to find the children of a given
		  window.

\*****************************************************************/

Window
*NT_get_children(win,n)
Window win;
int *n;
{
	int numcs=0;
        struct NT_child *tmp=win->child;
        Window *dest;

	while (tmp!=NULL)
	{
		numcs++;
		tmp=tmp->next;
	}
	*n=numcs;
	if (numcs==0)
		return (NULL);
	else
	{
		dest=(Window *) malloc (sizeof(Window)*numcs);
                tmp=win->child;
                while (tmp!=NULL)
		{
			dest[--numcs]=tmp->w;
			tmp=tmp->next;
		}
        }
        return (dest);
}


/*****************************************************************\

	Function: XTranslateCoordinates
	Inputs:   display, source window, destination window, source x, y.
	Returned: destination x, y, child window if any.

	Comments: Seems to work properly.

\*****************************************************************/

Bool
XTranslateCoordinates(display,sw,dw,sx,sy,dx,dy,ch)
Display *display;
Window sw,dw;
int sx,sy,*dx,*dy;
Window *ch;
{
	RECT srct,drct,crct;
	POINT target;
	Window *wp,child=NULL;
	int nwin,x;

        if (sw->w == INVALID_HANDLE)
        {
           srct.left = sw->x;
           srct.right =  sw->x + sw->wdth;
           srct.top = sw->y;
           srct.bottom = sw->y + sw->hght;
        }
        else
	  GetWindowRect(sw->w,&srct);

        if (dw->w == INVALID_HANDLE)
        {
           drct.left = dw->x;
           drct.right =  dw->x + dw->wdth;
           drct.top = dw->y;
           drct.bottom = dw->y + dw->hght;
        }
        else
	  GetWindowRect(dw->w,&drct),

	*dx=sx+srct.left-drct.left;
	*dy=sy+srct.top-drct.top;
	target.x=sx+srct.left;
	target.y=sy+srct.top;
	wp=NT_get_children(dw,&nwin);
	for (x=0;x<nwin;++x)
	{
          if (wp[x]->w == INVALID_HANDLE)
          {
            crct.left = wp[x]->x;
            crct.right =  wp[x]->x + wp[x]->wdth;
            crct.top = wp[x]->y;
            crct.bottom = wp[x]->y + wp[x]->hght;
          }
          else
	    GetWindowRect(wp[x]->w,&crct);
	  if (target.x>=crct.left && target.x<crct.right &&
	      target.y>=crct.left && target.y<crct.right &&
	      PtVisible(wp[x]->w,target.x,target.y))
		  child=wp[x];
        }
	free(wp);
	if (child==NULL)
		*ch=None;
	else
		*ch=child;
	return (True);
}


/*****************************************************************\

	Function: XUnmapWindow
	Inputs:   display, window.

	Comments: Removes a window and its frame, if it has one, from the
		  screen.

\*****************************************************************/

int
XUnmapWindow(display,w)
Display *display;
Window w;
{
	ShowWindow(w->w,SW_HIDE);
        if ( w->frame != NULL )
		ShowWindow(w->frame->w,SW_HIDE);
}


/*****************************************************************\

	Function: XCopyGC
	Inputs:   display, source gc, values mask, destination gc.

	Comments: Copies masked elements from source to destination.

\*****************************************************************/

int
XCopyGC(display,sgc,vmask,dgc)
Display *display;
GC sgc,dgc;
unsigned long vmask;
{
	if (vmask&GCFunction)
		dgc->values.function=sgc->values.function;
	if (vmask&GCPlaneMask)
		dgc->values.plane_mask=sgc->values.plane_mask;
	if (vmask&GCForeground)
		dgc->values.foreground=sgc->values.foreground;
	if (vmask&GCBackground)
		dgc->values.background=sgc->values.background;
	if (vmask&GCLineWidth)
		dgc->values.line_width=sgc->values.line_width;
	if (vmask&GCLineStyle)
		dgc->values.line_style=sgc->values.line_style;
	if (vmask&GCCapStyle)
		dgc->values.cap_style=sgc->values.cap_style;
	if (vmask&GCJoinStyle)
		dgc->values.join_style=sgc->values.join_style;
	if (vmask&GCFillStyle)
		dgc->values.fill_style=sgc->values.fill_style;
	if (vmask&GCFillRule)
		dgc->values.fill_rule=sgc->values.fill_rule;
	if (vmask&GCTile)
		dgc->values.tile=sgc->values.tile;
	if (vmask&GCStipple)
		dgc->values.stipple=sgc->values.stipple;
	if (vmask&GCTileStipXOrigin)
		dgc->values.ts_x_origin=sgc->values.ts_x_origin;
	if (vmask&GCTileStipYOrigin)
		dgc->values.ts_y_origin=sgc->values.ts_y_origin;
	if (vmask&GCFont)
		dgc->values.font=sgc->values.font;
	if (vmask&GCSubwindowMode)
		dgc->values.subwindow_mode=sgc->values.subwindow_mode;
	if (vmask&GCGraphicsExposures)
		dgc->values.graphics_exposures=sgc->values.graphics_exposures;
	if (vmask&GCClipXOrigin)
		dgc->values.clip_x_origin=sgc->values.clip_x_origin;
	if (vmask&GCClipYOrigin)
		dgc->values.clip_y_origin=sgc->values.clip_y_origin;
	if (vmask&GCClipMask)
		dgc->values.clip_mask=sgc->values.clip_mask;
	if (vmask&GCDashList)
		dgc->values.dashes=sgc->values.dashes;
	if (vmask&GCArcMode)
		dgc->values.arc_mode=sgc->values.arc_mode;

	dgc->dirty = 0xFFFF;
}


int
XSetClipMask(display,gc,cmask)
Display *display;
GC gc;
Pixmap cmask;
{
}


int
XSetClipRectangles(display,gc,clx,cly,rs,n,order)
Display *display;
GC gc;
int clx,cly;
XRectangle *rs;
int n,order;
{
}


/*****************************************************************\

	Function: XSetFunction
	Inputs:   display, gc, graphics operation.

	Comments: ZZzzz...

\*****************************************************************/

int
XSetFunction(display,gc,fn)
Display *display;
GC gc;
int fn;
{
	gc->values.function=fn;
	gc->dirty |= GCFunction;
}


/*****************************************************************\

	Function: XSetLineAttributes
	Inputs:   display, gc, line width, line style, cap style, join style.

	Comments: These all have windows equivalents.

\*****************************************************************/

int
XSetLineAttributes(display,gc,lw,ls,cs,js)
Display *display;
GC gc;
unsigned int lw;
int ls,cs,js;
{
	gc->values.line_width=lw;
	gc->values.line_style=ls;
	gc->values.cap_style=cs;
	gc->values.join_style=js;
	gc->dirty |= GCLineWidth | GCLineStyle | GCCapStyle | GCJoinStyle;
}


/*****************************************************************\

	Function: XSetPlaneMask
	Inputs:   display, gc, plane mask.

	Comments: What's a plane mask?

\*****************************************************************/

int
XSetPlaneMask(display,gc,pmask)
Display *display;
GC gc;
unsigned long pmask;
{
	gc->values.plane_mask=pmask;
}


int
XSetTile(display,gc,tile)
Display *display;
GC gc;
Pixmap tile;
{
}


Status
XAllocColorCells(display,cmap,cont,pmasks,np,pixels,nc)
Display *display;
Colormap cmap;
Bool cont;
unsigned long *pmasks;
unsigned int np;
unsigned long *pixels;
unsigned int nc;
{
  int i;
  cjh_printf("Alloate Color Cells with %d colors, %d masks.\n",nc,np);
  if (nextFreeColour + nc < cmapSize)
  {
    for (i = 0;i<nc;i++)
      pixels[i] = nextFreeColour++;
    if(np==1)
    {
      nextFreeColour+=nc;
      *pmasks = nc;
    }
    return 1;
  }
  return 0;

}


/*****************************************************************\

	Function: XAllocColorPlanes
	Inputs:   display, colour map, contiguous flag, pixel value list,
		  number of colours, number of reds, greens, blues.
	Returned: red mask, green mask, blue mask, status.

	Comments: Works for True Colour only.

\*****************************************************************/

Status
XAllocColorPlanes(display,cmap,cont,pixels,nc,nr,ng,nb,rmask,gmask,bmask)
Display *display;
Colormap cmap;
Bool cont;
unsigned long *pixels;
int nc;
int nr,ng,nb;
unsigned long *rmask,*gmask,*bmask;
{
	*rmask=255;
	*gmask=255<<8;
	*bmask=255<<16;
	return (1);
}


Status
XAllocNamedColor(display,cmap,cname,cell,rgb)
Display *display;
Colormap cmap;
char *cname;
XColor *cell,*rgb;
{
}


Colormap
XCreateColormap(display,w,visual,alloc)
Display *display;
Window w;
Visual *visual;
int alloc;
{
}


Status
XGetStandardColormap(display,w,cmapinf,prop)
Display *display;
Window w;
XStandardColormap *cmapinf;
Atom prop;
{
}


static int paletteTable[256];

buildPaletteTable()
{
  PALETTEENTRY pal[256];
  int i;
  int j;
  int numPalEntries;
  numPalEntries = GetSystemPaletteEntries(cjh_get_dc(getTopWinHandle()),0,255,pal);

  for (i=0;i<256;i++)
  {
    for (j=0;j<255;j++)
    {
      if (pal[j].peRed == sysPal->palPalEntry[i].peRed &&
          pal[j].peBlue == sysPal->palPalEntry[i].peBlue &&
          pal[j].peGreen == sysPal->palPalEntry[i].peGreen)
      {
        paletteTable[i] = j;
        break;
      }
    }
  }
}

int
XQueryColor(display,cmap,cell)
Display *display;
Colormap cmap;
XColor *cell;
{
  return XQueryColors(display,cmap,cell,1);
}


int
XQueryColors(display,cmap,cells,nc)
Display *display;
Colormap cmap;
XColor *cells;
int nc;
{
  int i;

  for (i=0;i<nc;i++)
  {
    cells[i].red=sysPal->palPalEntry[cells[i].pixel].peRed << 8;
    cells[i].green=sysPal->palPalEntry[cells[i].pixel].peGreen << 8;
    cells[i].blue=sysPal->palPalEntry[cells[i].pixel].peBlue << 8;
  }

}


int
XStoreColor(display,cmap,cell)
Display *display;
Colormap cmap;
XColor *cell;
{
  HWND topWinH;
  Window topW;
  HDC hDC;
    sysPal->palPalEntry[cell->pixel].peRed = cell->red >> 8;
    sysPal->palPalEntry[cell->pixel].peBlue = cell->blue >> 8;
    sysPal->palPalEntry[cell->pixel].peGreen = cell->green >> 8;
    cjh_printf("Storing single color %d - %x %x %x\n",cell->pixel,cell->red,cell->green,cell->blue);
  AnimatePalette(hpalX,cell->pixel,1,sysPal->palPalEntry);
  SetPaletteEntries(hpalX,cell->pixel,1,&(sysPal->palPalEntry[cell->pixel]));
  topWinH = getTopWinHandle(); /*GetActiveWindow();*/
  printf("Storing color\n");
  hDC = cjh_get_dc_ex(topWinH,NULL,DCX_NORESETATTRS);
  SelectPalette(hDC,hpalX,FALSE);
  SetSystemPaletteUse(hDC,SYSPAL_NOSTATIC);
  RealizePalette(hDC);
  cjh_rel_dc(topWinH,hDC);
  printf("Finishing storing color\n");
  SetActiveWindow(topWinH);
}



int
XStoreColors(display,cmap,cells,nc)
Display *display;
Colormap cmap;
XColor *cells;
int nc;
{
  HWND topWinH;
  Window topW;
  HDC hDC;
  int i;
  for (i=0 ; i<nc ; i++)
  {
    sysPal->palPalEntry[cells[i].pixel].peRed = cells[i].red >> 8;
    sysPal->palPalEntry[cells[i].pixel].peBlue = cells[i].blue >> 8;
    sysPal->palPalEntry[cells[i].pixel].peGreen = cells[i].green >> 8;
    cjh_printf("Storing color %d - %x %x %x\n",cells[i].pixel,cells[i].red,cells[i].green,cells[i].blue);
  }
  AnimatePalette(hpalX,0,cmapSize,sysPal->palPalEntry);
  SetPaletteEntries(hpalX,0,cmapSize,sysPal->palPalEntry);
  topWinH = getTopWinHandle();/*ActiveWindow();*/
  printf("Storing colors\n");
  hDC = cjh_get_dc_ex(topWinH,NULL,DCX_NORESETATTRS);
  /*SelectPalette(hDC,hpalX,FALSE);*/
  SetSystemPaletteUse(hDC,SYSPAL_NOSTATIC);
  RealizePalette(hDC);
  cjh_rel_dc(topWinH,hDC);
  printf("FInished storing colors.\n");
  SetActiveWindow(topWinH);
}

dumpSysPal(hDC)
HDC hDC;
{}

dumpSysPal2(hDC)
HDC hDC;
{
  PALETTEENTRY pal[256];
  int i;
  int j;
  int numPalEntries;
  numPalEntries = GetSystemPaletteEntries(hDC,0,255,pal);

  cjh_printf("System palette usage is %d\n",GetSystemPaletteUse(hDC));
  cjh_printf("Got %d SYSTEM PALETTE ENTRIES\n",numPalEntries);
  for(i=0;i<256;i+=8)
  {
     for (j=0;j<8;j++)
       cjh_printf("%2x-%2x|%2x|%2x|%2x ",i+j,pal[i+j].peRed,pal[i+j].peGreen,pal[i+j].peBlue,pal[i+j].peFlags);
     cjh_printf("\n");
  }
  numPalEntries = GetPaletteEntries(hpalX,0,255,pal);

  cjh_printf("Got %d LOGICAL PALETTE ENTRIES\n",numPalEntries);
  for(i=0;i<256;i+=8)
  {
     for (j=0;j<8;j++)
       cjh_printf("%2x-%2x|%2x|%2x|%2x ",i+j,pal[i+j].peRed,pal[i+j].peGreen,pal[i+j].peBlue,pal[i+j].peFlags);
     cjh_printf("\n");
  }

  cjh_printf("Palette correspondance table is ...\n");
  for (i=0;i<256;i+=8)
  {
    for (j=0;j<8;j++)
      cjh_printf("%2x-%2x|",i+j,paletteTable[i+j]);
    cjh_printf("\n");
  }
}



char
**XGetFontPath(display,nps)
Display *display;
int *nps;
{
	return (NULL);
}


Bool
XGetFontProperty(fstruct,atom,val)
XFontStruct *fstruct;
Atom atom;
unsigned long *val;
{
	return (0);
}


XFontStruct
*XLoadQueryFont(display,name)
Display *display;
char *name;
{
	static XFontStruct fs;

	return (&fs);
}

XFontStruct
*XQueryFont(display, font_id)
Display *display;
XID     font_id;
{
static XFontStruct fs;

  return(&fs);
}

KeySym
XKeycodeToKeysym(display, keycode, index)
Display *display;
KeyCode keycode;
int     index;
{
  return(NoSymbol);
}

XModifierKeymap
*XGetModifierMapping(display)
Display *display;
{
static XModifierKeymap map;

  map.max_keypermod = 0;

  return(&map);

}
int
XSetFont(display,gc,font)
Display *display;
GC gc;
Font font;
{
}


int
XSetFontPath(display,dirs,nd)
Display *display;
char **dirs;
int nd;
{
}


/*****************************************************************\

	Function: XTextExtents
	Inputs:   font structure, string, string length.
	Returned: writing direction, max ascent, max descent, font overall
		  characteristics.

	Comments: The design of windows fonts is similar to X, as far as
		  ascent and descent are concerned.  However, they are
		  positioned differently on the screen (see XDrawText).

\*****************************************************************/

static HDC desktopHDC;
static int firstTE = TRUE;
int
XTextExtents(fstruct,str,nc,dir,ascent,descent,overall)
XFontStruct *fstruct;
char *str;
int nc;
int *dir,*ascent,*descent;
XCharStruct *overall;
{
	TEXTMETRIC tmet;
        HDC hdc;
        SIZE tsize;
        HWND desktop;

        if (firstTE)
        {
          firstTE = FALSE;
          desktop=GetDesktopWindow();
          desktopHDC=cjh_get_dc(desktop);
        }
          hdc = desktopHDC;
	  GetTextMetrics(hdc,&tmet);
	  GetTextExtentPoint(hdc,str,nc,&tsize);
	  *dir=FontLeftToRight;
	  *ascent=tmet.tmAscent + 1;
	  *descent=tmet.tmDescent;
	  overall->ascent=tmet.tmAscent + 1;
	  overall->descent=tmet.tmDescent;
	  overall->width=tsize.cx;
	  overall->lbearing=0;
	  overall->rbearing=0;
	 /* cjh_rel_dc(desktop,hdc);*/

}


int
XTextExtents16(fstruct,str,nc,dir,ascent,descent,overall)
XFontStruct fstruct;
XChar2b *str;
int nc;
int *dir,*ascent,*descent;
XCharStruct *overall;
{
}


/*****************************************************************\


	Function: XTextWidth
	Inputs:   font structure, string, length of string.
	Returned: String width in pixels.

	Comments:

\*****************************************************************/

int
XTextWidth(fstruct,str,co)
XFontStruct *fstruct;
char *str;
int co;
{
	HDC hdc;
	SIZE tsize;
	HWND root;

        if(firstTE)
        {
          firstTE = FALSE;
	  root=GetDesktopWindow();
	  hdc=cjh_get_dc(root);
        }
	GetTextExtentPoint(hdc,str,co,&tsize);
	/*cjh_rel_dc(root,hdc);*/
	return (tsize.cx);
}


int
XTextWidth16(fstruct,str,co)
XFontStruct *fstruct;
XChar2b *str;
int co;
{
}


int
XGetErrorDatabaseText(display,name,msg,defstr,buf,len)
Display *display;
char *name,*msg;
char *defstr;
char *buf;
int len;
{
	static char def_err[]="Errors not implemented";
	int n;

	while (n<len && def_err[n]!=NULL)
		*(buf+n)=def_err[n++];
	*(buf+n)=NULL;
}


int
XGetErrorText(display,code,buf,len)
Display *display;
int code;
char *buf;
int len;
{
}


XErrorHandler
XSetErrorHandler(handler)
XErrorHandler handler;
{
}


/*****************************************************************\


	Function: XDefaultScreen
	Inputs:   display
	Returned: default screen number

	Comments:

\*****************************************************************/

int
XDefaultScreen(display)
Display *display;
{
	return (display->default_screen);
}


/*****************************************************************\


	Function: XScreenOfDisplay
	Inputs:   display,screen number
	Returned: screen list.

	Comments:

\*****************************************************************/

Screen
*XScreenOfDisplay(display,scr)
Display *display;
int scr;
{
	return (display->screens);
}


Cursor
XCreateFontCursor(display,shape)
Display *display;
unsigned int shape;
{
}


int
XRecolorCursor(display,cursor,fg,bg)
Display *display;
Cursor cursor;
XColor *fg,*bg;
{
}


/*****************************************************************\


	Function: XWarpPointer
	Inputs:   display, source window, destination window, source window
		  geometry, destination x, y.

	Comments: Not knowingly tested.

\*****************************************************************/

int
XWarpPointer(display,sw,dw,sx,sy,swidth,sheight,dx,dy)
Display *display;
Window sw,dw;
int sx,sy;
unsigned int swidth,sheight;
int dx,dy;
{
	POINT cpt,tmp;
	RECT srct;

	GetCursorPos(&cpt);
	if (sw==None)
	{
		if (dw==None)
			SetCursorPos(dx,dy);
		else
		{
			tmp.x=dx;
			tmp.y=dy;
			ClientToScreen(dw->w,&tmp);
			SetCursorPos(tmp.x,tmp.y);
		}
	}
	else
	{
		GetWindowRect(sw->w,&srct);
		tmp.x=sx;
		tmp.y=sy;
		ClientToScreen(sw->w,&tmp);
		if (swidth==0)
			swidth=srct.right-sx;
		if (sheight==0)
			sheight=srct.bottom-sy;
		if (cpt.x>=tmp.x && cpt.x<tmp.x+swidth &&
		    cpt.y>=tmp.y && cpt.y<tmp.y+sheight &&
		    PtVisible(sw->w,cpt.x,cpt.y))
		{
			if (dw==None)
				SetCursorPos(cpt.x+dx,cpt.y+dy);
			else
			{
				tmp.x=dx;
				tmp.y=dy;
				ClientToScreen(dw->w,&tmp);
				SetCursorPos(tmp.x,tmp.y);
			}
		}
	}
}


Bool
XCheckTypedEvent(display,ev,rep)
Display *display;
int ev;
XEvent *rep;
{
	return (False);
}


/*****************************************************************\


	Function: XCheckWindowEvent
	Inputs:   display, window, event mask.
	Returned: pointer to filled in event structure, status.

	Comments: This is fudged at the moment to work with the toolkit.
		  The event system needs rewriting to account properly for
		  event masks.

\*****************************************************************/

Bool
XCheckWindowEvent(display,w,emask,ev)
Display *display;
Window w;
int emask;
XEvent *ev;
{
	MSG msg;
	Bool status = 0;

	if (emask&SubstructureNotifyMask)
		if (PeekMessage(&msg,w->w,USR_StructureNotify,
				USR_StructureNotify,PM_REMOVE)||
		    PeekMessage(&msg,w->w,WM_PAINT,WM_PAINT,PM_REMOVE))
		{
			ev->type=ConfigureNotify;
			status = 1;
		}
	return(status);
}


int
XPending (display)
Display *display;
{
}


int
XPutBackEvent(display,event)
Display *display;
XEvent *event;
{
}


Status
XSendEvent(display,w,prop,emask,event)
Display *display;
Window w;
Bool prop;
unsigned long *emask;
XEvent *event;
{
}


/*****************************************************************\


	Function: XWindowEvent
	Inputs:   display, window, event mask.
	Returned: pointer to filled in event structure.

	Comments: This is fudged at the moment to work with the toolkit.
		  The event system needs rewriting to account properly for
		  event masks.

\*****************************************************************/

int
XWindowEvent(display,w,emask,rep)
Display *display;
Window w;
long emask;
XEvent *rep;
{
	MSG msg;

	if (emask&ExposureMask)
	{
		GetMessage(&msg,w->w,USR_StructureNotify,USR_StructureNotify);
		rep->type=ConfigureNotify;
	}
}


/*****************************************************************\


	Function: XBell
	Inputs:   display, percent loudness.

	Comments: Don't throw away your CD just yet.

\*****************************************************************/

int
XBell(display,pc)
Display *display;
int pc;
{
	Beep(200,400);
}


/*****************************************************************\


	Function: XGetInputFocus
	Inputs:   display, focus window, revert to window.

	Comments: We don't have the data in place for the revert to field
		  to work.

\*****************************************************************/

int
XGetInputFocus(display,focus,revto)
Display *display;
Window *focus;
int *revto;
{
	*focus=GetFocus();  /* Note: returns NULL if the focus window */
	revto=RevertToNone; /*       belongs to another thread.       */
}


/*****************************************************************\


	Function: XSetInputFocus
	Inputs:   display, focus window, revert to window, time.

	Comments: Set focus to requested client window.

\*****************************************************************/

int
XSetInputFocus(display,focus,revto,time)
Display *display;
Window focus;
int revto;
Time time;
{
	SetFocus(focus->w);
}


int
XLookupString(event,buf,nbytes,keysym,status)
XKeyEvent *event;
char *buf;
int nbytes;
KeySym *keysym;
XComposeStatus *status;
{
	*buf=event->keycode;
	*keysym=event->keycode;
	return (1);
}


int
XRefreshKeyboardMapping(event)
XMappingEvent *event;
{
}


int
XSetClassHint(display,w,chints)
Display *display;
Window w;
XClassHint *chints;
{
}


/*****************************************************************\


	Function: XSetNormalHints
	Inputs:   display, window, size hints.

	Comments: Assuming the role of the window manager, we alter the
		  window geometry as requested.

\*****************************************************************/

int
XSetNormalHints(display,w,hints)
Display *display;
Window w;
XSizeHints *hints;
{
	UINT ff;

        if (w->frame==NULL)
        {
	  if (!hints->flags&PPosition)
	       	  ff=SWP_NOMOVE;
	  else
		ff=0;
	  if (!hints->flags&PSize)
		ff=ff|SWP_NOSIZE;
          if (w->w == INVALID_HANDLE)
          {

/* Not yet mapped, but already being moved. set the new coordinates*/
            if(w->x == -1 && w->y == -1)
            {
              w->frame->x = hints->x;
              w->frame->y = hints->y;
              w->frame->wdth = hints->width + 8;
              w->frame->hght = hints->height + 32;
            }
            else
            {
              w->x = hints->x;
              w->y = hints->y;
              w->wdth = hints->width;
              w->hght = hints->height;
            }
          }
          else
	    SetWindowPos(w->w,HWND_TOPMOST,hints->x,hints->y,
			hints->width,hints->height,ff|SWP_SHOWWINDOW);
	}
}


int
XSetWMHints(display,w,wmhints)
Display *display;
Window w;
XWMHints wmhints;
{
}


Status
XSetWMProtocols(display,w,prots,co)
Display *display;
Window w;
Atom *prots;
int co;
{
}


/*****************************************************************\


	Function: XStoreName
	Inputs:   display, window, window name.

	Comments: Only set names to the frame windows, otherwise captions
		  appear in the client areas.

\*****************************************************************/

int
XStoreName(display,w,wname)
Display *display;
Window w;
char *wname;
{
int status = 0;

        if ( w->frame != NULL )
        {
         w->title_text = wname;
         if (w->frame->w !=INVALID_HANDLE)
	    status = SetWindowText (w->frame->w , wname);
        }

	return(status);
}



/*****************************************************************\


	Function: XDoesBackingStore
	Inputs:   screen

	Comments: No backing store at the moment.  Windows doesn't seem
		  to support it, unless we do it ourselves with compatible
		  bitmaps.

\*****************************************************************/

int
XDoesBackingStore(scr)
Screen *scr;
{
	return(0);
}


XExtCodes
*XInitExtension(display,name)
Display *display;
const char *name;
{
}


int
XConvertSelection(display,sel,target,prop,req,time)
Display *display;
Atom sel,target,prop;
Window req;
Time time;
{
}


/*****************************************************************\


	Function: XFree
	Inputs:   data to be freed.

	Comments: This might need changing sometime.  No crashes so far.

\*****************************************************************/

int
XFree(data)
char *data;
{
	free(data);
}

/*****************************************************************\


	Function: XServerVendor
	Inputs:   display.
	Returned: string of vendor's name.

	Comments: Copied from the display structure.

\*****************************************************************/

char
*XServerVendor(display)
Display *display;
{
	return (display->vendor);
}


int
XSetIconName(display,w,iname)
Display *display;
Window w;
char *iname;
{
}


int
XSetSelectionOwner(display,sel,owner,time)
Display *display;
Atom sel;
Window owner;
Time time;
{
}


/*****************************************************************\

	Function: XNextEvent
	Inputs:   display, event structure pointer.

	Comments: Windows routines receive messages (events) in two ways:
		  firstly by GetMessage, which takes messages from the
		  calling thread's message queue, and secondly by the
		  window function being called with events as arguments.
		  To simulate the X system, we get messages from the queue
		  and pass them to the window function anyway, which
		  processes them and fills out the local XEvent structure.
		  DispatchMessage calls the window procedure and waits until
		  it returns. Translate message turns WM_KEYUP/DOWN messages
		  into WM_CHAR.

\*****************************************************************/

int
XNextEvent(display, event)
Display *display;
XEvent  *event;
{
	MSG msg;

        XFlush(d);
	if (GetMessage(&msg, NULL, NULL, NULL))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		event->type = l_event.type;
		switch(l_event.type)
		{
		case Expose:
		event->xexpose.x=l_event.xexpose.x;
		event->xexpose.y=l_event.xexpose.y;
		event->xexpose.width=l_event.xexpose.width;
		event->xexpose.height=l_event.xexpose.height;
		event->xexpose.count = l_event.xexpose.count;
		event->xexpose.window = l_event.xexpose.window;
		XClearArea(display,l_event.xexpose.window,l_event.xexpose.x,
                           l_event.xexpose.y,l_event.xexpose.width,
                           l_event.xexpose.height,FALSE);
		break;
		case ConfigureNotify:
		event->xconfigure.window = l_event.xconfigure.window;
		break;
		case ButtonPress:
		case ButtonRelease:
		/*
printf("Button event %d - %d\n",  l_event.type, l_event.xbutton.button );
*/
		event->xbutton.x      = l_event.xbutton.x;
		event->xbutton.y      = l_event.xbutton.y;
		event->xbutton.button = l_event.xbutton.button;
		event->xbutton.window = l_event.xbutton.window;
		break;
		case KeyPress:
		event->xkey.x=0;
		event->xkey.y=0;
		event->xkey.state = l_event.xkey.state;
		event->xkey.keycode= l_event.xkey.keycode;
		event->xkey.window = l_event.xkey.window;
		break;
		case MotionNotify:
		event->xmotion.window=l_event.xmotion.window;
		event->xmotion.x=l_event.xmotion.x;
		event->xmotion.y=l_event.xmotion.y;
		event->xmotion.x_root=l_event.xmotion.x_root;
		event->xmotion.y_root=l_event.xmotion.y_root;
		event->xmotion.state=l_event.xmotion.state;
		break;
		case EnterNotify:
		event->xcrossing.x=l_event.xcrossing.x;
		event->xcrossing.y=l_event.xcrossing.y;
		event->xcrossing.window=l_event.xcrossing.window;
		break;
		case LeaveNotify:
		event->xcrossing.x=l_event.xcrossing.x;
		event->xcrossing.y=l_event.xcrossing.y;
		event->xcrossing.window=l_event.xcrossing.window;
		break;
		case ClientMessage:
		default:
		break;
		}
	}
}

int
XFlushQueue()
{
MSG msg;

  if (PeekMessage(&msg, NULL, NULL, NULL, NULL))
    {
    GetMessage(&msg, NULL, NULL, NULL);
    TranslateMessage(&msg);
    DispatchMessage(&msg);
    }
}



/*----------------------------------------------------------------*\
| FUNCTIONS TO MAINTAIN AN INTERNAL LIST OF WINDOWS AND THEIR      |
| ATTRIBUTES - AS WOULD BE MAINTAINED IN THE X SERVER.             |
\*----------------------------------------------------------------*/




/*---------------------------------------------------*\
| Function: NT_new_window_pair                        |
| Purpose:  Add a new window id to the Window table   |
| Return:   Pointer to the new Window structure.      |
\*---------------------------------------------------*/
static struct NT_window
*NT_new_window_pair(clientWin)
struct NT_window **clientWin;
{
  struct NT_window *new;
  struct NT_window *finder;
  NT_show_window_list();

  finder = window_list;
  while(finder)
  {
     if (finder->free_flag==NT_FREE_WIN && finder->client!= NULL)
       break;
    finder = finder->next;
  }
  if (!finder)
  {
    new = (struct NT_window *) malloc (sizeof(struct NT_window));
    new->next = window_list;
    new->child=NULL;
    new->props=NULL;
    new->free_flag = NT_NEWLY_CREATED;
    new->w = INVALID_HANDLE;
    window_list = new;

    (*clientWin) = (struct NT_window *) malloc (sizeof(struct NT_window));
    (*clientWin)->next = window_list;
    (*clientWin)->child=NULL;
    (*clientWin)->props=NULL;
    (*clientWin)->free_flag = NT_NEWLY_CREATED;
    (*clientWin)->top_flag = FALSE;
    (*clientWin)->w = INVALID_HANDLE;
    window_list = (*clientWin);
    printf("NEW window pair %x %x\n",window_list->next,window_list);
    return(window_list->next);
  }
  else
  {
    printf("REUSING window pair %x %x\n",finder,finder->client);

    *clientWin = finder->client;
    (*clientWin)->child=NULL;
    (*clientWin)->client = NULL;
    (*clientWin)->parent = NULL;
    (*clientWin)->frame = NULL;
    NT_del_prop_list((*clientWin)->props);
    (*clientWin)->props=NULL;
    (*clientWin)->free_flag = NT_NOT_REPROPED;
    (*clientWin)->top_flag = FALSE;

    finder->child=NULL;
    finder->client = NULL;
    finder->parent = NULL;
    finder->frame = NULL;
    NT_del_prop_list(finder->props);
    finder->props=NULL;
    finder->free_flag = NT_NOT_REPROPED;
    (*clientWin)->top_flag = FALSE;
    return finder;
  }
}

/*---------------------------------------------------*\
| Function: NT_new_window                             |
| Purpose:  Add a new window id to the Window table   |
| Return:   Pointer to the new Window structure.      |
\*---------------------------------------------------*/
static struct NT_window
*NT_new_window()
{
  struct NT_window *new;
  struct NT_window *finder;
  NT_show_window_list();

  finder = window_list;
  while(finder)
  {
     if (finder->free_flag==NT_FREE_WIN && finder->client==NULL
           && finder->frame == NULL)
       break;
    finder = finder->next;
  }
  if (!finder)
  {
    new = (struct NT_window *) malloc (sizeof(struct NT_window));
    new->next = window_list;
    new->child=NULL;
    new->props=NULL;
    new->free_flag = NT_NEWLY_CREATED;
    new->w = INVALID_HANDLE;
    window_list = new;
    printf("NEW window %x\n",window_list);
    return(window_list);
  }
  else
  {
    printf("REUSING window %x\n",finder);
    finder->child=NULL;
    finder->client = NULL;
    finder->parent = NULL;
    finder->frame = NULL;
    NT_del_prop_list(finder->props);
    finder->props=NULL;
    finder->free_flag = NT_NOT_REPROPED;
    return finder;
  }
}

/*---------------------------------------------------*\
| Function: NT_delete_window                          |
| Purpose:  Remove a window from the window list      |
| Input:    w - pointer to window data                |
| Return:   TRUE if deleted                           |
\*---------------------------------------------------*/
static int
NT_delete_window(struct NT_window *w)
{
struct NT_window *current,*last;
int status = FALSE;
  NT_show_window_list();

  if(w->parent != NULL)
    NT_del_child(w->parent,w);
/*if (window_list==w)
  {
    window_list=window_list->next;
    free(w);
    status=TRUE;
  }
  else
  {
    last=window_list;
    current=window_list->next;
    while (current!=w && current!=NULL)
    {
        last=current;
        current=current->next;
    }
    if (current!=NULL)
    {
        last->next=current->next;
        free(current);
        status=TRUE;
    }
  }
*/
  printf("Marking Window %x as FREE\n",w);
  w->free_flag = NT_FREE_WIN;
  ShowWindow(w->w,SW_HIDE);

  return TRUE;
  /*return(status);*/
}

/*------------------------------------------------*\
| Function: NT_find_window_from_id                 |
| Purpose:  Find the window in the window list     |
|           from the HWND id of the window.        |
| Input:    w - Window id (Windows HWND)           |
| Return:   pointer to NT_window structure for w.  |
\*------------------------------------------------*/
static struct NT_window
*NT_find_window_from_id(HWND w)
{
struct NT_window *current = window_list;
int i;

  while ( current != NULL &&
          current->w != w )
    current = current->next;
  if(current &&current->free_flag==NT_USED)
    return(current);
  return NULL;
}

int
NT_show_window_list()
{
struct NT_window *current=window_list;
struct NT_child *tmp;

  printf("----------- Window list --------------\n");
  while (current != NULL)
    {
    printf("%s Window - %d %d\n",current->free_flag?"":"Free", current, current->w);
    tmp=current->child;
    while (tmp!=NULL)
    {
        printf("Child          - %d %d\n", tmp, tmp->w);
    	tmp=tmp->next;
    }
    current = current->next;
    }
}


/*****************************************************************\

	Function: NT_add_child
	Inputs:   parent and child window IDs.
	Returned: 1

	Comments: When a child window is created (eg. client canvas) we
		  update our internal list of windows and their children.
		  New children are added to the front of the list.

\*****************************************************************/

int
NT_add_child(parent,child)
Window parent,child;
{
struct NT_child *new;

  new=(struct NT_child *) malloc (sizeof(struct NT_child));
  new->w=child;
  new->next = parent->child;
  parent->child=new;
  return(1);
}


/*****************************************************************\

	Function: NT_del_child
	Inputs:   parent and child window IDs.
	Returned: TRUE if window is removed, FALSE otherwise.

	Comments: Finds child window if it exits, and it so removes it from
		  the window list.

\*****************************************************************/

int
NT_del_child(parent,child)
struct NT_window *parent;
struct NT_window *child;
{
	struct NT_child *current,*last;
	int status=FALSE;

	if (parent->child->w==child)
	{
                current = parent->child;
		parent->child=parent->child->next;
		free(current);
		status=TRUE;
	}
	else
	{
		last=parent->child;
		current=parent->child->next;
		while (current->w!=child && current!=NULL)
		{
			last=current;
			current=current->next;
		}
		if (current!=NULL)
		{
			last->next=current->next;
			free(current);
			status=TRUE;
		}
	}
  return(status);
}


/*****************************************************************\

	Function: NT_set_rop
	Inputs:   window device context, X graphics context

	Comments: Sets the graphics drawing operation.

\*****************************************************************/

void
NT_set_rop(hdc,gc)
HDC hdc;
GC gc;
{
	switch (gc->values.function)
	{
		case GXclear:
			SetROP2(hdc,R2_BLACK);
		break;

		case GXand:
			SetROP2(hdc,R2_MASKPEN);
		break;

		case GXandReverse:
			SetROP2(hdc,R2_MASKPENNOT);
		break;

		case GXcopy:
			SetROP2(hdc,R2_COPYPEN);
		break;

		case GXnoop:
			SetROP2(hdc,R2_NOP);
		break;

		case GXxor:
			SetROP2(hdc,R2_XORPEN);/*XORPEN);*/
                        cjh_printf("Setting to Xor\n");
		break;

		case GXor:
			SetROP2(hdc,R2_MERGEPEN);
		break;

		case GXnor:
			SetROP2(hdc,R2_NOTMERGEPEN);
		break;

		case GXequiv:
			SetROP2(hdc,R2_NOTXORPEN);
		break;

		case GXinvert:
			SetROP2(hdc,R2_NOT);
		break;

		case GXorReverse:
			SetROP2(hdc,R2_MERGEPENNOT);
		break;

		case GXcopyInverted:
			SetROP2(hdc,R2_NOTCOPYPEN);
		break;

		case GXorInverted:
			SetROP2(hdc,R2_MERGENOTPEN);
		break;

		case GXnand:
			SetROP2(hdc,R2_NOTMASKPEN);
		break;

		case GXset:
			SetROP2(hdc,R2_WHITE);
		break;
	}
}

/*****************************************************************\

	Function: NT_check_update_GC
	Inputs:   gc - Graphics Context

	Comments: Check what has changed in the GC and modify the
		  pen and brush accordingly.

\*****************************************************************/
static int
NT_check_update_GC(gc)
GC gc;
{
	DWORD style=PS_GEOMETRIC;
	LOGBRUSH lbr;
	int	 width;
	HPEN     lpen;
	HBRUSH	 lbrush;
	NTGC	*lntgc;
	long color;

	if ( gc->ext_data == NULL )
	  {
	  gc->ext_data = (XExtData *)malloc(sizeof(XExtData));
	  lntgc = (NTGC *)malloc(sizeof(NTGC));
	  gc->ext_data->private_data = (char *)lntgc;
	  lntgc->pen = INVALID_HANDLE;
	  lntgc->brush = INVALID_HANDLE;
	  }

	if ( TRUE ||(gc->dirty & GCForeground) ||
             (gc->dirty & GCLineStyle)  ||
	     (gc->dirty & GCCapStyle)   ||
	     (gc->dirty & GCJoinStyle)  ||
	     (gc->dirty & GCLineWidth) )
          {
	  lbr.lbStyle=BS_SOLID;
	  lbr.lbColor=PALETTEINDEX(gc->values.foreground);
	  lbr.lbHatch=NULL;

	  if (gc->values.line_style==LineDoubleDash)
		  style|=PS_DASHDOT;
	  else if (gc->values.line_style==LineOnOffDash)
		  style|=PS_DASH;
	  else
		  style|=PS_SOLID;

	  if (gc->values.cap_style==CapProjecting)
		  style|=PS_ENDCAP_SQUARE;
	  else if (gc->values.cap_style==CapRound)
		  style|=PS_ENDCAP_ROUND;
	  else
		  style|=PS_ENDCAP_FLAT;

	  if (gc->values.join_style==JoinRound)
		  style|=PS_JOIN_ROUND;
	  else if (gc->values.join_style==JoinMiter)
		  style|=PS_JOIN_MITER;
	  else
		  style|=PS_JOIN_BEVEL;
	  width=gc->values.line_width;
	  if (width==0)
		  width=1;

	  lntgc = (NTGC *)gc->ext_data->private_data;
	  if ( lntgc->pen != INVALID_HANDLE )
	    DeleteObject(lntgc->pen);

	  lntgc->pen = ExtCreatePen(style,width,&lbr,0,NULL);
	  }

	if ( TRUE || (gc->dirty & GCForeground) )
	  {
	  lntgc = (NTGC *)gc->ext_data->private_data;
	  if ( lntgc->brush != INVALID_HANDLE )
	    DeleteObject(lntgc->brush);
	  lntgc->brush = CreateSolidBrush(PALETTEINDEX(gc->values.foreground));
	  }

   gc->dirty = 0;

   return(1);
}


/*****************************************************************\

	Function: NT_get_GC_pen
	Inputs:   device context, graphics context

	Comments: Sets the device context and pen according to the
		  graphics context.

\*****************************************************************/
static HPEN
NT_get_GC_pen(hdc,gc)
HDC hdc;
GC gc;
{
	NTGC *lntgc;

	NT_check_update_GC(gc);
	NT_set_rop(hdc,gc);

	lntgc = (NTGC *)gc->ext_data->private_data;

	return(lntgc->pen);
}


/*****************************************************************\

	Function: NT_get_GC_brush
	Inputs:   device context, graphics context
	Returns:  handle for brush.

	Comments: Same as above for painting operations.

\*****************************************************************/
static HBRUSH
NT_get_GC_brush(hdc,gc)
HDC hdc;
GC gc;
{
	NTGC *lntgc;

        NT_check_update_GC(gc);

	if (gc->values.fill_rule==EvenOddRule)
		SetPolyFillMode(hdc,ALTERNATE);
	else
		SetPolyFillMode(hdc,WINDING);

	NT_set_rop(hdc,gc);

	lntgc = (NTGC *)gc->ext_data->private_data;

	return(lntgc->brush);
}


/*****************************************************************\

	Function: NT_deg64_to_rad
	Inputs:   angle (in 64ths of a degree)

	Comments: Converts int angle to double in radians.

\*****************************************************************/

double
NT_deg64_to_rad(a)
int a;
{
	return ((double)a/64.0*0.017453);
}

/******************************************************************/
/*                                                                */
/*               Atoms and properties code.                       */
/*                                                                */
/******************************************************************/

static char **nt_atoms;
static int num_nt_atoms = 0;
static int max_num_nt_atoms = 0;
#define ATOMS_BLOCK_SIZE 40

/******************************************************************\

         Function:  XInternAtom
         Inputs:    Display, property name, creation flag.

         Comments:  Could be made much more efficient.

\******************************************************************/

Atom XInternAtom(display, property_name, only_if_exists)
Display *display;
char *property_name;
Bool only_if_exists;
{
  int i;
  char **new_nt_atoms;

  for (i=0;i< num_nt_atoms ;i++)
    if (strcmp(nt_atoms[i],property_name) == 0)
      return XA_LAST_PREDEFINED + i;

  if (only_if_exists)
    return None;

  if (num_nt_atoms >= max_num_nt_atoms)
  {
    new_nt_atoms = realloc(nt_atoms,(max_num_nt_atoms + ATOMS_BLOCK_SIZE)*sizeof(char *));
    if (!new_nt_atoms)
      return None;
    nt_atoms = new_nt_atoms;
    max_num_nt_atoms+= ATOMS_BLOCK_SIZE;
    nt_atoms[num_nt_atoms] = malloc(strlen(property_name)+1);
    if (!nt_atoms[num_nt_atoms])
      return None;
    strcpy(nt_atoms[num_nt_atoms],property_name);
    return (XA_LAST_PREDEFINED +  num_nt_atoms++);
  }
}

/******************************************************************\

         Function:  XGetAtomName
         Inputs:    Display,Atom

         Comments:  None.

\******************************************************************/
char *XGetAtomName(display,atom)
Display *display;
Atom atom;
{
  char *ret_string;
  if (atom > num_nt_atoms + XA_LAST_PREDEFINED)
    return NULL;

  if (! (ret_string = malloc(strlen(nt_atoms[atom - XA_LAST_PREDEFINED])+1)))
    return FALSE;

  strcpy(ret_string,nt_atoms[atom]);

  return ret_string;
}

/******************************************************************\

         Function:  XChangeProperty
         Inputs:    Display,Window,Property,type,format,mode,data,
                    nelements.

         Comments:  None.

\******************************************************************/
XChangeProperty(display,window,property,type,format,mode,data,nelements)
Display *display;
Window window;
Atom property;
Atom type;
int format;
int mode;
unsigned char *data;
int nelements;
{
  struct NT_prop_list *wanderer, *new;
  wanderer = window->props;
  while (wanderer)
  {
    if (wanderer->atom == property)
      break;
    wanderer = wanderer->next;
  }

  if (!wanderer)
  {
    if(!(new = malloc(sizeof(struct NT_prop_list))))
      return;
    if(!(new->data = malloc(nelements*format/8)))
      return;

    new->atom = property;
    new->format = format;
    new->num_items = nelements;
    new->type = type;
    memcpy(new->data,data,nelements*format/8);
    new->next = window->props;
    window->props = new;
  }
  else
  {
    switch(mode)
    {
      case PropModeReplace:
      case PropModePrepend:
      case PropModeAppend:
        free (wanderer->data);
        if (!(wanderer->data = malloc(nelements*format/8)))
          return;
        memcpy(wanderer->data,data,nelements*format/8);
        wanderer->format = format;
        wanderer->type = type;
        wanderer->num_items = nelements;
        break;
    }
  }
}

NT_del_prop_list(prop_list)
struct NT_prop_list *prop_list;
{
  struct NT_prop_list *next_prop_list;
  while(prop_list)
  {
    next_prop_list = prop_list->next;
    free (prop_list->data);
    free (prop_list);
    prop_list = next_prop_list;
  }
}

int XGetWindowProperty(display,window,property,long_offset,long_length,delete,
                   req_type,actual_type_return,actual_format_return,
                   nitems_return,bytes_after_return,prop_return)
Display *display;
Window window;
Atom property;
long long_offset;
long long_length;
Bool delete;
Atom req_type;
Atom *actual_type_return;
int *actual_format_return;
unsigned long *nitems_return;
unsigned long *bytes_after_return;
unsigned char **prop_return;
{
  struct NT_prop_list *wanderer;
  wanderer = window->props;
  while(wanderer)
  {
    if (wanderer->atom == property)
      break;
    wanderer = wanderer->next;
  }
  *prop_return = NULL;
  *nitems_return = 0;
  if (!wanderer)
    return 1;

  *actual_format_return = wanderer->format;
  *actual_type_return = wanderer->type;
  if (wanderer->type == req_type)
  {
    if((*prop_return = malloc(wanderer->format*wanderer->num_items/8)))
    {
      memcpy(*prop_return,wanderer->data,wanderer->format*wanderer->num_items/8);
      *nitems_return = wanderer->num_items;
      return Success;
    }
  }
  return 1;
}



char **XListExtensions(display,ret_num)
Display *display;
int *ret_num;
{
  *ret_num = 0;
  return NULL;
}

XFreeExtensionList(list)
char **list;
{
}

static FILE *pro_out = NULL;

#include <varargs.h>

int cjh_printf(fmt,va_alist)
char *fmt;
va_dcl
{
  int ret;
  va_list ap;
  va_start(ap);
  pro_out = fopen("std.out",pro_out?"a":"w");
  ret = vfprintf(pro_out,fmt,ap);
  fclose(pro_out);
  va_end(ap);
  return ret;
}

#endif




