/************************************************************************\
* The enclosed files, "the software," is provided by 
* Microsoft Corporation "as is" without warranty of any kind. 
* MICROSOFT DISCLAIMS ALL WARRANTIES, EITHER EXPRESS OR IMPLIED, 
* INCLUDING BUT NOT LIMITED TO IMPLIED WARRANTIES OF MERCHANTABILITY 
* AND FITNESS FOR A PARTICULAR PURPOSE.  You assume all risks of 
* using the software.
* 
* The software is Copyright (c) 1992 Microsoft Corporation.
* Original Author: John M. Hall, Microsoft SDE  9/1/92
*
* You are granted the right to freely distribute this software.
* You are granted the right to make changes provided this comment block
* is retained without modification and you acknowledge the changes.
* 
\************************************************************************/
/************************************************************************\
*
*  PROGRAM:     SHRTEST.C
*
*  PURPOSE:     Provide a simple test routine for Shrmem.dll
*
\************************************************************************/

#include <windows.h>
#include "shrmem.h"
#include "shrtest.h"
#include "ctype.h"
#include <stdio.h>



HANDLE hInst;
int iHandles = -1;
#define MAX_HANDLE 8
#define STR_SIZE  40
DWORD   dwHandle[MAX_HANDLE];
LPVOID  lpv[MAX_HANDLE];

HANDLE hDlg;

int index   = 0;
int address = 0;
DWORD result  = 0;
char chName[STR_SIZE];
BOOL bNotInChange = TRUE;

VOID UpdateControls()
{
    char chBuffer[STR_SIZE];
    BOOL bInChangeFlag = bNotInChange;

    bNotInChange = FALSE; // I don't want these changes getting progagated.

    SetDlgItemInt( hDlg, IDD_HANDLE_INDEX, index, FALSE);

    sprintf( chBuffer, "%#10x", dwHandle[index]);
    SetDlgItemText( hDlg, IDD_HANDLE_VALUE, chBuffer);

    SetDlgItemText( hDlg, IDD_HANDLE_NAME, chName);

    sprintf( chBuffer, "%#10x", address);
    SetDlgItemText( hDlg, IDD_ADDRESS, chBuffer);

    sprintf( chBuffer, "%#10x", result);
    SetDlgItemText( hDlg, IDD_RESULT, chBuffer);

    bNotInChange = bInChangeFlag;

}



VOID GetNewValues(WORD wID)
    {
    char chBuffer[STR_SIZE];
    BOOL bSucceed;
    int  iValue;
    int  ii;
    char ch;

    switch (wID)
        {
        case IDD_HANDLE_INDEX:
            iValue = GetDlgItemInt( hDlg, IDD_HANDLE_INDEX, &bSucceed, FALSE);
            if (bSucceed)
                {
                index = iValue;
                result = 0;
                UpdateControls();
                }
            break;
        case IDD_HANDLE_NAME:
            GetDlgItemText(hDlg, IDD_HANDLE_NAME, chName, STR_SIZE);
            break;

        case IDD_ADDRESS:

            result = 0;
            GetDlgItemText(hDlg, IDD_ADDRESS, chBuffer, STR_SIZE);
            ii = 0;
            while (chBuffer[ii] && isspace(chBuffer[ii]) && ii < STR_SIZE)
                {
                ii++;
                }

            if (chBuffer[ii] == '0' && tolower(chBuffer[ii+1]) == 'x')
                ii += 2;

            if (ch == 0x00)
                return;
            iValue = 0;
            while (chBuffer[ii] && isxdigit(chBuffer[ii]))
                {
                iValue *= 16;
                ch = chBuffer[ii];
                if (ch >= '0' && ch <= '9')
                    iValue += ch - '0';
                else
                    {
                    ch |= 0x20;  // lower case letters
                    if (ch >= 'a' && ch <= 'f')
                        iValue += ch - 'a' + 10;
                    else
                        iValue = 0;
                    }
                ii++;
                }
            address = iValue;
            sprintf( chBuffer, "%#10x", address);
            SetDlgItemText( hDlg, IDD_ADDRESS, chBuffer);
            break;

        default:
            break;
        
        }
    UNREFERENCED_PARAMETER(wID);
}



LONG APIENTRY CmdProc (HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
    switch (message)
        {
        case WM_INITDIALOG:
            hDlg = hwnd;
            chName[0] = 0x00;
            UpdateControls();

            return(FALSE);  // Continue with any init processing
            break;

        case WM_COMMAND:
            switch (LOWORD(wParam))
                {
                case IDOK:
                    EndDialog(hwnd, TRUE);
                    return(TRUE);

                case IDD_ALLOC:
                    result = ShrAlloc(2000, 0);
                    dwHandle[index] = result;
                    UpdateControls();
                    return(TRUE);

                case IDD_LOCK:
                    result = (DWORD) ShrLock(dwHandle[index]);
                    address = result;
                    UpdateControls();
                    return(TRUE);

                case IDD_UNLOCK:
                    result = ShrUnlock(dwHandle[index]);
                    UpdateControls();
                    return(TRUE);

                case IDD_FREE:
                    result = ShrFree(dwHandle[index]);
                    dwHandle[index] = result;
                    UpdateControls();
                    return(TRUE);

                case IDD_NAME:
                    result = ShrName(dwHandle[index], chName);
                    UpdateControls();
                    return(TRUE);

                case IDD_GET:
                    result = ShrGet(chName);
                    dwHandle[index] = result;
                    UpdateControls();
                    return(TRUE);

                case IDD_READ:
                    {
                    BOOL b = TRUE;
                    DWORD dw;
                    LPDWORD lpdw = (LPDWORD) address;

                    try
                        {
                        dw = *lpdw;
                        }
                    except (EXCEPTION_EXECUTE_HANDLER)
                        {
                        b = FALSE;
                        }
                    result = b;
                    UpdateControls();
                    return(TRUE);
                    }

                case IDD_WRITE:
                    {
                    BOOL b = TRUE;
                    LPDWORD lpdw = (LPDWORD) address;

                    try
                        {
                        *lpdw = 10;
                        }
                    except (EXCEPTION_EXECUTE_HANDLER)
                        {
                        b = FALSE;
                        }
                    result = b;
                    UpdateControls();
                    return(TRUE);
                    }

                case IDD_HANDLE_INDEX:
                case IDD_HANDLE_VALUE:
                case IDD_HANDLE_NAME:
                case IDD_ADDRESS:
                case IDD_RESULT:
                    if (HIWORD(wParam) == EN_KILLFOCUS && bNotInChange)
                        {
                        bNotInChange = FALSE;
                        GetNewValues(LOWORD(wParam));
                        bNotInChange = TRUE;
                        return(TRUE);
                        }
                    else
                        return(FALSE);
                default:
                    return(FALSE);
                }
            default:
                return(FALSE);
        }
}

/************************************************************************\
*
*  FUNCTION:    WinMain (standard WinMain INPUTS/RETURNS)
*
\************************************************************************/

int APIENTRY WinMain (HANDLE hInstance,HANDLE hPrevInstance,
                      LPSTR lpCmdLine, int nCmdShow)
{
    int ii;

    for (ii = 0; ii < MAX_HANDLE ; ii++)
        {
        dwHandle[ii] = 0;
        lpv[ii]      = 0;
        }

  DialogBox( hInstance, MAKEINTRESOURCE(IDD_CMDS), NULL, (DLGPROC) CmdProc);

  UNREFERENCED_PARAMETER(lpCmdLine);
  UNREFERENCED_PARAMETER(nCmdShow);
  UNREFERENCED_PARAMETER(hPrevInstance);
  return(0);
}



