@echo Microsoft RPC version 1.0 Preliminary---Update 1
@echo Copyright Microsoft Corp. 1992, All Rights Reserved
@echo Filename: RPCUPD01.BAT
@echo Purpose:  Template batch file that demonstrates
@echo           update file destination directories
@echo           for a sample configuration. Edit this
@echo           batch file for your configuration.
@echo           This file assumes that you have previously 
@echo           installed the complete preliminary release of
@echo           Microsoft RPC version 1.0 and that you have 
@echo           already downloaded the RPC update file
@echo           RPCUPD01.ZIP.
@echo           For more information about this update,
@echo           see PACKING.LST and README.TXT.
if "%1"=="" goto usage
@echo **********
@echo Edit these to match your configuration.
set WIN_DIR=c:\windows
set C7_DIR=c:\c700
set LM_DIR=c:\lanman.dos
set NT_DIR=c:\winnt
@echo **********
@echo Download RPC update file RPCUPD01.ZIP from CompuServe
@echo Then unzip the files: pkunzip -d RPCUPD01.ZIP
@echo The unzip operation creates the directory structure:
@echo     \dos
@echo     \win
@echo     \i386
@echo     \mips
@echo This template batch file assumes that you run it from
@echo this directory.

if "%1"=="MIPS" goto MIPS
if "%1"=="DOS" goto DOS
if "%1"=="WIN" goto WIN
if "%1"=="I386" goto I386
goto usage

:DOS
@echo ********************MS-DOS***************************
ren  %C7_DIR%\LIB\RPC.LIB *.OLD
copy DOS\RPC.LIB       %C7_DIR%\LIB
ren  %LM_DIR%\NETPROG\RPCLTC3.RPC *.OLD
copy DOS\RPCLTC3.RPC   %LM_DIR%\NETPROG
ren  %LM_DIR%\NETPROG\RPCLTC4.RPC *.OLD
copy DOS\RPCLTC4.RPC   %LM_DIR%\NETPROG
ren  %C7_DIR%\LIB\RPCNDR.LIB *.OLD
copy DOS\RPCNDR.LIB    %C7_DIR%\LIB
ren  %C7_DIR%\RPC\README.TXT *.OLD
copy README.TXT        %C7_DIR%\RPC
@echo Relink all MS-DOS .exe files with these new libraries
goto end

:WIN
@echo **************Microsoft Windows 3.x********************
@if .%windir%==. goto no_win
@echo Exit Microsoft Windows before trying to update
goto end
:no_win
ren  %WIN_DIR%\system\RPCLTC3.DLL *.OLD
copy WIN\RPCLTC3.DLL   %WIN_DIR%\system
ren  %WIN_DIR%\system\RPCLTC4.DLL *.OLD
copy WIN\RPCLTC4.DLL   %WIN_DIR%\system
ren  %C7_DIR%\lib\RPCNDRW.LIB *.OLD
copy WIN\RPCNDRW.LIB	%C7_DIR%\lib
ren  %WIN_DIR%\system\RPCNS1.DLL *.OLD
copy WIN\RPCNS1.DLL    %WIN_DIR%\system 
ren  %WIN_DIR%\system\RPCRT1.DLL *.OLD
copy WIN\RPCRT1.DLL    %WIN_DIR%\system
ren  %C7_DIR%\RPC\README.TXT *.OLD
copy README.TXT        %C7_DIR%\rpc
@echo Restart Windows
goto end

:I386
@echo ********************NT i386**************************
@echo Copy the new files into place
ren  %NT_DIR%\system\LOCATOR.EXE *.OLD
copy I386\LOCATOR.EXE  %NT_DIR%\system
ren  %NT_DIR%\system\RPCLTC3.DLL *.OLD
copy I386\RPCLTC3.DLL  %NT_DIR%\system
ren  %NT_DIR%\system\RPCLTS1.DLL *.OLD
copy I386\RPCLTS1.DLL  %NT_DIR%\system
ren  %NT_DIR%\system\RPCLTS3.DLL *.OLD
copy I386\RPCLTS3.DLL  %NT_DIR%\system
ren  %NT_DIR%\system\RPCRT4.DLL *.OLD
copy I386\RPCRT4.DLL   %NT_DIR%\system
ren  %NT_DIR%\system\RPCSS.EXE *.OLD
copy I386\RPCSS.EXE    %NT_DIR%\system
ren  %NT_DIR%\system\README.RPC *.OLD
copy README.TXT        %NT_DIR%\system\README.RPC
@echo Restart Windows NT to run the new DLLs
goto end

REM  The instructions for MIPS and i386 are similar.
:MIPS
@echo ********************NT MIPS**************************
@echo Copy the new files into place
ren  %NT_DIR%\system\LOCATOR.EXE *.OLD
copy MIPS\LOCATOR.EXE  %NT_DIR%\system
ren  %NT_DIR%\system\RPCLTC3.DLL *.OLD
copy MIPS\RPCLTC3.DLL  %NT_DIR%\system
ren  %NT_DIR%\system\RPCLTS1.DLL *.OLD
copy MIPS\RPCLTS1.DLL  %NT_DIR%\system
ren  %NT_DIR%\system\RPCLTS3.DLL *.OLD
copy MIPS\RPCLTS3.DLL  %NT_DIR%\system
ren  %NT_DIR%\system\RPCRT4.DLL *.OLD
copy MIPS\RPCRT4.DLL   %NT_DIR%\system
ren  %NT_DIR%\system\RPCSS.EXE *.OLD
copy MIPS\RPCSS.EXE    %NT_DIR%\system
ren  %NT_DIR%\system\README.RPC *.OLD
copy README.TXT        %NT_DIR%\system\README.RPC
@echo Restart Windows NT to run the new DLLs
goto end

:usage
@echo Usage:  rpcupd01 platform
@echo where platform = { DOS, WIN, I386, MIPS }
@echo Example:  rpcupd01 I386

:end

set WIN_DIR=
set C7_DIR=
set LM_DIR=
set NT_DIR=
