// Wkd driver for Port I/O.  Adapted from the ADLib driver.
// Robert R. Howell   January 8, 1992
// This file contains the main routines which actually open the driver, and execute
// the IOCTL requests by performing input and output.

#include "wkd.h"

NTSTATUS	wkdDispatch(	IN    PDEVICE_OBJECT pDO,
							IN    PIRP pIrp				)

// Arguments:		pDO - Pointer to device object
//					pIrp - Pointer to IO request packet

// Return Value:	Return status from dispatched routine

{
    PLOCAL_DEVICE_INFO pLDI;
    PIO_STACK_LOCATION pIrpStack;
    NTSTATUS Status;

    pIrp->IoStatus.Information = 0;						// Initialize the irp info field.
    pLDI = (PLOCAL_DEVICE_INFO)pDO->DeviceExtension;	// Get local info structure

    pIrpStack = IoGetCurrentIrpStackLocation(pIrp);     // Dispatch based on major fcn code.
    switch (pIrpStack->MajorFunction)
    	{
    	case IRP_MJ_CREATE:

			{
//			For now, I'll just accept the default access permissions.  The following code
//          may be necessary if more than one application wants to open the driver, or
//          if the device is opened with access permissions different than that used
//          in the sample applications.

//			This commented-out code is from the ADLIB driver.

//			SHARE_ACCESS ShareAccess;
//			IoSetShareAccess(pIrpStack->Parameters.Create.SecurityContext->DesiredAccess,
//  				      (ULONG)pIrpStack->Parameters.Create.ShareAccess,
//  				             pIrpStack->FileObject,
//				             &ShareAccess);
			}
//			if (pIrpStack->Parameters.Create.SecurityContext->DesiredAccess & FILE_READ_DATA &&
//			    pIrpStack->Parameters.Create.SecurityContext->DesiredAccess & FILE_WRITE_DATA
//			   )
				Status = STATUS_SUCCESS;
//			else
//				Status = STATUS_ACCESS_DENIED;
//			break;

    	case IRP_MJ_CLOSE:

			// The ADLIB driver checks some access codes here.  For now, I'll allow the
			// close under all conditions.
			Status = STATUS_SUCCESS;
	        break;

    	case IRP_MJ_DEVICE_CONTROL:
			if (pLDI->DeviceType != WKD_TYPE)		// Be sure command is for Wkd device.
				{
				Status = STATUS_NOT_IMPLEMENTED;    // ???? Not sure of right error status.
				break;
				}
		    switch (pIrpStack->Parameters.DeviceIoControl.IoControlCode)  // Which IOCTL code?
    			{
				case IOCTL_WKD_READ_PORT:
					Status = wkdIoctlReadPort( pLDI, pIrp, pIrpStack);
					break;
                case IOCTL_WKD_WRITE_PORT:
					Status = wkdIoctlWritePort(pLDI, pIrp, pIrpStack);
					break;
                default:
					Status = STATUS_NOT_IMPLEMENTED;
					break;
				}
            break;

		default:
			Status = STATUS_NOT_IMPLEMENTED;
			break;
		}

    												// We're done with I/O request.
	pIrp->IoStatus.Status = Status;                	// Record the status of the I/O action.

	IoCompleteRequest(pIrp, IO_NO_INCREMENT );     	// Don't boost priority when returning,
	                                               	// because this (supposedly) took little.
	                                               	// time.  I may change this, but don't
	                                               	// know the values to use.
    return Status;
}

/***************************** ioctl ***************************************/
NTSTATUS	wkdIoctlReadPort(	IN OUT PLOCAL_DEVICE_INFO pLDI,
								IN     PIRP pIrp,
								IN     PIO_STACK_LOCATION IrpStack  )

// Arguments:	pLDI		- our local device data
//				pIrp		- IO request packet
//				IrpStack	- The current stack location

//	Return Value:	STATUS_SUCCESS       - OK
//					STATUS_DEVICE_BUSY   - Device in use
//					STATUS_NOT_SUPPORTED - wrong device

{
								// NOTE:  Use METHOD_BUFFERED ioctls.
	PBYTE pIOBuffer  ;			// Pointer to transfer buffer.
	PULONG pIOB;                // PULong pointer for above buffer.
    ULONG InBufferSize ;		// Amount of data avail. from caller.
    ULONG OutBufferSize ;       // Max data that caller can accept.
	ULONG nPort;				// Port number to read
    NTSTATUS Status;

	InBufferSize  = IrpStack->Parameters.DeviceIoControl.InputBufferLength;  // From application.
    OutBufferSize = IrpStack->Parameters.DeviceIoControl.OutputBufferLength; // To   application.

	pIOBuffer     = pIrp->AssociatedIrp.SystemBuffer;  // NT copies inbuf here before entry
	                                                   // and copies this to outbuf after return,
	                                                   // for METHOD_BUFFERED IOCTL's.


	if (    InBufferSize  < sizeof(ULONG) 	// Does the input buffer hold a port number
         || OutBufferSize < sizeof(ULONG) ) //  and is there room to return the data?
		{									// Both are sent as ULONGS, but only the low byte
											// of the data is used.
		Status = STATUS_BUFFER_TOO_SMALL;
		pIrp->IoStatus.Information = 0;		// We won't be returning any data.
		}
	else									// Buffers are big enough.
		{
		pIOB = (PULONG)pIOBuffer;               // Get the I/O port number from the buffer.
        nPort = *pIOB;
		if (nPort < 0 || nPort >= NUMBER_PORTS)	// Is this a legal port value?
			{
			Status = STATUS_ACCESS_VIOLATION;	// It was not legal.
			pIrp->IoStatus.Information = 0;     // No data is returned after failure.
			}
		else		                            // Port number is OK.
			{
			pIrp->IoStatus.Information = sizeof(ULONG);     // Number of bytes to return.
		    *pIOB = READ_PORT_UCHAR( (PUCHAR)(pLDI->PortBase + nPort) );  // Read the port.
			Status = STATUS_SUCCESS;
			}
		}
    return Status;
}

/***************************** ioctl ***************************************/
NTSTATUS	wkdIoctlWritePort(	IN OUT PLOCAL_DEVICE_INFO pLDI,
								IN     PIRP pIrp,
								IN     PIO_STACK_LOCATION IrpStack  )


// Arguments:	pLDI		- our local device data
//				pIrp		- IO request packet
//				IrpStack	- The current stack location

//	Return Value:	STATUS_SUCCESS       - OK
//					STATUS_DEVICE_BUSY   - Device in use
//					STATUS_NOT_SUPPORTED - wrong device

{
								// NOTE:  Use METHOD_BUFFERED ioctls.
	PBYTE pIOBuffer  ;			// Pointer to transfer buffer.
	PULONG pIOB;                //   alias for above.
    ULONG InBufferSize ;		// Amount of data avail. from caller.
    ULONG OutBufferSize ;       // Max data that caller can accept.
	ULONG nPort;				// Port number to read or write.
    UCHAR Data;                 // Data to write.
    NTSTATUS Status;

	InBufferSize  = IrpStack->Parameters.DeviceIoControl.InputBufferLength;	 // From application.
    OutBufferSize = IrpStack->Parameters.DeviceIoControl.OutputBufferLength; // To   application.

	pIOBuffer     = pIrp->AssociatedIrp.SystemBuffer;  // NT copies inbuf here before entry
	                                                   // and copies this to outbuf after return,
	                                                   // for METHOD_BUFFERED IOCTL's.

	if ( InBufferSize < 2 * sizeof(ULONG) )	// Does the input buffer hold a port and data?
		{									// Both are sent as ULONGS, athough only low byte
											// of the data is used.
		Status = STATUS_BUFFER_TOO_SMALL;
		pIrp->IoStatus.Information = 0;		// We won't be returning any data after failure.
		}
	else									// Port & data ARE present in buffer.
		{
		pIOB = (PULONG)pIOBuffer;			// Get them.
        nPort =          *(pIOB  ) ;
		Data  = (UCHAR) (*(pIOB+1));
		if (nPort < 0 || nPort >= NUMBER_PORTS)	// Is this a legal port number?
			{
			Status = STATUS_ACCESS_VIOLATION;	// Illegal port number
			pIrp->IoStatus.Information = 0;     // so we won't return any data.
			}
		else									// Finally ready to write to the port.
			{
			pIrp->IoStatus.Information = 0;  	// Write never returns any data.
	        WRITE_PORT_UCHAR(	(PUCHAR)(pLDI->PortBase + nPort),
	        					(UCHAR) (Data)						);  // Write to the port.
		    Status = STATUS_SUCCESS;
			}
		}
    return Status;
}
