/***************************************************************************
    Driver unload routine for WKD driver.  Based upon the ADLIB driver from the DDK.
    Robert R. Howell    January 7, 1993
    The unload functions do not seem to be working yet, but that does not
    keep the driver from working.
***************************************************************************/

#include "wkd.h"

VOID wkdUnload(PDRIVER_OBJECT pDriverObject)
{
    PLOCAL_DEVICE_INFO pLDI;
    CM_RESOURCE_LIST NullResourceList;
    BOOLEAN ResourceConflict;

    // Find our global data
    pLDI = (PLOCAL_DEVICE_INFO)pDriverObject->DeviceObject->DeviceExtension;

    // Report we're not using any hardware.  If we don't do this
    // then we'll conflict with ourselves (!) on the next load
    NullResourceList.Count = 0;    // For reporting failure

    IoReportResourceUsage(NULL,					// In the current version I never registered
                          pDriverObject,		// the useage, so is probably not necessary.
                          &NullResourceList,
                          sizeof(ULONG),
                          pLDI->pWkdDevObj,
                          NULL,
                          0,
                          FALSE,
                          &ResourceConflict);

    // NOTE:  The WKD driver is simple enough that most of the following comments
    //        from the ADLIB driver no longer apply.

    // Assume all handles are closed down.
    // Delete the things we allocated - devices, Interrupt objects,
    // adapter objects.  The driver object has a chain of devices across it.

    if (pLDI->SymbolicLink)					// Release the link to the file system name.
        ZwClose(pLDI->SymbolicLink);

    IoDeleteDevice(pLDI->pWkdDevObj);		// Delete the device object.
}
