// WKD.H    Include file for Wyoming Infrared Camera Kludge Interface Driver (WICKID)
// Robert R. Howell   January 6, 1993

#include <ntddk.h>
#include <string.h>
#include <windef.h>

/* Default base port, and # of ports */
#define BASE_PORT		0x300
#define NUMBER_PORTS        4


// Device type           -- in the "User Defined" range."
#define WKD_TYPE 40000

// NT device name
#define WKD_DEVICE_NAME L"\\Device\\Wkd0"

// File system device name.   When you execute a CreateFile call to open the device, use
//  "\\.\WkdDev", or, given C's conversion of \\ to \, use "\\\\.\\WkdDev"
#define DOS_DEVICE_NAME L"\\DosDevices\\WkdDev"


// Define the IOCTL codes we will use.  The IOCTL code contains a command identifier, plus
// other information about the device, the type of access, and the type of buffering.

// Because I have access to the \ddk\public\sdk\inc\devioctl.h file I just keep these in
// symbolic form.  If I gave the drivers to someone who didn't have this files, I would have
// to give them numerical versions of these constants.  Are the macro's EVER likely to change?
// There is a statement in one of the documentation books about registering "public" IOCTL
// codes with Microsoft.  However, the include file says that the IOCTL codes
// from 0x800 to 0xFFF are for customer use.

#define IOCTL_WKD_READ_PORT \
	CTL_CODE( WKD_TYPE, 0x900, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_WKD_WRITE_PORT \
	CTL_CODE(WKD_TYPE,  0x901, METHOD_BUFFERED, FILE_WRITE_ACCESS)

// driver local data structure specific to each device object
typedef struct _LOCAL_DEVICE_INFO {
    ULONG           DeviceType;         // in or out
    ULONG           PortBase;           // base port address
    PDEVICE_OBJECT  pWkdDevObj;     	// The wkd device object.
    HANDLE          SymbolicLink;       // Link from NT Driver to the File system name
} LOCAL_DEVICE_INFO, *PLOCAL_DEVICE_INFO;


/********************* function prototypes ***********************************/
NTSTATUS	DriverEntry(		IN   PDRIVER_OBJECT pDriverObject,		// In wkdinit.c
    							IN   PUNICODE_STRING RegistryPath		);

NTSTATUS	wkdCreateDevice(	IN   PWSTR szPrototypeName,             // In wkdinit.c
								IN   DEVICE_TYPE DeviceType,
								IN   PDRIVER_OBJECT pDriverObject,
								OUT  PDEVICE_OBJECT *ppDevObj		);

NTSTATUS	wkdCreate(			IN OUT PLOCAL_DEVICE_INFO pLDI		);	// In wkdinit.c


NTSTATUS	wkdDispatch(		IN    PDEVICE_OBJECT pDO,         		// In dispatch.c
								IN    PIRP pIrp						);

VOID 		wkdUnload(			IN	  PDRIVER_OBJECT pDriverObject  );	// In wkdinit.c

NTSTATUS	wkdIoctlReadPort(	IN OUT PLOCAL_DEVICE_INFO pLDI,
								IN     PIRP pIrp,
								IN     PIO_STACK_LOCATION IrpStack  );

NTSTATUS	wkdIoctlWritePort(	IN OUT PLOCAL_DEVICE_INFO pLDI,
								IN     PIRP pIrp,
								IN     PIO_STACK_LOCATION IrpStack  );
