// WKD Port Io driver for NT  VERSION 0.9
// Adapted from NT DDK  ADLIB:  drvrinit.c file
//
// Robert R. Howell  January 8, 1993

//	This module contains code for the initialization phase of the WKD Port device driver.
//	I've also added code to make it unloadable, but this may not be working yet.

#include "wkd.h"
#include "stdlib.h"

//#define SBCONFIG    // Register driver & objects if this symbol is defined.
                      // Registering the driver does not seem to be critical to making the
                      //   driver function.  The code within the IFDEF is not compiled
                      //   and has not been tested.

NTSTATUS	DriverEntry(	IN PDRIVER_OBJECT  pDriverObject,
							IN PUNICODE_STRING RegistryPath		)

{
    ULONG PortBase;            		// Port location, in NT's address form.

	PLOCAL_DEVICE_INFO pLocalInfo;  // Device extension:  local information for each device.
	NTSTATUS Status;
	PDEVICE_OBJECT pWkdDevObj;
	HANDLE SymbolicLink;			// Link between internal device name and file system name.
	CM_RESOURCE_LIST ResBuffer;		// Resource list to report back to the system
	BOOLEAN ResourceConflict;
	PCM_RESOURCE_LIST ResourceList;
	ResourceList = (PCM_RESOURCE_LIST)&ResBuffer;

		// Convert the IO port address into a form NT likes.
		{
        ULONG MemType;
		PHYSICAL_ADDRESS PortAddress;
		PHYSICAL_ADDRESS MappedAddress;
		PortBase = BASE_PORT;				// I/O port address, defined in include file
		MemType = 1;               			// located in IO space
		PortAddress.LowPart  = PortBase;
		PortAddress.HighPart = 0;
		HalTranslateBusAddress(	Isa,
								0,
								PortAddress,
								&MemType,
								&MappedAddress );
		if (MemType == 0)
			// Map 1 byte of IO space into a non-cached address space
			PortBase = (ULONG)MmMapIoSpace(	MappedAddress,
											NUMBER_PORTS,
											FALSE			);
		else
			PortBase = (ULONG)MappedAddress.LowPart;
		}

	// Initialize the driver object dispatch table.  NT sends requests to these routines.
    pDriverObject->MajorFunction[IRP_MJ_CREATE]         = wkdDispatch;
	pDriverObject->MajorFunction[IRP_MJ_CLOSE]          = wkdDispatch;
	pDriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL] = wkdDispatch;
	pDriverObject->DriverUnload 						= wkdUnload;

    // Create our device.
    Status = wkdCreateDevice(	WKD_DEVICE_NAME,
								WKD_TYPE,
								pDriverObject,
								&pWkdDevObj			);
	if (!NT_SUCCESS(Status)) return Status;

    // Initialize the local driver info for each device object.
	pLocalInfo = (PLOCAL_DEVICE_INFO)pWkdDevObj->DeviceExtension;

    pLocalInfo->pWkdDevObj = pWkdDevObj;
    pLocalInfo->DeviceType = WKD_TYPE;
    pLocalInfo->PortBase   = PortBase;

// The part of the code within the IFDEF is not compiled and has not been tested.
// It enters some registry information, which apparently isn't critical to the
// device function.
#ifdef SBCONFIG
    // Initalize our resource list
    RtlZeroMemory((PVOID)&ResBuffer, sizeof(ResBuffer));
    ResourceList->Count = 1;
    ResourceList->List[0].InterfaceType = Isa;
    // ResourceList->List[0].Busnumber = 0;             Already 0
    ResourceList->List[0].PartialResourceList.Count = 1;
    ResourceList->List[0].PartialResourceList.PartialDescriptors[0].Type =
                                               CmResourceTypePort;
    ResourceList->List[0].PartialResourceList.PartialDescriptors[0].ShareDisposition =
                                               CmResourceShareDriverExclusive;
    ResourceList->List[0].PartialResourceList.PartialDescriptors[0].u.Port.Start.LowPart =
                                               BASE_PORT;
    ResourceList->List[0].PartialResourceList.PartialDescriptors[0].u.Port.Length =
                                               NUMBER_PORTS;

    // Report our resource usage and detect conflicts
    Status = IoReportResourceUsage(NULL,
                                   pDriverObject,
                                   ResourceList,
                                   sizeof(ResBuffer),
                                   pLocalInfo->pWkdDevObj,
                                   NULL,
                                   0,
                                   FALSE,
                                   &ResourceConflict);

    if (ResourceConflict)
    	Status = STATUS_DEVICE_CONFIGURATION_ERROR;

    if (!NT_SUCCESS(Status))
    	{
        dprintf1("Resource reporting problem %8X", Status);
        ZwClose(pLocalInfo->SymbolicLink);
        IoDeleteDevice(pLocalInfo->pWkdDevObj);
        return Status;
        }
#endif // SBCONFIG

    return STATUS_SUCCESS;
}

/***********************************************************************************/
//    Create a new device.  Ideally I should use a name derived from the "Prototype", with
//    a number appended at the end.  An example of the string concatenation can be found
//    in the ADLIB driver, but it is complicated.
//    For simplicity I'll just use the fixed name defined in the include file.
//    This means that only one device can be created.

NTSTATUS
wkdCreateDevice(
    IN   PWSTR				PrototypeName,	// Name base, # WOULD be appended to this.
    IN   DEVICE_TYPE 		DeviceType,		// Type of device to create
    IN   PDRIVER_OBJECT 	pDriverObject,	// Driver that is calling this routine
    OUT  PDEVICE_OBJECT 	*ppDevObj		// Pointer to device obj pointer created.
	)

{
    NTSTATUS Status;						// Status of utility calls
    UNICODE_STRING DeviceName;

    RtlInitUnicodeString(&DeviceName, WKD_DEVICE_NAME);  // Get UNICODE name for device.

	Status = IoCreateDevice(							 // Create it.
				pDriverObject,
				sizeof(LOCAL_DEVICE_INFO),
				&DeviceName,
				DeviceType,
				0,
				FALSE,                      // Not Exclusive
				ppDevObj
				);

	if (!NT_SUCCESS(Status)) return Status;				// Give up if create failed.

	// Clear local device info memory
	RtlZeroMemory((*ppDevObj)->DeviceExtension, sizeof(LOCAL_DEVICE_INFO));

	// Set up the rest of the device info
	(*ppDevObj)->Flags |= DO_BUFFERED_IO;
	(*ppDevObj)->AlignmentRequirement = FILE_BYTE_ALIGNMENT;

	// Try to create a symbolic link object for this device
    // This link makes the device visible to the NT file system.
	((PLOCAL_DEVICE_INFO)(*ppDevObj)->DeviceExtension)->SymbolicLink = NULL;

		{
		OBJECT_ATTRIBUTES LinkAttributes;
		UNICODE_STRING LinkObject;
		HANDLE LinkHandle;

		RtlInitUnicodeString(&LinkObject, DOS_DEVICE_NAME);

		InitializeObjectAttributes(	&LinkAttributes,
									&LinkObject,
									OBJ_CASE_INSENSITIVE,
									NULL,
									NULL                   );

		Status = ZwCreateSymbolicLinkObject(	&LinkHandle,
												SYMBOLIC_LINK_ALL_ACCESS,
												&LinkAttributes,
												&DeviceName                );
		if (!NT_SUCCESS(Status))  		// If we we couldn't create the link then
			{                           //  the device isn't useful.  Abort installation.
			IoDeleteDevice(*ppDevObj);
			return Status;
			}

        // Store the link information.  We'll need it on close.
		((PLOCAL_DEVICE_INFO)(*ppDevObj)->DeviceExtension)->SymbolicLink = LinkHandle;
		}
		return STATUS_SUCCESS;
}
