// Read a byte from a port using the wkd driver.
// Robert R. Howell   January 6, 1993

// The variables to do both reads and writes are allocated, and the device
// is opened for both types of access. However, only the read IOCTL is called.
// If you do not need to do any writes, then you can shorted ibuf[2] to ibuf[1]
// and can drop the "WRITE" access in the CreateFile call.


#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "wkdtst.h"		// This defines the IOCTL constants.

void main(int argc, char * argv[])
{

	// The following is returned by IOCTL.  It is true if the read succeeds.
	BOOL	irslt;

	// The following parameters are used in the IOCTL call
    HANDLE hndFile;			// Handle to device, obtain from CreateFile
	ULONG	inbuf [2];		// Buffer sent to the driver.
	ULONG	outbuf[1];		// Buffer received from driver.
	DWORD 	nout;			// Number of bytes returned

    // Note that the input and output buffers are ULONG's, which are 32 bits in WIN32.

    // The port address is placed in inbuf[0] before the IOCTL call.
    // It is given as 0, 1, 2, ... relative to the base address sent in wkd.h

    // The port data is returned in the low order byte of outbuf[0];

    if (argc < 2)
		{
		printf("\nWkdRead nport  reads data from a given IO port, using the WkdDev");
		printf("\n               device.  Ports are numbers as 0, 1, ... relative to");
		printf("\n               the base set in the driver.  The default driver");
		printf("\n               uses ports 300h through 303h");
		printf("\n               All numbers are read and printed in hex.");
		exit(1);
		}

    hndFile = CreateFile(	"\\\\.\\WkdDev",					// Open the Device "file"
    						GENERIC_READ    | GENERIC_WRITE,	// Only read is required here.
    						FILE_SHARE_READ | FILE_SHARE_WRITE,	// Only read is required here.
    						NULL,
    						OPEN_EXISTING,
    						0,
    						NULL			);

	if (hndFile == INVALID_HANDLE_VALUE)			// Was the device opened?
		{
		printf("\nUnable to open the device.");
		exit(1);
		}

	sscanf(argv[1], "%x", &inbuf[0]);				// Get the port number to be read

    irslt = DeviceIoControl(hndFile,				// Handle to device
    						IOCTL_WKD_READ_PORT,    // IO Control code for Read
							inbuf,					// Buffer to driver.     inbuf[0]  = port.
							4,						// Length of buffer in bytes.
							outbuf,					// Buffer from driver.   outbuf[0] = data.
							4,   					// Length of buffer in bytes.
							&nout,					// Bytes places in outbuf.  Should be 4.
							NULL                    // NULL means wait till op. completes.
						  );


	if (irslt)										// Did the IOCTL succeed?
		printf("Read from port %x returned %x", inbuf[0], outbuf[0]);
    else
		printf("\nIoctl failed with code %ld", GetLastError() );


	if (!CloseHandle(hndFile))                       // Close the Device "file".
		printf("\nFailed to close device.");
}
