// WKDTST is the include file for use with the test programs.
// Robert R. Howell
// January 6, 1992

// THIS FILE JUST DEFINES THE IOCTL CODES.

// I'VE DEFINED THEM HERE USING NUMERICAL CONSTANTS, CONSISTENT WITH THE VALUES CREATED IN
// THE DRIVERS USING THE CTL_CODE MACROS.

// THE VALUES DEPEND UPON THE DEVICE TYPE, COMMAND CODE, ACCESS CODES, AND BUFFER METHOD.

// IF YOU CHANGE ANY OF THOSE CONSTANTS THE NUMERICAL VALUES WILL CHANGE.
// YOU SHOULD FIND THE NEW CONSTANTS AND REPLACE THE FOLLOWING ONES.

// ALTERNATIVELY, YOU CAN CHANGE THE FOLLOWING "DEFINE" TO USE THE MACRO'S
// IN \DDK\public\sdk\inc\devioctl.h
// THAT HOWEVER, MEANS THAT ANYONE COMPILING THE application MUST HAVE ACCESS TO THE DDK
// INCLUDE FILE.


#define USECONSTANTS

#if defined (USECONSTANTS)

#define IOCTL_WKD_READ_PORT   0x9c406400
#define IOCTL_WKD_WRITE_PORT  0x9c40A404


#else

// Define the IOCTL codes we will use.  The IOCTL code contains a command identifier, plus
// other information about the device, the type of access, and the type of buffering.

// Because I have access to the \ddk\public\sdk\inc\devioctl.h file I just keep these in
// symbolic form.  If I gave the drivers to someone who didn't have this files, I would have
// to give them numerical versions of these constants.  Are the macro's EVER likely to change?
// There is a statement in one of the documentation books about registering "public" IOCTL
// codes with Microsoft.  However, the include file says that the IOCTL codes
// from 0x800 to 0xFFF are for customer use.


#include <\ddk\public\sdk\inc\devioctl.h>	// THIS PATH COULD CHANGE.

#define WKD_TYPE 40000		// This is a device number in the "User defined" range.

#define IOCTL_WKD_READ_PORT \
	CTL_CODE( WKD_TYPE, 0x900, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_WKD_WRITE_PORT \
	CTL_CODE(WKD_TYPE,  0x901, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#endif

