// Write a byte to an port using the wkd driver.
// Robert R. Howell   January 6, 1993

// The variables to do both reads and writes are allocated, and the device
// is opened for both types of access. However, only the write IOCTL is called.
// If you do not need to do any reads, then you can delete the allocation of outbuf
// and can drop the "READ" access in the CreateFile call.

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "wkdtst.h"		// This defines the IOCTL constants.

void main(int argc, char * argv[])
{

	// The following is returned by IOCTL.  It is true if the write succeeds.
	BOOL	irslt;

	// The following parameters are used in the IOCTL call
    HANDLE hndFile;			// Handle to device, obtain from CreateFile
	ULONG	inbuf [2];		// Buffer sent to the driver.
	ULONG	outbuf[1];		// Buffer sent from the driver.  Needed only for reads.
	DWORD 	nout;			// Number of bytes returned */

    // Note that the input and output buffers are ULONG's, which are 32 bits in WIN32.

    // The port address is placed in inbuf[0] and the byte to be output is placed
    // in the low order byte of inbuf [1] before the IOCTL call.
    // The address is given as 0, 1, 2, ... relative to the base address sent in wkd.h


    if (argc < 3)
		{
		printf("\nWkdWrite nport ndata  writes data to a given IO port, using ");
		printf("\n                      the WkdDev device.  Ports are numbers as");
		printf("\n                      0, 1, ... relative to the base set in the");
		printf("\n                      the driver.  The default driver uses ports");
		printf("\n                      uses ports 300h through 303h.");
		printf("\n                      All numbers are read in hex.");
		exit(1);
		}


	hndFile = CreateFile("\\\\.\\WkdDev",						// Open the Device "file"
    					 GENERIC_READ    | GENERIC_WRITE,		// Only write is required here.
    					 FILE_SHARE_READ | FILE_SHARE_WRITE,	// Only write is required here.
    					 NULL,
    					 OPEN_EXISTING,
    					 0,
    					 NULL			);

	if (hndFile == INVALID_HANDLE_VALUE)			// Was the device opened?
		{
		printf("\nUnable to open the device.");
		exit(1);
		}

	sscanf(argv[1], "%x", &inbuf[0]);				// Get the port number to be written
	sscanf(argv[2], "%x", &inbuf[1]);				// Get the data to be written.
	                                                //   Only the low order byte is used.

    irslt = DeviceIoControl(hndFile,				// Handle to device
    						IOCTL_WKD_WRITE_PORT,   // IO Control code for Write
							inbuf,					// Buffer to driver.  Holds port & data.
							8,						// Length of buffer in bytes.
							NULL,					// Buffer from driver.   Not used.
							0,   					// Length of buffer in bytes.
							&nout,					// Bytes places in outbuf.  Should be 0.
							NULL                    // NULL means wait till I/O completes.
						  );


	if (irslt)										// Did the IOCTL succeed?
		printf("Wrote to port %x the data %x", inbuf[0], inbuf[1]);
    else
		printf("\nIoctl failed with code %ld", GetLastError() );


	if (!CloseHandle(hndFile))                       // Close the Device "file".
		printf("\nFailed to close device.");

	outbuf;	// This statement just prevents the "unreferenced variable" warning.
}
