// WKDVDD  gives DOS applications access to the NS32000 device at addresses 300 - 303
// Robert R. Howell
// January 6, 1993
// Based on /DDK/PRIVATE/VDD/SAMPLES/SAMPLE2/VDD  in the NT DDK

#include <windows.h>
#include <vddsvc.h>		// VDD services header
#include <devioctl.h>
#include "wkdvdd.h"


/** Global variables **/
    HANDLE  hVDD;			// VDD module handle
    HANDLE  hndFile;		// Handle to WINNT "file" device driver
    BOOLEAN IOHook;         // True if we did install the I/O hook.

/********************************************************************************/
// Called when DLL is first started or when it is terminated.
// This occurs automatically, depending upon whether a DOS application is running.

BOOL	VddDllEntry(	HANDLE   hVdd,             // Handle to the VDD
    					DWORD    dwReason,         // Called for for Init or Close?
    					LPVOID   lpReserved  )     // Not used.

//   RETURNS:
//      on ATTACH call:    TRUE  if Initialization is successful
//                         FALSE if Initialization fails.
//
//      on other calls:    TRUE

{
    VDD_IO_PORTRANGE PortRange;
    VDD_IO_HANDLERS  IOHandlers;

    hVDD = hVdd;		// Save the VDD handle in global memory, for later use.

    switch ( dwReason )
    	{
		case DLL_PROCESS_ATTACH:


			// Perhaps I should call _CRT_INIT here.  See the notes in the CRTDLL.ZIP
			// file which Microsoft posted in the MSWIN32 forum.  I'm not sure if they
			// apply to VDD's.  The program does seem to work without this call.


            // Open the NT device which talks with the I/O ports.
		    hndFile = CreateFile(	"\\\\.\\WkdDev",
    								GENERIC_READ    | GENERIC_WRITE,
    								FILE_SHARE_READ | FILE_SHARE_WRITE,
    								NULL,
    								OPEN_EXISTING,
    								0,
    								NULL								);
			if (hndFile == INVALID_HANDLE_VALUE)
				return FALSE;

			// Have NT call MyInB and MyOutB on BYTE IN and BYTE OUT instructions.
			// NT should simulate the word and string I/O's by using BYTE I/O's.
			IOHandlers.inb_handler	= MyInB;
			IOHandlers.inw_handler	= NULL;
			IOHandlers.insb_handler	= NULL;
			IOHandlers.insw_handler	= NULL;
			IOHandlers.outb_handler	= MyOutB;
			IOHandlers.outw_handler	= NULL;
			IOHandlers.outsb_handler= NULL;
			IOHandlers.outsw_handler= NULL;
			PortRange.First 		= BASE_PORT;
			PortRange.Last			= BASE_PORT + NUMBER_PORTS - 1;

			IOHook = VDDInstallIOHook(hVDD, (WORD) 1, &PortRange, &IOHandlers);
			break;

    	case DLL_PROCESS_DETACH:

			if (IOHook)                                 // Release IO hook of ports.
	    		VDDDeInstallIOHook(hVDD, 1, &PortRange);

			if (hndFile != INVALID_HANDLE_VALUE)        // Close NT port IO device.
				CloseHandle(hndFile);

			break;

    	default:
        	break;
	    }

    return TRUE;
}


VOID	MyInB(	WORD Port, PBYTE Buffer )		// Called when an IN is executed.
                                                // Read port using IOCTL, put data in buffer.
{
	ULONG	inbuf [8];		// Buffer sent     to   IOCTL routine
	ULONG   outbuf[8];		// Buffer received from IOCLT routine
	DWORD 	nout;			// Number of bytes returned by IOCTL routine

	inbuf[0] = (ULONG) (Port - BASE_PORT);          // Relative port address.
	if (DeviceIoControl(	hndFile,				// Handle to NT FILE DEVICE
							(ULONG) IOCTL_WKD_READ_PORT,
							inbuf,                  // Information sent to IOCTL:
							4,                      // Number of bytes sent.
							outbuf,                 // Data from IOCTL
							4,                      // Size of outbuf buffer in bytes.
							&nout,                  // Number of bytes returned
							NULL)
		 )
		{
		*Buffer = (BYTE) (outbuf[0]);				// Send data to application
		}
    else
		*Buffer = 0xFF;								// If IOCTL failed return 0xFF.
}


VOID	MyOutB(	WORD Port, BYTE Data )				// Called when an OUT is executed
                                                    // Write data to port using IOCTL.
{
	ULONG	inbuf [8];		// Buffer sent     to   IOCTL routine
	ULONG   outbuf[8];		// Buffer received from IOCLT routine
	DWORD 	nout;			// Number of bytes returned by IOCTL routine

    inbuf[0] = (ULONG) (Port - BASE_PORT);			// RELATIVE port address,
	inbuf[1] = (ULONG)  Data;                   	// then one byte of data in
													// low byte of second ULONG.

	DeviceIoControl(	hndFile,                    // Handle to NT FILE DEVICE
						(ULONG) IOCTL_WKD_WRITE_PORT,
						inbuf,                      // Information sent to IOCTL:
						8,                          // Number of bytes sent.
						outbuf,                     // Data from IOCTL
						0,                          // Size of outbuf buffer.
						&nout,                      // Number of bytes returned
						NULL);
}
