// WKDVDD  gives DOS applications access to a block of IO ports.
// Robert R. Howell
// January 6, 1992
// Based on /DDK/PRIVATE/VDD/SAMPLES/SAMPLE2/VDD  in the NT DDK

#define BASE_PORT          0x300		// The first I/O port to be handled.
#define NUMBER_PORTS           4        // The number of I/O ports to be handled.


#define WKD_TYPE 40000		// This is a device number in the "User defined" range.


// Define the IOCTL codes we will use.  The IOCTL code contains a command identifier, plus
// other information about the device, the type of access, and the type of buffering.

// Because I have access to the \ddk\public\sdk\inc\devioctl.h file I just keep these in
// symbolic form.  If I gave the drivers to someone who didn't have this files, I would have
// to give them numerical versions of these constants.  Are the macro's EVER likely to change?
// There is a statement in one of the documentation books about registering "public" IOCTL
// codes with Microsoft.  However, the include file says that the IOCTL codes
// from 0x800 to 0xFFF are for customer use.

#define IOCTL_WKD_READ_PORT \
	CTL_CODE( WKD_TYPE, 0x900, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_WKD_WRITE_PORT \
	CTL_CODE(WKD_TYPE,  0x901, METHOD_BUFFERED, FILE_WRITE_ACCESS)



BOOL VddDllEntry(HANDLE hVdd, DWORD dwReason, LPVOID lpReserved);   // Entry function of VDD

VOID MyInB(WORD, PBYTE);		// Called when IN  is executed by DOS program.
VOID MyOutB(WORD, BYTE);        // Called when OUT is executed by DOS program..
