// Simple driver that demonstrates dynamically loading and unloading

#include "ntddk.h"

NTSTATUS
LdUnldOpen(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    );

NTSTATUS
LdUnldClose(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    );

VOID
LdUnldUnload(
    IN PDRIVER_OBJECT DriverObject
    );

NTSTATUS
DriverEntry(
    IN PDRIVER_OBJECT DriverObject,
    IN PUNICODE_STRING RegistryPath
    ) {

    PDEVICE_OBJECT deviceObject = NULL;
    NTSTATUS status;
    UNICODE_STRING uniNameString;


    KdPrint(("LDUNLD: Hi from the Load/Unload driver!\n"));

    //
    // Allocate space for the name.
    //

    RtlInitUnicodeString(
        &uniNameString,
        NULL
        );

    uniNameString.MaximumLength = sizeof(L"\\Device\\Ldunld") + sizeof(WCHAR);
    uniNameString.Buffer = ExAllocatePool(
                               PagedPool,
                               uniNameString.MaximumLength
                               );

    //
    // The only reason the above could have failed is if
    // there wasn't enough system memory to form the UNICODE
    // string.
    //

    if (!uniNameString.Buffer) {

        KdPrint(("LDUNLD: Not enough space for our name!!!\n"));
        return STATUS_INSUFFICIENT_RESOURCES;

    }

    //
    // Form the name.
    //

    RtlZeroMemory(
        uniNameString.Buffer,
        uniNameString.MaximumLength
        );

    RtlAppendUnicodeToString(
        &uniNameString,
        L"\\Device\\Ldunld"
        );

    //
    // Create the device object
    //

    status = IoCreateDevice(
                 DriverObject,
                 0,
                 &uniNameString,
                 FILE_DEVICE_UNKNOWN,
                 0,
                 TRUE,
                 &deviceObject
                 );

    //
    // We don't need the memory for the name anymore.
    //

    ExFreePool(uniNameString.Buffer);

    if (NT_SUCCESS(status)) {

        //
        // Create dispatch points for create/open, close, unload.
        //

        DriverObject->MajorFunction[IRP_MJ_CREATE] = LdUnldOpen;
        DriverObject->MajorFunction[IRP_MJ_CLOSE] = LdUnldClose;
        DriverObject->DriverUnload = LdUnldUnload;

        KdPrint(("LDUNLD: just about ready!\n"));

    }

    return status;

}

NTSTATUS
LdUnldOpen(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    ) {

    //
    // No need to do anything.
    //

    //
    // Fill these in before calling IoCompleteRequest.
    //
    // DON'T get cute and try to use the status field of
    // the irp in the return status.  That IRP IS GONE as
    // soon as you call IoCompleteRequest.
    //

    KdPrint(("LDUNLD: I've just loaded!!\n"));

    Irp->IoStatus.Status = STATUS_SUCCESS;
    Irp->IoStatus.Information = 0;

    IoCompleteRequest(
        Irp,
        IO_NO_INCREMENT
        );

    return STATUS_SUCCESS;

}

NTSTATUS
LdUnldClose(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    ) {

    //
    // No need to do anything.
    //

    //
    // Fill these in before calling IoCompleteRequest.
    //
    // DON'T get cute and try to use the status field of
    // the irp in the return status.  That IRP IS GONE as
    // soon as you call IoCompleteRequest.
    //

    Irp->IoStatus.Status = STATUS_SUCCESS;
    Irp->IoStatus.Information = 0;

    KdPrint(("LDUNLD: I've just closed!!\n"));

    IoCompleteRequest(
        Irp,
        IO_NO_INCREMENT
        );

    return STATUS_SUCCESS;

}

VOID
LdUnldUnload(
    IN PDRIVER_OBJECT DriverObject
    ) {

    //
    // All *THIS* driver needs to do is to delete the device extension.
    //
    // Almost every other driver ever witten would need to do a
    // significant amount of work here deallocating stuff.
    //

    KdPrint(("LDUNLD: I'll be back!!\n"));
    IoDeleteDevice(DriverObject->DeviceObject);

}


