/**************************************************************************\
* status.c - module to support the status bar.
*
*         Steve Firebaugh
*         Microsoft Developer Support
*         Copyright (c) 1992 Microsoft Corporation
*
*
* resized by main frame window.
* text and painting managed in this module.
\**************************************************************************/
#define UNICODE

#include <windows.h>
#include "uniput.h"


/* spacing for the fields in the status bar... */
#define SBORDER 6
#define SFIELD0 160
#define SFIELD1 100

/* logfont for the font selected into the static windows on status bar */
LOGFONT logfontsmall = {
      UCFONTHEIGHT /2 ,
      UCFONTWIDTH /2,
       0 ,
       0 ,
     400 ,
       0 ,
       0 ,
       0 ,
       UNICODE_CHARSET ,
       0 ,
       0 ,
       2 ,
       2 ,
      TEXT("Lucida Sans Unicode")};




/**************************************************************************\
*
*  function:  StatusWndProc()
*
*  input parameters:  normal window procedure parameters.
*
*  global variables:
\**************************************************************************/
LRESULT CALLBACK StatusWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
static HFONT hfontStatic;
static HWND hwndStatic0, hwndStatic1;
RECT rect, clientrect;


  switch (message) {

    /**********************************************************************\
    *  WM_CREATE
    *
    * Create two static child windows, and select a font for them.
    \**********************************************************************/
    case WM_CREATE: {
      GetClientRect (hwnd, &clientrect);

      hwndStatic0 = CreateWindow(
              TEXT("STATIC"),
              TEXT("File: <none>"),
              WS_CHILD | WS_VISIBLE | SS_CENTER,
              0,0,0,0,
              hwnd, NULL, hInst, 0);



      hwndStatic1 = CreateWindow(
              TEXT("STATIC"),
              TEXT("<text stream>:  "),
              WS_CHILD | WS_VISIBLE | SS_LEFT,
              0,0,0,0,
              hwnd, NULL, hInst, 0);



      hfontStatic = CreateFontIndirect (&logfontsmall);
      SendMessage (hwndStatic0, WM_SETFONT, (WPARAM) hfontStatic, 0);
      SendMessage (hwndStatic1, WM_SETFONT, (WPARAM) hfontStatic, 0);
    } break;


    /**********************************************************************\
    *  WM_DESTROY
    *
    * free the font we created at WM_CREATE time.
    \**********************************************************************/
    case WM_DESTROY:
      DeleteObject (hfontStatic);
    break;


    /**********************************************************************\
    *  WM_CTLCOLORSTATIC
    \**********************************************************************/
    case WM_CTLCOLORSTATIC: {
      HDC hdc;

      hdc = (HDC) wParam;
      SetBkMode (hdc, TRANSPARENT);
      return (LRESULT)GetStockObject (LTGRAY_BRUSH);
    } break;


    /**********************************************************************\
    *  WM_SIZE
    *
    * Resize the static controls to stretch them to always fill the status
    *  bar minus some border area.
    \**********************************************************************/
    case WM_SIZE: {
      GetClientRect (hwnd, &clientrect);

      rect.left = 2*SBORDER;
      rect.top = clientrect.top + SBORDER;
      rect.right = SFIELD0;
      rect.bottom = clientrect.bottom - SBORDER;

      SetWindowPos (hwndStatic0, HWND_TOP,
        rect.left,
        rect.top,
        rect.right - rect.left,
        rect.bottom - rect.top, 0);

      rect.left  =  rect.right + 4*SBORDER;
      rect.right = clientrect.right - 2*SBORDER;

      SetWindowPos (hwndStatic1, HWND_TOP,
        rect.left,
        rect.top,
        rect.right - rect.left,
        rect.bottom - rect.top, 0);

      return TRUE;
    } break;




    /**********************************************************************\
    *  WMU_SETFILENAME
    *
    * lParam - pointer to new string.
    *
    \**********************************************************************/
    case WMU_SETFILENAME: {
      LPCTSTR lpctstr;
      TCHAR buffer[100];



      lpctstr = (LPCTSTR) lParam;
      if (lpctstr != NULL)
        wsprintf (buffer, TEXT("File: %s"), lpctstr);
      else
        wsprintf (buffer, TEXT("File: <none>"));


      SetWindowText (hwndStatic0,buffer);

    } break;


#define MAXCHARS 30

    /**********************************************************************\
    *  WMU_CHARACTER
    *
    * lParam - WCHAR value
    *
    * Display a string of characters in the second static window. This is
    *  a FIFO buffer, if we fill it, shift characters to the left, and
    *  set the string back into the static control.
    *
    \**********************************************************************/
    case WMU_CHARACTER: {
      TCHAR buffer[MAXCHARS+1];
      int nchar;
      int i;

      GetWindowText (hwndStatic1,buffer, MAXCHARS+1);
      nchar = GetWindowTextLength (hwndStatic1);

      if (nchar >= MAXCHARS) {
        nchar = MAXCHARS-1;
        for (i= 0; i<(MAXCHARS-1); i++)
          buffer[i] = buffer[i+1];
      }

      buffer[nchar] = (TCHAR) lParam;
      buffer[nchar+1] = (TCHAR) '\000';

      SetWindowText (hwndStatic1,buffer);

    } break;



    /**********************************************************************\
    *  WM_PAINT
    *
    * Gray background is done automatically, just outline the two static
    *  text windows with 3-D effect.
    \**********************************************************************/
    case WM_PAINT: {
      HDC hdc;
      PAINTSTRUCT ps;

      hdc = BeginPaint(hwnd, &ps);
      GetClientRect (hwnd, &clientrect);

      /* outline static0 */
      rect.left = 2*SBORDER;
      rect.top = clientrect.top + SBORDER;
      rect.right = SFIELD0;
      rect.bottom = clientrect.bottom - SBORDER;
      InflateRect (&rect, 1, 1);
      FrameRect (hdc, &rect, GetStockObject (GRAY_BRUSH));
      InflateRect (&rect, -1, -1);
      SelectObject (hdc, GetStockObject (WHITE_PEN));
      MoveToEx (hdc, rect.right, rect.top, NULL);
      LineTo (hdc,rect.right, rect.bottom);
      LineTo (hdc,rect.left, rect.bottom);

      /* outline static1 */
      rect.left = rect.right + 4*SBORDER;
      rect.right = clientrect.right - 2*SBORDER;
      InflateRect (&rect, 1, 1);
      FrameRect (hdc, &rect, GetStockObject (GRAY_BRUSH));
      InflateRect (&rect, -1, -1);
      SelectObject (hdc, GetStockObject (WHITE_PEN));
      MoveToEx (hdc, rect.right, rect.top, NULL);
      LineTo (hdc,rect.right, rect.bottom);
      LineTo (hdc,rect.left, rect.bottom);

      EndPaint (hwnd, &ps);

    } return FALSE; /* end WM_PAINT */
  } /* end switch */
  return (DefWindowProc(hwnd, message, wParam, lParam));
}
