/*
  C source for GNU CHESS

  Revision: 1990-09-30

  Modified by Daryl Baker for use in MS WINDOWS environment

  Copyright (C) 1986, 1987, 1988, 1989, 1990 Free Software Foundation, Inc.
  Copyright (c) 1988, 1989, 1990  John Stanback

  This file is part of CHESS.

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/

extern struct leaf;

extern int parse (FILE * fd, unsigned int *mv, int side);
extern void GetOpenings (HWND hWnd);
extern void OpeningBook (unsigned int *hint);
extern void repetition (int *cnt);
extern void SelectMove (HWND hWnd, int side, int iop);
extern int search (int side,
                   int ply,
                   int depth,
                   int alpha,
                   int beta,
                   unsigned int *bstline,
                   int *rpt);
#if ttblsz
extern int ProbeTTable (int side,
                        int depth,
                        int *alpha,
                        int *beta,
                        int *score);
extern void PutInTTable (int side,
                         int score,
                         int depth,
                         int alpha,
                         int beta,
                         unsigned int mv);
extern void ZeroTTable (void);
extern void ZeroRPT (void);
#ifdef HASHFILE
extern int ProbeFTable (int side,
                        int depth,
                        int *alpha,
                        int *beta,
                        int *score);
extern void PutInFTable (int side,
                         int score,
                         int depth,
                         int alpha,
                         int beta,
                         unsigned int f,
                         unsigned int t);
#endif /* HASHFILE */
#endif /* ttblsz */
extern void Initialize_moves (void);
extern void MoveList (int side, int ply);
extern void CaptureList (int side, int ply);
extern int castle (int side, int kf, int kt, int iop);
extern void MakeMove (int side,
                      struct leaf far * node,
                      int *tempb,
                      int *tempc,
                      int *tempsf,
                      int *tempst,
                      int *INCscore);
extern void UnmakeMove (int side,
                        struct leaf far * node,
                        int *tempb,
                        int *tempc,
                        int *tempsf,
                        int *tempst);
extern void InitializeStats (void);
extern int SqAtakd (int sq, int side);
extern int evaluate (int side,
                     int ply,
                     int alpha,
                     int beta,
                     int INCscore,
                     int *slk,
                     int *InChk);
extern void ScoreLoneKing (int side, int *score);
extern void ScorePosition (int side, int *score);
extern void ExaminePosition (void);
extern void UpdateWeights (void);

extern void Initialize (void);
extern void InputCommand (void);
extern void ExitChess (void);
extern void ClrScreen (void);
extern void SetTimeControl (void);
extern void SelectLevel (void);
extern void UpdateDisplay (HWND hWnd, int f,
                           int t,
                           int flag,
                           int iscastle);
extern void ElapsedTime (int iop);
extern void ShowSidetoMove (void);
extern void SearchStartStuff (int side);
extern void ShowDepth (char ch);
extern void ShowResults (int score,
                         unsigned int *bstline, char ch);
extern void algbr (int f, int t, int flag);
extern void OutputMove (HWND hWnd);
extern void ShowCurrentMove (int pnt, int f, int t);
extern void ShowMessage (HWND hWnd, char *s);
extern void ClrScreen (void);
extern void gotoXY (int x, int y);
extern void ClrEoln (void);
extern void DrawPiece (HWND hWnd, int sq);
extern void UpdateClocks (void);
extern void ataks (int side, int *a);
extern void ListGame (HWND hWnd, char *fname);
extern void NewGame (HWND hWnd);

extern void QuerySqSize ( POINT *pptl ) ;
extern void QueryBoardSize ( POINT *pptl );
extern void QuerySqOrigin ( int x, int y, POINT *pptl);
extern void QuerySqCoords ( int x, int y, POINT aptl[] );
extern void Draw_Board ( HDC hDC, int reverse,
                  DWORD DarkColor, DWORD LightColor );
extern void DrawAllPieces ( HDC hDC, int reverse, int *pbrd, int *color, DWORD xblack, DWORD xwhite );
extern void DrawWindowBackGround ( HDC hDC, HWND hWnd, DWORD bkcolor);
extern BOOL FAR ChessInit (HANDLE hInstance);
extern void InitHitTest ( void );
extern int HitTest ( int x, int y);
extern void HiliteSquare ( HWND hWnd, int Square);
extern void UnHiliteSquare ( HWND hWnd, int Square);
extern void Hittest_Destructor ( VOID);
extern void SetStandardColors ( VOID );
extern void SaveColors ( LPSTR appname );
extern void GetStartupColors ( LPSTR appname );
extern int ColorDialog ( HWND hWnd, HANDLE hInst, DWORD Param );
extern int TimeControlDialog (HWND hWnd, HANDLE hInst, DWORD Param );
extern void Create_Children ( HWND hWnd, HANDLE hInst, int xchar, int ychar);
extern int ReviewDialog ( HWND hWnd, HANDLE hInst);
extern void SaveGame (HWND hWnd, char *fname);
extern void GetGame (HWND hWnd, char *fname);
extern void Undo (HWND hWnd);
extern void GiveHint (HWND hWnd);
extern int VerifyMove (HWND hWnd, char *s, int iop, unsigned int *mv);
extern int init_main (HWND hWnd);
extern void ShowSidetoMove (void);
extern BOOL APIENTRY About(HWND, UINT, UINT, LONG);
extern LONG APIENTRY ChessWndProc(HWND, UINT, UINT, LONG);
extern void Init_Menus (HWND hWnd, UINT wParam, LONG lParam );
extern void FreeBook (void);
extern void DrawCoords ( HDC hDC, int reverse, DWORD clrBackGround, DWORD clrText);
extern int TestDialog ( HWND hWnd, HANDLE hInst);
extern HWND StatDialog ( HWND hWnd, HANDLE hInst);
extern int PromoteDialog ( HWND hWnd, HANDLE hInst);
extern void pick (int p1, int p2);
extern void SMessageBox ( HWND hWnd, int str_num, int str1_num );
extern void ShowPlayers (void);
extern void FreeGlobals (void);
extern void algbr (int f, int t, int flag);

extern int FAR DoGetNumberDlg (HANDLE, HWND, char *, int);


