/*
  C source for GNU CHESS

  Revision: 1990-09-30

  Modified by Daryl Baker for use in MS WINDOWS environment

  Copyright (C) 1986, 1987, 1988, 1989, 1990 Free Software Foundation, Inc.
  Copyright (c) 1988, 1989, 1990  John Stanback

  This file is part of CHESS.

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/

#define NOATOM 
#define NOCLIPBOARD
#define NOCREATESTRUCT
#define NOFONT
#define NOREGION
#define NOSOUND
#define NOWH
#define NOWINOFFSETS
#define NOCOMM
#define NOKANJI

#include <windows.h>
#include <stdio.h>

#include "gnuchess.h"

struct BookEntry FAR *Book;

#if ttblsz
unsigned long hashkey, hashbd;
/*struct hashval hashcode[2][7][64];*/
/*static struct huge ttable[2][ttblsz]; */
struct hashval FAR *hashcode;
struct hashentry FAR *ttable;
#endif /* ttblsz */

FILE *hashfile;
/*struct leaf Tree[2000], *root;*/
struct leaf FAR *Tree, FAR *root;

int TrPnt[maxdepth];
int PieceList[2][16], PawnCnt[2][8];
#define wking PieceList[white][0]
#define bking PieceList[black][0]
#define EnemyKing PieceList[c2][0]
int castld[2], Mvboard[64];
int svalue[64];
struct flags flag;
int opponent, computer, Awindow, Bwindow, dither, INCscore;
long ResponseTime, ExtraTime, Level, et, et0, time0, ft;
long NodeCnt, ETnodes, EvalNodes, HashCnt, FHashCnt, HashCol;
int player, xwndw, rehash;

/*struct GameRec GameList[512];*/
struct GameRec FAR *GameList;

int Sdepth, GameCnt, Game50, MaxSearchDepth;
int epsquare, contempt;
/*struct BookEntry *Book;*/
struct TimeControlRec TimeControl;
int TCflag, TCmoves, TCminutes, OperatorTime;
unsigned int hint, PrVar[maxdepth];
int Pindex[64];
int PieceCnt[2];
int c1, c2, *atk1, *atk2, *PC1, *PC2, atak[2][64];
int mtl[2], pmtl[2], emtl[2], hung[2];
int FROMsquare, TOsquare, Zscore, zwndw;
int HasKnight[2], HasBishop[2], HasRook[2], HasQueen[2];
int ChkFlag[maxdepth], CptrFlag[maxdepth], PawnThreat[maxdepth];
int Pscore[maxdepth], Tscore[maxdepth];
unsigned int killr0[maxdepth], killr1[maxdepth];
unsigned int killr2[maxdepth], killr3[maxdepth];
unsigned int PV, Swag0, Swag1, Swag2, Swag3, Swag4;
/*unsigned char history[8192];*/
unsigned char FAR *history;

int rpthash[2][256];
int Mwpawn[64], Mbpawn[64], Mknight[2][64], Mbishop[2][64];
int Mking[2][64], Kfield[2][64];
int KNIGHTPOST, KNIGHTSTRONG, BISHOPSTRONG, KATAK;
int PEDRNK2B, PWEAKH, PADVNCM, PADVNCI, PAWNSHIELD, PDOUBLED, PBLOK;
int RHOPN, RHOPNX, KHOPN, KHOPNX, KSFTY;
int ATAKD, HUNGP, HUNGX, KCASTLD, KMOVD, XRAY, PINVAL;
int stage, stage2, Developed[2];
int PawnBonus, BishopBonus, RookBonus;

/*int distdata[64][64], taxidata[64][64];*/
int FAR *distdata, FAR *taxidata;

int board[64], color[64];
/*unsigned char nextpos[8][64][64]; */
/*unsigned char nextdir[8][64][64]; */
unsigned char FAR *nextpos;
unsigned char FAR *nextdir;


const int otherside[3] = {1, 0, 2};

#if ttblsz
#if HASHFILE
/*
  In a networked enviroment gnuchess might be compiled on different
  hosts with different random number generators, that is not acceptable
  if they are going to share the same transposition table.
*/
static unsigned long int next = 1;

unsigned int urand (void)
{
  next *= 1103515245;
  next += 12345;
  return ((unsigned int) (next >> 16) & 0xFFFF);
}

void srand (unsigned int seed)
{
  next = seed;
}
#endif /*HASHFILE*/
#endif /*ttblsz*/

HWND hComputerColor;
HWND hComputerMove;
HWND hWhosTurn;
HWND hClockComputer;
HWND hClockHuman;
HWND hMsgComputer;
HWND hMsgHuman;
HWND hStats;

