#include <stdio.h>
#include <string.h>
#include <process.h>
#include <ctype.h>

enum Bool
{
    kFalse = 0,
    kTrue = 1
};

FILE* gInFile;
FILE* gOutFile;

struct sSectionInfo
{
    const char* fSectionName;
    const char* fMessage;
    const char* fSuffix;
};

enum
{
    kNumSections = 3,
    kBufSize = 1024
};

struct sSectionInfo gSections[kNumSections] =
{
    { "Code",               "Code exports",    NULL },
    { "Uninitialized Data", "BSS exports",     "CONSTANT" },
    { "Initialized Data",   "Data exports",    "CONSTANT" }
};


int gOrdNum = 1000;

void ProcessSymbols(void);
void ProcessSection(int i);
Bool WriteOneName(char* buf, const char* suffix);

int main(int argc, char ** argv)
{
    puts("\
Map2Def for Windows NT, by Kostya V. the Cytomax Slut\n\
");

    if(argc != 3)
    {
        puts("\
Usage: Map2Def inFile.map outFile.def\n\
The mapfile has to be created with Microsoft LINK32\n\
");
        return 1;
    }

    gInFile = fopen(argv[1], "rt");
    if(gInFile == NULL)
    {
        printf("Cannot open .map file: %s\n", argv[1]);
        return 1;
    }

    gOutFile = fopen(argv[2], "wt");
    if(gOutFile == NULL)
    {
        fclose(gInFile);
        printf("Cannot open .def file: %s\n", argv[2]);
        return 1;
    }

    ProcessSymbols();

    fclose(gInFile);
    fclose(gOutFile);

    printf("\
\n\
Success, output file: %s\n", argv[2]);

    return 0;
}

void ProcessSymbols(void)
{
    static char buf[kBufSize];

    // scan for the next section
    while(fgets(buf, sizeof buf, gInFile) != NULL)
    {
        if(buf[0] != ' ' && buf[0] != '\n')
        {
            // found a section, try to identify it
            for(int i = 0; i < kNumSections; i++)
            {
                if(strncmp(buf, gSections[i].fSectionName, strlen(gSections[i].fSectionName)) == 0)
                {
                    ProcessSection(i);
                    break;
                }
            }
        }
    }
}

void ProcessSection(int i)
{
    static char buf[kBufSize];

    printf("\
%s:\t", gSections[i].fMessage);

    fprintf(gOutFile, "\
\n\
; %s\n\
\n", gSections[i].fMessage);

    int total = 0;
    int cnt = 0;

    while(fgets(buf, sizeof buf, gInFile) != NULL)
    {
        if(buf[0] == '\n' && ++cnt == 2)
            break;

        if(WriteOneName(buf, gSections[i].fSuffix))
            total ++;
    }

    printf("\
%d\n", total);
}

Bool WriteOneName(char* buf, const char* suffix)
{
    if(buf[0] == '\n' || strchr(buf, '(') != NULL)
        return kFalse;

    char* name = buf;

    while(*name == ' ')
       name++;
    if(*name == 0)
        goto error;

    while(isxdigit(*name))
        name++;
    if(*name == 0)
        goto error;

    while(*name == ' ')
       name++;
    if(*name == 0)
        goto error;

    {
        char* end = name;
        while(*end != ' ')
           end++;
        if(*end == 0 || name == end)
            goto error;

        *end = 0;

        if(strcmp(name, "end") == 0)
            return kFalse;

        fprintf(gOutFile, "\
\t%s\t@%d\t%s\n", name, gOrdNum ++, suffix != NULL ? suffix : "");
    }

    return kTrue;

error:
    printf("\
\n\
Invalid line found in the map file:\n\
%s\n", buf);
    exit(1);
    return kFalse;
}
