
/*		Winner		version 1.07.06		for Windows NT     10/28/92		*/

#include "windows.h"
#include "drivinit.h"
#include "winner.h"
#include "commdlg.h"
#include "io.h"
#include "shellapi.h"
#include "stdio.h"
#include "string.h"
#include <sys\types.h>
#include <sys\stat.h>

FARPROC lpAbortDlg, lpAbortProc;

CHOOSEFONT cf;
LOGFONT lf;
OFSTRUCT OfStruct;
OPENFILENAME ofn;
PAINTSTRUCT ps;
PLOGFONT plf;
PRINTDLG pd;
RECT Rect;
TEXTMETRIC TextMetric;
HANDLE hAccTable;
HANDLE hEditBuffer;
HANDLE hNewFile;
HANDLE hHourGlass;
HANDLE hInst;
HANDLE hNewBuffer;
HANDLE hOldBuffer;
HANDLE hPrevRunning;
HANDLE hSaveCursor;
HANDLE hShell;
HBRUSH hBkBrush;
HDC hDC;
HDC GetPrinterDC ( void );
HDC hPr;
HFONT hFont;
HFONT hgFont;
HFONT hgWndFont;
HMENU hMenu;
HPEN hPen;
HWND hAbortDlgWnd;
HWND hBtOpenWnd;
HWND hBtOpen2Wnd;
HWND hBtSaveWnd;
HWND hBtSaveasWnd;
HWND hBtDeleteWnd;
HWND hBtPrintWnd;
HWND hBtTypeWnd;
HWND hBtExitWnd;
HWND hBtUndoWnd;
HWND hBtCutWnd;
HWND hBtCopyWnd;
HWND hBtPasteWnd;
HWND hBtClearWnd;
HWND hBtSelaWnd;
HWND hBtFindWnd;
HWND hBtNextWnd;
HWND hBtPrevWnd;
HWND hBtReplWnd;
HWND hBtReplaWnd;
HWND hBtCmplWnd;
HWND hBtBuildWnd;
HWND hBtBuildallWnd;
HWND hBtCleanWnd;
HWND hBtRunWnd;
HWND hBtChelpWnd;
HWND hBtWhelpWnd;
HWND hEditWnd;
HWND hwnd;
BOOL bAbort;
BOOL bButCut = FALSE;
BOOL fCase	   = FALSE;
BOOL bChanges = FALSE;
BOOL bSaveEnabled = FALSE;
BOOL bSearchin=FALSE;
DWORD dwEnd;
DWORD dwResults;
DWORD dwLineCount;
DWORD dwStart;
DWORD dwStyle;
DWORD dwStyleEx;
DWORD dwTextColor;
LPSTR lpstrPointer;
PSTR pBuffer;
PSTR pEditBuffer;
WORD wIndex;
WORD wLines;
WORD TabSpacing = 8;
UINT idMenu;
char szBaseWindowTitle[ ] = "Winner";
char szEmptyString[ ] = "";
char szFFileName[MAXFILENAME];
char szFileName[MAXFILENAME] = "";
char szFileTitle[MAXFILENAME];
char szFilterSpec[128] = "All Files (*.*)\0*.*\0Executable (*.EXE)\0*.EXE\0Text Files (*.TXT)\0*.TXT\0";
char szLine[128];
char szRepl[160] = "";
char szSearch[160] = "";
char szTemp[128];
char Untitled[ ] = "Winner - ( untitled )";
char szWindowTitle[80];
char szRepl[ ];
int Count;
int CurrentLine;
int EX = 0;
int EY = 0;
int EW= 640;
int EH= 400;
int hFile;
int Heigth;
int LineLength;
int LinesPerPage;
int LineSpace;
int Response;
int nTabs[1] = {34};
int Width = 0;
struct stat FileStatus;

int PASCAL WinMain ( hInstance, hPrevInstance, lpCmdLine, nCmdShow )
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{	MSG msg;
	RECT Rect;
	hPrevRunning = FindWindow("WinnerWClass", NULL);
	if ( !hPrevInstance ) {
		WNDCLASS	wc;
		wc.style = NULL;
		wc.lpfnWndProc = MainWndProc;
		wc.cbClsExtra = 0;
		wc.cbWndExtra = 0;
		wc.hInstance = hInstance;
		wc.hIcon = LoadIcon ( hInstance,"Icon" );
		wc.hCursor = LoadCursor ( NULL, IDC_ARROW );
		wc.hbrBackground = GetStockObject ( LTGRAY_BRUSH );
		wc.lpszMenuName = "WinnerMenu";
		wc.lpszClassName = "WinnerWClass";
		if (!RegisterClass ( &wc ) )
			return ( FALSE ) ; }
	if(hPrevRunning) {
		dwTextColor = RGB(0, 0, 128);
		EX = 50 ;
		EY = 25 ; }
	lstrcpy ( (LPSTR)&szFileName,  lpCmdLine ) ;
	if(!lstrcmpi( (LPSTR)&szFileName, "buildres.ult\0")){
		dwTextColor = RGB(128, 0, 0);
		EX=0;
		EY=200;
		EH=280;}
	hInst = hInstance ;
	hAccTable = LoadAccelerators ( hInst, "WinnerAcc" ) ;
	dwStyle = WS_OVERLAPPEDWINDOW ;
	hwnd = CreateWindow ( "WinnerWClass", szBaseWindowTitle, dwStyle, EX, EY, EW-EX, EH, NULL, NULL, hInstance, NULL ) ;
	if ( !hwnd )
		return ( FALSE) ;
	dwStyle = WS_CHILD|WS_VISIBLE|ES_MULTILINE|WS_VSCROLL|ES_AUTOVSCROLL|ES_NOHIDESEL|WS_HSCROLL|ES_AUTOHSCROLL;
	if(GetAsyncKeyState(VK_CONTROL)<0)
		dwStyle = WS_CHILD|WS_VISIBLE|ES_MULTILINE|WS_VSCROLL|ES_AUTOVSCROLL|ES_NOHIDESEL;
	dwStyleEx = WS_EX_TOPMOST ;
	GetClientRect ( hwnd, ( LPRECT) &Rect ) ;
	Width = ( Rect.right - Rect.left ) ;
	Heigth = ( Rect.bottom - Rect.top ) ;
	hEditWnd = CreateWindowEx ( dwStyleEx, "Edit", NULL, dwStyle, 0, 25, Width, Heigth - 25, hwnd, (HMENU)IDC_EDIT, hInst, NULL ) ;
	if ( !hEditWnd ) {
		DestroyWindow ( hwnd ) ;
		return ( NULL ) ; }
	dwStyle = WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_PUSHBUTTON;
	hBtOpenWnd = CreateWindowEx ( dwStyleEx, "Button", "O", dwStyle, 8, 2, 16, 20, hwnd, (HMENU)IDM_OPEN, hInst, NULL );
	hBtOpen2Wnd = CreateWindowEx ( dwStyleEx, "Button", "2", dwStyle, 24, 2, 16, 20, hwnd, (HMENU)IDM_OPEN2, hInst, NULL );
	hBtSaveWnd = CreateWindowEx ( dwStyleEx, "Button", "S", dwStyle, 40, 2, 16, 20, hwnd, (HMENU)IDM_SAVE, hInst, NULL );
	hBtSaveasWnd = CreateWindowEx ( dwStyleEx, "Button", "A", dwStyle, 56, 2, 16, 20, hwnd, (HMENU)IDM_SAVEAS, hInst, NULL );
	hBtDeleteWnd = CreateWindowEx ( dwStyleEx, "Button", "D", dwStyle, 72, 2, 16, 20, hwnd, (HMENU)IDM_DELETE, hInst, NULL );
	hBtPrintWnd = CreateWindowEx ( dwStyleEx, "Button", "P", dwStyle, 88, 2, 16, 20, hwnd, (HMENU)IDM_PRINT, hInst, NULL );
	hBtTypeWnd = CreateWindowEx ( dwStyleEx, "Button", "T", dwStyle, 104, 2, 16, 20, hwnd, (HMENU)IDM_FONTS, hInst, NULL );
	hBtExitWnd = CreateWindowEx ( dwStyleEx, "Button", "X", dwStyle, 120, 2, 16, 20, hwnd, (HMENU)IDM_EXIT, hInst, NULL );
	hBtUndoWnd = CreateWindowEx ( dwStyleEx, "Button", "U", dwStyle, 144, 2, 16, 20, hwnd, (HMENU)IDM_UNDO, hInst, NULL );
	hBtCutWnd = CreateWindowEx ( dwStyleEx, "Button", "C", dwStyle, 160, 2, 16, 20, hwnd, (HMENU)IDM_CUT, hInst, NULL );
	hBtCopyWnd = CreateWindowEx ( dwStyleEx, "Button", ">", dwStyle, 176, 2, 16, 20, hwnd, (HMENU)IDM_COPY, hInst, NULL );
	hBtPasteWnd = CreateWindowEx ( dwStyleEx, "Button", "P", dwStyle, 192, 2, 16, 20, hwnd, (HMENU)IDM_PASTE, hInst, NULL );
	hBtClearWnd = CreateWindowEx ( dwStyleEx, "Button", "D", dwStyle, 208, 2, 16, 20, hwnd, (HMENU)IDM_CLEAR, hInst, NULL );
	hBtSelaWnd = CreateWindowEx ( dwStyleEx, "Button", "A", dwStyle, 224, 2, 16, 20, hwnd, (HMENU)IDM_SELECTALL, hInst, NULL );
	hBtFindWnd = CreateWindowEx ( dwStyleEx, "Button", "F", dwStyle, 248, 2, 16, 20, hwnd, (HMENU)IDM_FIND, hInst, NULL );
	hBtNextWnd = CreateWindowEx ( dwStyleEx, "Button", "N", dwStyle, 264, 2, 16, 20, hwnd, (HMENU)IDM_NEXT, hInst, NULL );
	hBtPrevWnd = CreateWindowEx ( dwStyleEx, "Button", "P", dwStyle, 280, 2, 16, 20, hwnd, (HMENU)IDM_PREV, hInst, NULL );
	hBtReplWnd = CreateWindowEx ( dwStyleEx, "Button", "R", dwStyle, 296, 2, 16, 20, hwnd, (HMENU)IDM_REPL, hInst, NULL );
	hBtReplaWnd = CreateWindowEx ( dwStyleEx, "Button", "A", dwStyle, 312, 2, 16, 20, hwnd, (HMENU)IDM_REPLA, hInst, NULL );
	hBtCmplWnd = CreateWindowEx ( dwStyleEx, "Button", "C", dwStyle, 336, 2, 16, 20, hwnd, (HMENU)IDM_CMPL, hInst, NULL );
	hBtBuildWnd = CreateWindowEx ( dwStyleEx, "Button", "B", dwStyle, 352, 2, 16, 20, hwnd, (HMENU)IDM_BUILD, hInst, NULL );
	hBtBuildallWnd = CreateWindowEx ( dwStyleEx, "Button", "A", dwStyle, 368, 2, 16, 20, hwnd, (HMENU)IDM_BUILDALL, hInst, NULL );
	hBtCleanWnd = CreateWindowEx ( dwStyleEx, "Button", "C", dwStyle, 384, 2, 16, 20, hwnd, (HMENU)IDM_CLEAN, hInst, NULL );
	hBtRunWnd = CreateWindowEx ( dwStyleEx, "Button", "E", dwStyle, 400, 2, 16, 20, hwnd, (HMENU)IDM_RUN, hInst, NULL );
	hBtChelpWnd = CreateWindowEx ( dwStyleEx, "Button", "C", dwStyle, 424, 2, 16, 20, hwnd, (HMENU)IDM_CHELP, hInst, NULL );
	hBtWhelpWnd = CreateWindowEx ( dwStyleEx, "Button", "W", dwStyle, 440, 2, 16, 20, hwnd, (HMENU)IDM_WHELP, hInst, NULL );
	EnableWindow(hBtNextWnd, FALSE);
	EnableWindow(hBtPrevWnd, FALSE);
	EnableWindow(hBtReplWnd, FALSE);
	EnableWindow(hBtCmplWnd, FALSE);
	EnableWindow(hBtBuildWnd, FALSE);
	EnableWindow(hBtBuildallWnd, FALSE);
	SendMessage(hEditWnd, EM_LIMITTEXT, 1048576, 0L);
	hHourGlass = LoadCursor ( NULL, IDC_WAIT ) ;
	hSaveCursor = LoadCursor( NULL, IDC_ARROW ) ;
	ofn.lStructSize = sizeof ( OPENFILENAME ) ;
	ofn.hwndOwner = hwnd ;
	ofn.lpstrFilter	 = szFilterSpec ;
	ofn.lpstrCustomFilter = NULL ;
	ofn.nMaxCustFilter = 0 ;
	ofn.nFilterIndex = 1 ;
	ofn.lpstrFile = szFileName ;
	ofn.nMaxFile = MAXFILENAME ;
	ofn.lpstrInitialDir = NULL ;
	ofn.lpstrFileTitle = szFileTitle ;
	ofn.nMaxFileTitle = MAXFILENAME ;
	ofn.lpstrTitle = NULL ;
	ofn.lpstrDefExt = "" ;
	ofn.Flags = 0 ;
	pd.lStructSize = sizeof ( PRINTDLG ) ;
	pd.hwndOwner = hwnd ;
	pd.hDevMode = NULL ;
	pd.hDevNames = NULL ;
	pd.Flags = PD_RETURNDEFAULT;
	pd.nCopies = 1 ;
	strcpy ( lf.lfFaceName, "MS Sans Serif") ;
	lf.lfHeight = 8 ;
	plf = (PLOGFONT) LocalAlloc ( LPTR, sizeof (LOGFONT) ) ;
	plf->lfHeight = lf.lfHeight ;
	strcpy (plf->lfFaceName, lf.lfFaceName ) ;
	hgWndFont = CreateFontIndirect (plf) ;
	SendMessage ( hEditWnd, WM_SETFONT, (WPARAM)hgWndFont, 0L ) ;
	LocalFree ( (HLOCAL) plf );
	ShowWindow ( hwnd, nCmdShow ) ;
	UpdateWindow ( hwnd ) ;
	SendMessage ( hEditWnd, EM_SETTABSTOPS, 1, ( LPARAM )( int far* ) &TabSpacing ) ;
	memset ( &cf, 0, sizeof (CHOOSEFONT ) ) ;
	cf.lStructSize = sizeof ( CHOOSEFONT ) ;
	cf.hwndOwner = hwnd ;
	cf.lpLogFont = &lf ;
	cf.Flags = CF_SCREENFONTS | CF_EFFECTS | CF_INITTOLOGFONTSTRUCT ;
	cf.rgbColors = RGB ( 0, 0, 0 ) ;
	cf.nFontType = SCREEN_FONTTYPE ;
	hMenu = GetMenu (hwnd) ;
	hBkBrush = (HBRUSH)GetStockObject(WHITE_BRUSH);
	if(hPrevRunning) {
		EnableMenuItem ( hMenu, IDM_OPEN2, MF_DISABLED | MF_GRAYED | MF_BYCOMMAND ) ;
		EnableWindow(hBtOpen2Wnd, FALSE);
		cf.rgbColors = RGB ( 0, 0, 255 ); }
	if ( lstrlen (lpCmdLine ) ) 
		PostMessage ( hwnd, WM_COMMAND, IDM_VIEW, 0L) ;
	while ( GetMessage ( &msg, NULL, NULL, NULL ) ) {
		if ( !TranslateAccelerator ( hwnd, hAccTable, &msg ) ) {
			TranslateMessage ( &msg ) ;
			DispatchMessage ( &msg ) ; } }
	return ( msg.wParam ) ;
}

long APIENTRY MainWndProc ( HWND hWnd, UINT uMsg, UINT wParam, LONG lParam )
{	FARPROC lpProcAbout ;
	DWORD FlagSave ;
	DWORD IOStatus ;
	int Status ;
	int nPageSize ;
	switch ( uMsg ) {
		case WM_COMMAND :
			switch ( LOWORD(wParam) ) {
				case IDM_ABOUT :
					lpProcAbout = MakeProcInstance ( About, hInst ) ;
					DialogBox ( hInst, "AboutBox", hWnd, lpProcAbout ) ;
					FreeProcInstance ( lpProcAbout ) ;
					break ;
				case IDM_NEW :
					if ( !QuerySaveFile ( hWnd ) )
						return ( NULL ) ;
					bChanges = FALSE ;
					szFileName[0] = 0 ;
				    hOldBuffer = ( HANDLE ) SendMessage ( hEditWnd, EM_GETHANDLE, 0, 0L ) ;
					if ( hOldBuffer ){
						hNewBuffer = LocalAlloc ( LMEM_MOVEABLE | LMEM_ZEROINIT, 1 );
						SendMessage ( hEditWnd, EM_SETHANDLE, (WPARAM)hNewBuffer, 0L ) ;
						SetWindowText ( hWnd, "Winner- Untitled" ) ;
						SetFocus ( hEditWnd ) ;
						LocalFree ( hOldBuffer );}
					break ;
				case IDM_RUN:
					sprintf(szFFileName, "%s", szFileName );
					ofn.nFilterIndex = 2 ;
					ofn.lpstrTitle="Execute File";
					if ( !GetOpenFileName ( ( LPOPENFILENAME ) &ofn ) )
						return ( NULL ) ;
					ShellExecute ( hWnd, NULL, (LPSTR)&szFileName, "", "", SW_SHOW ) ;
					sprintf(szFileName, "%s", szFFileName );
					ofn.nFilterIndex = 1 ;
					break;
				case IDM_OPEN2:
					if(GetAsyncKeyState(VK_CONTROL)<0)
						ShowWindow(hwnd,SW_MINIMIZE);
					ofn.nFilterIndex = 1 ;
					ofn.lpstrTitle="Open 2nd File";
					sprintf(szFFileName, "%s", szFileName );
					if ( !GetOpenFileName ( ( LPOPENFILENAME ) &ofn ) )
						return ( NULL ) ;
					ShellExecute ( hWnd, NULL, "Winner.exe", (LPSTR)&szFileName, "", SW_SHOW) ;
					sprintf(szFileName, "%s", szFFileName );
					break;
				case IDM_DELETE :
					ofn.nFilterIndex = 1 ;
					ofn.lpstrTitle="Delete File";
					sprintf(szFFileName, "%s", szFileName );
					if ( !GetOpenFileName ( ( LPOPENFILENAME ) &ofn ) )
						return ( NULL ) ;
					sprintf ( szTemp, "DELETE: %s ?", szFileName ) ;
					Response = MessageBox ( hWnd, szTemp, "Winner",  MB_YESNOCANCEL | MB_ICONEXCLAMATION ) ;
					if ( Response == IDYES )
						DeleteFile ( ( LPSTR )&szFileName ) ;
					sprintf(szFileName, "%s", szFFileName );
					break;
				case IDM_OPEN :
					if ( !QuerySaveFile ( hWnd ) )
						return ( NULL ) ;
					ofn.nFilterIndex = 1 ;
					ofn.lpstrTitle="Open File";
					if ( !GetOpenFileName ( ( LPOPENFILENAME ) &ofn ) )
						return ( NULL ) ;
				case IDM_VIEW :
					hFile = OpenFile ( ( LPSTR ) szFileName, ( LPOFSTRUCT )&OfStruct, OF_READ ) ;
					if ( !hFile )
						return ( NULL ) ;
					hOldBuffer = ( HANDLE ) SendMessage ( hEditWnd, EM_GETHANDLE, 0, 0L ) ;
					LocalFree ( hOldBuffer ) ;
					dwResults  = GetFileSize((HANDLE)hFile, NULL);
					hEditBuffer = LocalAlloc ( LMEM_MOVEABLE | LMEM_ZEROINIT, dwResults+1 ) ;
					if ( !hEditBuffer ) {
						MessageBox ( hWnd, "Not enough memory.", NULL, MB_OK | MB_ICONEXCLAMATION ) ;
						_lclose ( hFile ) ;
						return ( NULL ) ; }
					hSaveCursor = SetCursor ( hHourGlass ) ;
					pEditBuffer = LocalLock ( hEditBuffer ) ;
					ReadFile((HANDLE)hFile, pEditBuffer, dwResults, (LPDWORD)&IOStatus, NULL ) ;
					_lclose ( hFile ) ;
					LocalUnlock ( hEditBuffer ) ;
					if ( IOStatus != dwResults ) {
						sprintf ( szTemp, "Error reading %s.", szFileName ) ;
						SetCursor ( hSaveCursor ) ;
						MessageBox ( hWnd, szTemp, NULL, MB_OK | MB_ICONEXCLAMATION ) ; }
					sprintf ( szTemp, "%s - %s", szBaseWindowTitle, szFileName ) ;
					SendMessage ( hEditWnd, EM_SETHANDLE, (WPARAM)hEditBuffer, 0L ) ;
					SetWindowText ( hWnd, szTemp ) ;
					SetFocus ( hEditWnd ) ;
					bChanges = FALSE ;
					SetCursor ( hSaveCursor ) ;
					EnableMenuItem ( hMenu, IDM_CMPL, MF_ENABLED | MF_BYCOMMAND ) ;
					EnableMenuItem ( hMenu, IDM_BUILD, MF_ENABLED | MF_BYCOMMAND ) ;
					EnableMenuItem ( hMenu, IDM_BUILDALL, MF_ENABLED | MF_BYCOMMAND ) ;
					EnableWindow(hBtCmplWnd, TRUE);
					EnableWindow(hBtBuildWnd, TRUE);
					EnableWindow(hBtBuildallWnd,TRUE);
					break ;
				case IDM_SAVE :
					if ( szFileName[ 0 ] ) {
						if ( bChanges )
							SaveFile ( hWnd ) ;
						SetFocus(hEditWnd);
						break ; }
					SetFocus(hEditWnd);
				case IDM_SAVEAS :
					ofn.nFilterIndex = 1 ;
					ofn.lpstrTitle="Save File As";
					if ( !GetSaveFileName ( ( LPOPENFILENAME ) &ofn ) )
						return FALSE ;
					lstrcpy ( szWindowTitle, szBaseWindowTitle ) ;
					lstrcat ( szWindowTitle, " - " ) ;
					lstrcat ( szWindowTitle, szFileTitle ) ;
					SetWindowText ( hWnd, szWindowTitle ) ;
		    		SaveFile ( hWnd ) ;
		    		break ;
				case IDM_PRINT :
					hSaveCursor = SetCursor ( hHourGlass ) ;
					hPr = GetPrinterDC( ) ;
					if ( !hPr ) {
						sprintf ( szTemp, "Cannot print %s", szFileName ) ;
						MessageBox ( hWnd, szTemp, NULL, MB_OK | MB_ICONHAND ) ;
						return ( NULL ) ; }
					lpAbortDlg =  MakeProcInstance ( AbortDlg, hInst ) ;
					lpAbortProc = MakeProcInstance( AbortProc, hInst ) ;
					SetAbortProc ( hPr, lpAbortProc ) ;
					plf = ( PLOGFONT ) LocalAlloc ( LPTR, sizeof ( LOGFONT ) ) ;
					plf->lfHeight = -MulDiv ( lf.lfHeight, GetDeviceCaps ( hPr, LOGPIXELSY ), 72 ) ;
					plf->lfWeight = lf.lfWeight ;
					plf->lfItalic = lf.lfItalic ;
					plf->lfUnderline = lf.lfUnderline ;
					plf->lfStrikeOut = lf.lfStrikeOut ;
					plf->lfCharSet = lf.lfCharSet ;
					plf->lfQuality = lf.lfQuality ;
					plf->lfPitchAndFamily = lf.lfPitchAndFamily ;
					strcpy ( plf->lfFaceName, lf.lfFaceName ) ;
					hFont = CreateFontIndirect ( plf ) ;
					SelectObject ( hPr, hFont ) ;
					if ( Escape ( hPr, STARTDOC, 14, "PrntFile text", ( LPSTR ) NULL ) < 0 ) {
						MessageBox ( hWnd, "Unable to start print job", NULL, MB_OK | MB_ICONHAND ) ;
						FreeProcInstance ( lpAbortDlg ) ;
						FreeProcInstance ( lpAbortProc ) ;
						DeleteDC ( hPr ) ; }
					bAbort = FALSE ;
					hAbortDlgWnd = CreateDialog ( hInst, "AbortDlg", hWnd, lpAbortDlg ) ;
					if ( !hAbortDlgWnd ) {
						SetCursor ( hSaveCursor ) ;
						MessageBox ( hWnd, "NULL Abort window handle", NULL, MB_OK | MB_ICONHAND ) ;
						return ( FALSE ) ; }
					ShowWindow ( hAbortDlgWnd, SW_NORMAL ) ;
					EnableWindow ( hWnd, FALSE ) ;
					SetCursor ( hSaveCursor ) ;
					GetTextMetrics ( hPr, &TextMetric ) ;
					LineSpace = TextMetric.tmHeight + TextMetric.tmExternalLeading ;
					nPageSize = GetDeviceCaps ( hPr, VERTRES ) ;
					LinesPerPage = nPageSize / LineSpace - 2 ;
					wLines = ( WORD ) SendMessage ( hEditWnd, EM_GETLINECOUNT, 0, 0L ) ;
					CurrentLine = 1 ;
					dwStyle = 1 ;
					StartPage ( hPr ) ;
					Count = sprintf ( szTemp, "File Name  %s     Page  %lu ", szFileName, dwStyle ) ;
					TextOut ( hPr, 99, CurrentLine*LineSpace, ( LPSTR ) szTemp, Count ) ;
					CurrentLine ++ ;
					TextOut ( hPr, 0, CurrentLine*LineSpace, "", NULL ) ;
					CurrentLine ++ ;
					for ( wIndex = Status = 0; wIndex < wLines; wIndex++ ) {
						szLine[0] = 127 ;
						szLine[1] = 0 ;
						LineLength = ( int ) SendMessage ( hEditWnd, EM_GETLINE, wIndex, ( DWORD ) ( LPSTR ) szLine ) ;
						TabbedTextOut ( hPr, 99, CurrentLine*LineSpace, ( LPSTR ) szLine, LineLength, 1,  nTabs, 99 ) ;
						if ( ++CurrentLine > LinesPerPage ) {
							CurrentLine = 1 ;
							dwStyle ++ ;
							Status = EndPage ( hPr ) ;
							if ( Status < 0 || bAbort )
								break ;
							SelectObject ( hPr, hFont ) ;
							StartPage ( hPr ) ;
							Count = sprintf ( szTemp, "File Name  %s      Page  %lu ", szFileName, dwStyle ) ;
							TextOut ( hPr, 99, CurrentLine*LineSpace, ( LPSTR ) szTemp, Count ) ;
							CurrentLine ++ ;
							TextOut ( hPr, 0, CurrentLine*LineSpace, "", NULL ) ;
							CurrentLine ++ ; } }
					if ( Status >= 0 && !bAbort ) {
						Escape( hPr, NEWFRAME, 0, 0L, 0L ) ;
						Escape( hPr, ENDDOC, 0, 0L, 0L ) ; }
					EnableWindow ( hWnd, TRUE ) ;
					DestroyWindow ( hAbortDlgWnd ) ;
					FreeProcInstance ( lpAbortDlg ) ;
					FreeProcInstance ( lpAbortProc ) ;
					LocalFree ( ( HLOCAL ) plf ) ;
					DeleteObject ( hFont ) ;
					DeleteDC ( hPr ) ;
					break ;
				case IDM_PRINTSETUP :
					FlagSave = pd.Flags ;
					pd.Flags = PD_RETURNDC | PD_PRINTSETUP ;
/*					PrintDlg ( ( LPPRINTDLG ) &pd ) ;	*/
/*					pd.Flags = FlagSave ;	*/
					break ;
				case IDM_UNDO :
					SendMessage ( hEditWnd,EM_UNDO,0,0L ) ;
					SetFocus(hEditWnd);
					break ;
				case IDM_CUT :
					SendMessage ( hEditWnd, WM_CUT, 0, 0L ) ;
					SetFocus(hEditWnd);
					break ;
				case IDM_COPY :
					SendMessage ( hEditWnd, WM_COPY, 0, 0L ) ;
					SendMessage ( hEditWnd, EM_GETSEL, (WPARAM)(LPDWORD)&dwStart, 0L ) ;
					SendMessage ( hEditWnd, EM_SETSEL, (WPARAM)dwStart, (LPARAM)dwStart ) ;
					SetFocus(hEditWnd);
					break ;
				case IDM_PASTE :
					SendMessage ( hEditWnd, WM_PASTE, 0, 0L ) ;
					SetFocus(hEditWnd);
					break ;
				case IDM_CLEAR :
					SendMessage ( hEditWnd, WM_CLEAR, 0, 0L ) ;
					break ;
				case IDM_SELECTALL :
					SendMessage ( hEditWnd, EM_SETSEL, 0, -1 ) ;
					break ;
				case IDM_CMPL:
					if ( !QuerySaveFile ( hWnd ) )
						return ( NULL ) ;
					ShellExecute ( hWnd, NULL, "winner.bat", szFileName,"", SW_MINIMIZE ) ;
					break ;					
				case IDM_BUILD :
					if ( !QuerySaveFile ( hWnd ) )
						return ( NULL ) ;
					ShellExecute ( hWnd, NULL, "winner.bat", " b", "", SW_MINIMIZE ) ;
					break ;
				case IDM_BUILDALL :
					if ( !QuerySaveFile ( hWnd ) )
						return ( NULL ) ;
					ShellExecute ( hWnd, NULL, "winner.bat", " a", "", SW_MINIMIZE ) ;
					break ;
				case IDM_CLEAN :
					ShellExecute ( hWnd, NULL, "winner.bat", " c", "" ,SW_MINIMIZE ) ;
					break ;
				case IDM_FIND :
					EnableMenuItem ( hMenu, IDM_NEXT, MF_ENABLED | MF_BYCOMMAND ) ;
					EnableWindow(hBtNextWnd, TRUE);
					EnableMenuItem ( hMenu, IDM_PREV, MF_ENABLED | MF_BYCOMMAND ) ;
					EnableWindow(hBtPrevWnd, TRUE);
					EnableMenuItem ( hMenu, IDM_REPL, MF_ENABLED | MF_BYCOMMAND ) ;
					EnableWindow(hBtReplWnd, TRUE);
					Find( ) ;
					break ;
				case IDM_NEXT :
					FindNext( ) ;
					SetFocus(hEditWnd);
					break ;
				case IDM_PREV :
					FindPrev( ) ;
					SetFocus(hEditWnd);
					break ;
				case IDM_REPL :
					SendMessage ( hEditWnd, EM_REPLACESEL, 0, ( LPARAM ) ( LPSTR ) &szRepl ) ;
					SetFocus(hEditWnd);
					break ;
				case IDM_REPLA :
					bSearchin = TRUE ;
					SendMessage ( hEditWnd, EM_SETSEL, 0, 0L ) ;
					Find( ) ;
					while ( bSearchin ) {
						bSearchin = FALSE ;
						dwResults = SendMessage ( hEditWnd, EM_GETSEL, 0, 0L ) ;
						if ( dwResults != 0 ) {
							SendMessage ( hEditWnd, EM_REPLACESEL, 0, ( LPARAM ) ( LPSTR ) &szRepl ) ;
							bSearchin = TRUE ;
							FindNext( ) ; } }
					break ;
				case IDM_FONTS :
					if (ChooseFont (&cf)) {
						plf = (PLOGFONT) LocalAlloc ( LPTR, sizeof (LOGFONT) ) ;
						plf->lfHeight = lf.lfHeight ;
						plf->lfWeight = lf.lfWeight ;
						plf->lfItalic = lf.lfItalic ;
						plf->lfUnderline = lf.lfUnderline ;
						plf->lfStrikeOut = lf.lfStrikeOut ;
						plf->lfCharSet = lf.lfCharSet ;
						plf->lfQuality = lf.lfQuality ;
						plf->lfPitchAndFamily = lf.lfPitchAndFamily ;
						strcpy (plf->lfFaceName, lf.lfFaceName ) ;
						dwTextColor = cf.rgbColors ;
						hgFont = CreateFontIndirect (plf) ;
						SendMessage ( hEditWnd, WM_SETFONT, (WPARAM)hgFont, 0L ) ;
						LocalFree ( (HLOCAL) plf ); }
					break ;
				case IDM_EXIT :
					QuerySaveFile ( hWnd ) ;
					DestroyWindow ( hWnd ) ;
					break ;
				case IDM_CHELP:
					ShellExecute ( hWnd, NULL, "winhlp32.exe", " msc.hlp", "", SW_SHOW ) ;
					break;
				case IDM_WHELP:
					ShellExecute ( hWnd, NULL, "winhlp32.exe", " api32wh.hlp", "", SW_SHOW ) ;
					break;
				case IDC_EDIT :
					if ( HIWORD ( wParam ) == EN_CHANGE ) {
						bChanges = TRUE ;
						SendMessage ( hEditWnd, EM_GETSEL, (WPARAM)(LPDWORD)&dwStart, 0L ) ;
						dwResults = SendMessage ( hEditWnd, EM_LINEFROMCHAR,dwStart,0L ) ;
						if ( dwResults == dwLineCount )
							break ;
						dwLineCount = sprintf ( szTemp, "Line Number  %u    ", dwResults+1 ) ;
						hDC = GetDC(hwnd);
						SetBkColor(hDC, (COLORREF)RGB(192, 192, 192));
						SelectObject(hDC, hgWndFont);
						TextOut(hDC, 472, 5, (LPSTR)&szTemp, dwLineCount) ;
						ReleaseDC(hwnd, hDC);
						dwLineCount = dwResults ;
						if(bButCut) {
							bButCut = FALSE;
							break;}
						TabSpacing =  (WORD)dwResults ;
						dwResults = SendMessage ( hEditWnd, EM_GETLINE, (WPARAM)TabSpacing, ( DWORD ) ( LPSTR ) szTemp ) ;
						if ( dwResults == 0 ) {
							dwResults = SendMessage ( hEditWnd, EM_GETLINE, (WPARAM)TabSpacing - 1, ( DWORD ) ( LPSTR ) szTemp ) ;
							lpstrPointer = ( LPSTR ) szTemp ;
							TabSpacing = 0 ;
							while ( *lpstrPointer == ( BYTE ) 9 ) {
								TabSpacing ++ ;
								lpstrPointer ++ ; }
							lpstrPointer = ( LPSTR ) szTemp + dwResults -1 ;
							if ( *lpstrPointer == ( BYTE ) 40 )
								TabSpacing++ ;
							if ( *lpstrPointer == ( BYTE ) 41 )
								TabSpacing++ ;
							if ( *lpstrPointer == ( BYTE ) 58 )
								TabSpacing++ ;
							if ( *lpstrPointer == ( BYTE ) 123 )
								TabSpacing++ ;
							if ( TabSpacing > 0 )
								if ( *lpstrPointer == ( BYTE ) 125 )
									TabSpacing-- ;
							wsprintf ( szTemp, "" ) ;
							while ( TabSpacing >0 ) {
								lstrcat ( szTemp, "\t" ) ;
								TabSpacing-- ; }
							SendMessage ( hEditWnd, EM_REPLACESEL, 0, ( LPARAM ) ( LPSTR ) szTemp ) ; }
						break ; }
					if ( HIWORD ( wParam ) == EN_ERRSPACE ) {
						MessageBox ( GetFocus ( ), "Out of memory.", "PrntFile Sample Application", MB_ICONHAND | MB_OK ) ; }
					break ; }
				break ;
		case WM_PAINT:
			hDC = BeginPaint(hwnd, (LPPAINTSTRUCT)&ps);
			MoveToEx(hDC, 0, 24, NULL);
			hPen = SelectObject(hDC, (HGDIOBJ)GetStockObject(BLACK_PEN));
			LineTo(hDC, 632, 24);
			MoveToEx(hDC, 466, 20, NULL);
			DeleteObject(hPen);
			hPen = SelectObject(hDC, (HGDIOBJ)CreatePen(PS_SOLID, 2, RGB(128,128,128)));
			LineTo(hDC, 466, 3);
			LineTo(hDC, 620, 3);
			LineTo(hDC, 620, 4);
			DeleteObject(hPen);
			hPen = SelectObject(hDC, (HGDIOBJ)CreatePen(PS_SOLID, 2, RGB(255, 255, 255)));
			LineTo(hDC, 620,21);
			LineTo(hDC, 466, 21);
			DeleteObject(hPen);
			dwResults = sprintf ( szTemp, "Line Number  %u    ", dwLineCount+1 ) ;
			SetBkColor(hDC, (COLORREF)RGB(192, 192, 192));
			SelectObject(hDC, hgWndFont);
			TextOut(hDC, 472, 5, (LPSTR)&szTemp, dwResults) ;
			EndPaint(hwnd, (LPPAINTSTRUCT)&ps);
		case WM_CTLCOLOREDIT:
			if (lParam == (LPARAM)hEditWnd) {
				SetTextColor ( (HDC) wParam, (COLORREF) dwTextColor);
				return (WPARAM)hBkBrush;}
			return NULL;
		case WM_SETCURSOR :
			if (wParam == (WPARAM)hEditWnd ) {
				SendMessage(hEditWnd, EM_GETSEL, (WPARAM)(LPDWORD)&dwStart, (LPARAM)(LPDWORD)&dwEnd);
				if(HIWORD(lParam) == WM_RBUTTONUP) {
					if(dwEnd == dwStart)
						SendMessage ( hEditWnd, WM_PASTE, 0, 0L ) ;
					else {
						SendMessage ( hEditWnd, WM_CUT, 0, 0L ) ;
						SendMessage ( hEditWnd, EM_SETSEL, (WPARAM)dwStart, (LPARAM)dwStart ) ;
						bButCut = TRUE;}}
				dwResults = SendMessage ( hEditWnd, EM_LINEFROMCHAR, dwStart, 0L ) ;
				if ( dwResults == dwLineCount )
					break ;
				dwLineCount = sprintf ( szTemp, "Line Number  %u    ", dwResults+1 ) ;
				hDC = GetDC(hwnd);
				SetBkColor(hDC, (COLORREF)RGB(192, 192, 192));
				SelectObject(hDC, hgWndFont);
				TextOut(hDC, 472, 5, (LPSTR)&szTemp, dwLineCount) ;
				ReleaseDC(hwnd, hDC);
				dwLineCount=dwResults ;
				break ; }
			return ( DefWindowProc ( hWnd, uMsg, wParam, lParam ) ) ;
		case WM_SETFOCUS :
			SetFocus ( hEditWnd ) ;
			break ;
		case WM_SIZE :
			MoveWindow ( hEditWnd, 0, 25, LOWORD ( lParam ), HIWORD ( lParam ) - 25, TRUE ) ;
			break ;
		case WM_QUERYENDSESSION :
			return ( QuerySaveFile ( hWnd ) ) ;
		case WM_CLOSE :
			if ( QuerySaveFile ( hWnd ) )
				DestroyWindow ( hWnd ) ;
			break ;
		case WM_DESTROY :
			PostQuitMessage ( 0 ) ;
			break ;
		default :
			return ( DefWindowProc ( hWnd, uMsg, wParam, lParam ) ) ; }
	return ( NULL ) ;
}

BOOL SaveFile ( hWnd )
HWND hWnd ;
{   BOOL bSuccess ;
    DWORD IOStatus ;
    if ( ( hNewFile = CreateFile (szFileName, 	GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE,
											NULL, CREATE_ALWAYS, 0, NULL ) ) < 0) {
		sprintf ( szTemp, "Cannot write to %s.", szFileName ) ;
        MessageBox ( hWnd, szTemp, NULL, MB_OK | MB_ICONHAND ) ;
        return ( FALSE ) ; }
    hEditBuffer = ( HANDLE) SendMessage ( hEditWnd, EM_GETHANDLE, 0, 0L ) ;
    pEditBuffer = LocalLock ( hEditBuffer ) ;
    hSaveCursor = SetCursor ( hHourGlass ) ;
     WriteFile (hNewFile, pEditBuffer, strlen ( pEditBuffer ), (LPDWORD)&IOStatus, NULL ) ;
    CloseHandle ( hNewFile ) ;
    SetCursor ( hSaveCursor ) ;
    if ( IOStatus != strlen ( pEditBuffer ) ) {
		sprintf ( szTemp, "Error writing to %s.", szFileName ) ;
        MessageBox ( hWnd, szTemp, NULL, MB_OK | MB_ICONHAND ) ;
        bSuccess = FALSE ; }
    else {
        bSuccess = TRUE ;
        bChanges = FALSE ; }
    LocalUnlock ( hEditBuffer ) ;
    return ( bSuccess ) ;
}

BOOL QuerySaveFile ( hWnd )
HWND hWnd ;
{	if ( bChanges ) {
		sprintf ( szTemp, "Save current changes: %s", szFileName ) ;
        Response = MessageBox ( hWnd, szTemp, "Winner",  MB_YESNOCANCEL | MB_ICONEXCLAMATION ) ;
        if ( Response == IDYES ) {
			while ( !szFileName[ 0 ] ) {
				if ( !GetSaveFileName ( ( LPOPENFILENAME ) &ofn ) )
					return FALSE ; }
            SaveFile ( hWnd ) ; }
        else if ( Response == IDCANCEL )
			return ( FALSE ) ; }
    else  return ( TRUE ) ;
}

HDC GetPrinterDC ( void )
{	HDC         hDC ;
    LPDEVMODE   lpDevMode = NULL ;
    LPDEVNAMES  lpDevNames ;
    LPSTR       lpszDriverName ;
    LPSTR       lpszDeviceName ;
    LPSTR       lpszPortName ;
    if ( !PrintDlg ( ( LPPRINTDLG ) &pd ) )
		return ( NULL ) ;
	if ( pd.hDC )
		hDC = pd.hDC ;
	else {
		if ( !pd.hDevNames )
			return ( NULL ) ;
        lpDevNames = ( LPDEVNAMES ) GlobalLock ( pd.hDevNames ) ;
        lpszDriverName = ( LPSTR ) lpDevNames + lpDevNames->wDriverOffset ;
        lpszDeviceName = ( LPSTR ) lpDevNames + lpDevNames->wDeviceOffset ;
        lpszPortName   = ( LPSTR ) lpDevNames + lpDevNames->wOutputOffset ;
        GlobalUnlock ( pd.hDevNames ) ;
        if ( pd.hDevMode )
			lpDevMode = ( LPDEVMODE ) GlobalLock ( pd.hDevMode ) ;
        hDC = CreateDC ( lpszDriverName, lpszDeviceName, lpszPortName, NULL ) ;
        if ( pd.hDevMode && lpDevMode )
			GlobalUnlock ( pd.hDevMode ) ; }
    if ( pd.hDevNames ) {
		GlobalFree( pd.hDevNames ) ;
		pd.hDevNames = NULL ; }
    if ( pd.hDevMode ) {
		GlobalFree ( pd.hDevMode ) ;
		pd.hDevMode = NULL ; }
    return ( hDC ) ;
}

int APIENTRY AbortProc ( hPr, Code )
HDC hPr ;
int Code ;
{	MSG msg ;
    if ( !hAbortDlgWnd )
		return ( TRUE ) ;
	while ( !bAbort && PeekMessage ( &msg, NULL, NULL, NULL, TRUE ) )
       	if ( !IsDialogMessage ( hAbortDlgWnd, &msg ) ) {
			TranslateMessage ( &msg ) ;
			DispatchMessage ( &msg ) ; }
    return ( !bAbort ) ;
}

int APIENTRY AbortDlg ( HWND hDlg, UINT uMsg, UINT wParam, LONG lParam )
{	switch ( uMsg ) {
        case WM_COMMAND :
            return ( bAbort = TRUE ) ;
        case WM_INITDIALOG :
            SetFocus ( GetDlgItem ( hDlg, IDCANCEL ) ) ;
            SetDlgItemText ( hDlg, IDC_FILENAME, szFileName ) ;
            return ( TRUE ) ; }
    return ( FALSE ) ;
}

BOOL APIENTRY About ( HWND hDlg, UINT uMsg, UINT wParam, LONG lParam )
{	switch ( uMsg ) {
        case WM_INITDIALOG :
            return ( TRUE ) ;
        case WM_COMMAND :
			if ( LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL ) {
				EndDialog( hDlg, TRUE ) ;
                return ( TRUE ) ; }
            return ( TRUE ) ; }
    return ( FALSE ) ;
}

BOOL NEAR PASCAL RealSlowCompare (pSubject, pTarget )
LPSTR pSubject;
LPSTR pTarget;
{	if (fCase){
		while (*pTarget)
	    	if (*pTarget++ != *pSubject++)
				return FALSE;}
    else{
		AnsiLower ((LPSTR)pTarget);
		while (*pTarget)
			if (*pTarget++ != (char)(DWORD)AnsiLower ((LPSTR)(DWORD)(BYTE)*pSubject++))
				return FALSE;}
    return TRUE;
}

VOID NEAR PASCAL MyFindText( dch )
LONG dch;
{	DWORD  cch;
	DWORD i;
	if (!*szSearch)
		return;
	SendMessage(hEditWnd, EM_GETSEL,(WPARAM)(LPDWORD)&dwStart, 0L);
	hEditBuffer = (HANDLE)SendMessage (hEditWnd, EM_GETHANDLE, 0, 0L);
	pEditBuffer = LocalLock(hEditBuffer);
	cch = SendMessage (hEditWnd, WM_GETTEXTLENGTH, 0, 0L);
	pEditBuffer += dwStart + dch;
	if (dch < 0)
		i = dwStart;
	else
		i = cch - dwStart + 1 - lstrlen (szSearch);
	while ( i > 0){
		dwStart+=dch;
		if (RealSlowCompare(pEditBuffer, (LPSTR)&szSearch)){
			LocalUnlock(hEditBuffer);
			dwEnd = dwStart + lstrlen (szSearch);
			SendMessage (hEditWnd, EM_SETSEL, dwStart, dwEnd);
			return;}
		i--;
		pEditBuffer += dch;}
	LocalUnlock (hEditBuffer);
	MessageBox (hwnd,"Done","Find String", MB_OK);
	SendMessage(hEditWnd, EM_SETSEL, 0, 0L);
	SetFocus(hEditWnd);
	return;
}

VOID FAR PASCAL FindPrev(void)
{	MyFindText(-1);
}

VOID FAR PASCAL FindNext(void)
{	MyFindText(1);
}

BOOL APIENTRY FindDlgProc(HWND hwnd, UINT uMsg, UINT wParam, LONG lParam)
{	switch (uMsg){
		case WM_INITDIALOG:{
			CheckDlgButton (hwnd, IDD_CASE, fCase);
			SetDlgItemText (hwnd, IDD_SEARCH, szSearch);
			SetDlgItemText (hwnd, IDD_REPL, szRepl);
			if (!lstrlen (szSearch)){
				EnableWindow (GetDlgItem (hwnd, IDOK), FALSE);
				EnableWindow (GetDlgItem (hwnd, IDD_PREV), FALSE);}
			break;}
		case WM_COMMAND:{
			int i = 1;
			switch (LOWORD(wParam)){
				case IDD_SEARCH:
					if (HIWORD (wParam) == EN_CHANGE){
						if (! SendDlgItemMessage (hwnd, IDD_SEARCH, WM_GETTEXTLENGTH, 0, 0L))
							i = FALSE;
					else
						i = TRUE;
					EnableWindow (GetDlgItem (hwnd, IDOK), i);
					EnableWindow (GetDlgItem (hwnd, IDD_PREV), i);}
					break;
				case IDD_CASE:
					CheckDlgButton (hwnd, IDD_CASE, !IsDlgButtonChecked (hwnd, IDD_CASE));
					break;
				case IDD_PREV:
					i=-1;
				case IDOK:
					fCase = IsDlgButtonChecked( hwnd, IDD_CASE);
					GetDlgItemText (hwnd, IDD_SEARCH, szSearch, sizeof (szSearch));
					GetDlgItemText (hwnd, IDD_REPL, szRepl, sizeof (szRepl));
					MyFindText (i);
				case IDCANCEL:
					EndDialog (hwnd, 0);
					break;
				default:
					return FALSE;}
			break;}
		default:
	    	return FALSE;}
	return TRUE;
}

VOID FAR PASCAL Find()
{	FARPROC lpfn;
    lpfn = MakeProcInstance (FindDlgProc, hInst);
    DialogBox (hInst,"FindBox", hEditWnd, lpfn);
    FreeProcInstance (lpfn);
}