#include <windows.h>
#include <stdlib.h>
#include <dos.h>

#include <wintfmt.h>
#include <wtfdefs.h>
#include <wtfdemop.h>

extern HWND hDialog;

#pragma argsused
int FAR PASCAL _export CompareDatesDlgProc(HWND hDlg,
					   WORD wMsg,
					   WORD wParam,
					   LONG lParam)
{
   static HBRUSH hBrush = 0;
   static HWND   hBoxes[DATEGRIDSIZE];
   static HWND   hDates[MAXDATES];
   static char   szDates[MAXDATES][MAXDATESIZE] = { {"01012000"},
						    {"19991230"},
						    {"311299"  },
						    {"920229"  },
						    {"20011130"} };
   static char szDisplayDate[]     = "19991231";        /* szDisplayDate and dDate */
   static struct dosdate_t dDate   = {31, 12, 1999, 0}; /* should be the same */

   switch (wMsg) {
	  case WM_INITDIALOG: {
	       int  iErrVal;
	       HWND hDisplay = GetDlgItem(hDlg, WTF_IDD_DATE0);
	       hDialog = hDlg;
/*
   Get handles for edit controls.
*/
	       if ((iErrVal = GetHandlesForControls(hDlg,
						    WTF_IDD_DATE1,
						    MAXDATES,
						    (unsigned int FAR *) &hDates[0])) < 0)
	       return QuitDialog(iErrVal, 0);
/*
   Get handles for grid controls.
*/
	       if ((iErrVal = GetHandlesForControls(hDlg,
						    WTF_IDD_BOX1,
						    DATEGRIDSIZE,
						    (unsigned int FAR *) &hBoxes[0])) < 0)
	       return QuitDialog(iErrVal, 0);
/*
   Set all grid controls to read only.
*/
	       if (!SetGridControlsToReadOnly((int FAR *) &hBoxes[0],
					      DATEGRIDSIZE))
	       return QuitDialog(WTF_ERR_FUNCTIONFAILED, 0);
/*
   Write comparison date to the display field.
*/
	       if ((iErrVal = SetDate(hDisplay,
				      szDisplayDate,
				      sizeof(szDisplayDate))) < 0)
	       return QuitDialog(iErrVal, 0);
/*
   Set Display field to Read only.
*/
	       if (!OffWrite(hDisplay))
	       return QuitDialog(WTF_ERR_FUNCTIONFAILED, 0);
/*
   Create handle to red brush for grid color.
*/
	       hBrush = CreateSolidBrush(BACKGROUNDR);
	  } // EO case WM_INITDIALOG
	  break;

	  case WM_CLOSE:
	  return QuitDialog(1, hBrush);
/*
   Color the WinTfmt fields for which SetFmtColors() has been called..
*/
	  case WM_CTLCOLOR:
	  return ColorFmt(wParam, lParam);

	  case WM_COMMAND:
	       switch (wParam) {
		      case WTF_IDD_OK: {
			   int iErrVal;
/*
   Write default dates to the edit controls.
*/
			   if ((iErrVal = SetStringsToControls((LPSTR) szDates,
							       MAXDATES,
							       MAXDATESIZE,
							       (int FAR *) &hDates[0])) < 0)
			   return QuitDialog(iErrVal, hBrush);
		      } // EO case WTF_IDD_OK
		      break;

		      case WTF_IDD_COMPARE: {
			   BOOL bTrue;
			   int  i, j;
/*
   Compare value in display field with the values in the edit controls.
   Color the grid controls according to the value of bTrue.
*/
			   for (i = 0, j = 0; i < MAXDATES; i++, j = MAXDATES*i) {
			       bTrue = IsEqual(hDates[i], dDate);
			       SetBoxColor(bTrue, hBoxes[j], hBrush, FOREGROUND, BACKGROUNDR);
			       bTrue = IsGreaterEqual(hDates[i], dDate);
			       SetBoxColor(bTrue, hBoxes[j+1], hBrush, FOREGROUND, BACKGROUNDR);
			       bTrue = IsGreater(hDates[i], dDate);
			       SetBoxColor(bTrue, hBoxes[j+2], hBrush, FOREGROUND, BACKGROUNDR);
			       bTrue = IsLesserEqual(hDates[i], dDate);
			       SetBoxColor(bTrue, hBoxes[j+3], hBrush, FOREGROUND, BACKGROUNDR);
			       bTrue = IsLesser(hDates[i], dDate);
			       SetBoxColor(bTrue, hBoxes[j+4], hBrush, FOREGROUND, BACKGROUNDR);
			   } // EO for (i = 0
		      } // EO case
		      break;

		      case WTF_IDD_EXIT:
		      return QuitDialog(1, hBrush);

	       } // EO switch(wParam)
	       break;
   } // EO switch (wMsg)
return 0;
} // EO TestDataDlgProc()
