#include <windows.h>

#include <wintfmt.h>
#include <wtfdefs.h>
#include <wtfdemop.h>

extern HWND hDialog;

#pragma argsused
int FAR PASCAL _export CompareNumericDlgProc(HWND hDlg,
					     WORD wMsg,
					     WORD wParam,
					     LONG lParam)
{
   static HBRUSH hBrush = 0;
   static HWND   hCompare;
   static HWND   hBoxes[NUMGRIDSIZE];
   static HWND   hNumbers[MAXNUMS];
   static double dNumber = 950.001;
   static char   szNumbers[MAXNUMS][MAXNUMBERSIZE] = { {"950"},
						       {"950.0001"},
						       {"950.001"},
						       {"950.01"},
						       {"950.1"} };
   switch (wMsg) {
	  case WM_INITDIALOG: {
	       int iErrVal;
	       hDialog = hDlg;
/*
   Get the handles to the edit controls.
*/
	       if ((iErrVal = GetHandlesForControls(hDlg,
						    WTF_IDD_NEWNUM1,
						    MAXNUMS,
						    (unsigned int FAR *) &hNumbers[0])) < 0)
	       return QuitDialog(iErrVal, 0);
/*
   Get the handles to the grid controls.
*/
	       if ((iErrVal = GetHandlesForControls(hDlg,
						    WTF_IDD_BOX1,
						    NUMGRIDSIZE,
						    (unsigned int FAR *) &hBoxes[0])) < 0)
	       return QuitDialog(iErrVal, 0);
/*
   Set the grid controls to read only.   If the return value is FALSE, the
   handle to the control is invalid.
*/
	       if (!SetGridControlsToReadOnly((int FAR *) &hBoxes[0],
					      DATEGRIDSIZE))
	       return QuitDialog(iErrVal, 0);
/*
   Create handle to yellow brush for the grid color.
*/
	       hBrush = CreateSolidBrush(BACKGROUNDY);

	       if ((hCompare = GetDlgItem(hDlg, WTF_IDD_NEWNUM0)) == NULL)
	       return QuitDialog(WTF_ERR_HANDLE2CTL, hBrush);
/*
   Write the default number to the comparison field.
*/
	       if ((iErrVal = SetFmtEx(hCompare, dNumber)) < 0)
	       return QuitDialog(iErrVal, hBrush);
	  } // EO case
	  break;

	  case WM_CLOSE:
	  return QuitDialog(1, hBrush);
/*
   Color the WinTfmt fields for which SetFmtColors() has been called.
*/
	  case WM_CTLCOLOR:
	  return ColorFmt(wParam, lParam);

	  case WM_COMMAND:
	       switch (wParam) {
		      case WTF_IDD_OK: {
			   int iErrVal;
/*
   Reset the default number to the comparison field.
*/
			   if ((iErrVal = SetFmtEx(hCompare, dNumber)) < 0)
			   return QuitDialog(iErrVal, hBrush);
/*
   Write the default values to the WinTfmt edit controls.
*/
			   if ((iErrVal = SetStringsToControls((LPSTR) szNumbers,
							       MAXNUMS,
							       MAXNUMBERSIZE,
							       (int FAR *) &hNumbers[0])) < 0)
			   return QuitDialog(iErrVal, hBrush);
		      } // EO case WTF_IDD_OK
		      break;

		      case WTF_IDD_COMPARE: {
			   BOOL bTrue;
			   int  iErrVal, i, j;
			   double dCompare;
/*
   Get the value from the comparison field and store it in dCompare.
*/
			   if ((iErrVal = GetFmtEx(hCompare, dCompare)) < 0)
			   return QuitDialog(iErrVal, hBrush);
/*
   Compare the value of dCompare with the values in the edit controls.
   Color the grid controls according to the value of bTrue.
*/
			   for (i = 0, j = 0; i < MAXNUMS; i++, j = MAXNUMS*i) {
			       bTrue = IsEqual(hNumbers[i], dCompare);
			       SetBoxColor(bTrue, hBoxes[j], hBrush, FOREGROUND, BACKGROUNDY);
			       bTrue = IsGreaterEqual(hNumbers[i], dCompare);
			       SetBoxColor(bTrue, hBoxes[j+1], hBrush, FOREGROUND, BACKGROUNDY);
			       bTrue = IsGreater(hNumbers[i], dCompare);
			       SetBoxColor(bTrue, hBoxes[j+2], hBrush, FOREGROUND, BACKGROUNDY);
			       bTrue = IsLesserEqual(hNumbers[i], dCompare);
			       SetBoxColor(bTrue, hBoxes[j+3], hBrush, FOREGROUND, BACKGROUNDY);
			       bTrue = IsLesser(hNumbers[i], dCompare);
			       SetBoxColor(bTrue, hBoxes[j+4], hBrush, FOREGROUND, BACKGROUNDY);
			   } // EO for (i = 0

		      } // EO case
		      break;

		      case WTF_IDD_EXIT:
		      return QuitDialog(1, hBrush);

	       } // EO switch(wParam)
	       break;
   } // EO switch (wMsg)
return 0;
} // EO CompareNumericDlgProc()

