#include <windows.h>

#include <wintfmt.h>
#include <wtfdefs.h>
#include <wtfdemop.h>

extern HWND hDialog;

#pragma argsused
int FAR PASCAL _export CompareStringsDlgProc(HWND hDlg,
					     WORD wMsg,
					     WORD wParam,
					     LONG lParam)
{
   static HBRUSH hBrush;
   static HWND   hBoxes[STGSGRIDSIZE];
   static HWND   hStrings[MAXSTRINGS];
   static char   szDisplayString[] = "a";
   static char   szStrings[MAXSTRINGS][STRINGLEN] = { {"A"},
						      {"b"},
						      {"c"},
						      {"D"},
						      {"e"} };

   BOOL   bTrue;

   switch (wMsg) {
	  case WM_INITDIALOG: {
	       int iErrVal;
	       hDialog = hDlg;
/*
   Get the handles to the edit controls.
*/
	       if ((iErrVal = GetHandlesForControls(hDlg,
						    WTF_IDD_STRING1,
						    MAXSTRINGS,
						    (unsigned int FAR *) &hStrings[0])) < 0)
	       return QuitDialog(iErrVal, 0);
/*
   Get the handles for the grid controls.
*/
	       if ((iErrVal = GetHandlesForControls(hDlg,
						    WTF_IDD_BOX1,
						    STGSGRIDSIZE,
						    (unsigned int FAR *) &hBoxes[0])) < 0)
	       return QuitDialog(iErrVal, 0);
/*
   Set the grid controls to read only.
*/
	       if (!SetGridControlsToReadOnly((int FAR *) &hBoxes[0],
					      DATEGRIDSIZE))
	       return QuitDialog(iErrVal, 0);
/*
   Create handle to blue brush for the grid color.
*/
	       hBrush = CreateSolidBrush(BACKGROUNDB);
/*
   Write the comparison string to the display field.
*/
	       SetDlgItemText(hDlg, WTF_IDD_STRING0, (LPSTR) szDisplayString);
	  } // EO case
	  break;

	  case WM_CLOSE:
	  return QuitDialog(1, hBrush);
/*
   Color the WinTfmt fields for which SetFmtColors() has been called.
*/
	  case WM_CTLCOLOR:
	  return ColorFmt(wParam, lParam);

	  case WM_COMMAND:
	       switch (wParam) {
		      case WTF_IDD_EXIT:
		      return QuitDialog(1, hBrush);

		      case WTF_IDD_SET: {
			   int iErrVal;
/*
   Write the default strings to the edit controls.
*/
			   if ((iErrVal = SetStringsToControls((LPSTR) szStrings,
							       MAXSTRINGS,
							       STRINGLEN,
							       (int FAR *) &hStrings[0])) < 0)
			   return QuitDialog(iErrVal, hBrush);
		      } // EO case
		      break;

		      case WTF_IDD_COMPARE: {
			   BOOL bTrue;
			   int  i, j;
/*
   Compare the display string with the strings in the edit controls.
   The comparison is case sensitive.  Color the grid controls according
   to the value of bTrue.
*/
			   for (i = 0, j = 0; i < MAXSTRINGS; i++, j = MAXSTRINGS*i) {
			       bTrue = IsEqual(hStrings[i], szDisplayString);
			       SetBoxColor(bTrue, hBoxes[j], hBrush, FOREGROUND, BACKGROUNDB);
			       bTrue = IsGreaterEqual(hStrings[i], szDisplayString);
			       SetBoxColor(bTrue, hBoxes[j+1], hBrush, FOREGROUND, BACKGROUNDB);
			       bTrue = IsGreater(hStrings[i], szDisplayString);
			       SetBoxColor(bTrue, hBoxes[j+2], hBrush, FOREGROUND, BACKGROUNDB);
			       bTrue = IsLesserEqual(hStrings[i], szDisplayString);
			       SetBoxColor(bTrue, hBoxes[j+3], hBrush, FOREGROUND, BACKGROUNDB);
			       bTrue = IsLesser(hStrings[i], szDisplayString);
			       SetBoxColor(bTrue, hBoxes[j+4], hBrush, FOREGROUND, BACKGROUNDB);
			   } // EO for (i = 0

		      } // EO case WTF_IDD_COMPARE
		      break;

		      case WTF_IDD_OK: {
			   int  i, j;
/*
   Compare the display string with the strings in the edit controls.
   The comparison ignores the case.   Color the grid controls according
   to the value of bTrue.
*/
			   for (i = 0, j = 0; i < MAXSTRINGS; i++, j = MAXSTRINGS*i) {
			       bTrue = IsEquali(hStrings[i], szDisplayString);
			       SetBoxColor(bTrue, hBoxes[j], hBrush, FOREGROUND, BACKGROUNDB);
			       bTrue = IsGreaterEquali(hStrings[i], szDisplayString);
			       SetBoxColor(bTrue, hBoxes[j+1], hBrush, FOREGROUND, BACKGROUNDB);
			       bTrue = IsGreateri(hStrings[i], szDisplayString);
			       SetBoxColor(bTrue, hBoxes[j+2], hBrush, FOREGROUND, BACKGROUNDB);
			       bTrue = IsLesserEquali(hStrings[i], szDisplayString);
			       SetBoxColor(bTrue, hBoxes[j+3], hBrush, FOREGROUND, BACKGROUNDB);
			       bTrue = IsLesseri(hStrings[i], szDisplayString);
			       SetBoxColor(bTrue, hBoxes[j+4], hBrush, FOREGROUND, BACKGROUNDB);
			   } // EO for (i = 0

		      } // EO case WTF_IDD_OK
		      break;

	       } // EO switch(wParam)
	       break;
   } // EO switch (wMsg)
return 0;
} // EO CompareStringsDlgProc()
