#include <windows.h>

#include <wintfmt.h>
#include <wtfdefs.h>
#include <wtfdemop.h>

extern HWND hDialog;

#pragma argsused
int FAR PASCAL _export DateDlgProc(HWND hDlg,
				   WORD wMsg,
				   WORD wParam,
				   LONG lParam)
{
   static HWND hDates[MAXDATES];
   static char szBuffers[MAXDATES][MAXDATESIZE];
   static char szDates[MAXDATES][MAXDATESIZE] = { {"31121999"},
						  {"20001231"},
						  {"220299"  },
						  {"930125"  },
						  {"20000101"} };
   static char szDateString[] = "19921231";
   int iErrVal;

   switch (wMsg) {
	  case WM_INITDIALOG:
	       hDialog =  hDlg;
/*
   Get the handles for the edit controls.
*/
	       if ((iErrVal = GetHandlesForControls(hDlg,
						    WTF_IDD_DATE1,
						    MAXDATES,
						    (unsigned int FAR *) &hDates[0])) < 0)
	       return QuitDialog(iErrVal, 0);
	  break;

	  case WM_CLOSE:
	  return QuitDialog(1, 0);

	  case WM_COMMAND:
	       switch (wParam) {
		      case WTF_IDD_EXIT:
		      return QuitDialog(1, 0);

		      case WTF_IDD_SET: {
			   DisplayMessage(1,
					  IDS_SETDATE1,
					  (LPSTR) szDateString);
/*
   Pass a date in file format CCYYMMDD, rearrange the digits according
   to the window format and write the date to the edit controls.
*/
			   if ((iErrVal = SetDateToControls((LPSTR) szDateString,
							    MAXDATES,
							    (int FAR *) &hDates[0])) < 0)
			   return QuitDialog(iErrVal, 0);
		      } // EO case
		      break;

		      case WTF_IDD_OK:
/*
   Write the default dates to the edit controls.
*/
			   if ((iErrVal = SetStringsToControls((LPSTR) szDates,
							       MAXDATES,
							       MAXDATESIZE,
							       (int FAR *) &hDates[0])) < 0)
			   return QuitDialog(iErrVal, 0);
		      break;

		      case WTF_IDD_GET: {
			   int i;
			   LPSTR lpBuffer = &szBuffers[0][0];
/*
   Get the dates from the edit controls.  Reformat the contents
   and return a string in the file format CCYYMMDD.
*/
			   for (i = 0; i < PREDEFINED; i++, lpBuffer += MAXDATESIZE) {
			       if ((iErrVal = GetDate(hDates[i],
						      lpBuffer,
						      MAXDATESIZE)) < 0)
			       return QuitDialog(iErrVal, 0);
			   } // EO for
/*
   Display the dates from the edit controls.
*/
			   DisplayMessage(2,
					  IDS_GETDATE1,
					  IDS_GETDATE2,
					  (LPSTR) szBuffers[0],
					  (LPSTR) szBuffers[1],
					  (LPSTR) szBuffers[2],
					  (LPSTR) szBuffers[3],
					  (LPSTR) szBuffers[4]);
		      } // EO case WTF_IDD_GET
		      break;

	       } // EO switch(wParam)
	       break;
   } // EO switch (wMsg)
return 0;
} // EO UserDefinedDlgProc()

