#include <windows.h>

#include <wintfmt.h>
#include <wtfdefs.h>
#include <wtfdemop.h>

extern HWND hDialog;

#pragma argsused
int FAR PASCAL _export DemoDlgProc(HWND hDlg,
				   WORD wMsg,
				   WORD wParam,
				   LONG lParam)
{
   static HWND   hControls[PREDEFINED];
   static HBRUSH hBrushes[4];
   static char   szBuffers[PREDEFINED][STRINGLEN];
   static char   szTextPlusFormat[PREDEFINED][STRINGLEN];
   static char   szStrings[PREDEFINED][STRINGLEN] = { {"5105551212"},  // phone number
						      {"123456789"},   // social security #
						      {"123199"},      // date
						      {"12311999"},    // date with century
						      {"98765"},       // 5 digit zip code
						      {"987654321"},   // 9 digit zip code
						      {"1234567.89"},  // numeric
						      {"99.99"} };     // currency
   switch (wMsg) {
	  case WM_INITDIALOG: {
	       int iErrVal;
	       hDialog =  hDlg;
/*
   Get the handles for the edit controls.
*/
	       if ((iErrVal = GetHandlesForControls(hDlg,
						    WTF_IDD_USPHONE,
						    PREDEFINED,
						    (unsigned int FAR *) &hControls[0])) < 0)
	       return QuitDialog(iErrVal, 0);
/*
   Create handles to red, yellow, green and blue brushes for the WinTfmt
   edit control colors.
*/
	       hBrushes[0] = CreateSolidBrush(BACKGROUNDR);
	       hBrushes[1] = CreateSolidBrush(BACKGROUNDY);
	       hBrushes[2] = CreateSolidBrush(BACKGROUNDG);
	       hBrushes[3] = CreateSolidBrush(BACKGROUNDB);
	  } // EO case
	  break;

	  case WM_CLOSE: {
	       int i;
	       for (i = 0; i < 4; i++)
		   DeleteObject(hBrushes[i]);

	  return QuitDialog(1, 0);
	  } // EO case
/*
   Color WinTfmt fields for which SetFmtColors() has been called.
*/
	  case WM_CTLCOLOR:
	  return ColorFmt(wParam, lParam);

	  case WM_COMMAND:
	       switch (wParam) {

/*
   Register the foreground and background colors for each WinTfmt edit
   control.  SetFmtColors() can only fail if the handle to the window
   is invalid.
*/
		      case WTF_IDD_COLOR:
			   SetFmtColors(hControls[0], FOREGROUND, BACKGROUNDR, hBrushes[0]);
			   SetFmtColors(hControls[1], FOREGROUND, BACKGROUNDY, hBrushes[1]);
			   SetFmtColors(hControls[2], FOREGROUND, BACKGROUNDG, hBrushes[2]);
			   SetFmtColors(hControls[3], FOREGROUND, BACKGROUNDB, hBrushes[3]);
			   SetFmtColors(hControls[4], FOREGROUND, BACKGROUNDR, hBrushes[0]);
			   SetFmtColors(hControls[5], FOREGROUND, BACKGROUNDY, hBrushes[1]);
			   SetFmtColors(hControls[6], FOREGROUND, BACKGROUNDG, hBrushes[2]);
			   SetFmtColors(hControls[7], FOREGROUND, BACKGROUNDB, hBrushes[3]);
		      break;

		      case WTF_IDD_RESET: {
			   int i, iErrVal;

			   for (i = 0; i < PREDEFINED; i++) {
/*
   Set the brush, background and foreground colors for all the WinTfmt
   edit controls to be NULL.
*/
			       SetFmtColors(hControls[i], 0, 0, 0);
/*
   Reset the contents of the edit control to the format characters.
   (e.g. __/__/__ for a date)
*/
			       if ((iErrVal = ResetFmt(hControls[i])) < 0)
			       return QuitDialog(iErrVal, 0);
			   } // EO for
		      } // EO  case
		      break;

		      case WTF_IDD_SET: {
			   int iErrVal;
/*
   Write the default strings to the edit controls.
*/
			   if ((iErrVal = SetStringsToControls((LPSTR) szStrings,
							       PREDEFINED,
							       STRINGLEN,
							       (int FAR *) &hControls[0])) < 0)
			   return QuitDialog(iErrVal, 0);
		      } // EO case WTF_IDD_SET
		      break;

		      case WTF_IDD_SHOW: {
			   int  i, iErrVal, iID;
			   LPSTR lpBuffer = &szBuffers[0][0];
			   LPSTR lpText   = &szTextPlusFormat[0][0];
/*
   Get the text from the edit controls, not including the format characters.
*/
			   for (i = 0; i < PREDEFINED; i++, lpBuffer += STRINGLEN) {
			       if ((iErrVal = GetFmt(hControls[i],
						     lpBuffer,
						     STRINGLEN)) < 0)
			       return QuitDialog(iErrVal, 0);
			   } // EO for
/*
   Get the text from the edit controls, including the format characters,
   for comparison
*/
			   for (i = 0, iID = WTF_IDD_USPHONE; i < PREDEFINED; i++, iID++, lpText += STRINGLEN) {
			       if ((iErrVal = GetDlgItemText(hDlg,
							     iID,
							     lpText,
							     STRINGLEN)) < 0)
			       return QuitDialog(iErrVal, 0);
			   } // EO for
/*
   Display Message box with the values retrieved from the edit controls.
*/
			   DisplayMessage(4,
					  IDS_GETFMT1,
					  IDS_GETFMT2,
					  IDS_GETFMT3,
					  IDS_GETFMT4,
					  (LPSTR) szBuffers[0],
					  (LPSTR) szBuffers[1],
					  (LPSTR) szBuffers[2],
					  (LPSTR) szBuffers[3],
					  (LPSTR) szBuffers[4],
					  (LPSTR) szBuffers[5],
					  (LPSTR) szBuffers[6],
					  (LPSTR) szBuffers[7],
					  (LPSTR) szTextPlusFormat[0],
					  (LPSTR) szTextPlusFormat[1],
					  (LPSTR) szTextPlusFormat[2],
					  (LPSTR) szTextPlusFormat[3],
					  (LPSTR) szTextPlusFormat[4],
					  (LPSTR) szTextPlusFormat[5],
					  (LPSTR) szTextPlusFormat[6],
					  (LPSTR) szTextPlusFormat[7]);

		      } // EO case WTF_IDD_SHOW
		      break;
		      case WTF_IDD_EXIT: {
			   int i;
			   for (i = 0; i < 4; i++)
			       DeleteObject(hBrushes[i]);
		      return QuitDialog(1, 0);
		      } // EO case
	       } // EO switch(wParam)
	       break;
   } // EO switch (wMsg)
return 0;
} // EO DemoDlgProc()

