#include <windows.h>

#include <wintfmt.h>
#define  SCREENWRITE
#include <wtfdefs.h>
#include <wtfdemop.h>

extern HWND hDialog;

#pragma argsused
int FAR PASCAL _export NumericDlgProc(HWND hDlg,
				      WORD wMsg,
				      WORD wParam,
				      LONG lParam)
{
   static HWND hNumbers[MAXNUMBERS];
   static char szNumbers[MAXNUMBERS][MAXNUMBERSIZE] = { {"1234"},
							{"123456.78901"},
							{"123.4567890"},
							{"876543.21"},
							{"9876543.21"},
							{"543.21"} };
   switch (wMsg) {
	  case WM_INITDIALOG: {
	       int iErrVal;
	       hDialog = hDlg;
/*
   Get the handles for the edit controls.
*/
	       if ((iErrVal = GetHandlesForControls(hDlg,
						    WTF_IDD_NEWNUM1,
						    MAXNUMBERS,
						    (unsigned int FAR *) &hNumbers[0])) < 0)
	       return QuitDialog(iErrVal, 0);
/*
   Write the default values, for the WinTfmt numeric edit controls
   (Signed/Left Minus/Read Write) to the static text controls.
*/
	       SetDlgItemText(hDlg, WTF_IDD_SIGNED, (LPSTR) szSigned);
	       SetDlgItemText(hDlg, WTF_IDD_MINUS, (LPSTR) szMinusLeft);
	       SetDlgItemText(hDlg, WTF_IDD_WRITE, (LPSTR) szReadWrite);
	  break;
	  } // EO case WM_INITDIALOG

	  case WM_CLOSE:
	  return QuitDialog(1, 0);

	  case WM_COMMAND:
	       switch (wParam) {
		      case WTF_IDD_EXIT:
		      return QuitDialog(1, 0);

		      case WTF_IDD_OK: {
			   int iErrVal;
/*
   Write the default numeric values to the edit controls.
*/
			   if ((iErrVal = SetStringsToControls((LPSTR) szNumbers,
							       MAXNUMBERS,
							       MAXNUMBERSIZE,
							       (int FAR *) &hNumbers[0])) < 0)
			   return QuitDialog(iErrVal, 0);
		      } // EO case
		      break;

		      case WTF_IDD_UNSIGN: {
			   int i;
/*
   Set all the numeric fields to be unsigned.  The return value from OffSign()
   is TRUE if the handle is valid, and FALSE if it is not.  It might be a good
   idea to check the return value during development.
*/
			   for (i = 0; i < MAXNUMBERS; i++)
			       OffSign(hNumbers[i]);
/*
   Write the string "Unsigned" to the static control.
*/
			   SetDlgItemText(hDlg, WTF_IDD_SIGNED, (LPSTR) szUnsigned);
		      } // EO case WTF_IDD_UNSIGN
		      break;

		      case WTF_IDD_SIGN: {
			   int i;
/*
   Reset all the numeric fields to be signed.  The return value from
   OnSign() is TRUE if the handle is valid, and FALSE if it is not.
*/
			   for (i = 0; i < MAXNUMBERS; i++)
			       OnSign(hNumbers[i]);
/*
   Write the string "Signed" to the static control.
*/
			   SetDlgItemText(hDlg, WTF_IDD_SIGNED, (LPSTR) szSigned);
		      } // EO case
		      break;
		      case WTF_IDD_RONLY: {
			   int i;
/*
   Set all the numeric fields to be read only.  The return value from
   OffWrite() is TRUE if the handle is valid, and FALSE if it is not.
*/
			   for (i = 0; i < MAXNUMBERS; i++)
			       OffWrite(hNumbers[i]);
/*
   Write the string "Read Only" to the static control.
*/
			   SetDlgItemText(hDlg, WTF_IDD_WRITE, (LPSTR) szReadOnly);
		      } // EO case
		      break;
		      case WTF_IDD_RW: {
			   int i;
/*
   Reset all the numeric fields to be Read/Write.  The return value from
   OnWrite() is TRUE if the handle is valid, and FALSE if it is not.
*/
			   for (i = 0; i < MAXNUMBERS; i++)
			       OnWrite(hNumbers[i]);
/*
   Write the string "Read/Write" to the static control.
*/
			   SetDlgItemText(hDlg, WTF_IDD_WRITE, (LPSTR) szReadWrite);
		      } // EO case
		      break;
		      case WTF_IDD_FINANCE: {
			   int i;
/*
   Set all the numeric fields to display a negative value with parenthesis.
   The return value from MinusFinance() is TRUE if the handle is valid,
   and FALSE if it is not.
*/
			   for (i = 0; i < MAXNUMBERS; i++)
			       MinusFinance(hNumbers[i]);
/*
   Write the string "Minus Finance" to the static control.
*/
			   SetDlgItemText(hDlg, WTF_IDD_MINUS, (LPSTR) szMinusFinance);
		      } // EO case
		      break;
		      case WTF_IDD_RIGHT: {
			   int i;
/*
   Set all the numeric fields to display a negative value with the minus
   sign to the right of the number.  The return value from MinusRight()
   is TRUE if the handle is valid, and FALSE if it is not.
*/
			   for (i = 0; i < MAXNUMBERS; i++)
			       MinusRight(hNumbers[i]);
/*
   Write the string "Right Minus" to the static control.
*/
			   SetDlgItemText(hDlg, WTF_IDD_MINUS, (LPSTR) szMinusRight);
		      } // EO case
		      break;
		      case WTF_IDD_LEFT: {
			   int i;
/*
   Reset all the numeric fields to display a negative value with the minus
   sign to the left of the number.  The return value from MinusLeft() is
   TRUE if the handle is valid, and FALSE if it is not.
*/
			   for (i = 0; i < MAXNUMBERS; i++)
			       MinusLeft(hNumbers[i]);
/*
   Write the string "Left Minus" to the static control.
*/
			   SetDlgItemText(hDlg, WTF_IDD_MINUS, (LPSTR) szMinusLeft);
		      } // EO case
		      break;
	       } // EO switch(wParam)
	       break;
   } // EO switch (wMsg)
return 0;
} // EO UserNumericDlgProc()

