#include <windows.h>
#include <stdarg.h>
#include <dos.h>
#include <stdlib.h>

#include <wintfmt.h>
#define SETUP
#include <wtfdefs.h>
#include <wtfdemop.h>

HWND   hDialog;
static HANDLE hInst;

#pragma argsused
int PASCAL WinMain(HANDLE hInstance,
		   HANDLE hPrevInstance,
		   LPSTR  lpszCmdLine,
		   int    cmdShow)
{
   HWND     hwnd;
   MSG      msg;
   WNDCLASS wndclass;

   if (!hPrevInstance) {
      wndclass.lpszClassName    = szClassName;
      wndclass.hInstance        = hInstance;
      wndclass.lpfnWndProc      = MainWTFDemoProc;
      wndclass.hCursor          = NULL;
      wndclass.hIcon            = LoadIcon(hInstance, (LPCSTR) "WTF_DEMO_MAINICON");
      wndclass.lpszMenuName     = MAKEINTRESOURCE(WTF_DEMO_MENU);
      wndclass.hbrBackground    = COLOR_WINDOW + 1;
      wndclass.style            = NULL;
      wndclass.cbClsExtra       = 0;
      wndclass.cbWndExtra       = 0;

      RegisterClass(&wndclass);
   } // if (!hPrevInstance)

   hInst = hInstance;

   hwnd = CreateWindow(szClassName,
		       szProcHead,
		       WS_OVERLAPPEDWINDOW,
		       CW_USEDEFAULT,
		       0,
		       CW_USEDEFAULT,
		       0,
		       NULL,
		       NULL,
		       hInstance,
		       NULL);

   ShowWindow(hwnd, TRUE);

   while (GetMessage(&msg,0,0,0)) {
	 TranslateMessage(&msg);
	 DispatchMessage(&msg);
   } // while (GetMessage())

return 0;
} // EO WinMain()


LONG FAR PASCAL _export MainWTFDemoProc(HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
   int iErrVal;

   switch (wMsg) {
	  case WM_CREATE: {
	       unsigned char szSymbol[3] = "  ";
	       unsigned char szSymbol2[5] = "";
	       hWindow = hWnd;
/*
   Seup the WinTfmt environment.
*/
	       if (StartFmt(hInst, hWnd) != 1) {
		  DisplayMessage(1,
				 IDS_STARTFMT);
	       return DestroyWindow(hWnd);
	       } // EO if (StartFmt() != 1
/*
   Create new numeric classes and formats.  NewNumber() requires the handle
   to the instance, handle to the parent window, name of the window class,
   total number of digits in the format and the number of decimals.
*/
	       if ((iErrVal = NewNumber(hInst,
					hWnd,
					szNewNumber0Class,
					13,              /* 13 digits, total */
					6)) <= 0)        /* 6 decimals */
	       return QuitDemo(iErrVal);
	       if ((iErrVal = NewNumber(hInst,
					hWnd,
					szNewNumber1Class,
					4,
					0)) <= 0)
	       return QuitDemo(iErrVal);
	       if ((iErrVal = NewNumber(hInst,
					hWnd,
					szNewNumber2Class,
					11,
					5)) <= 0)
	       return QuitDemo(iErrVal);
	       if ((iErrVal = NewNumber(hInst,
					hWnd,
					szNewNumber3Class,
					10,
					7)) <= 0)
	       return QuitDemo(iErrVal);
	       if ((iErrVal = NewNumber(hInst,
					hWnd,
					szBoxClass,
					2,
					0)) < 0)
	       return QuitDemo(iErrVal);
/*
   Create new currency classes and formats.  NewCurrency() requires the
   handle to the instance, handle to the parent window, name of the window
   class, the currency symbol, total number of digits in the format and the
   number of decimal digits.
*/
	       szSymbol[0] = JAPANESEYEN;
	       if ((iErrVal = NewCurrency(hInst,
					  hWnd,
					  szCurrency1,
					  szSymbol,
					  8,
					  2)) <= 0)
	       return QuitDemo(iErrVal);
	       szSymbol[0] = BRITPOUND;
	       if ((iErrVal = NewCurrency(hInst,
					  hWnd,
					  szCurrency2,
					  szSymbol,
					  9,
					  2)) <= 0)
	       return QuitDemo(iErrVal);
	       lstrcpy((LPSTR) szSymbol2, (LPSTR) "FFR ");
	       if ((iErrVal = NewCurrency(hInst,
					  hWnd,
					  szCurrency3,
					  szSymbol2,
					  5,
					  2)) <= 0)
	       return QuitDemo(iErrVal);
/*
   Create new date classes and formats.  NewFmt() requires the handle to the
   instance, handle to the parent window, name of the window class, and the
   format specification.
*/
	       if ((iErrVal = NewFmt(hInst,
				     hWnd,
				     szDate1Class,
				     szDate1Fmt)) < 0)
	       return QuitDemo(iErrVal);
	       if ((iErrVal = NewFmt(hInst,
				     hWnd,
				     szDate2Class,
				     szDate2Fmt)) < 0)
	       return QuitDemo(iErrVal);
	       if ((iErrVal = NewFmt(hInst,
				     hWnd,
				     szDate3Class,
				     szDate3Fmt)) < 0)
	       return QuitDemo(iErrVal);
	       if ((iErrVal = NewFmt(hInst,
				     hWnd,
				     szDate4Class,
				     szDate4Fmt)) < 0)
	       return QuitDemo(iErrVal);
	       if ((iErrVal = NewFmt(hInst,
				     hWnd,
				     szDate5Class,
				     szDate5Fmt)) < 0)
	       return QuitDemo(iErrVal);
/*
   Create new generic character format and class.
*/
	       if ((iErrVal = NewFmt(hInst,
				     hWnd,
				     szString1Class,
				     szString1Format)) < 0)
	       return QuitDemo(iErrVal);
	  } // EO case
	  break;

	  case WM_CLOSE:
	       QuitDemo(1);
	  break;

	  case WM_COMMAND:
	       switch (wParam) {
		      case WTF_IDM_DEMO: {
			   lpfnDlg = MakeProcInstance(DemoDlgProc,
						      hInst);
			   if ((iErrVal = DialogBox(hInst,
						    MAKEINTRESOURCE(WTF_DLG_DEMO),
						    hWnd,
						    lpfnDlg)) < 0)
			   return iErrVal;

			   FreeProcInstance(lpfnDlg);
		      } // EO WTF_IDM_DEMO
		      break;
		      case WTF_IDM_USER: {
			   lpfnDlg = MakeProcInstance(DateDlgProc,
						      hInst);
			   if ((iErrVal = DialogBox(hInst,
						    MAKEINTRESOURCE(WTF_DLG_USER),
						    hWnd,
						    lpfnDlg)) < 0)
			   return iErrVal;

			   FreeProcInstance(lpfnDlg);
		      } // EO WTF_IDM_DATE
		      break;

		      case WTF_IDM_NUMS: {
			   lpfnDlg = MakeProcInstance(NumericDlgProc,
						      hInst);
			   if ((iErrVal = DialogBox(hInst,
						    MAKEINTRESOURCE(WTF_DLG_NUMS),
						    hWnd,
						    lpfnDlg)) < 0)
			   return iErrVal;

			   FreeProcInstance(lpfnDlg);
		      } // EO WTF_IDM_DATE
		      break;

		      case WTF_IDM_COMPARE_DATES: {
			   lpfnDlg = MakeProcInstance(CompareDatesDlgProc,
						      hInst);
			   if ((iErrVal = DialogBox(hInst,
						    MAKEINTRESOURCE(WTF_DLG_COMPARE_DATES),
						    hWnd,
						    lpfnDlg)) < 0)
			   return iErrVal;

			   FreeProcInstance(lpfnDlg);
		      } // EO WTF_IDM_COMPARE_DATES
		      break;

		      case WTF_IDM_COMPARE_STRINGS: {
			   lpfnDlg = MakeProcInstance(CompareStringsDlgProc,
						      hInst);
			   if ((iErrVal = DialogBox(hInst,
						    MAKEINTRESOURCE(WTF_DLG_COMPARE_STRINGS),
						    hWnd,
						    lpfnDlg)) < 0)
			   return iErrVal;

			   FreeProcInstance(lpfnDlg);
		      } // EO WTF_IDM_COMPARE_STRINGS
		      break;

		      case WTF_IDM_COMPARE_NUMERIC: {
			   lpfnDlg = MakeProcInstance(CompareNumericDlgProc,
						      hInst);
			   if ((iErrVal = DialogBox(hInst,
						    MAKEINTRESOURCE(WTF_DLG_COMPARE_NUMERIC),
						    hWnd,
						    lpfnDlg)) < 0)
			   return iErrVal;

			   FreeProcInstance(lpfnDlg);
		      } // EO WTF_IDM_COMPARE_NUMERIC
		      break;

		      case WTF_IDM_EXIT:
			   QuitDemo(1);
		      break;
	       } // EO switch (wParam)
	  break;
	  default:
	  return DefWindowProc(hWnd, wMsg, wParam, lParam);
   } // EO switch(wMsg)
return 0;
} // EO MainWTFDemoProc()


void DisplayMessage(int iNumber,
		    ...)
{
   int     i;
   WORD    wID;
   char    szFormat[257] = "", szBuffer[1028] = "";
   char    szMessage[1028] = "";
   va_list val;

   va_start(val, iNumber);

   for (i = 0; i < iNumber; i++) {
       wID = va_arg(val, WORD);
       if (!LoadString(hInst,
		       wID,
		       (LPSTR) szFormat,
		       sizeof(szFormat))) {
	  MessageBox(hDialog,
		     (LPSTR) "String not in STRINGTABLE.",
		     (LPSTR) "WinTfmt Demo Program",
		     MB_OK | MB_ICONSTOP);
	  va_end(val);
       return;
       } // EO if (!LoadString)
       lstrcat((LPSTR) szBuffer, (LPSTR) szFormat);
   } // EO for

   wvsprintf((LPSTR) szMessage,
	     (LPSTR) szBuffer,
	     val);

   MessageBox(hDialog,
	      (LPSTR) szMessage,
	      (LPSTR) "WinTfmt Demo Program",
	      MB_OK | MB_ICONINFORMATION);

   va_end(val);
} // EO DisplayMessage()


int QuitDialog(int    i,
	       HBRUSH hBrush)
{
   if (i < 0)
      DisplayMessage(1,
		     IDS_ERROREXIT,
		     i);

   if (hBrush)
      DeleteObject(hBrush);

   EndDialog(hDialog,
	     0);

return i;
} // EO QuitDialog()


int QuitDemo(int  i)
{
   if (i < 0)
      DisplayMessage(1,
		     IDS_ERROREXIT,
		     i);
/*
   Release memory associated with application defined classes.
*/
   EndFmt(hInst);
   DestroyWindow(hWindow);

return i;
} // EO QuitDemo()

