#include <windows.h>

#include <wintfmt.h>


int GetHandlesForControls(HWND hDialog,
			  int  wFirstID,
			  int  wMaxHandles,
			  unsigned int FAR *handle)
{
   int i, j;
/*
   Get the handles for the controls.
*/
   for (i = 0, j = wFirstID; i < wMaxHandles; i++, j++, handle++) {
       if ((*handle = GetDlgItem(hDialog,
				 j)) == NULL)
       return WTF_ERR_HANDLE2CTL;
   } // EO for
return 1;
} // EO GetHandlesForControls()

int SetStringsToControls(LPSTR    lpStrings,
			 int      iCount,
			 int      iStringLen,
			 int FAR *hStringCtl)
{
   int iErrVal, i;
/*
   Set strings to the WinTfmt edit controls.
*/
   for (i = 0; i < iCount; i++, hStringCtl++, lpStrings+=iStringLen) {
       if ((iErrVal = SetFmt(*hStringCtl,
			     lpStrings,
			     iStringLen)) < 0)
       return (iErrVal);
   } // EO for
return 1;
} // EO SetStringsToControls()

int SetDateToControls(LPSTR    lpDate,
		      int      iCount,
		      int FAR *hDateCtl)
{
   int iErrVal, i;
/*
   Take a date in file format CCYYMMDD, rearrange the digits according
   to the window class format and write the date to the edit control.
*/
   for (i = 0; i < iCount; i++, hDateCtl++) {
       if ((iErrVal = SetDate(*hDateCtl,
			      lpDate,
			      lstrlen(lpDate))) < 0)
       return iErrVal;
   } // EO for

return 1;
} // EO SetDateToControls()


void SetBoxColor(BOOL     bTrue,
		 HWND     hBox,
		 HBRUSH   hBrush,
		 COLORREF cForeground,
		 COLORREF cBackground)
{
/*
   Color the grid controls according to the value of bTrue.  If bTrue is
   TRUE, set the foreground and background colors to the values received,
   otherwise, reset the brush, background and foreground colors to the
   default.  SetFmtColors() can only fail if the handle is invalid.
*/

   if (bTrue)
      SetFmtColors(hBox, cForeground, cBackground, hBrush);
   else
      SetFmtColors(hBox, 0, 0, 0);
} // EO SetBoxColor()


BOOL SetGridControlsToReadOnly(int FAR *hGrid,
			       int      iCount)
{
   int i;
/*
   Set the grid controls to read only.  OffWrite() can only fail if
   the handle is invalid.
*/
   for (i = 0; i < iCount; i++, hGrid++) {
       if (!OffWrite(*hGrid))
       return FALSE;
   } // EO for

return TRUE;
} // EO SetGridControlsToReadOnly()
