#include <windows.h>
#include <excpt.h>
#include <stdio.h>
#include <stdlib.h>
#include "getnextw.h"

HANDLE hInst;
HANDLE hWnd, hWndCurrent, hWndSafe;

int APIENTRY WinMain (HANDLE hInstance,
                      HANDLE hPrevInstance,
                      LPSTR  lpCmdLine,
                      int    nCmdShow)
{
  MSG  msg;
  WNDCLASS wc;

  UNREFERENCED_PARAMETER( lpCmdLine );
  UNREFERENCED_PARAMETER( hPrevInstance );

  hInst = hInstance;

  wc.style = NULL;
  wc.lpfnWndProc = (WNDPROC)MainWndProc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = hInstance;
  wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);
  wc.hCursor = LoadCursor (NULL, IDC_ARROW);
  wc.hbrBackground = GetStockObject (WHITE_BRUSH);
  wc.lpszMenuName = "getnextw_Menu";
  wc.lpszClassName = "getnextwWClass";

  RegisterClass(&wc);


  hWnd = CreateWindow ("getnextwWClass",
		       "GetNextWindow Sample",
		       WS_CLIPCHILDREN | WS_OVERLAPPEDWINDOW,
                       CW_USEDEFAULT,
                       CW_USEDEFAULT,
                       CW_USEDEFAULT,
                       CW_USEDEFAULT,
                       NULL,
                       NULL,
                       hInstance,
                       NULL);


  hWndCurrent = hWnd;

  ShowWindow(hWnd, nCmdShow);

  while (GetMessage (&msg, NULL, NULL, NULL))
    DispatchMessage (&msg);      // Dispatch message to window.

  return (msg.wParam);           // Returns value from PostQuitMessage.

}




LONG APIENTRY MainWndProc (HWND hwnd,
                           UINT message,
                           UINT wParam,
                           LONG lParam)
{


  switch (message)
      {
	 case WM_COMMAND:
	   switch (LOWORD(wParam))
	     {
	     case IDM_NEXT:
		{
		CHAR Buf[80];
		CHAR Buf2[80];

		hWndSafe = GetNextWindow (hWndCurrent, GW_HWNDNEXT);
		if (hWndSafe)
		  {
		  hWndCurrent = hWndSafe;
		  sprintf(Buf, "Window handle value = 0x%08x", hWndCurrent);
		  GetWindowText (hWndCurrent, Buf2, 80);
		  MessageBox (NULL, Buf2, Buf, MB_OK);
		  SetFocus (hWndCurrent);
		  }
		 else
		  {
		   MessageBox (NULL, "GetNextWindow GW_HWNDNEXT returned NULL",
			       "Information", MB_OK);
		  }
		}
		break;


	     case IDM_PREV:
		{
		CHAR Buf[80];
		CHAR Buf2[80];
		hWndSafe = GetNextWindow (hWndCurrent, GW_HWNDPREV);
		if (hWndSafe)
		  {
		  hWndCurrent = hWndSafe;
		  sprintf(Buf, "Window handle value = 0x%08x", hWndCurrent);
		  GetWindowText (hWndCurrent, Buf2, 80);
		  MessageBox (NULL, Buf2, Buf, MB_OK);
		  SetFocus (hWndCurrent);
		  }
		 else
		  {
		   MessageBox (NULL, "GetNextWindow GW_HWNDPREV returned NULL",
			       "Information", MB_OK);
		  }
		}
		break;




	     }
	       return (0);

        case WM_DESTROY:
          PostQuitMessage(0);
          return (0);


       }
    return DefWindowProc (hwnd, message, wParam, lParam);
}
