// ************************************************************************
// MODULE    : MinDll.C
// PURPOSE   : A simple Win32 DLL
// FUNCTIONS :
//   DllEntryPoint - main DLL entry point
//   MyPrintF      - aliased printf()
//   MyBeep        - Generates a beep
// COMMENTS  :
//
// ************************************************************************
#define  STRICT
#include <Windows.H>
#include "MinDll.H"


// ************************************************************************
// FUNCTION : DllEntryPoint( HANDLE, DWORD, LPVOID )
// PURPOSE  : DllEntryPoint is called by Windows when the DLL is entered
//            via a "Process Attach", "Thread Attach", "Thread Detach" or a
//            "Process Detach".
// ************************************************************************
BOOL WINAPI
DllEntryPoint( HANDLE hDll, DWORD dwReason, LPVOID lpReserved )
{
  UNREFERENCED_PARAMETER( hDll );
  UNREFERENCED_PARAMETER( lpReserved );

  switch( dwReason ) {
    case DLL_PROCESS_ATTACH:
      // initialize any instance data or allocate a TLS (thread local
      // storage) index using the TlsAlloc API
      break;

    case DLL_THREAD_ATTACH:
      // initialize a TLS slot
      break;

    case DLL_THREAD_DETACH:
      // free a TLS slot
      break;

    case DLL_PROCESS_DETACH:
      // return and TLS indexes allocated by using the TlsFree API and free
      // any thread local data
      break;
  }

  return TRUE;
}


//***************************************************************************
// FUNCTION : MyBeep( )
// PURPOSE  : Generate a simple beep
//***************************************************************************
BOOL
MyBeep()
{
  return( Beep( 0x100, 1000 ) );
}
