//---------------------------------------------------------------------
// b4log.cpp	3-9-93-93	djf
// B4DEventLog class definitiion
//
// This class controls access to the  event log in the registry
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// includes
//---------------------------------------------------------------------

#include <string.h>
#include "B4DLog.h"	// class definition

//---------------------------------------------------------------------
// constants
//---------------------------------------------------------------------

B4DEventLog::B4DEventLog
	( 
	const char * pszSourceName,
	const char * pszMessageFile
	)
:
hSource(0)
{
// Adding a Source to the Registry

// You can use the default Application event log without adding your 
// source name to the registry. However, the event viewer will not be 
// able to map your event ID codes to message strings unless you 
// register your source and provide a message-file name. 
// You can add a new source name to the registry by opening a new 
// registry subkey under the Application key, and adding registry 
// values to the new subkey. The following code opens a new source 
// name called pszSourceName and adds a message-file name and 
// supported-types bitmask to the new subkey: 

	HKEY hKey;
	char szBuf[256];
	static const char * SUBKEY_PATH =		
		"SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\";
    /*
     * Add our source name as a subkey under the "Application"
     * key in the eventlog service portion of the registry.
     */

	strcpy( szBuf, SUBKEY_PATH );
	strcat( szBuf, pszSourceName );
	DWORD dwKeyDisposition;
	long lResult =
		RegCreateKeyEx
			(
			HKEY_LOCAL_MACHINE,			// handle to open key
			szBuf,						// path to subkey
			0,							// reserved - must be zero
			"???",						// class string
			REG_OPTION_NON_VOLATILE,	// special option flags
			KEY_ALL_ACCESS,				// security access mask
			NULL,						// security attributes 
            &hKey,						// return new key handle
			&dwKeyDisposition			// return disposition (new or old)
			);
	if ( lResult != ERROR_SUCCESS )
		RaiseException
			(
			lResult,
			EXCEPTION_NONCONTINUABLE,
			0,
			NULL
			);

    /* Add the event-id message file name to the subkey */
	lResult =
    	RegSetValueEx
			(
			hKey,						/* subkey handle     */
            "EventMessageFile",     	/* value name        */
            0,                      	/* must be zero      */
            REG_EXPAND_SZ,          	/* value type        */
            (LPBYTE) pszMessageFile, 	/* address of value data */
            strlen(pszMessageFile) + 1  /* length of value data  */
			);
	if ( lResult != ERROR_SUCCESS )
		RaiseException
			(
			lResult,
			EXCEPTION_NONCONTINUABLE,
			0,
			NULL
			);

    /* Set the supported types flags */
   	DWORD dwData = 
			EVENTLOG_ERROR_TYPE 
		| 	EVENTLOG_WARNING_TYPE 
		|   EVENTLOG_INFORMATION_TYPE;

	lResult =
    	RegSetValueEx
			(
			hKey,      			/* subkey handle                */
            "TypesSupported",  	/* value name                   */
            0,                 	/* must be zero                 */
            REG_DWORD,         	/* value type                   */
            (LPBYTE) &dwData,  	/* address of value data        */
            sizeof(DWORD)    	/* length of value data         */
			);
	if ( lResult != ERROR_SUCCESS )
		RaiseException
			(
			lResult,
			EXCEPTION_NONCONTINUABLE,
			0,
			NULL
			);

    RegCloseKey(hKey);

// After you have added your source name to the registry, you can use 
// the RegisterEventSource function to obtain a handle to the 
// Application event log. 

    hSource = 
		RegisterEventSource
			(
			NULL, 					/* use local machine           */
            (LPSTR) pszSourceName   /* source name                 */
			);

    if (hSource == NULL)
		RaiseException
			(
			GetLastError(),
			EXCEPTION_NONCONTINUABLE,
			0,
			NULL
			);


} // B4DEventLog::B4DEventLog()

B4DEventLog::~B4DEventLog()
{
    DeregisterEventSource(hSource);

} // B4DEventLog::~B4DEventLog()

void B4DEventLog::reportEvent
	(
	WORD fwEventType,		/* event type to log	*/
	WORD fwCategory,		/* event category	*/
	DWORD IDEvent,			/* event ID	*/
	PSID pUserSid,			/* user SID (optional)	*/
	WORD cStrings,			/* number of strings to merge with message	*/
	DWORD cbData,			/* size of raw data (in bytes)	*/
	LPTSTR *plpszStrings,	/* array of strings to merge with message	*/
	LPVOID lpvData			/* address of raw data	*/
	)
{
// ReportEvent (Win32)  

	BOOL bResult =
		ReportEvent
			(
			hSource, 
			fwEventType,		/* event type to log	*/
			fwCategory,			/* event category	*/
			IDEvent,			/* event ID	*/
			pUserSid,			/* user SID (optional)	*/
			cStrings,			/* number of strings to merge with message	*/
			cbData,				/* size of raw data (in bytes)	*/
			plpszStrings,		/* array of strings to merge with message	*/
			lpvData				/* address of raw data	*/
			);
	if ( !bResult )
		RaiseException
			(
			GetLastError(),
			EXCEPTION_NONCONTINUABLE,
			0,
			NULL
			);

} // void B4DEventLog::reportEvent()
