//---------------------------------------------------------------------
// b4log.h	3-9-93-93	djf
// B4DEventLog class definitiion
//
// This class controls access to the  event log in the registry
//---------------------------------------------------------------------

#if !defined( __B4DLOG_H )
#define __B4DLOG_H

//---------------------------------------------------------------------
// includes
//---------------------------------------------------------------------
#include <windows.h>

//---------------------------------------------------------------------
// constants
//---------------------------------------------------------------------

class B4DEventLog
{
public:
	B4DEventLog
		( 
		const char * pszSourceName,
		const char * pszMessageFile
		);
	virtual ~B4DEventLog();

	// calls the Win32 API ReportEvent() function
	// The ReportEvent function writes an entry at the end of the 
	// event log. 
	void reportEvent
		(
		WORD fwEventType,		/* event type to log	*/
		WORD fwCategory,		/* event category	*/
		DWORD IDEvent,			/* event ID	*/
		PSID pUserSid,			/* user SID (optional)	*/
		WORD cStrings,			/* number of strings to merge with message	*/
		DWORD cbData,			/* size of raw data (in bytes)	*/
		LPTSTR *plpszStrings,	/* array of strings to merge with message	*/
		LPVOID lpvData			/* address of raw data	*/
		);

private:

    HANDLE hSource;

}; // class B4DEventLog

#endif // !defined( __B4DLOG_H )
