/******************************************************************************\
*
*  PROGRAM:     MAIN.C
*
*  PURPOSE:     To test the resource-only DLL "B4DMSG.DLL".
*				This is an extension of the resdll sample in
*				the October pre-release.  I have added Message
*				Compiler and Exception Handling.
*
*  FUNCTIONS:   WinMain()     - initialization, create window, msg loop
*               MainWndProc() - processes main window msgs
*
*  COMMENTS:    
*
*
\******************************************************************************/

#include <windows.h>
#include "Main.h"
#include "b4dmsgrs.h"		// B4DMsgResource
#include "b4dlog.h"			// B4DEventLog

static B4DMsgResource	*pMessageResource=0;
static B4DEventLog     	*pEventLog=0;

static void CauseException();
static int MainExceptionFilter
	( 
	DWORD					dwExceptionCode,
	LPEXCEPTION_POINTERS	pExceptionPointers
	);

/******************************************************************************\
*
*  FUNCTION:    WinMain (standard WinMain INPUTS/RETURNS)
*
*  GLOBAL VARS: ghLib - library instance handle
*
*  LOCAL VARS:  hwnd - handle of the main standard window
*               msg  - msg to get/dispatch
*
\******************************************************************************/

int WINAPI WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpCmdLine,  int nCmdShow)
{
	HWND hwnd;
  	MSG msg;

	if ( (pMessageResource = new B4DMsgResource) == 0 )
		{
		MessageBox( NULL, "Unable to load resource DLL", __FILE__, MB_ICONSTOP | MB_OK );
		return FALSE;
		}

	if ( (pEventLog = new B4DEventLog("B4DMSG","B4DMSG.DLL")) == 0 )
		{
		MessageBox( NULL, "Unable to open event log", __FILE__, MB_ICONSTOP | MB_OK );
		return FALSE;
		}

try
	{
	if (!hPrevInstance)
  		{
    	WNDCLASS wc;

	    wc.style         = CS_HREDRAW | CS_VREDRAW;;
    	wc.lpfnWndProc   = (WNDPROC)MainWndProc;
    	wc.cbClsExtra    = 0;
    	wc.cbWndExtra    = 0;
    	wc.hInstance     = hInstance;
    	wc.hIcon         = NULL;
    	wc.hCursor       = LoadCursor( NULL, IDC_ARROW );
    	wc.hbrBackground = GetStockObject (WHITE_BRUSH);
    	wc.lpszMenuName  = NULL;
    	wc.lpszClassName = (LPCTSTR) "B4DMSG";

    	if (!RegisterClass (&wc))
    		{
      		MessageBox (NULL, (LPCTSTR) "WinMain(): RegisterClass() failed",
                  (LPCTSTR) "Err! - MAIN", MB_OK | MB_ICONEXCLAMATION);
      		return(FALSE);
    		}
  		}

	if (!(hwnd = CreateWindow ("B4DMSG", "B4DMSG DLL Sample Application",
                             WS_OVERLAPPEDWINDOW,
                             CW_USEDEFAULT, CW_USEDEFAULT,
                             CW_USEDEFAULT, CW_USEDEFAULT,
                             NULL, NULL, hInstance, NULL)))
    return (NULL);

  ShowWindow (hwnd, nCmdShow);

  while (GetMessage (&msg, NULL, NULL, NULL))
  {
    TranslateMessage (&msg);
    DispatchMessage  (&msg);
  }

	delete pMessageResource;
	delete pEventLog;
    return msg.wParam;
}
except( MainExceptionFilter( GetExceptionCode(), GetExceptionInformation() ) )
{
} // except

}

/******************************************************************************\
*
*  FUNCTION:    MainWndProc (standard window procedure INPUTS/RETURNS)
*
*  GLOBAL VARS: ghLib - library instance handle
*
*  LOCAL VARS:  hbm - handle of bitmap in THE_DLL.DLL
*
\******************************************************************************/

LRESULT CALLBACK MainWndProc (HWND hwnd, UINT message, WPARAM wParam,
                              LPARAM lParam)
{
	switch (message)
  		{
	    case WM_CHAR:
			CauseException();
      		return 0;
	    case WM_DESTROY:
			PostQuitMessage (NULL);
      		break;
    	default:
      		return (DefWindowProc(hwnd, message, wParam, lParam));
  		}

	return NULL;
}

static void CauseException()
{
	static const int ARG_COUNT = 2;
	DWORD exceptionArguments[ARG_COUNT];

	// do these guys go out of scope?
	// I don't know
	int nArg = 123;
	int * pnArg = &nArg;
	char * szArg = "aaaa";

	// pointer to pointer to char
	exceptionArguments[0] = (DWORD) &szArg; 

	// pointer to pointer to int
	exceptionArguments[1] = (DWORD) &pnArg;

	RaiseException
		(
		B4D_ERROR_DEMO,
		0, // not EXCEPTION_NONCONTINUABLE,
		ARG_COUNT,
		exceptionArguments			
		);
} // static void CauseException()

static int MainExceptionFilter
	( 
	DWORD					dwExceptionCode,
	LPEXCEPTION_POINTERS	pExceptionPointers
	)
{
	int nResult = EXCEPTION_CONTINUE_SEARCH;

	// see if it's one of ours
	// if it's a B4D Exception, display a message
	if ( HIWORD(dwExceptionCode & 0x0FFF0000) == B4D_FACILITY )
		{
		MessageBox
			(
			NULL,
			pMessageResource->get
			    ( 
			    dwExceptionCode, 
			    (va_list *) &pExceptionPointers->ExceptionRecord->ExceptionInformation 
			    ),
			"Error!",
			MB_ICONSTOP | MB_OK
			);
		pEventLog->reportEvent
			(
			EVENTLOG_ERROR_TYPE,	/* event type to log	*/
			0,						/* event category */
			dwExceptionCode,		/* event ID	*/
			NULL,					/* user SID (optional)	*/
			0,						/* number of strings to merge with message	*/
			0,						/* size of raw data (in bytes)	*/
			NULL,					/* array of strings to merge with message	*/
			NULL					/* address of raw data	*/
			);
		nResult = EXCEPTION_EXECUTE_HANDLER;
		} // if ( HIWORD(dwExceptionCode & 0x0FFF0000) == B4D_FACILITY )

	return nResult;
	
} // static int MainExceptionFilter
