/************************************************************************\
* The enclosed files, "the software," is provided by 
* Microsoft Corporation "as is" without warranty of any kind. 
* MICROSOFT DISCLAIMS ALL WARRANTIES, EITHER EXPRESS OR IMPLIED, 
* INCLUDING BUT NOT LIMITED TO IMPLIED WARRANTIES OF MERCHANTABILITY 
* AND FITNESS FOR A PARTICULAR PURPOSE.  You assume all risks of 
* using the software.
* 
* The software is Copyright (c) 1992 Microsoft Corporation.
* Original Author: John M. Hall, Microsoft SDE  9/1/92
*
* You are granted the right to freely distribute this software.
* You are granted the right to make changes provided this comment block
* is retained without modification and you acknowledge the changes.
* 
\************************************************************************/
#define DEBUG
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <windows.h>
#include <string.h>
#include <memory.h>
#include <process.h>

#define SZ_DUMMY 10

int GetRegDataBound( HKEY hkey)
{
    char chDummy[SZ_DUMMY];

    DWORD cSubKeys;    
    DWORD cbMaxSubkey; 
    DWORD cbMaxClass;  
    DWORD cValues; 
    DWORD cbMaxValueName;  
    DWORD cbMaxValueData;  
    DWORD cbSecurityDescriptor;    
    FILETIME ftLastWriteTime;
    DWORD lErr;
    DWORD cbClassSize = SZ_DUMMY;


    lErr = RegQueryInfoKey(hkey, chDummy, &cbClassSize,
            NULL, &cSubKeys, &cbMaxSubkey, &cbMaxClass,
            &cValues, &cbMaxValueName, &cbMaxValueData,
            &cbSecurityDescriptor, &ftLastWriteTime);

    if (lErr == ERROR_SUCCESS)
        return(cbMaxValueData);
    else
        return(-1);
}


main()
{
    HKEY hKeyData;
    LONG lErr;
    LPTSTR lptstr;
    int   iSize;
    DWORD dwType;
    DWORD dwSize;
    int   iIndex;

    lErr = RegOpenKeyEx( HKEY_LOCAL_MACHINE,
            "Software\\Microsoft\\Windows NT\\CurrentVersion\\Perflib\\409", 0, 
            KEY_ALL_ACCESS, &hKeyData);

    
    assert( lErr == ERROR_SUCCESS);

    iSize = GetRegDataBound(hKeyData);

    if (iSize == -1)
        exit(-1);

    iSize++;
    lptstr = malloc(iSize * sizeof(TCHAR));

    dwSize = iSize;

    lErr = RegQueryValueEx( hKeyData, "Counters", 0, &dwType,
            (LPBYTE) lptstr, &dwSize);

    assert( lErr == ERROR_SUCCESS);

    while(*lptstr)
        {
        iIndex = atoi(lptstr);
        lptstr += strlen(lptstr) + 1;
        printf("#define CNTR_%.3d\t \"%s\"\n", iIndex, lptstr);
        lptstr += strlen(lptstr) + 1;
        }



    lErr = RegCloseKey(hKeyData);
    assert( lErr == ERROR_SUCCESS);
    return(0);
}


