
//======================================//
// Perfmon-Specific Types               //
//======================================//

#include <winperf.h>

typedef PERF_DATA_BLOCK *PPERFDATA ;
typedef PERF_OBJECT_TYPE *PPERFOBJECT ;
typedef PERF_COUNTER_DEFINITION *PPERFCOUNTERDEF ;
typedef PERF_INSTANCE_DEFINITION *PPERFINSTANCEDEF ;

#define FirstObject(a)  ((PPERFOBJECT) ((PBYTE) (a) + (a)->HeaderLength))
#define NextObject(a)   ((PPERFOBJECT) ((PBYTE) (a) + (a)->TotalByteLength))
#define FirstCounter(a) ((PPERFCOUNTERDEF) ((PCHAR) (a) + (a)->HeaderLength))
#define NextCounter(a)  ((PPERFCOUNTERDEF) ((PCHAR) (a) + (a)->ByteLength))
#define FirstInstance(a) ((PPERFINSTANCEDEF) ((PCHAR) (a) + (a)->DefinitionLength))
#define GetCounterBlock(a) ((PERF_COUNTER_BLOCK *) ((PCHAR) (a) + (a)->ByteLength))

#define NextInstance(a) ((PPERFINSTANCEDEF) \
          ((PCHAR) GetCounterBlock((a)) + GetCounterBlock((a))->ByteLength))

#define InstanceName(a) ((LPTSTR)((PCHAR)(a) + (a)->NameOffset))




// System

#define  SYSTEM                           2
#define  READ_OPERATIONS               	 10
#define  WRITE_OPERATIONS                12
#define  READ_BYTES                	     16
#define  WRITE_BYTES                	 18
#define  CONTEXT_SWITCHES               146
#define  SYSTEM_CALLS                	150
#define  TOTAL_PROCESSOR_TIME           240
#define  NUMBER_OF_PROCESSORS           240
#define  TOTAL_USER_TIME                242
#define  TOTAL_PRIVILEGED_TIME          244
#define  TOTAL_INTERRUPTS               246

// Processor

#define  PROCESSOR                      238
#define  PROCESSOR_TIME                	  6
#define  USER_TIME                	    142
#define  KERNEL_TIME                	144
#define  INTERRUPTS                	    148

// Memory

#define  MEMORY                	          4
#define  AVAILABLE_PAGES                 24
#define  COMMITTED_PAGES                 26
#define  COMMIT_LIMIT                	 30
#define  PAGE_FAULTS                	 28
#define  WRITE_COPIES                	 32
#define  PAGES                	         40
#define  PAGE_READS                	     42
#define  CACHE_PAGES                	 44
#define  CACHE_READS                	 46
#define  DIRTY_PAGES                	 48
#define  DIRTY_WRITES                	 50
#define  MAPPED_PAGES                	 52
#define  MAPPED_WRITES                	 54
#define  PAGED_POOL                	     56
#define  NON_PAGED_POOL                	 58
#define  PAGED_POOL_ALLOCS               60
#define  PAGED_POOL_FREES                62
#define  NON_PAGED_POOL_ALLOCS           64
#define  NON_PAGED_POOL_FREES            66

// Process

#define  PROCESS                        230
#define  P_PROCESSOR_TIME               188
#define  P_USER_TIME                    156
#define  P_KERNEL_TIME                  158
#define  P_READ_OPERATIONS              160
#define  P_WRITE_OPERATIONS             162
#define  P_READ_XFER_COUNT              166
#define  P_WRITE_XFER_COUNT             168
#define  PEAK_VIRTUAL_SIZE              172
#define  VIRTUAL_SIZE                   174
#define  P_PAGE_FAULTS                  176
#define  PEAK_WORKING_SET               178
#define  WORKING_SET                    180
#define  PEAK_PAGE_FILE                 182
#define  PAGE_FILE                      184
#define  PRIVATE_PAGES                  186

// Thread

#define  THREAD                         232
#define  T_PROCESSOR_TIME               190
#define  T_USER_TIME                    192
#define  T_KERNEL_TIME                  194
#define  T_CONTEXT_SWITCHES             196

// Objects
#define  OBJECT                         260
#define  PROCESSES                      248
#define  THREADS                        250
#define  EVENTS                         252
#define  SEMAPHORES                     254
#define  MUTEXES                        256
#define  SECTIONS                       258


#define NDX_PROCTIME 0
#define NDX_THRDTIME 1
#define NDX_PROCUSER 2
#define NDX_PROCPRIV 3
#define MAX_NDX      4

typedef struct _COUNTER_INFO
    {
    BOOL    bFilledIn;
    DWORD   CounterType;
    DWORD   CounterOffset;
    DWORD   dwLow;
    DWORD   dwHi;
    } COUNTER_INFO;
